package software.amazon.awscdk.services.autoscaling.hooktargets;

/**
 * Use an SNS topic as a hook target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.hooktargets.*;
 * import software.amazon.awscdk.services.sns.*;
 * Topic topic;
 * TopicHook topicHook = new TopicHook(topic);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:56.524Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling_hooktargets.TopicHook")
public class TopicHook extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget {

    protected TopicHook(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TopicHook(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param topic This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TopicHook(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(topic, "topic is required") });
    }

    /**
     * If an `IRole` is found in `options`, grant it topic publishing permissions.
     * <p>
     * Otherwise, create a new <code>IRole</code> and grant it topic publishing permissions.
     * <p>
     * @return the `IRole` with topic publishing permissions and the ARN of the topic it has publishing permission to.
     * @param _scope This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.LifecycleHookTargetConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BindHookTargetOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.LifecycleHookTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }
}
