package software.amazon.awscdk.services.applicationautoscaling;

/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalingPolicy`.
 * <p>
 * The <code>AWS::ApplicationAutoScaling::ScalingPolicy</code> resource defines a scaling policy that Application Auto Scaling uses to adjust the capacity of a scalable target.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScalingPolicy.html">PutScalingPolicy</a> in the <em>Application Auto Scaling API Reference</em> . For more information about Application Auto Scaling scaling policies, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html">Target tracking scaling policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html">Step scaling policies</a> in the <em>Application Auto Scaling User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.applicationautoscaling.*;
 * CfnScalingPolicy cfnScalingPolicy = CfnScalingPolicy.Builder.create(this, "MyCfnScalingPolicy")
 *         .policyName("policyName")
 *         .policyType("policyType")
 *         // the properties below are optional
 *         .resourceId("resourceId")
 *         .scalableDimension("scalableDimension")
 *         .scalingTargetId("scalingTargetId")
 *         .serviceNamespace("serviceNamespace")
 *         .stepScalingPolicyConfiguration(StepScalingPolicyConfigurationProperty.builder()
 *                 .adjustmentType("adjustmentType")
 *                 .cooldown(123)
 *                 .metricAggregationType("metricAggregationType")
 *                 .minAdjustmentMagnitude(123)
 *                 .stepAdjustments(List.of(StepAdjustmentProperty.builder()
 *                         .scalingAdjustment(123)
 *                         // the properties below are optional
 *                         .metricIntervalLowerBound(123)
 *                         .metricIntervalUpperBound(123)
 *                         .build()))
 *                 .build())
 *         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
 *                 .targetValue(123)
 *                 // the properties below are optional
 *                 .customizedMetricSpecification(CustomizedMetricSpecificationProperty.builder()
 *                         .metricName("metricName")
 *                         .namespace("namespace")
 *                         .statistic("statistic")
 *                         // the properties below are optional
 *                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .unit("unit")
 *                         .build())
 *                 .disableScaleIn(false)
 *                 .predefinedMetricSpecification(PredefinedMetricSpecificationProperty.builder()
 *                         .predefinedMetricType("predefinedMetricType")
 *                         // the properties below are optional
 *                         .resourceLabel("resourceLabel")
 *                         .build())
 *                 .scaleInCooldown(123)
 *                 .scaleOutCooldown(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:56.091Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy")
public class CfnScalingPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnScalingPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnScalingPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ApplicationAutoScaling::ScalingPolicy`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnScalingPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the scaling policy.
     * <p>
     * Updates to the name of a target tracking scaling policy are not supported, unless you also update the metric used for scaling. To change only a target tracking scaling policy's name, first delete the policy by removing the existing <code>AWS::ApplicationAutoScaling::ScalingPolicy</code> resource from the template and updating the stack. Then, recreate the resource with the same settings and a different name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPolicyName() {
        return software.amazon.jsii.Kernel.get(this, "policyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the scaling policy.
     * <p>
     * Updates to the name of a target tracking scaling policy are not supported, unless you also update the metric used for scaling. To change only a target tracking scaling policy's name, first delete the policy by removing the existing <code>AWS::ApplicationAutoScaling::ScalingPolicy</code> resource from the template and updating the stack. Then, recreate the resource with the same settings and a different name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policyName", java.util.Objects.requireNonNull(value, "policyName is required"));
    }

    /**
     * The scaling policy type.
     * <p>
     * The following policy types are supported:
     * <p>
     * <code>TargetTrackingScaling</code> —Not supported for Amazon EMR
     * <p>
     * <code>StepScaling</code> —Not supported for DynamoDB, Amazon Comprehend, Lambda, Amazon Keyspaces, Amazon MSK, Amazon ElastiCache, or Neptune.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPolicyType() {
        return software.amazon.jsii.Kernel.get(this, "policyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scaling policy type.
     * <p>
     * The following policy types are supported:
     * <p>
     * <code>TargetTrackingScaling</code> —Not supported for Amazon EMR
     * <p>
     * <code>StepScaling</code> —Not supported for DynamoDB, Amazon Comprehend, Lambda, Amazon Keyspaces, Amazon MSK, Amazon ElastiCache, or Neptune.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policyType", java.util.Objects.requireNonNull(value, "policyType is required"));
    }

    /**
     * The identifier of the resource associated with the scaling policy.
     * <p>
     * This string consists of the resource type and unique identifier.
     * <p>
     * <ul>
     * <li>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code> .</li>
     * <li>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code> .</li>
     * <li>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code> .</li>
     * <li>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code> .</li>
     * <li>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code> .</li>
     * <li>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code> .</li>
     * <li>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code> .</li>
     * <li>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
     * <li>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://docs.aws.amazon.com/https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a> .</li>
     * <li>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code> .</li>
     * <li>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code> .</li>
     * <li>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code> . Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code> .</li>
     * <li>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code> .</li>
     * <li>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code> .</li>
     * <li>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code> .</li>
     * <li>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceId() {
        return software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the resource associated with the scaling policy.
     * <p>
     * This string consists of the resource type and unique identifier.
     * <p>
     * <ul>
     * <li>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code> .</li>
     * <li>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code> .</li>
     * <li>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code> .</li>
     * <li>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code> .</li>
     * <li>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code> .</li>
     * <li>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code> .</li>
     * <li>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code> .</li>
     * <li>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
     * <li>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://docs.aws.amazon.com/https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a> .</li>
     * <li>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code> .</li>
     * <li>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code> .</li>
     * <li>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code> . Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code> .</li>
     * <li>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code> .</li>
     * <li>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code> .</li>
     * <li>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code> .</li>
     * <li>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceId", value);
    }

    /**
     * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
     * <p>
     * <ul>
     * <li><code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</li>
     * <li><code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</li>
     * <li><code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</li>
     * <li><code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</li>
     * <li><code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</li>
     * <li><code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</li>
     * <li><code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</li>
     * <li><code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</li>
     * <li><code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</li>
     * <li><code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model endpoint variant.</li>
     * <li><code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</li>
     * <li><code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</li>
     * <li><code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</li>
     * <li><code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</li>
     * <li><code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</li>
     * <li><code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</li>
     * <li><code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</li>
     * <li><code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</li>
     * <li><code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</li>
     * <li><code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScalableDimension() {
        return software.amazon.jsii.Kernel.get(this, "scalableDimension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
     * <p>
     * <ul>
     * <li><code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</li>
     * <li><code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</li>
     * <li><code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</li>
     * <li><code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</li>
     * <li><code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</li>
     * <li><code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</li>
     * <li><code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</li>
     * <li><code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</li>
     * <li><code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</li>
     * <li><code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model endpoint variant.</li>
     * <li><code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</li>
     * <li><code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</li>
     * <li><code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</li>
     * <li><code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</li>
     * <li><code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</li>
     * <li><code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</li>
     * <li><code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</li>
     * <li><code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</li>
     * <li><code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</li>
     * <li><code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalableDimension(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scalableDimension", value);
    }

    /**
     * The CloudFormation-generated ID of an Application Auto Scaling scalable target.
     * <p>
     * For more information about the ID, see the Return Value section of the <code>AWS::ApplicationAutoScaling::ScalableTarget</code> resource.
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the <code>ScalingTargetId</code> property, or the <code>ResourceId</code> , <code>ScalableDimension</code> , and <code>ServiceNamespace</code> properties, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScalingTargetId() {
        return software.amazon.jsii.Kernel.get(this, "scalingTargetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CloudFormation-generated ID of an Application Auto Scaling scalable target.
     * <p>
     * For more information about the ID, see the Return Value section of the <code>AWS::ApplicationAutoScaling::ScalableTarget</code> resource.
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the <code>ScalingTargetId</code> property, or the <code>ResourceId</code> , <code>ScalableDimension</code> , and <code>ServiceNamespace</code> properties, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingTargetId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scalingTargetId", value);
    }

    /**
     * The namespace of the AWS service that provides the resource, or a `custom-resource` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceNamespace() {
        return software.amazon.jsii.Kernel.get(this, "serviceNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The namespace of the AWS service that provides the resource, or a `custom-resource` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceNamespace(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceNamespace", value);
    }

    /**
     * A step scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStepScalingPolicyConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "stepScalingPolicyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A step scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStepScalingPolicyConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.StepScalingPolicyConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "stepScalingPolicyConfiguration", value);
    }

    /**
     * A step scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStepScalingPolicyConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stepScalingPolicyConfiguration", value);
    }

    /**
     * A target tracking scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargetTrackingScalingPolicyConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "targetTrackingScalingPolicyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A target tracking scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetTrackingScalingPolicyConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "targetTrackingScalingPolicyConfiguration", value);
    }

    /**
     * A target tracking scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetTrackingScalingPolicyConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetTrackingScalingPolicyConfiguration", value);
    }
    /**
     * Contains customized metric specification information for a target tracking scaling policy for Application Auto Scaling.
     * <p>
     * For information about the available metrics for a service, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html">AWS services that publish CloudWatch metrics</a> in the <em>Amazon CloudWatch User Guide</em> .
     * <p>
     * To create your customized metric specification:
     * <p>
     * <ul>
     * <li>Add values for each required parameter from CloudWatch. You can use an existing metric, or a new metric that you create. To use your own metric, you must first publish the metric to CloudWatch. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publish custom metrics</a> in the <em>Amazon CloudWatch User Guide</em> .</li>
     * <li>Choose a metric that changes proportionally with capacity. The value of the metric should increase or decrease in inverse proportion to the number of capacity units. That is, the value of the metric should decrease when capacity increases, and increase when capacity decreases.</li>
     * </ul>
     * <p>
     * For an example of how creating new metrics can be useful, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-using-sqs-queue.html">Scaling based on Amazon SQS</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> . This topic mentions Auto Scaling groups, but the same scenario for Amazon SQS can apply to the target tracking scaling policies that you create for a Spot Fleet by using Application Auto Scaling.
     * <p>
     * For more information about the CloudWatch terminology below, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch concepts</a> .
     * <p>
     * <code>CustomizedMetricSpecification</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html">AWS::ApplicationAutoScaling::ScalingPolicy TargetTrackingScalingPolicyConfiguration</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * CustomizedMetricSpecificationProperty customizedMetricSpecificationProperty = CustomizedMetricSpecificationProperty.builder()
     *         .metricName("metricName")
     *         .namespace("namespace")
     *         .statistic("statistic")
     *         // the properties below are optional
     *         .dimensions(List.of(MetricDimensionProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.CustomizedMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomizedMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomizedMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the metric.
         * <p>
         * To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that is returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * The namespace of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

        /**
         * The statistic of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatistic();

        /**
         * The dimensions of the metric.
         * <p>
         * Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * The unit of the metric.
         * <p>
         * For a complete list of the units that CloudWatch supports, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a> data type in the <em>Amazon CloudWatch API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomizedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomizedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomizedMetricSpecificationProperty> {
            java.lang.String metricName;
            java.lang.String namespace;
            java.lang.String statistic;
            java.lang.Object dimensions;
            java.lang.String unit;

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getMetricName}
             * @param metricName The name of the metric. This parameter is required.
             *                   To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that is returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getNamespace}
             * @param namespace The namespace of the metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getStatistic}
             * @param statistic The statistic of the metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistic(java.lang.String statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getDimensions}
             * @param dimensions The dimensions of the metric.
             *                   Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getDimensions}
             * @param dimensions The dimensions of the metric.
             *                   Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getUnit}
             * @param unit The unit of the metric.
             *             For a complete list of the units that CloudWatch supports, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a> data type in the <em>Amazon CloudWatch API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomizedMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomizedMetricSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomizedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomizedMetricSpecificationProperty {
            private final java.lang.String metricName;
            private final java.lang.String namespace;
            private final java.lang.String statistic;
            private final java.lang.Object dimensions;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
                this.statistic = java.util.Objects.requireNonNull(builder.statistic, "statistic is required");
                this.dimensions = builder.dimensions;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.String getStatistic() {
                return this.statistic;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("namespace", om.valueToTree(this.getNamespace()));
                data.set("statistic", om.valueToTree(this.getStatistic()));
                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.CustomizedMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomizedMetricSpecificationProperty.Jsii$Proxy that = (CustomizedMetricSpecificationProperty.Jsii$Proxy) o;

                if (!metricName.equals(that.metricName)) return false;
                if (!namespace.equals(that.namespace)) return false;
                if (!statistic.equals(that.statistic)) return false;
                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricName.hashCode();
                result = 31 * result + (this.namespace.hashCode());
                result = 31 * result + (this.statistic.hashCode());
                result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `MetricDimension` specifies a name/value pair that is part of the identity of a CloudWatch metric for the `Dimensions` property of the [AWS::ApplicationAutoScaling::ScalingPolicy CustomizedMetricSpecification](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html) property type. Duplicate dimensions are not allowed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * MetricDimensionProperty metricDimensionProperty = MetricDimensionProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.MetricDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the dimension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value of the dimension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link MetricDimensionProperty#getName}
             * @param name The name of the dimension. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link MetricDimensionProperty#getValue}
             * @param value The value of the dimension. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDimensionProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.MetricDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDimensionProperty.Jsii$Proxy that = (MetricDimensionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains predefined metric specification information for a target tracking scaling policy for Application Auto Scaling.
     * <p>
     * <code>PredefinedMetricSpecification</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html">AWS::ApplicationAutoScaling::ScalingPolicy TargetTrackingScalingPolicyConfiguration</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * PredefinedMetricSpecificationProperty predefinedMetricSpecificationProperty = PredefinedMetricSpecificationProperty.builder()
     *         .predefinedMetricType("predefinedMetricType")
     *         // the properties below are optional
     *         .resourceLabel("resourceLabel")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredefinedMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PredefinedMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredefinedMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric type.
         * <p>
         * The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot fleet requests and ECS services.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPredefinedMetricType();

        /**
         * Identifies the resource associated with the metric type.
         * <p>
         * You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Spot Fleet or ECS service.
         * <p>
         * You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
         * <p>
         * <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code> .
         * <p>
         * Where:
         * <p>
         * <ul>
         * <li>app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN</li>
         * <li>targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.</li>
         * </ul>
         * <p>
         * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredefinedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredefinedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredefinedMetricSpecificationProperty> {
            java.lang.String predefinedMetricType;
            java.lang.String resourceLabel;

            /**
             * Sets the value of {@link PredefinedMetricSpecificationProperty#getPredefinedMetricType}
             * @param predefinedMetricType The metric type. This parameter is required.
             *                             The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot fleet requests and ECS services.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricType(java.lang.String predefinedMetricType) {
                this.predefinedMetricType = predefinedMetricType;
                return this;
            }

            /**
             * Sets the value of {@link PredefinedMetricSpecificationProperty#getResourceLabel}
             * @param resourceLabel Identifies the resource associated with the metric type.
             *                      You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Spot Fleet or ECS service.
             *                      <p>
             *                      You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
             *                      <p>
             *                      <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code> .
             *                      <p>
             *                      Where:
             *                      <p>
             *                      <ul>
             *                      <li>app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN</li>
             *                      <li>targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.</li>
             *                      </ul>
             *                      <p>
             *                      To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceLabel(java.lang.String resourceLabel) {
                this.resourceLabel = resourceLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredefinedMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredefinedMetricSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredefinedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredefinedMetricSpecificationProperty {
            private final java.lang.String predefinedMetricType;
            private final java.lang.String resourceLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predefinedMetricType = software.amazon.jsii.Kernel.get(this, "predefinedMetricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceLabel = software.amazon.jsii.Kernel.get(this, "resourceLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predefinedMetricType = java.util.Objects.requireNonNull(builder.predefinedMetricType, "predefinedMetricType is required");
                this.resourceLabel = builder.resourceLabel;
            }

            @Override
            public final java.lang.String getPredefinedMetricType() {
                return this.predefinedMetricType;
            }

            @Override
            public final java.lang.String getResourceLabel() {
                return this.resourceLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("predefinedMetricType", om.valueToTree(this.getPredefinedMetricType()));
                if (this.getResourceLabel() != null) {
                    data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredefinedMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredefinedMetricSpecificationProperty.Jsii$Proxy that = (PredefinedMetricSpecificationProperty.Jsii$Proxy) o;

                if (!predefinedMetricType.equals(that.predefinedMetricType)) return false;
                return this.resourceLabel != null ? this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.predefinedMetricType.hashCode();
                result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `StepAdjustment` specifies a step adjustment for the `StepAdjustments` property of the [AWS::ApplicationAutoScaling::ScalingPolicy StepScalingPolicyConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html) property type.
     * <p>
     * For the following examples, suppose that you have an alarm with a breach threshold of 50:
     * <p>
     * <ul>
     * <li>To trigger a step adjustment when the metric is greater than or equal to 50 and less than 60, specify a lower bound of 0 and an upper bound of 10.</li>
     * <li>To trigger a step adjustment when the metric is greater than 40 and less than or equal to 50, specify a lower bound of -10 and an upper bound of 0.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html#as-scaling-steps">Step adjustments</a> in the <em>Application Auto Scaling User Guide</em> .
     * <p>
     * You can find a sample template snippet in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#aws-resource-applicationautoscaling-scalingpolicy--examples">Examples</a> section of the <code>AWS::ApplicationAutoScaling::ScalingPolicy</code> documentation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * StepAdjustmentProperty stepAdjustmentProperty = StepAdjustmentProperty.builder()
     *         .scalingAdjustment(123)
     *         // the properties below are optional
     *         .metricIntervalLowerBound(123)
     *         .metricIntervalUpperBound(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.StepAdjustmentProperty")
    @software.amazon.jsii.Jsii.Proxy(StepAdjustmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StepAdjustmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount by which to scale.
         * <p>
         * The adjustment is based on the value that you specified in the <code>AdjustmentType</code> property (either an absolute number or a percentage). A positive value adds to the current capacity and a negative number subtracts from the current capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getScalingAdjustment();

        /**
         * The lower bound for the difference between the alarm threshold and the CloudWatch metric.
         * <p>
         * If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
         * <p>
         * You must specify at least one upper or lower bound.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMetricIntervalLowerBound() {
            return null;
        }

        /**
         * The upper bound for the difference between the alarm threshold and the CloudWatch metric.
         * <p>
         * If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.
         * <p>
         * You must specify at least one upper or lower bound.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMetricIntervalUpperBound() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StepAdjustmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StepAdjustmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StepAdjustmentProperty> {
            java.lang.Number scalingAdjustment;
            java.lang.Number metricIntervalLowerBound;
            java.lang.Number metricIntervalUpperBound;

            /**
             * Sets the value of {@link StepAdjustmentProperty#getScalingAdjustment}
             * @param scalingAdjustment The amount by which to scale. This parameter is required.
             *                          The adjustment is based on the value that you specified in the <code>AdjustmentType</code> property (either an absolute number or a percentage). A positive value adds to the current capacity and a negative number subtracts from the current capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingAdjustment(java.lang.Number scalingAdjustment) {
                this.scalingAdjustment = scalingAdjustment;
                return this;
            }

            /**
             * Sets the value of {@link StepAdjustmentProperty#getMetricIntervalLowerBound}
             * @param metricIntervalLowerBound The lower bound for the difference between the alarm threshold and the CloudWatch metric.
             *                                 If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
             *                                 <p>
             *                                 You must specify at least one upper or lower bound.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricIntervalLowerBound(java.lang.Number metricIntervalLowerBound) {
                this.metricIntervalLowerBound = metricIntervalLowerBound;
                return this;
            }

            /**
             * Sets the value of {@link StepAdjustmentProperty#getMetricIntervalUpperBound}
             * @param metricIntervalUpperBound The upper bound for the difference between the alarm threshold and the CloudWatch metric.
             *                                 If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.
             *                                 <p>
             *                                 You must specify at least one upper or lower bound.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricIntervalUpperBound(java.lang.Number metricIntervalUpperBound) {
                this.metricIntervalUpperBound = metricIntervalUpperBound;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StepAdjustmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StepAdjustmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StepAdjustmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepAdjustmentProperty {
            private final java.lang.Number scalingAdjustment;
            private final java.lang.Number metricIntervalLowerBound;
            private final java.lang.Number metricIntervalUpperBound;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scalingAdjustment = software.amazon.jsii.Kernel.get(this, "scalingAdjustment", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.metricIntervalLowerBound = software.amazon.jsii.Kernel.get(this, "metricIntervalLowerBound", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.metricIntervalUpperBound = software.amazon.jsii.Kernel.get(this, "metricIntervalUpperBound", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scalingAdjustment = java.util.Objects.requireNonNull(builder.scalingAdjustment, "scalingAdjustment is required");
                this.metricIntervalLowerBound = builder.metricIntervalLowerBound;
                this.metricIntervalUpperBound = builder.metricIntervalUpperBound;
            }

            @Override
            public final java.lang.Number getScalingAdjustment() {
                return this.scalingAdjustment;
            }

            @Override
            public final java.lang.Number getMetricIntervalLowerBound() {
                return this.metricIntervalLowerBound;
            }

            @Override
            public final java.lang.Number getMetricIntervalUpperBound() {
                return this.metricIntervalUpperBound;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scalingAdjustment", om.valueToTree(this.getScalingAdjustment()));
                if (this.getMetricIntervalLowerBound() != null) {
                    data.set("metricIntervalLowerBound", om.valueToTree(this.getMetricIntervalLowerBound()));
                }
                if (this.getMetricIntervalUpperBound() != null) {
                    data.set("metricIntervalUpperBound", om.valueToTree(this.getMetricIntervalUpperBound()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.StepAdjustmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StepAdjustmentProperty.Jsii$Proxy that = (StepAdjustmentProperty.Jsii$Proxy) o;

                if (!scalingAdjustment.equals(that.scalingAdjustment)) return false;
                if (this.metricIntervalLowerBound != null ? !this.metricIntervalLowerBound.equals(that.metricIntervalLowerBound) : that.metricIntervalLowerBound != null) return false;
                return this.metricIntervalUpperBound != null ? this.metricIntervalUpperBound.equals(that.metricIntervalUpperBound) : that.metricIntervalUpperBound == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scalingAdjustment.hashCode();
                result = 31 * result + (this.metricIntervalLowerBound != null ? this.metricIntervalLowerBound.hashCode() : 0);
                result = 31 * result + (this.metricIntervalUpperBound != null ? this.metricIntervalUpperBound.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `StepScalingPolicyConfiguration` is a property of the [AWS::ApplicationAutoScaling::ScalingPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html) resource that specifies a step scaling policy configuration for Application Auto Scaling.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScalingPolicy.html">PutScalingPolicy</a> in the <em>Application Auto Scaling API Reference</em> . For more information about step scaling policies, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html">Step scaling policies</a> in the <em>Application Auto Scaling User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * StepScalingPolicyConfigurationProperty stepScalingPolicyConfigurationProperty = StepScalingPolicyConfigurationProperty.builder()
     *         .adjustmentType("adjustmentType")
     *         .cooldown(123)
     *         .metricAggregationType("metricAggregationType")
     *         .minAdjustmentMagnitude(123)
     *         .stepAdjustments(List.of(StepAdjustmentProperty.builder()
     *                 .scalingAdjustment(123)
     *                 // the properties below are optional
     *                 .metricIntervalLowerBound(123)
     *                 .metricIntervalUpperBound(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.StepScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StepScalingPolicyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StepScalingPolicyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the `ScalingAdjustment` value in the `StepAdjustment` property is an absolute number or a percentage of the current capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdjustmentType() {
            return null;
        }

        /**
         * The amount of time, in seconds, to wait for a previous scaling activity to take effect.
         * <p>
         * With scale-out policies, the intention is to continuously (but not excessively) scale out. After Application Auto Scaling successfully scales out using a step scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends. While the cooldown period is in effect, capacity added by the initiating scale-out activity is calculated as part of the desired capacity for the next scale-out activity. For example, when an alarm triggers a step scaling policy to increase the capacity by 2, the scaling activity completes successfully, and a cooldown period starts. If the alarm triggers again during the cooldown period but at a more aggressive step adjustment of 3, the previous increase of 2 is considered part of the current capacity. Therefore, only 1 is added to the capacity.
         * <p>
         * With scale-in policies, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the cooldown period after a scale-in activity, Application Auto Scaling scales out the target immediately. In this case, the cooldown period for the scale-in activity stops and doesn't complete.
         * <p>
         * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:
         * <p>
         * <ul>
         * <li>AppStream 2.0 fleets</li>
         * <li>Aurora DB clusters</li>
         * <li>ECS services</li>
         * <li>EMR clusters</li>
         * <li>Neptune clusters</li>
         * <li>SageMaker endpoint variants</li>
         * <li>Spot Fleets</li>
         * <li>Custom resources</li>
         * </ul>
         * <p>
         * For all other scalable targets, the default value is 0:
         * <p>
         * <ul>
         * <li>Amazon Comprehend document classification and entity recognizer endpoints</li>
         * <li>DynamoDB tables and global secondary indexes</li>
         * <li>Amazon Keyspaces tables</li>
         * <li>Lambda provisioned concurrency</li>
         * <li>Amazon MSK broker storage</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCooldown() {
            return null;
        }

        /**
         * The aggregation type for the CloudWatch metrics.
         * <p>
         * Valid values are <code>Minimum</code> , <code>Maximum</code> , and <code>Average</code> . If the aggregation type is null, the value is treated as <code>Average</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricAggregationType() {
            return null;
        }

        /**
         * The minimum value to scale by when the adjustment type is `PercentChangeInCapacity` .
         * <p>
         * For example, suppose that you create a step scaling policy to scale out an Amazon ECS service by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the service has 4 tasks and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Application Auto Scaling scales out the service by 2 tasks.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinAdjustmentMagnitude() {
            return null;
        }

        /**
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * <p>
         * At least one step adjustment is required if you are adding a new step scaling policy configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStepAdjustments() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StepScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StepScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StepScalingPolicyConfigurationProperty> {
            java.lang.String adjustmentType;
            java.lang.Number cooldown;
            java.lang.String metricAggregationType;
            java.lang.Number minAdjustmentMagnitude;
            java.lang.Object stepAdjustments;

            /**
             * Sets the value of {@link StepScalingPolicyConfigurationProperty#getAdjustmentType}
             * @param adjustmentType Specifies whether the `ScalingAdjustment` value in the `StepAdjustment` property is an absolute number or a percentage of the current capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adjustmentType(java.lang.String adjustmentType) {
                this.adjustmentType = adjustmentType;
                return this;
            }

            /**
             * Sets the value of {@link StepScalingPolicyConfigurationProperty#getCooldown}
             * @param cooldown The amount of time, in seconds, to wait for a previous scaling activity to take effect.
             *                 With scale-out policies, the intention is to continuously (but not excessively) scale out. After Application Auto Scaling successfully scales out using a step scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends. While the cooldown period is in effect, capacity added by the initiating scale-out activity is calculated as part of the desired capacity for the next scale-out activity. For example, when an alarm triggers a step scaling policy to increase the capacity by 2, the scaling activity completes successfully, and a cooldown period starts. If the alarm triggers again during the cooldown period but at a more aggressive step adjustment of 3, the previous increase of 2 is considered part of the current capacity. Therefore, only 1 is added to the capacity.
             *                 <p>
             *                 With scale-in policies, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the cooldown period after a scale-in activity, Application Auto Scaling scales out the target immediately. In this case, the cooldown period for the scale-in activity stops and doesn't complete.
             *                 <p>
             *                 Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:
             *                 <p>
             *                 <ul>
             *                 <li>AppStream 2.0 fleets</li>
             *                 <li>Aurora DB clusters</li>
             *                 <li>ECS services</li>
             *                 <li>EMR clusters</li>
             *                 <li>Neptune clusters</li>
             *                 <li>SageMaker endpoint variants</li>
             *                 <li>Spot Fleets</li>
             *                 <li>Custom resources</li>
             *                 </ul>
             *                 <p>
             *                 For all other scalable targets, the default value is 0:
             *                 <p>
             *                 <ul>
             *                 <li>Amazon Comprehend document classification and entity recognizer endpoints</li>
             *                 <li>DynamoDB tables and global secondary indexes</li>
             *                 <li>Amazon Keyspaces tables</li>
             *                 <li>Lambda provisioned concurrency</li>
             *                 <li>Amazon MSK broker storage</li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cooldown(java.lang.Number cooldown) {
                this.cooldown = cooldown;
                return this;
            }

            /**
             * Sets the value of {@link StepScalingPolicyConfigurationProperty#getMetricAggregationType}
             * @param metricAggregationType The aggregation type for the CloudWatch metrics.
             *                              Valid values are <code>Minimum</code> , <code>Maximum</code> , and <code>Average</code> . If the aggregation type is null, the value is treated as <code>Average</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricAggregationType(java.lang.String metricAggregationType) {
                this.metricAggregationType = metricAggregationType;
                return this;
            }

            /**
             * Sets the value of {@link StepScalingPolicyConfigurationProperty#getMinAdjustmentMagnitude}
             * @param minAdjustmentMagnitude The minimum value to scale by when the adjustment type is `PercentChangeInCapacity` .
             *                               For example, suppose that you create a step scaling policy to scale out an Amazon ECS service by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the service has 4 tasks and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Application Auto Scaling scales out the service by 2 tasks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minAdjustmentMagnitude(java.lang.Number minAdjustmentMagnitude) {
                this.minAdjustmentMagnitude = minAdjustmentMagnitude;
                return this;
            }

            /**
             * Sets the value of {@link StepScalingPolicyConfigurationProperty#getStepAdjustments}
             * @param stepAdjustments A set of adjustments that enable you to scale based on the size of the alarm breach.
             *                        At least one step adjustment is required if you are adding a new step scaling policy configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepAdjustments(software.amazon.awscdk.IResolvable stepAdjustments) {
                this.stepAdjustments = stepAdjustments;
                return this;
            }

            /**
             * Sets the value of {@link StepScalingPolicyConfigurationProperty#getStepAdjustments}
             * @param stepAdjustments A set of adjustments that enable you to scale based on the size of the alarm breach.
             *                        At least one step adjustment is required if you are adding a new step scaling policy configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepAdjustments(java.util.List<? extends java.lang.Object> stepAdjustments) {
                this.stepAdjustments = stepAdjustments;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StepScalingPolicyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StepScalingPolicyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StepScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepScalingPolicyConfigurationProperty {
            private final java.lang.String adjustmentType;
            private final java.lang.Number cooldown;
            private final java.lang.String metricAggregationType;
            private final java.lang.Number minAdjustmentMagnitude;
            private final java.lang.Object stepAdjustments;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adjustmentType = software.amazon.jsii.Kernel.get(this, "adjustmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cooldown = software.amazon.jsii.Kernel.get(this, "cooldown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.metricAggregationType = software.amazon.jsii.Kernel.get(this, "metricAggregationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minAdjustmentMagnitude = software.amazon.jsii.Kernel.get(this, "minAdjustmentMagnitude", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stepAdjustments = software.amazon.jsii.Kernel.get(this, "stepAdjustments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adjustmentType = builder.adjustmentType;
                this.cooldown = builder.cooldown;
                this.metricAggregationType = builder.metricAggregationType;
                this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
                this.stepAdjustments = builder.stepAdjustments;
            }

            @Override
            public final java.lang.String getAdjustmentType() {
                return this.adjustmentType;
            }

            @Override
            public final java.lang.Number getCooldown() {
                return this.cooldown;
            }

            @Override
            public final java.lang.String getMetricAggregationType() {
                return this.metricAggregationType;
            }

            @Override
            public final java.lang.Number getMinAdjustmentMagnitude() {
                return this.minAdjustmentMagnitude;
            }

            @Override
            public final java.lang.Object getStepAdjustments() {
                return this.stepAdjustments;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdjustmentType() != null) {
                    data.set("adjustmentType", om.valueToTree(this.getAdjustmentType()));
                }
                if (this.getCooldown() != null) {
                    data.set("cooldown", om.valueToTree(this.getCooldown()));
                }
                if (this.getMetricAggregationType() != null) {
                    data.set("metricAggregationType", om.valueToTree(this.getMetricAggregationType()));
                }
                if (this.getMinAdjustmentMagnitude() != null) {
                    data.set("minAdjustmentMagnitude", om.valueToTree(this.getMinAdjustmentMagnitude()));
                }
                if (this.getStepAdjustments() != null) {
                    data.set("stepAdjustments", om.valueToTree(this.getStepAdjustments()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.StepScalingPolicyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StepScalingPolicyConfigurationProperty.Jsii$Proxy that = (StepScalingPolicyConfigurationProperty.Jsii$Proxy) o;

                if (this.adjustmentType != null ? !this.adjustmentType.equals(that.adjustmentType) : that.adjustmentType != null) return false;
                if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
                if (this.metricAggregationType != null ? !this.metricAggregationType.equals(that.metricAggregationType) : that.metricAggregationType != null) return false;
                if (this.minAdjustmentMagnitude != null ? !this.minAdjustmentMagnitude.equals(that.minAdjustmentMagnitude) : that.minAdjustmentMagnitude != null) return false;
                return this.stepAdjustments != null ? this.stepAdjustments.equals(that.stepAdjustments) : that.stepAdjustments == null;
            }

            @Override
            public final int hashCode() {
                int result = this.adjustmentType != null ? this.adjustmentType.hashCode() : 0;
                result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
                result = 31 * result + (this.metricAggregationType != null ? this.metricAggregationType.hashCode() : 0);
                result = 31 * result + (this.minAdjustmentMagnitude != null ? this.minAdjustmentMagnitude.hashCode() : 0);
                result = 31 * result + (this.stepAdjustments != null ? this.stepAdjustments.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `TargetTrackingScalingPolicyConfiguration` is a property of the [AWS::ApplicationAutoScaling::ScalingPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html) resource that specifies a target tracking scaling policy configuration for Application Auto Scaling. Use a target tracking scaling policy to adjust the capacity of the specified scalable target in response to actual workloads, so that resource utilization remains at or near the target utilization value.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScalingPolicy.html">PutScalingPolicy</a> in the <em>Application Auto Scaling API Reference</em> . For more information about target tracking scaling policies, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html">Target tracking scaling policies</a> in the <em>Application Auto Scaling User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * TargetTrackingScalingPolicyConfigurationProperty targetTrackingScalingPolicyConfigurationProperty = TargetTrackingScalingPolicyConfigurationProperty.builder()
     *         .targetValue(123)
     *         // the properties below are optional
     *         .customizedMetricSpecification(CustomizedMetricSpecificationProperty.builder()
     *                 .metricName("metricName")
     *                 .namespace("namespace")
     *                 .statistic("statistic")
     *                 // the properties below are optional
     *                 .dimensions(List.of(MetricDimensionProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .unit("unit")
     *                 .build())
     *         .disableScaleIn(false)
     *         .predefinedMetricSpecification(PredefinedMetricSpecificationProperty.builder()
     *                 .predefinedMetricType("predefinedMetricType")
     *                 // the properties below are optional
     *                 .resourceLabel("resourceLabel")
     *                 .build())
     *         .scaleInCooldown(123)
     *         .scaleOutCooldown(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetTrackingScalingPolicyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetTrackingScalingPolicyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The target value for the metric.
         * <p>
         * Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For example, if the metric is CPU utilization, then the target value is a percent value that represents how much of the CPU can be used before scaling out.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue();

        /**
         * A customized metric.
         * <p>
         * You can specify either a predefined metric or a customized metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomizedMetricSpecification() {
            return null;
        }

        /**
         * Indicates whether scale in by the target tracking scaling policy is disabled.
         * <p>
         * If the value is <code>true</code> , scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableScaleIn() {
            return null;
        }

        /**
         * A predefined metric.
         * <p>
         * You can specify either a predefined metric or a customized metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredefinedMetricSpecification() {
            return null;
        }

        /**
         * The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.
         * <p>
         * With the <em>scale-in cooldown period</em> , the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the scale-in cooldown period, Application Auto Scaling scales out the target immediately. In this case, the scale-in cooldown period stops and doesn't complete.
         * <p>
         * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:
         * <p>
         * <ul>
         * <li>AppStream 2.0 fleets</li>
         * <li>Aurora DB clusters</li>
         * <li>ECS services</li>
         * <li>EMR clusters</li>
         * <li>Neptune clusters</li>
         * <li>SageMaker endpoint variants</li>
         * <li>Spot Fleets</li>
         * <li>Custom resources</li>
         * </ul>
         * <p>
         * For all other scalable targets, the default value is 0:
         * <p>
         * <ul>
         * <li>Amazon Comprehend document classification and entity recognizer endpoints</li>
         * <li>DynamoDB tables and global secondary indexes</li>
         * <li>Amazon Keyspaces tables</li>
         * <li>Lambda provisioned concurrency</li>
         * <li>Amazon MSK broker storage</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScaleInCooldown() {
            return null;
        }

        /**
         * The amount of time, in seconds, to wait for a previous scale-out activity to take effect.
         * <p>
         * With the <em>scale-out cooldown period</em> , the intention is to continuously (but not excessively) scale out. After Application Auto Scaling successfully scales out using a target tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends. While the cooldown period is in effect, the capacity added by the initiating scale-out activity is calculated as part of the desired capacity for the next scale-out activity.
         * <p>
         * Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:
         * <p>
         * <ul>
         * <li>AppStream 2.0 fleets</li>
         * <li>Aurora DB clusters</li>
         * <li>ECS services</li>
         * <li>EMR clusters</li>
         * <li>Neptune clusters</li>
         * <li>SageMaker endpoint variants</li>
         * <li>Spot Fleets</li>
         * <li>Custom resources</li>
         * </ul>
         * <p>
         * For all other scalable targets, the default value is 0:
         * <p>
         * <ul>
         * <li>Amazon Comprehend document classification and entity recognizer endpoints</li>
         * <li>DynamoDB tables and global secondary indexes</li>
         * <li>Amazon Keyspaces tables</li>
         * <li>Lambda provisioned concurrency</li>
         * <li>Amazon MSK broker storage</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScaleOutCooldown() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetTrackingScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetTrackingScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetTrackingScalingPolicyConfigurationProperty> {
            java.lang.Number targetValue;
            java.lang.Object customizedMetricSpecification;
            java.lang.Object disableScaleIn;
            java.lang.Object predefinedMetricSpecification;
            java.lang.Number scaleInCooldown;
            java.lang.Number scaleOutCooldown;

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getTargetValue}
             * @param targetValue The target value for the metric. This parameter is required.
             *                    Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For example, if the metric is CPU utilization, then the target value is a percent value that represents how much of the CPU can be used before scaling out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetValue(java.lang.Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getCustomizedMetricSpecification}
             * @param customizedMetricSpecification A customized metric.
             *                                      You can specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedMetricSpecification(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.CustomizedMetricSpecificationProperty customizedMetricSpecification) {
                this.customizedMetricSpecification = customizedMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getCustomizedMetricSpecification}
             * @param customizedMetricSpecification A customized metric.
             *                                      You can specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedMetricSpecification(software.amazon.awscdk.IResolvable customizedMetricSpecification) {
                this.customizedMetricSpecification = customizedMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getDisableScaleIn}
             * @param disableScaleIn Indicates whether scale in by the target tracking scaling policy is disabled.
             *                       If the value is <code>true</code> , scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableScaleIn(java.lang.Boolean disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getDisableScaleIn}
             * @param disableScaleIn Indicates whether scale in by the target tracking scaling policy is disabled.
             *                       If the value is <code>true</code> , scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableScaleIn(software.amazon.awscdk.IResolvable disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getPredefinedMetricSpecification}
             * @param predefinedMetricSpecification A predefined metric.
             *                                      You can specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricSpecification(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredefinedMetricSpecificationProperty predefinedMetricSpecification) {
                this.predefinedMetricSpecification = predefinedMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getPredefinedMetricSpecification}
             * @param predefinedMetricSpecification A predefined metric.
             *                                      You can specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricSpecification(software.amazon.awscdk.IResolvable predefinedMetricSpecification) {
                this.predefinedMetricSpecification = predefinedMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getScaleInCooldown}
             * @param scaleInCooldown The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.
             *                        With the <em>scale-in cooldown period</em> , the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the scale-in cooldown period, Application Auto Scaling scales out the target immediately. In this case, the scale-in cooldown period stops and doesn't complete.
             *                        <p>
             *                        Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:
             *                        <p>
             *                        <ul>
             *                        <li>AppStream 2.0 fleets</li>
             *                        <li>Aurora DB clusters</li>
             *                        <li>ECS services</li>
             *                        <li>EMR clusters</li>
             *                        <li>Neptune clusters</li>
             *                        <li>SageMaker endpoint variants</li>
             *                        <li>Spot Fleets</li>
             *                        <li>Custom resources</li>
             *                        </ul>
             *                        <p>
             *                        For all other scalable targets, the default value is 0:
             *                        <p>
             *                        <ul>
             *                        <li>Amazon Comprehend document classification and entity recognizer endpoints</li>
             *                        <li>DynamoDB tables and global secondary indexes</li>
             *                        <li>Amazon Keyspaces tables</li>
             *                        <li>Lambda provisioned concurrency</li>
             *                        <li>Amazon MSK broker storage</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleInCooldown(java.lang.Number scaleInCooldown) {
                this.scaleInCooldown = scaleInCooldown;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getScaleOutCooldown}
             * @param scaleOutCooldown The amount of time, in seconds, to wait for a previous scale-out activity to take effect.
             *                         With the <em>scale-out cooldown period</em> , the intention is to continuously (but not excessively) scale out. After Application Auto Scaling successfully scales out using a target tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends. While the cooldown period is in effect, the capacity added by the initiating scale-out activity is calculated as part of the desired capacity for the next scale-out activity.
             *                         <p>
             *                         Application Auto Scaling provides a default value of 600 for Amazon ElastiCache replication groups and a default value of 300 for the following scalable targets:
             *                         <p>
             *                         <ul>
             *                         <li>AppStream 2.0 fleets</li>
             *                         <li>Aurora DB clusters</li>
             *                         <li>ECS services</li>
             *                         <li>EMR clusters</li>
             *                         <li>Neptune clusters</li>
             *                         <li>SageMaker endpoint variants</li>
             *                         <li>Spot Fleets</li>
             *                         <li>Custom resources</li>
             *                         </ul>
             *                         <p>
             *                         For all other scalable targets, the default value is 0:
             *                         <p>
             *                         <ul>
             *                         <li>Amazon Comprehend document classification and entity recognizer endpoints</li>
             *                         <li>DynamoDB tables and global secondary indexes</li>
             *                         <li>Amazon Keyspaces tables</li>
             *                         <li>Lambda provisioned concurrency</li>
             *                         <li>Amazon MSK broker storage</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleOutCooldown(java.lang.Number scaleOutCooldown) {
                this.scaleOutCooldown = scaleOutCooldown;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetTrackingScalingPolicyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetTrackingScalingPolicyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetTrackingScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetTrackingScalingPolicyConfigurationProperty {
            private final java.lang.Number targetValue;
            private final java.lang.Object customizedMetricSpecification;
            private final java.lang.Object disableScaleIn;
            private final java.lang.Object predefinedMetricSpecification;
            private final java.lang.Number scaleInCooldown;
            private final java.lang.Number scaleOutCooldown;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customizedMetricSpecification = software.amazon.jsii.Kernel.get(this, "customizedMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableScaleIn = software.amazon.jsii.Kernel.get(this, "disableScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.predefinedMetricSpecification = software.amazon.jsii.Kernel.get(this, "predefinedMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scaleInCooldown = software.amazon.jsii.Kernel.get(this, "scaleInCooldown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scaleOutCooldown = software.amazon.jsii.Kernel.get(this, "scaleOutCooldown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetValue = java.util.Objects.requireNonNull(builder.targetValue, "targetValue is required");
                this.customizedMetricSpecification = builder.customizedMetricSpecification;
                this.disableScaleIn = builder.disableScaleIn;
                this.predefinedMetricSpecification = builder.predefinedMetricSpecification;
                this.scaleInCooldown = builder.scaleInCooldown;
                this.scaleOutCooldown = builder.scaleOutCooldown;
            }

            @Override
            public final java.lang.Number getTargetValue() {
                return this.targetValue;
            }

            @Override
            public final java.lang.Object getCustomizedMetricSpecification() {
                return this.customizedMetricSpecification;
            }

            @Override
            public final java.lang.Object getDisableScaleIn() {
                return this.disableScaleIn;
            }

            @Override
            public final java.lang.Object getPredefinedMetricSpecification() {
                return this.predefinedMetricSpecification;
            }

            @Override
            public final java.lang.Number getScaleInCooldown() {
                return this.scaleInCooldown;
            }

            @Override
            public final java.lang.Number getScaleOutCooldown() {
                return this.scaleOutCooldown;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetValue", om.valueToTree(this.getTargetValue()));
                if (this.getCustomizedMetricSpecification() != null) {
                    data.set("customizedMetricSpecification", om.valueToTree(this.getCustomizedMetricSpecification()));
                }
                if (this.getDisableScaleIn() != null) {
                    data.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
                }
                if (this.getPredefinedMetricSpecification() != null) {
                    data.set("predefinedMetricSpecification", om.valueToTree(this.getPredefinedMetricSpecification()));
                }
                if (this.getScaleInCooldown() != null) {
                    data.set("scaleInCooldown", om.valueToTree(this.getScaleInCooldown()));
                }
                if (this.getScaleOutCooldown() != null) {
                    data.set("scaleOutCooldown", om.valueToTree(this.getScaleOutCooldown()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetTrackingScalingPolicyConfigurationProperty.Jsii$Proxy that = (TargetTrackingScalingPolicyConfigurationProperty.Jsii$Proxy) o;

                if (!targetValue.equals(that.targetValue)) return false;
                if (this.customizedMetricSpecification != null ? !this.customizedMetricSpecification.equals(that.customizedMetricSpecification) : that.customizedMetricSpecification != null) return false;
                if (this.disableScaleIn != null ? !this.disableScaleIn.equals(that.disableScaleIn) : that.disableScaleIn != null) return false;
                if (this.predefinedMetricSpecification != null ? !this.predefinedMetricSpecification.equals(that.predefinedMetricSpecification) : that.predefinedMetricSpecification != null) return false;
                if (this.scaleInCooldown != null ? !this.scaleInCooldown.equals(that.scaleInCooldown) : that.scaleInCooldown != null) return false;
                return this.scaleOutCooldown != null ? this.scaleOutCooldown.equals(that.scaleOutCooldown) : that.scaleOutCooldown == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetValue.hashCode();
                result = 31 * result + (this.customizedMetricSpecification != null ? this.customizedMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.disableScaleIn != null ? this.disableScaleIn.hashCode() : 0);
                result = 31 * result + (this.predefinedMetricSpecification != null ? this.predefinedMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.scaleInCooldown != null ? this.scaleInCooldown.hashCode() : 0);
                result = 31 * result + (this.scaleOutCooldown != null ? this.scaleOutCooldown.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicyProps.Builder();
        }

        /**
         * The name of the scaling policy.
         * <p>
         * Updates to the name of a target tracking scaling policy are not supported, unless you also update the metric used for scaling. To change only a target tracking scaling policy's name, first delete the policy by removing the existing <code>AWS::ApplicationAutoScaling::ScalingPolicy</code> resource from the template and updating the stack. Then, recreate the resource with the same settings and a different name.
         * <p>
         * @return {@code this}
         * @param policyName The name of the scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(final java.lang.String policyName) {
            this.props.policyName(policyName);
            return this;
        }

        /**
         * The scaling policy type.
         * <p>
         * The following policy types are supported:
         * <p>
         * <code>TargetTrackingScaling</code> —Not supported for Amazon EMR
         * <p>
         * <code>StepScaling</code> —Not supported for DynamoDB, Amazon Comprehend, Lambda, Amazon Keyspaces, Amazon MSK, Amazon ElastiCache, or Neptune.
         * <p>
         * @return {@code this}
         * @param policyType The scaling policy type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyType(final java.lang.String policyType) {
            this.props.policyType(policyType);
            return this;
        }

        /**
         * The identifier of the resource associated with the scaling policy.
         * <p>
         * This string consists of the resource type and unique identifier.
         * <p>
         * <ul>
         * <li>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code> .</li>
         * <li>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code> .</li>
         * <li>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code> .</li>
         * <li>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code> .</li>
         * <li>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code> .</li>
         * <li>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code> .</li>
         * <li>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code> .</li>
         * <li>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
         * <li>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://docs.aws.amazon.com/https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a> .</li>
         * <li>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code> .</li>
         * <li>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code> .</li>
         * <li>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code> . Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code> .</li>
         * <li>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code> .</li>
         * <li>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code> .</li>
         * <li>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code> .</li>
         * <li>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param resourceId The identifier of the resource associated with the scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(final java.lang.String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        /**
         * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
         * <p>
         * <ul>
         * <li><code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</li>
         * <li><code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</li>
         * <li><code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</li>
         * <li><code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</li>
         * <li><code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</li>
         * <li><code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</li>
         * <li><code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</li>
         * <li><code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</li>
         * <li><code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</li>
         * <li><code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model endpoint variant.</li>
         * <li><code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</li>
         * <li><code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</li>
         * <li><code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</li>
         * <li><code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</li>
         * <li><code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</li>
         * <li><code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</li>
         * <li><code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</li>
         * <li><code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</li>
         * <li><code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</li>
         * <li><code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param scalableDimension The scalable dimension. This string consists of the service namespace, resource type, and scaling property. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalableDimension(final java.lang.String scalableDimension) {
            this.props.scalableDimension(scalableDimension);
            return this;
        }

        /**
         * The CloudFormation-generated ID of an Application Auto Scaling scalable target.
         * <p>
         * For more information about the ID, see the Return Value section of the <code>AWS::ApplicationAutoScaling::ScalableTarget</code> resource.
         * <p>
         * <blockquote>
         * <p>
         * You must specify either the <code>ScalingTargetId</code> property, or the <code>ResourceId</code> , <code>ScalableDimension</code> , and <code>ServiceNamespace</code> properties, but not both.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param scalingTargetId The CloudFormation-generated ID of an Application Auto Scaling scalable target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingTargetId(final java.lang.String scalingTargetId) {
            this.props.scalingTargetId(scalingTargetId);
            return this;
        }

        /**
         * The namespace of the AWS service that provides the resource, or a `custom-resource` .
         * <p>
         * @return {@code this}
         * @param serviceNamespace The namespace of the AWS service that provides the resource, or a `custom-resource` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceNamespace(final java.lang.String serviceNamespace) {
            this.props.serviceNamespace(serviceNamespace);
            return this;
        }

        /**
         * A step scaling policy.
         * <p>
         * @return {@code this}
         * @param stepScalingPolicyConfiguration A step scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepScalingPolicyConfiguration(final software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.StepScalingPolicyConfigurationProperty stepScalingPolicyConfiguration) {
            this.props.stepScalingPolicyConfiguration(stepScalingPolicyConfiguration);
            return this;
        }
        /**
         * A step scaling policy.
         * <p>
         * @return {@code this}
         * @param stepScalingPolicyConfiguration A step scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepScalingPolicyConfiguration(final software.amazon.awscdk.IResolvable stepScalingPolicyConfiguration) {
            this.props.stepScalingPolicyConfiguration(stepScalingPolicyConfiguration);
            return this;
        }

        /**
         * A target tracking scaling policy.
         * <p>
         * @return {@code this}
         * @param targetTrackingScalingPolicyConfiguration A target tracking scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetTrackingScalingPolicyConfiguration(final software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty targetTrackingScalingPolicyConfiguration) {
            this.props.targetTrackingScalingPolicyConfiguration(targetTrackingScalingPolicyConfiguration);
            return this;
        }
        /**
         * A target tracking scaling policy.
         * <p>
         * @return {@code this}
         * @param targetTrackingScalingPolicyConfiguration A target tracking scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetTrackingScalingPolicyConfiguration(final software.amazon.awscdk.IResolvable targetTrackingScalingPolicyConfiguration) {
            this.props.targetTrackingScalingPolicyConfiguration(targetTrackingScalingPolicyConfiguration);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy build() {
            return new software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
