package software.amazon.awscdk.services.acmpca;

/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 * <p>
 * Use the <code>AWS::ACMPCA::CertificateAuthority</code> resource to create a private CA. Once the CA exists, you can use the <code>AWS::ACMPCA::Certificate</code> resource to issue a new CA certificate. Alternatively, you can issue a CA certificate using an on-premises CA, and then use the <code>AWS::ACMPCA::CertificateAuthorityActivation</code> resource to import the new CA certificate and activate the CA.
 * <p>
 * <blockquote>
 * <p>
 * Before removing a <code>AWS::ACMPCA::CertificateAuthority</code> resource from the CloudFormation stack, disable the affected CA. Otherwise, the action will fail. You can disable the CA by removing its associated <code>AWS::ACMPCA::CertificateAuthorityActivation</code> resource from CloudFormation.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnCertificateAuthority cfnCertificateAuthority = CfnCertificateAuthority.Builder.create(this, "CA")
 *         .type("ROOT")
 *         .keyAlgorithm("RSA_2048")
 *         .signingAlgorithm("SHA256WITHRSA")
 *         .subject(SubjectProperty.builder()
 *                 .country("US")
 *                 .organization("string")
 *                 .organizationalUnit("string")
 *                 .distinguishedNameQualifier("string")
 *                 .state("string")
 *                 .commonName("123")
 *                 .serialNumber("string")
 *                 .locality("string")
 *                 .title("string")
 *                 .surname("string")
 *                 .givenName("string")
 *                 .initials("DG")
 *                 .pseudonym("string")
 *                 .generationQualifier("DBG")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:55.662Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateAuthority")
public class CfnCertificateAuthority extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnCertificateAuthority(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCertificateAuthority(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ACMPCA::CertificateAuthority`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCertificateAuthority(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.acmpca.CfnCertificateAuthorityProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) for the private CA that issued the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Base64 PEM-encoded certificate signing request (CSR) for your certificate authority certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCertificateSigningRequest() {
        return software.amazon.jsii.Kernel.get(this, "attrCertificateSigningRequest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Key-value pairs that will be attached to the new private CA.
     * <p>
     * You can associate up to 50 tags with a private CA. For information using tags with IAM to manage permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Type of the public key algorithm and size, in bits, of the key pair that your CA creates when it issues a certificate.
     * <p>
     * When you create a subordinate CA, you must use a key algorithm supported by the parent CA.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyAlgorithm() {
        return software.amazon.jsii.Kernel.get(this, "keyAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Type of the public key algorithm and size, in bits, of the key pair that your CA creates when it issues a certificate.
     * <p>
     * When you create a subordinate CA, you must use a key algorithm supported by the parent CA.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyAlgorithm(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keyAlgorithm", java.util.Objects.requireNonNull(value, "keyAlgorithm is required"));
    }

    /**
     * Name of the algorithm your private CA uses to sign certificate requests.
     * <p>
     * This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign certificates when they are issued.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSigningAlgorithm() {
        return software.amazon.jsii.Kernel.get(this, "signingAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of the algorithm your private CA uses to sign certificate requests.
     * <p>
     * This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign certificates when they are issued.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSigningAlgorithm(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "signingAlgorithm", java.util.Objects.requireNonNull(value, "signingAlgorithm is required"));
    }

    /**
     * Structure that contains X.500 distinguished name information for your private CA.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSubject() {
        return software.amazon.jsii.Kernel.get(this, "subject", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Structure that contains X.500 distinguished name information for your private CA.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubject(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.SubjectProperty value) {
        software.amazon.jsii.Kernel.set(this, "subject", java.util.Objects.requireNonNull(value, "subject is required"));
    }

    /**
     * Structure that contains X.500 distinguished name information for your private CA.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubject(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "subject", java.util.Objects.requireNonNull(value, "subject is required"));
    }

    /**
     * Type of your private CA.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Type of your private CA.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * Specifies information to be added to the extension section of the certificate signing request (CSR).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCsrExtensions() {
        return software.amazon.jsii.Kernel.get(this, "csrExtensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies information to be added to the extension section of the certificate signing request (CSR).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCsrExtensions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.CsrExtensionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "csrExtensions", value);
    }

    /**
     * Specifies information to be added to the extension section of the certificate signing request (CSR).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCsrExtensions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "csrExtensions", value);
    }

    /**
     * Specifies a cryptographic key management compliance standard used for handling CA keys.
     * <p>
     * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
     * <p>
     * <em>Note:</em> <code>FIPS_140_2_LEVEL_3_OR_HIGHER</code> is not supported in the following Regions:
     * <p>
     * <ul>
     * <li>ap-northeast-3</li>
     * <li>ap-southeast-3</li>
     * </ul>
     * <p>
     * When creating a CA in these Regions, you must provide <code>FIPS_140_2_LEVEL_2_OR_HIGHER</code> as the argument for <code>KeyStorageSecurityStandard</code> . Failure to do this results in an <code>InvalidArgsException</code> with the message, "A certificate authority cannot be created in this region with the specified security standard."
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKeyStorageSecurityStandard() {
        return software.amazon.jsii.Kernel.get(this, "keyStorageSecurityStandard", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies a cryptographic key management compliance standard used for handling CA keys.
     * <p>
     * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
     * <p>
     * <em>Note:</em> <code>FIPS_140_2_LEVEL_3_OR_HIGHER</code> is not supported in the following Regions:
     * <p>
     * <ul>
     * <li>ap-northeast-3</li>
     * <li>ap-southeast-3</li>
     * </ul>
     * <p>
     * When creating a CA in these Regions, you must provide <code>FIPS_140_2_LEVEL_2_OR_HIGHER</code> as the argument for <code>KeyStorageSecurityStandard</code> . Failure to do this results in an <code>InvalidArgsException</code> with the message, "A certificate authority cannot be created in this region with the specified security standard."
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyStorageSecurityStandard(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keyStorageSecurityStandard", value);
    }

    /**
     * Information about the certificate revocation list (CRL) created and maintained by your private CA.
     * <p>
     * Certificate revocation information used by the CreateCertificateAuthority and UpdateCertificateAuthority actions. Your certificate authority can create and maintain a certificate revocation list (CRL). A CRL contains information about certificates that have been revoked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRevocationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "revocationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the certificate revocation list (CRL) created and maintained by your private CA.
     * <p>
     * Certificate revocation information used by the CreateCertificateAuthority and UpdateCertificateAuthority actions. Your certificate authority can create and maintain a certificate revocation list (CRL). A CRL contains information about certificates that have been revoked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRevocationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.RevocationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "revocationConfiguration", value);
    }

    /**
     * Information about the certificate revocation list (CRL) created and maintained by your private CA.
     * <p>
     * Certificate revocation information used by the CreateCertificateAuthority and UpdateCertificateAuthority actions. Your certificate authority can create and maintain a certificate revocation list (CRL). A CRL contains information about certificates that have been revoked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRevocationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "revocationConfiguration", value);
    }
    /**
     * Provides access information used by the `authorityInfoAccess` and `subjectInfoAccess` extensions described in [RFC 5280](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280) .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * AccessDescriptionProperty accessDescriptionProperty = AccessDescriptionProperty.builder()
     *         .accessLocation(GeneralNameProperty.builder()
     *                 .directoryName(SubjectProperty.builder()
     *                         .commonName("commonName")
     *                         .country("country")
     *                         .customAttributes(List.of(CustomAttributeProperty.builder()
     *                                 .objectIdentifier("objectIdentifier")
     *                                 .value("value")
     *                                 .build()))
     *                         .distinguishedNameQualifier("distinguishedNameQualifier")
     *                         .generationQualifier("generationQualifier")
     *                         .givenName("givenName")
     *                         .initials("initials")
     *                         .locality("locality")
     *                         .organization("organization")
     *                         .organizationalUnit("organizationalUnit")
     *                         .pseudonym("pseudonym")
     *                         .serialNumber("serialNumber")
     *                         .state("state")
     *                         .surname("surname")
     *                         .title("title")
     *                         .build())
     *                 .dnsName("dnsName")
     *                 .ediPartyName(EdiPartyNameProperty.builder()
     *                         .nameAssigner("nameAssigner")
     *                         .partyName("partyName")
     *                         .build())
     *                 .ipAddress("ipAddress")
     *                 .otherName(OtherNameProperty.builder()
     *                         .typeId("typeId")
     *                         .value("value")
     *                         .build())
     *                 .registeredId("registeredId")
     *                 .rfc822Name("rfc822Name")
     *                 .uniformResourceIdentifier("uniformResourceIdentifier")
     *                 .build())
     *         .accessMethod(AccessMethodProperty.builder()
     *                 .accessMethodType("accessMethodType")
     *                 .customObjectIdentifier("customObjectIdentifier")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.AccessDescriptionProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessDescriptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessDescriptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of `AccessDescription` information.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAccessLocation();

        /**
         * The type and format of `AccessDescription` information.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAccessMethod();

        /**
         * @return a {@link Builder} of {@link AccessDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessDescriptionProperty> {
            java.lang.Object accessLocation;
            java.lang.Object accessMethod;

            /**
             * Sets the value of {@link AccessDescriptionProperty#getAccessLocation}
             * @param accessLocation The location of `AccessDescription` information. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessLocation(software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.GeneralNameProperty accessLocation) {
                this.accessLocation = accessLocation;
                return this;
            }

            /**
             * Sets the value of {@link AccessDescriptionProperty#getAccessLocation}
             * @param accessLocation The location of `AccessDescription` information. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessLocation(software.amazon.awscdk.IResolvable accessLocation) {
                this.accessLocation = accessLocation;
                return this;
            }

            /**
             * Sets the value of {@link AccessDescriptionProperty#getAccessMethod}
             * @param accessMethod The type and format of `AccessDescription` information. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessMethod(software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.AccessMethodProperty accessMethod) {
                this.accessMethod = accessMethod;
                return this;
            }

            /**
             * Sets the value of {@link AccessDescriptionProperty#getAccessMethod}
             * @param accessMethod The type and format of `AccessDescription` information. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessMethod(software.amazon.awscdk.IResolvable accessMethod) {
                this.accessMethod = accessMethod;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessDescriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessDescriptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessDescriptionProperty {
            private final java.lang.Object accessLocation;
            private final java.lang.Object accessMethod;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessLocation = software.amazon.jsii.Kernel.get(this, "accessLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.accessMethod = software.amazon.jsii.Kernel.get(this, "accessMethod", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessLocation = java.util.Objects.requireNonNull(builder.accessLocation, "accessLocation is required");
                this.accessMethod = java.util.Objects.requireNonNull(builder.accessMethod, "accessMethod is required");
            }

            @Override
            public final java.lang.Object getAccessLocation() {
                return this.accessLocation;
            }

            @Override
            public final java.lang.Object getAccessMethod() {
                return this.accessMethod;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accessLocation", om.valueToTree(this.getAccessLocation()));
                data.set("accessMethod", om.valueToTree(this.getAccessMethod()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.AccessDescriptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessDescriptionProperty.Jsii$Proxy that = (AccessDescriptionProperty.Jsii$Proxy) o;

                if (!accessLocation.equals(that.accessLocation)) return false;
                return this.accessMethod.equals(that.accessMethod);
            }

            @Override
            public final int hashCode() {
                int result = this.accessLocation.hashCode();
                result = 31 * result + (this.accessMethod.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes the type and format of extension access.
     * <p>
     * Only one of <code>CustomObjectIdentifier</code> or <code>AccessMethodType</code> may be provided. Providing both results in <code>InvalidArgsException</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * AccessMethodProperty accessMethodProperty = AccessMethodProperty.builder()
     *         .accessMethodType("accessMethodType")
     *         .customObjectIdentifier("customObjectIdentifier")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.AccessMethodProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessMethodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessMethodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the `AccessMethod` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessMethodType() {
            return null;
        }

        /**
         * An object identifier (OID) specifying the `AccessMethod` .
         * <p>
         * The OID must satisfy the regular expression shown below. For more information, see NIST's definition of <a href="https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomObjectIdentifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessMethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessMethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessMethodProperty> {
            java.lang.String accessMethodType;
            java.lang.String customObjectIdentifier;

            /**
             * Sets the value of {@link AccessMethodProperty#getAccessMethodType}
             * @param accessMethodType Specifies the `AccessMethod` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessMethodType(java.lang.String accessMethodType) {
                this.accessMethodType = accessMethodType;
                return this;
            }

            /**
             * Sets the value of {@link AccessMethodProperty#getCustomObjectIdentifier}
             * @param customObjectIdentifier An object identifier (OID) specifying the `AccessMethod` .
             *                               The OID must satisfy the regular expression shown below. For more information, see NIST's definition of <a href="https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customObjectIdentifier(java.lang.String customObjectIdentifier) {
                this.customObjectIdentifier = customObjectIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessMethodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessMethodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessMethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessMethodProperty {
            private final java.lang.String accessMethodType;
            private final java.lang.String customObjectIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessMethodType = software.amazon.jsii.Kernel.get(this, "accessMethodType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customObjectIdentifier = software.amazon.jsii.Kernel.get(this, "customObjectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessMethodType = builder.accessMethodType;
                this.customObjectIdentifier = builder.customObjectIdentifier;
            }

            @Override
            public final java.lang.String getAccessMethodType() {
                return this.accessMethodType;
            }

            @Override
            public final java.lang.String getCustomObjectIdentifier() {
                return this.customObjectIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessMethodType() != null) {
                    data.set("accessMethodType", om.valueToTree(this.getAccessMethodType()));
                }
                if (this.getCustomObjectIdentifier() != null) {
                    data.set("customObjectIdentifier", om.valueToTree(this.getCustomObjectIdentifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.AccessMethodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessMethodProperty.Jsii$Proxy that = (AccessMethodProperty.Jsii$Proxy) o;

                if (this.accessMethodType != null ? !this.accessMethodType.equals(that.accessMethodType) : that.accessMethodType != null) return false;
                return this.customObjectIdentifier != null ? this.customObjectIdentifier.equals(that.customObjectIdentifier) : that.customObjectIdentifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessMethodType != null ? this.accessMethodType.hashCode() : 0;
                result = 31 * result + (this.customObjectIdentifier != null ? this.customObjectIdentifier.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configuration information for a certificate revocation list (CRL).
     * <p>
     * Your private certificate authority (CA) creates base CRLs. Delta CRLs are not supported. You can enable CRLs for your new or an existing private CA by setting the <em>Enabled</em> parameter to <code>true</code> . Your private CA writes CRLs to an S3 bucket that you specify in the <em>S3BucketName</em> parameter. You can hide the name of your bucket by specifying a value for the <em>CustomCname</em> parameter. Your private CA copies the CNAME or the S3 bucket name to the <em>CRL Distribution Points</em> extension of each certificate it issues. Your S3 bucket policy must give write permission to ACM Private CA.
     * <p>
     * ACM Private CA assets that are stored in Amazon S3 can be protected with encryption. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#crl-encryption">Encrypting Your CRLs</a> .
     * <p>
     * Your private CA uses the value in the <em>ExpirationInDays</em> parameter to calculate the <em>nextUpdate</em> field in the CRL. The CRL is refreshed prior to a certificate's expiration date or when a certificate is revoked. When a certificate is revoked, it appears in the CRL until the certificate expires, and then in one additional CRL after expiration, and it always appears in the audit report.
     * <p>
     * A CRL is typically updated approximately 30 minutes after a certificate is revoked. If for any reason a CRL update fails, ACM Private CA makes further attempts every 15 minutes.
     * <p>
     * CRLs contain the following fields:
     * <p>
     * <ul>
     * <li><em>Version</em> : The current version number defined in RFC 5280 is V2. The integer value is 0x1.</li>
     * <li><em>Signature Algorithm</em> : The name of the algorithm used to sign the CRL.</li>
     * <li><em>Issuer</em> : The X.500 distinguished name of your private CA that issued the CRL.</li>
     * <li><em>Last Update</em> : The issue date and time of this CRL.</li>
     * <li><em>Next Update</em> : The day and time by which the next CRL will be issued.</li>
     * <li><em>Revoked Certificates</em> : List of revoked certificates. Each list item contains the following information.</li>
     * <li><em>Serial Number</em> : The serial number, in hexadecimal format, of the revoked certificate.</li>
     * <li><em>Revocation Date</em> : Date and time the certificate was revoked.</li>
     * <li><em>CRL Entry Extensions</em> : Optional extensions for the CRL entry.</li>
     * <li><em>X509v3 CRL Reason Code</em> : Reason the certificate was revoked.</li>
     * <li><em>CRL Extensions</em> : Optional extensions for the CRL.</li>
     * <li><em>X509v3 Authority Key Identifier</em> : Identifies the public key associated with the private key used to sign the certificate.</li>
     * <li><em>X509v3 CRL Number:</em> : Decimal sequence number for the CRL.</li>
     * <li><em>Signature Algorithm</em> : Algorithm used by your private CA to sign the CRL.</li>
     * <li><em>Signature Value</em> : Signature computed over the CRL.</li>
     * </ul>
     * <p>
     * Certificate revocation lists created by ACM Private CA are DER-encoded. You can use the following OpenSSL command to list a CRL.
     * <p>
     * <code>openssl crl -inform DER -text -in *crl_path* -noout</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html">Planning a certificate revocation list (CRL)</a> in the <em>AWS Certificate Manager Private Certificate Authority (PCA) User Guide</em>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * CrlConfigurationProperty crlConfigurationProperty = CrlConfigurationProperty.builder()
     *         .customCname("customCname")
     *         .enabled(false)
     *         .expirationInDays(123)
     *         .s3BucketName("s3BucketName")
     *         .s3ObjectAcl("s3ObjectAcl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.CrlConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CrlConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CrlConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Name inserted into the certificate *CRL Distribution Points* extension that enables the use of an alias for the CRL distribution point.
         * <p>
         * Use this value if you don't want the name of your S3 bucket to be public.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomCname() {
            return null;
        }

        /**
         * Boolean value that specifies whether certificate revocation lists (CRLs) are enabled.
         * <p>
         * You can use this value to enable certificate revocation for a new CA when you call the <code>CreateCertificateAuthority</code> operation or for an existing CA when you call the <code>UpdateCertificateAuthority</code> operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * Validity period of the CRL in days.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getExpirationInDays() {
            return null;
        }

        /**
         * Name of the S3 bucket that contains the CRL.
         * <p>
         * If you do not provide a value for the <em>CustomCname</em> argument, the name of your S3 bucket is placed into the <em>CRL Distribution Points</em> extension of the issued certificate. You can change the name of your bucket by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> operation. You must specify a <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-policies">bucket policy</a> that allows ACM Private CA to write the CRL to your bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketName() {
            return null;
        }

        /**
         * Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket.
         * <p>
         * If you choose PUBLIC_READ, the CRL will be accessible over the public internet. If you choose BUCKET_OWNER_FULL_CONTROL, only the owner of the CRL S3 bucket can access the CRL, and your PKI clients may need an alternative method of access.
         * <p>
         * If no value is specified, the default is PUBLIC_READ.
         * <p>
         * <blockquote>
         * <p>
         * This default can cause CA creation to fail in some circumstances. If you have enabled the Block Public Access (BPA) feature in your S3 account, then you must specify the value of this parameter as <code>BUCKET_OWNER_FULL_CONTROL</code> , and not doing so results in an error. If you have disabled BPA in S3, then you can specify either <code>BUCKET_OWNER_FULL_CONTROL</code> or <code>PUBLIC_READ</code> as the value.
         * <p>
         * </blockquote>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-bpa">Blocking public access to the S3 bucket</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3ObjectAcl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CrlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CrlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CrlConfigurationProperty> {
            java.lang.String customCname;
            java.lang.Object enabled;
            java.lang.Number expirationInDays;
            java.lang.String s3BucketName;
            java.lang.String s3ObjectAcl;

            /**
             * Sets the value of {@link CrlConfigurationProperty#getCustomCname}
             * @param customCname Name inserted into the certificate *CRL Distribution Points* extension that enables the use of an alias for the CRL distribution point.
             *                    Use this value if you don't want the name of your S3 bucket to be public.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customCname(java.lang.String customCname) {
                this.customCname = customCname;
                return this;
            }

            /**
             * Sets the value of {@link CrlConfigurationProperty#getEnabled}
             * @param enabled Boolean value that specifies whether certificate revocation lists (CRLs) are enabled.
             *                You can use this value to enable certificate revocation for a new CA when you call the <code>CreateCertificateAuthority</code> operation or for an existing CA when you call the <code>UpdateCertificateAuthority</code> operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CrlConfigurationProperty#getEnabled}
             * @param enabled Boolean value that specifies whether certificate revocation lists (CRLs) are enabled.
             *                You can use this value to enable certificate revocation for a new CA when you call the <code>CreateCertificateAuthority</code> operation or for an existing CA when you call the <code>UpdateCertificateAuthority</code> operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CrlConfigurationProperty#getExpirationInDays}
             * @param expirationInDays Validity period of the CRL in days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expirationInDays(java.lang.Number expirationInDays) {
                this.expirationInDays = expirationInDays;
                return this;
            }

            /**
             * Sets the value of {@link CrlConfigurationProperty#getS3BucketName}
             * @param s3BucketName Name of the S3 bucket that contains the CRL.
             *                     If you do not provide a value for the <em>CustomCname</em> argument, the name of your S3 bucket is placed into the <em>CRL Distribution Points</em> extension of the issued certificate. You can change the name of your bucket by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> operation. You must specify a <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-policies">bucket policy</a> that allows ACM Private CA to write the CRL to your bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link CrlConfigurationProperty#getS3ObjectAcl}
             * @param s3ObjectAcl Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket.
             *                    If you choose PUBLIC_READ, the CRL will be accessible over the public internet. If you choose BUCKET_OWNER_FULL_CONTROL, only the owner of the CRL S3 bucket can access the CRL, and your PKI clients may need an alternative method of access.
             *                    <p>
             *                    If no value is specified, the default is PUBLIC_READ.
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    This default can cause CA creation to fail in some circumstances. If you have enabled the Block Public Access (BPA) feature in your S3 account, then you must specify the value of this parameter as <code>BUCKET_OWNER_FULL_CONTROL</code> , and not doing so results in an error. If you have disabled BPA in S3, then you can specify either <code>BUCKET_OWNER_FULL_CONTROL</code> or <code>PUBLIC_READ</code> as the value.
             *                    <p>
             *                    </blockquote>
             *                    <p>
             *                    For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-bpa">Blocking public access to the S3 bucket</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ObjectAcl(java.lang.String s3ObjectAcl) {
                this.s3ObjectAcl = s3ObjectAcl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CrlConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CrlConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CrlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrlConfigurationProperty {
            private final java.lang.String customCname;
            private final java.lang.Object enabled;
            private final java.lang.Number expirationInDays;
            private final java.lang.String s3BucketName;
            private final java.lang.String s3ObjectAcl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customCname = software.amazon.jsii.Kernel.get(this, "customCname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.expirationInDays = software.amazon.jsii.Kernel.get(this, "expirationInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3ObjectAcl = software.amazon.jsii.Kernel.get(this, "s3ObjectAcl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customCname = builder.customCname;
                this.enabled = builder.enabled;
                this.expirationInDays = builder.expirationInDays;
                this.s3BucketName = builder.s3BucketName;
                this.s3ObjectAcl = builder.s3ObjectAcl;
            }

            @Override
            public final java.lang.String getCustomCname() {
                return this.customCname;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Number getExpirationInDays() {
                return this.expirationInDays;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            public final java.lang.String getS3ObjectAcl() {
                return this.s3ObjectAcl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomCname() != null) {
                    data.set("customCname", om.valueToTree(this.getCustomCname()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getExpirationInDays() != null) {
                    data.set("expirationInDays", om.valueToTree(this.getExpirationInDays()));
                }
                if (this.getS3BucketName() != null) {
                    data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                }
                if (this.getS3ObjectAcl() != null) {
                    data.set("s3ObjectAcl", om.valueToTree(this.getS3ObjectAcl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.CrlConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CrlConfigurationProperty.Jsii$Proxy that = (CrlConfigurationProperty.Jsii$Proxy) o;

                if (this.customCname != null ? !this.customCname.equals(that.customCname) : that.customCname != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.expirationInDays != null ? !this.expirationInDays.equals(that.expirationInDays) : that.expirationInDays != null) return false;
                if (this.s3BucketName != null ? !this.s3BucketName.equals(that.s3BucketName) : that.s3BucketName != null) return false;
                return this.s3ObjectAcl != null ? this.s3ObjectAcl.equals(that.s3ObjectAcl) : that.s3ObjectAcl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customCname != null ? this.customCname.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.expirationInDays != null ? this.expirationInDays.hashCode() : 0);
                result = 31 * result + (this.s3BucketName != null ? this.s3BucketName.hashCode() : 0);
                result = 31 * result + (this.s3ObjectAcl != null ? this.s3ObjectAcl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the certificate extensions to be added to the certificate signing request (CSR).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * CsrExtensionsProperty csrExtensionsProperty = CsrExtensionsProperty.builder()
     *         .keyUsage(KeyUsageProperty.builder()
     *                 .crlSign(false)
     *                 .dataEncipherment(false)
     *                 .decipherOnly(false)
     *                 .digitalSignature(false)
     *                 .encipherOnly(false)
     *                 .keyAgreement(false)
     *                 .keyCertSign(false)
     *                 .keyEncipherment(false)
     *                 .nonRepudiation(false)
     *                 .build())
     *         .subjectInformationAccess(List.of(AccessDescriptionProperty.builder()
     *                 .accessLocation(GeneralNameProperty.builder()
     *                         .directoryName(SubjectProperty.builder()
     *                                 .commonName("commonName")
     *                                 .country("country")
     *                                 .customAttributes(List.of(CustomAttributeProperty.builder()
     *                                         .objectIdentifier("objectIdentifier")
     *                                         .value("value")
     *                                         .build()))
     *                                 .distinguishedNameQualifier("distinguishedNameQualifier")
     *                                 .generationQualifier("generationQualifier")
     *                                 .givenName("givenName")
     *                                 .initials("initials")
     *                                 .locality("locality")
     *                                 .organization("organization")
     *                                 .organizationalUnit("organizationalUnit")
     *                                 .pseudonym("pseudonym")
     *                                 .serialNumber("serialNumber")
     *                                 .state("state")
     *                                 .surname("surname")
     *                                 .title("title")
     *                                 .build())
     *                         .dnsName("dnsName")
     *                         .ediPartyName(EdiPartyNameProperty.builder()
     *                                 .nameAssigner("nameAssigner")
     *                                 .partyName("partyName")
     *                                 .build())
     *                         .ipAddress("ipAddress")
     *                         .otherName(OtherNameProperty.builder()
     *                                 .typeId("typeId")
     *                                 .value("value")
     *                                 .build())
     *                         .registeredId("registeredId")
     *                         .rfc822Name("rfc822Name")
     *                         .uniformResourceIdentifier("uniformResourceIdentifier")
     *                         .build())
     *                 .accessMethod(AccessMethodProperty.builder()
     *                         .accessMethodType("accessMethodType")
     *                         .customObjectIdentifier("customObjectIdentifier")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.CsrExtensionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CsrExtensionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CsrExtensionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates the purpose of the certificate and of the key contained in the certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyUsage() {
            return null;
        }

        /**
         * For CA certificates, provides a path to additional information pertaining to the CA, such as revocation and policy.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2">Subject Information Access</a> in RFC 5280.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubjectInformationAccess() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CsrExtensionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CsrExtensionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CsrExtensionsProperty> {
            java.lang.Object keyUsage;
            java.lang.Object subjectInformationAccess;

            /**
             * Sets the value of {@link CsrExtensionsProperty#getKeyUsage}
             * @param keyUsage Indicates the purpose of the certificate and of the key contained in the certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsage(software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.KeyUsageProperty keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            /**
             * Sets the value of {@link CsrExtensionsProperty#getKeyUsage}
             * @param keyUsage Indicates the purpose of the certificate and of the key contained in the certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsage(software.amazon.awscdk.IResolvable keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            /**
             * Sets the value of {@link CsrExtensionsProperty#getSubjectInformationAccess}
             * @param subjectInformationAccess For CA certificates, provides a path to additional information pertaining to the CA, such as revocation and policy.
             *                                 For more information, see <a href="https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2">Subject Information Access</a> in RFC 5280.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectInformationAccess(software.amazon.awscdk.IResolvable subjectInformationAccess) {
                this.subjectInformationAccess = subjectInformationAccess;
                return this;
            }

            /**
             * Sets the value of {@link CsrExtensionsProperty#getSubjectInformationAccess}
             * @param subjectInformationAccess For CA certificates, provides a path to additional information pertaining to the CA, such as revocation and policy.
             *                                 For more information, see <a href="https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2">Subject Information Access</a> in RFC 5280.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectInformationAccess(java.util.List<? extends java.lang.Object> subjectInformationAccess) {
                this.subjectInformationAccess = subjectInformationAccess;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CsrExtensionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CsrExtensionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CsrExtensionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CsrExtensionsProperty {
            private final java.lang.Object keyUsage;
            private final java.lang.Object subjectInformationAccess;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keyUsage = software.amazon.jsii.Kernel.get(this, "keyUsage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subjectInformationAccess = software.amazon.jsii.Kernel.get(this, "subjectInformationAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyUsage = builder.keyUsage;
                this.subjectInformationAccess = builder.subjectInformationAccess;
            }

            @Override
            public final java.lang.Object getKeyUsage() {
                return this.keyUsage;
            }

            @Override
            public final java.lang.Object getSubjectInformationAccess() {
                return this.subjectInformationAccess;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKeyUsage() != null) {
                    data.set("keyUsage", om.valueToTree(this.getKeyUsage()));
                }
                if (this.getSubjectInformationAccess() != null) {
                    data.set("subjectInformationAccess", om.valueToTree(this.getSubjectInformationAccess()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.CsrExtensionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CsrExtensionsProperty.Jsii$Proxy that = (CsrExtensionsProperty.Jsii$Proxy) o;

                if (this.keyUsage != null ? !this.keyUsage.equals(that.keyUsage) : that.keyUsage != null) return false;
                return this.subjectInformationAccess != null ? this.subjectInformationAccess.equals(that.subjectInformationAccess) : that.subjectInformationAccess == null;
            }

            @Override
            public final int hashCode() {
                int result = this.keyUsage != null ? this.keyUsage.hashCode() : 0;
                result = 31 * result + (this.subjectInformationAccess != null ? this.subjectInformationAccess.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the X.500 relative distinguished name (RDN).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * CustomAttributeProperty customAttributeProperty = CustomAttributeProperty.builder()
     *         .objectIdentifier("objectIdentifier")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.CustomAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the object identifier (OID) of the attribute type of the relative distinguished name (RDN).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObjectIdentifier();

        /**
         * Specifies the attribute value of relative distinguished name (RDN).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link CustomAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomAttributeProperty> {
            java.lang.String objectIdentifier;
            java.lang.String value;

            /**
             * Sets the value of {@link CustomAttributeProperty#getObjectIdentifier}
             * @param objectIdentifier Specifies the object identifier (OID) of the attribute type of the relative distinguished name (RDN). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectIdentifier(java.lang.String objectIdentifier) {
                this.objectIdentifier = objectIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link CustomAttributeProperty#getValue}
             * @param value Specifies the attribute value of relative distinguished name (RDN). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomAttributeProperty {
            private final java.lang.String objectIdentifier;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.objectIdentifier = software.amazon.jsii.Kernel.get(this, "objectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.objectIdentifier = java.util.Objects.requireNonNull(builder.objectIdentifier, "objectIdentifier is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getObjectIdentifier() {
                return this.objectIdentifier;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("objectIdentifier", om.valueToTree(this.getObjectIdentifier()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.CustomAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomAttributeProperty.Jsii$Proxy that = (CustomAttributeProperty.Jsii$Proxy) o;

                if (!objectIdentifier.equals(that.objectIdentifier)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.objectIdentifier.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes an Electronic Data Interchange (EDI) entity as described in as defined in [Subject Alternative Name](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280) in RFC 5280.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * EdiPartyNameProperty ediPartyNameProperty = EdiPartyNameProperty.builder()
     *         .nameAssigner("nameAssigner")
     *         .partyName("partyName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.EdiPartyNameProperty")
    @software.amazon.jsii.Jsii.Proxy(EdiPartyNameProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EdiPartyNameProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the name assigner.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNameAssigner();

        /**
         * Specifies the party name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPartyName();

        /**
         * @return a {@link Builder} of {@link EdiPartyNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EdiPartyNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EdiPartyNameProperty> {
            java.lang.String nameAssigner;
            java.lang.String partyName;

            /**
             * Sets the value of {@link EdiPartyNameProperty#getNameAssigner}
             * @param nameAssigner Specifies the name assigner. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nameAssigner(java.lang.String nameAssigner) {
                this.nameAssigner = nameAssigner;
                return this;
            }

            /**
             * Sets the value of {@link EdiPartyNameProperty#getPartyName}
             * @param partyName Specifies the party name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partyName(java.lang.String partyName) {
                this.partyName = partyName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EdiPartyNameProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EdiPartyNameProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EdiPartyNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EdiPartyNameProperty {
            private final java.lang.String nameAssigner;
            private final java.lang.String partyName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nameAssigner = software.amazon.jsii.Kernel.get(this, "nameAssigner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.partyName = software.amazon.jsii.Kernel.get(this, "partyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nameAssigner = java.util.Objects.requireNonNull(builder.nameAssigner, "nameAssigner is required");
                this.partyName = java.util.Objects.requireNonNull(builder.partyName, "partyName is required");
            }

            @Override
            public final java.lang.String getNameAssigner() {
                return this.nameAssigner;
            }

            @Override
            public final java.lang.String getPartyName() {
                return this.partyName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("nameAssigner", om.valueToTree(this.getNameAssigner()));
                data.set("partyName", om.valueToTree(this.getPartyName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.EdiPartyNameProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EdiPartyNameProperty.Jsii$Proxy that = (EdiPartyNameProperty.Jsii$Proxy) o;

                if (!nameAssigner.equals(that.nameAssigner)) return false;
                return this.partyName.equals(that.partyName);
            }

            @Override
            public final int hashCode() {
                int result = this.nameAssigner.hashCode();
                result = 31 * result + (this.partyName.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes an ASN.1 X.400 `GeneralName` as defined in [RFC 5280](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280) . Only one of the following naming options should be provided. Providing more than one option results in an `InvalidArgsException` error.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * GeneralNameProperty generalNameProperty = GeneralNameProperty.builder()
     *         .directoryName(SubjectProperty.builder()
     *                 .commonName("commonName")
     *                 .country("country")
     *                 .customAttributes(List.of(CustomAttributeProperty.builder()
     *                         .objectIdentifier("objectIdentifier")
     *                         .value("value")
     *                         .build()))
     *                 .distinguishedNameQualifier("distinguishedNameQualifier")
     *                 .generationQualifier("generationQualifier")
     *                 .givenName("givenName")
     *                 .initials("initials")
     *                 .locality("locality")
     *                 .organization("organization")
     *                 .organizationalUnit("organizationalUnit")
     *                 .pseudonym("pseudonym")
     *                 .serialNumber("serialNumber")
     *                 .state("state")
     *                 .surname("surname")
     *                 .title("title")
     *                 .build())
     *         .dnsName("dnsName")
     *         .ediPartyName(EdiPartyNameProperty.builder()
     *                 .nameAssigner("nameAssigner")
     *                 .partyName("partyName")
     *                 .build())
     *         .ipAddress("ipAddress")
     *         .otherName(OtherNameProperty.builder()
     *                 .typeId("typeId")
     *                 .value("value")
     *                 .build())
     *         .registeredId("registeredId")
     *         .rfc822Name("rfc822Name")
     *         .uniformResourceIdentifier("uniformResourceIdentifier")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.GeneralNameProperty")
    @software.amazon.jsii.Jsii.Proxy(GeneralNameProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeneralNameProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains information about the certificate subject.
         * <p>
         * The certificate can be one issued by your private certificate authority (CA) or it can be your private CA certificate. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate. The DN must be unique for each entity, but your private CA can issue more than one certificate with the same DN to the same entity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDirectoryName() {
            return null;
        }

        /**
         * Represents `GeneralName` as a DNS name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDnsName() {
            return null;
        }

        /**
         * Represents `GeneralName` as an `EdiPartyName` object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEdiPartyName() {
            return null;
        }

        /**
         * Represents `GeneralName` as an IPv4 or IPv6 address.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpAddress() {
            return null;
        }

        /**
         * Represents `GeneralName` using an `OtherName` object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOtherName() {
            return null;
        }

        /**
         * Represents `GeneralName` as an object identifier (OID).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegisteredId() {
            return null;
        }

        /**
         * Represents `GeneralName` as an [RFC 822](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc822) email address.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRfc822Name() {
            return null;
        }

        /**
         * Represents `GeneralName` as a URI.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUniformResourceIdentifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeneralNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeneralNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeneralNameProperty> {
            java.lang.Object directoryName;
            java.lang.String dnsName;
            java.lang.Object ediPartyName;
            java.lang.String ipAddress;
            java.lang.Object otherName;
            java.lang.String registeredId;
            java.lang.String rfc822Name;
            java.lang.String uniformResourceIdentifier;

            /**
             * Sets the value of {@link GeneralNameProperty#getDirectoryName}
             * @param directoryName Contains information about the certificate subject.
             *                      The certificate can be one issued by your private certificate authority (CA) or it can be your private CA certificate. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate. The DN must be unique for each entity, but your private CA can issue more than one certificate with the same DN to the same entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder directoryName(software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.SubjectProperty directoryName) {
                this.directoryName = directoryName;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getDirectoryName}
             * @param directoryName Contains information about the certificate subject.
             *                      The certificate can be one issued by your private certificate authority (CA) or it can be your private CA certificate. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate. The DN must be unique for each entity, but your private CA can issue more than one certificate with the same DN to the same entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder directoryName(software.amazon.awscdk.IResolvable directoryName) {
                this.directoryName = directoryName;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getDnsName}
             * @param dnsName Represents `GeneralName` as a DNS name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsName(java.lang.String dnsName) {
                this.dnsName = dnsName;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getEdiPartyName}
             * @param ediPartyName Represents `GeneralName` as an `EdiPartyName` object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ediPartyName(software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.EdiPartyNameProperty ediPartyName) {
                this.ediPartyName = ediPartyName;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getEdiPartyName}
             * @param ediPartyName Represents `GeneralName` as an `EdiPartyName` object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ediPartyName(software.amazon.awscdk.IResolvable ediPartyName) {
                this.ediPartyName = ediPartyName;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getIpAddress}
             * @param ipAddress Represents `GeneralName` as an IPv4 or IPv6 address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipAddress(java.lang.String ipAddress) {
                this.ipAddress = ipAddress;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getOtherName}
             * @param otherName Represents `GeneralName` using an `OtherName` object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder otherName(software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.OtherNameProperty otherName) {
                this.otherName = otherName;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getOtherName}
             * @param otherName Represents `GeneralName` using an `OtherName` object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder otherName(software.amazon.awscdk.IResolvable otherName) {
                this.otherName = otherName;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getRegisteredId}
             * @param registeredId Represents `GeneralName` as an object identifier (OID).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder registeredId(java.lang.String registeredId) {
                this.registeredId = registeredId;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getRfc822Name}
             * @param rfc822Name Represents `GeneralName` as an [RFC 822](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc822) email address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rfc822Name(java.lang.String rfc822Name) {
                this.rfc822Name = rfc822Name;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getUniformResourceIdentifier}
             * @param uniformResourceIdentifier Represents `GeneralName` as a URI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uniformResourceIdentifier(java.lang.String uniformResourceIdentifier) {
                this.uniformResourceIdentifier = uniformResourceIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeneralNameProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeneralNameProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GeneralNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeneralNameProperty {
            private final java.lang.Object directoryName;
            private final java.lang.String dnsName;
            private final java.lang.Object ediPartyName;
            private final java.lang.String ipAddress;
            private final java.lang.Object otherName;
            private final java.lang.String registeredId;
            private final java.lang.String rfc822Name;
            private final java.lang.String uniformResourceIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.directoryName = software.amazon.jsii.Kernel.get(this, "directoryName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dnsName = software.amazon.jsii.Kernel.get(this, "dnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ediPartyName = software.amazon.jsii.Kernel.get(this, "ediPartyName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ipAddress = software.amazon.jsii.Kernel.get(this, "ipAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.otherName = software.amazon.jsii.Kernel.get(this, "otherName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.registeredId = software.amazon.jsii.Kernel.get(this, "registeredId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rfc822Name = software.amazon.jsii.Kernel.get(this, "rfc822Name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.uniformResourceIdentifier = software.amazon.jsii.Kernel.get(this, "uniformResourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.directoryName = builder.directoryName;
                this.dnsName = builder.dnsName;
                this.ediPartyName = builder.ediPartyName;
                this.ipAddress = builder.ipAddress;
                this.otherName = builder.otherName;
                this.registeredId = builder.registeredId;
                this.rfc822Name = builder.rfc822Name;
                this.uniformResourceIdentifier = builder.uniformResourceIdentifier;
            }

            @Override
            public final java.lang.Object getDirectoryName() {
                return this.directoryName;
            }

            @Override
            public final java.lang.String getDnsName() {
                return this.dnsName;
            }

            @Override
            public final java.lang.Object getEdiPartyName() {
                return this.ediPartyName;
            }

            @Override
            public final java.lang.String getIpAddress() {
                return this.ipAddress;
            }

            @Override
            public final java.lang.Object getOtherName() {
                return this.otherName;
            }

            @Override
            public final java.lang.String getRegisteredId() {
                return this.registeredId;
            }

            @Override
            public final java.lang.String getRfc822Name() {
                return this.rfc822Name;
            }

            @Override
            public final java.lang.String getUniformResourceIdentifier() {
                return this.uniformResourceIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDirectoryName() != null) {
                    data.set("directoryName", om.valueToTree(this.getDirectoryName()));
                }
                if (this.getDnsName() != null) {
                    data.set("dnsName", om.valueToTree(this.getDnsName()));
                }
                if (this.getEdiPartyName() != null) {
                    data.set("ediPartyName", om.valueToTree(this.getEdiPartyName()));
                }
                if (this.getIpAddress() != null) {
                    data.set("ipAddress", om.valueToTree(this.getIpAddress()));
                }
                if (this.getOtherName() != null) {
                    data.set("otherName", om.valueToTree(this.getOtherName()));
                }
                if (this.getRegisteredId() != null) {
                    data.set("registeredId", om.valueToTree(this.getRegisteredId()));
                }
                if (this.getRfc822Name() != null) {
                    data.set("rfc822Name", om.valueToTree(this.getRfc822Name()));
                }
                if (this.getUniformResourceIdentifier() != null) {
                    data.set("uniformResourceIdentifier", om.valueToTree(this.getUniformResourceIdentifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.GeneralNameProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeneralNameProperty.Jsii$Proxy that = (GeneralNameProperty.Jsii$Proxy) o;

                if (this.directoryName != null ? !this.directoryName.equals(that.directoryName) : that.directoryName != null) return false;
                if (this.dnsName != null ? !this.dnsName.equals(that.dnsName) : that.dnsName != null) return false;
                if (this.ediPartyName != null ? !this.ediPartyName.equals(that.ediPartyName) : that.ediPartyName != null) return false;
                if (this.ipAddress != null ? !this.ipAddress.equals(that.ipAddress) : that.ipAddress != null) return false;
                if (this.otherName != null ? !this.otherName.equals(that.otherName) : that.otherName != null) return false;
                if (this.registeredId != null ? !this.registeredId.equals(that.registeredId) : that.registeredId != null) return false;
                if (this.rfc822Name != null ? !this.rfc822Name.equals(that.rfc822Name) : that.rfc822Name != null) return false;
                return this.uniformResourceIdentifier != null ? this.uniformResourceIdentifier.equals(that.uniformResourceIdentifier) : that.uniformResourceIdentifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.directoryName != null ? this.directoryName.hashCode() : 0;
                result = 31 * result + (this.dnsName != null ? this.dnsName.hashCode() : 0);
                result = 31 * result + (this.ediPartyName != null ? this.ediPartyName.hashCode() : 0);
                result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
                result = 31 * result + (this.otherName != null ? this.otherName.hashCode() : 0);
                result = 31 * result + (this.registeredId != null ? this.registeredId.hashCode() : 0);
                result = 31 * result + (this.rfc822Name != null ? this.rfc822Name.hashCode() : 0);
                result = 31 * result + (this.uniformResourceIdentifier != null ? this.uniformResourceIdentifier.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines one or more purposes for which the key contained in the certificate can be used.
     * <p>
     * Default value for each option is false.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * KeyUsageProperty keyUsageProperty = KeyUsageProperty.builder()
     *         .crlSign(false)
     *         .dataEncipherment(false)
     *         .decipherOnly(false)
     *         .digitalSignature(false)
     *         .encipherOnly(false)
     *         .keyAgreement(false)
     *         .keyCertSign(false)
     *         .keyEncipherment(false)
     *         .nonRepudiation(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.KeyUsageProperty")
    @software.amazon.jsii.Jsii.Proxy(KeyUsageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeyUsageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Key can be used to sign CRLs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrlSign() {
            return null;
        }

        /**
         * Key can be used to decipher data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataEncipherment() {
            return null;
        }

        /**
         * Key can be used only to decipher data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecipherOnly() {
            return null;
        }

        /**
         * Key can be used for digital signing.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDigitalSignature() {
            return null;
        }

        /**
         * Key can be used only to encipher data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncipherOnly() {
            return null;
        }

        /**
         * Key can be used in a key-agreement protocol.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyAgreement() {
            return null;
        }

        /**
         * Key can be used to sign certificates.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyCertSign() {
            return null;
        }

        /**
         * Key can be used to encipher data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyEncipherment() {
            return null;
        }

        /**
         * Key can be used for non-repudiation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNonRepudiation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KeyUsageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeyUsageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeyUsageProperty> {
            java.lang.Object crlSign;
            java.lang.Object dataEncipherment;
            java.lang.Object decipherOnly;
            java.lang.Object digitalSignature;
            java.lang.Object encipherOnly;
            java.lang.Object keyAgreement;
            java.lang.Object keyCertSign;
            java.lang.Object keyEncipherment;
            java.lang.Object nonRepudiation;

            /**
             * Sets the value of {@link KeyUsageProperty#getCrlSign}
             * @param crlSign Key can be used to sign CRLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crlSign(java.lang.Boolean crlSign) {
                this.crlSign = crlSign;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getCrlSign}
             * @param crlSign Key can be used to sign CRLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crlSign(software.amazon.awscdk.IResolvable crlSign) {
                this.crlSign = crlSign;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getDataEncipherment}
             * @param dataEncipherment Key can be used to decipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataEncipherment(java.lang.Boolean dataEncipherment) {
                this.dataEncipherment = dataEncipherment;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getDataEncipherment}
             * @param dataEncipherment Key can be used to decipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataEncipherment(software.amazon.awscdk.IResolvable dataEncipherment) {
                this.dataEncipherment = dataEncipherment;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getDecipherOnly}
             * @param decipherOnly Key can be used only to decipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decipherOnly(java.lang.Boolean decipherOnly) {
                this.decipherOnly = decipherOnly;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getDecipherOnly}
             * @param decipherOnly Key can be used only to decipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decipherOnly(software.amazon.awscdk.IResolvable decipherOnly) {
                this.decipherOnly = decipherOnly;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getDigitalSignature}
             * @param digitalSignature Key can be used for digital signing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder digitalSignature(java.lang.Boolean digitalSignature) {
                this.digitalSignature = digitalSignature;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getDigitalSignature}
             * @param digitalSignature Key can be used for digital signing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder digitalSignature(software.amazon.awscdk.IResolvable digitalSignature) {
                this.digitalSignature = digitalSignature;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getEncipherOnly}
             * @param encipherOnly Key can be used only to encipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encipherOnly(java.lang.Boolean encipherOnly) {
                this.encipherOnly = encipherOnly;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getEncipherOnly}
             * @param encipherOnly Key can be used only to encipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encipherOnly(software.amazon.awscdk.IResolvable encipherOnly) {
                this.encipherOnly = encipherOnly;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getKeyAgreement}
             * @param keyAgreement Key can be used in a key-agreement protocol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyAgreement(java.lang.Boolean keyAgreement) {
                this.keyAgreement = keyAgreement;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getKeyAgreement}
             * @param keyAgreement Key can be used in a key-agreement protocol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyAgreement(software.amazon.awscdk.IResolvable keyAgreement) {
                this.keyAgreement = keyAgreement;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getKeyCertSign}
             * @param keyCertSign Key can be used to sign certificates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyCertSign(java.lang.Boolean keyCertSign) {
                this.keyCertSign = keyCertSign;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getKeyCertSign}
             * @param keyCertSign Key can be used to sign certificates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyCertSign(software.amazon.awscdk.IResolvable keyCertSign) {
                this.keyCertSign = keyCertSign;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getKeyEncipherment}
             * @param keyEncipherment Key can be used to encipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyEncipherment(java.lang.Boolean keyEncipherment) {
                this.keyEncipherment = keyEncipherment;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getKeyEncipherment}
             * @param keyEncipherment Key can be used to encipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyEncipherment(software.amazon.awscdk.IResolvable keyEncipherment) {
                this.keyEncipherment = keyEncipherment;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getNonRepudiation}
             * @param nonRepudiation Key can be used for non-repudiation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nonRepudiation(java.lang.Boolean nonRepudiation) {
                this.nonRepudiation = nonRepudiation;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getNonRepudiation}
             * @param nonRepudiation Key can be used for non-repudiation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nonRepudiation(software.amazon.awscdk.IResolvable nonRepudiation) {
                this.nonRepudiation = nonRepudiation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeyUsageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeyUsageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeyUsageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyUsageProperty {
            private final java.lang.Object crlSign;
            private final java.lang.Object dataEncipherment;
            private final java.lang.Object decipherOnly;
            private final java.lang.Object digitalSignature;
            private final java.lang.Object encipherOnly;
            private final java.lang.Object keyAgreement;
            private final java.lang.Object keyCertSign;
            private final java.lang.Object keyEncipherment;
            private final java.lang.Object nonRepudiation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.crlSign = software.amazon.jsii.Kernel.get(this, "crlSign", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataEncipherment = software.amazon.jsii.Kernel.get(this, "dataEncipherment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.decipherOnly = software.amazon.jsii.Kernel.get(this, "decipherOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.digitalSignature = software.amazon.jsii.Kernel.get(this, "digitalSignature", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encipherOnly = software.amazon.jsii.Kernel.get(this, "encipherOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyAgreement = software.amazon.jsii.Kernel.get(this, "keyAgreement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyCertSign = software.amazon.jsii.Kernel.get(this, "keyCertSign", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyEncipherment = software.amazon.jsii.Kernel.get(this, "keyEncipherment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nonRepudiation = software.amazon.jsii.Kernel.get(this, "nonRepudiation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.crlSign = builder.crlSign;
                this.dataEncipherment = builder.dataEncipherment;
                this.decipherOnly = builder.decipherOnly;
                this.digitalSignature = builder.digitalSignature;
                this.encipherOnly = builder.encipherOnly;
                this.keyAgreement = builder.keyAgreement;
                this.keyCertSign = builder.keyCertSign;
                this.keyEncipherment = builder.keyEncipherment;
                this.nonRepudiation = builder.nonRepudiation;
            }

            @Override
            public final java.lang.Object getCrlSign() {
                return this.crlSign;
            }

            @Override
            public final java.lang.Object getDataEncipherment() {
                return this.dataEncipherment;
            }

            @Override
            public final java.lang.Object getDecipherOnly() {
                return this.decipherOnly;
            }

            @Override
            public final java.lang.Object getDigitalSignature() {
                return this.digitalSignature;
            }

            @Override
            public final java.lang.Object getEncipherOnly() {
                return this.encipherOnly;
            }

            @Override
            public final java.lang.Object getKeyAgreement() {
                return this.keyAgreement;
            }

            @Override
            public final java.lang.Object getKeyCertSign() {
                return this.keyCertSign;
            }

            @Override
            public final java.lang.Object getKeyEncipherment() {
                return this.keyEncipherment;
            }

            @Override
            public final java.lang.Object getNonRepudiation() {
                return this.nonRepudiation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCrlSign() != null) {
                    data.set("crlSign", om.valueToTree(this.getCrlSign()));
                }
                if (this.getDataEncipherment() != null) {
                    data.set("dataEncipherment", om.valueToTree(this.getDataEncipherment()));
                }
                if (this.getDecipherOnly() != null) {
                    data.set("decipherOnly", om.valueToTree(this.getDecipherOnly()));
                }
                if (this.getDigitalSignature() != null) {
                    data.set("digitalSignature", om.valueToTree(this.getDigitalSignature()));
                }
                if (this.getEncipherOnly() != null) {
                    data.set("encipherOnly", om.valueToTree(this.getEncipherOnly()));
                }
                if (this.getKeyAgreement() != null) {
                    data.set("keyAgreement", om.valueToTree(this.getKeyAgreement()));
                }
                if (this.getKeyCertSign() != null) {
                    data.set("keyCertSign", om.valueToTree(this.getKeyCertSign()));
                }
                if (this.getKeyEncipherment() != null) {
                    data.set("keyEncipherment", om.valueToTree(this.getKeyEncipherment()));
                }
                if (this.getNonRepudiation() != null) {
                    data.set("nonRepudiation", om.valueToTree(this.getNonRepudiation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.KeyUsageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeyUsageProperty.Jsii$Proxy that = (KeyUsageProperty.Jsii$Proxy) o;

                if (this.crlSign != null ? !this.crlSign.equals(that.crlSign) : that.crlSign != null) return false;
                if (this.dataEncipherment != null ? !this.dataEncipherment.equals(that.dataEncipherment) : that.dataEncipherment != null) return false;
                if (this.decipherOnly != null ? !this.decipherOnly.equals(that.decipherOnly) : that.decipherOnly != null) return false;
                if (this.digitalSignature != null ? !this.digitalSignature.equals(that.digitalSignature) : that.digitalSignature != null) return false;
                if (this.encipherOnly != null ? !this.encipherOnly.equals(that.encipherOnly) : that.encipherOnly != null) return false;
                if (this.keyAgreement != null ? !this.keyAgreement.equals(that.keyAgreement) : that.keyAgreement != null) return false;
                if (this.keyCertSign != null ? !this.keyCertSign.equals(that.keyCertSign) : that.keyCertSign != null) return false;
                if (this.keyEncipherment != null ? !this.keyEncipherment.equals(that.keyEncipherment) : that.keyEncipherment != null) return false;
                return this.nonRepudiation != null ? this.nonRepudiation.equals(that.nonRepudiation) : that.nonRepudiation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.crlSign != null ? this.crlSign.hashCode() : 0;
                result = 31 * result + (this.dataEncipherment != null ? this.dataEncipherment.hashCode() : 0);
                result = 31 * result + (this.decipherOnly != null ? this.decipherOnly.hashCode() : 0);
                result = 31 * result + (this.digitalSignature != null ? this.digitalSignature.hashCode() : 0);
                result = 31 * result + (this.encipherOnly != null ? this.encipherOnly.hashCode() : 0);
                result = 31 * result + (this.keyAgreement != null ? this.keyAgreement.hashCode() : 0);
                result = 31 * result + (this.keyCertSign != null ? this.keyCertSign.hashCode() : 0);
                result = 31 * result + (this.keyEncipherment != null ? this.keyEncipherment.hashCode() : 0);
                result = 31 * result + (this.nonRepudiation != null ? this.nonRepudiation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information to enable and configure Online Certificate Status Protocol (OCSP) for validating certificate revocation status.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * OcspConfigurationProperty ocspConfigurationProperty = OcspConfigurationProperty.builder()
     *         .enabled(false)
     *         .ocspCustomCname("ocspCustomCname")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.OcspConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OcspConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OcspConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating certificate revocation status.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * By default, ACM Private CA injects an Amazon domain into certificates being validated by the Online Certificate Status Protocol (OCSP).
         * <p>
         * A customer can alternatively use this object to define a CNAME specifying a customized OCSP domain.
         * <p>
         * Note: The value of the CNAME must not include a protocol prefix such as "http://" or "https://".
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOcspCustomCname() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OcspConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OcspConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OcspConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.String ocspCustomCname;

            /**
             * Sets the value of {@link OcspConfigurationProperty#getEnabled}
             * @param enabled Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating certificate revocation status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link OcspConfigurationProperty#getEnabled}
             * @param enabled Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating certificate revocation status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link OcspConfigurationProperty#getOcspCustomCname}
             * @param ocspCustomCname By default, ACM Private CA injects an Amazon domain into certificates being validated by the Online Certificate Status Protocol (OCSP).
             *                        A customer can alternatively use this object to define a CNAME specifying a customized OCSP domain.
             *                        <p>
             *                        Note: The value of the CNAME must not include a protocol prefix such as "http://" or "https://".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ocspCustomCname(java.lang.String ocspCustomCname) {
                this.ocspCustomCname = ocspCustomCname;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OcspConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OcspConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OcspConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OcspConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.String ocspCustomCname;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ocspCustomCname = software.amazon.jsii.Kernel.get(this, "ocspCustomCname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.ocspCustomCname = builder.ocspCustomCname;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getOcspCustomCname() {
                return this.ocspCustomCname;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getOcspCustomCname() != null) {
                    data.set("ocspCustomCname", om.valueToTree(this.getOcspCustomCname()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.OcspConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OcspConfigurationProperty.Jsii$Proxy that = (OcspConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.ocspCustomCname != null ? this.ocspCustomCname.equals(that.ocspCustomCname) : that.ocspCustomCname == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.ocspCustomCname != null ? this.ocspCustomCname.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a custom ASN.1 X.400 `GeneralName` using an object identifier (OID) and value. The OID must satisfy the regular expression shown below. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier) .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * OtherNameProperty otherNameProperty = OtherNameProperty.builder()
     *         .typeId("typeId")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.OtherNameProperty")
    @software.amazon.jsii.Jsii.Proxy(OtherNameProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OtherNameProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies an OID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTypeId();

        /**
         * Specifies an OID value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link OtherNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OtherNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OtherNameProperty> {
            java.lang.String typeId;
            java.lang.String value;

            /**
             * Sets the value of {@link OtherNameProperty#getTypeId}
             * @param typeId Specifies an OID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeId(java.lang.String typeId) {
                this.typeId = typeId;
                return this;
            }

            /**
             * Sets the value of {@link OtherNameProperty#getValue}
             * @param value Specifies an OID value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OtherNameProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OtherNameProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OtherNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OtherNameProperty {
            private final java.lang.String typeId;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.typeId = software.amazon.jsii.Kernel.get(this, "typeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.typeId = java.util.Objects.requireNonNull(builder.typeId, "typeId is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getTypeId() {
                return this.typeId;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("typeId", om.valueToTree(this.getTypeId()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.OtherNameProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OtherNameProperty.Jsii$Proxy that = (OtherNameProperty.Jsii$Proxy) o;

                if (!typeId.equals(that.typeId)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.typeId.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Certificate revocation information used by the CreateCertificateAuthority and UpdateCertificateAuthority actions.
     * <p>
     * Your private certificate authority (CA) can configure Online Certificate Status Protocol (OCSP) support and/or maintain a certificate revocation list (CRL). OCSP returns validation information about certificates as requested by clients, and a CRL contains an updated list of certificates revoked by your CA. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html">RevokeCertificate</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * RevocationConfigurationProperty revocationConfigurationProperty = RevocationConfigurationProperty.builder()
     *         .crlConfiguration(CrlConfigurationProperty.builder()
     *                 .customCname("customCname")
     *                 .enabled(false)
     *                 .expirationInDays(123)
     *                 .s3BucketName("s3BucketName")
     *                 .s3ObjectAcl("s3ObjectAcl")
     *                 .build())
     *         .ocspConfiguration(OcspConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .ocspCustomCname("ocspCustomCname")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.RevocationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RevocationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RevocationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrlConfiguration() {
            return null;
        }

        /**
         * Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by your private CA.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOcspConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RevocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RevocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RevocationConfigurationProperty> {
            java.lang.Object crlConfiguration;
            java.lang.Object ocspConfiguration;

            /**
             * Sets the value of {@link RevocationConfigurationProperty#getCrlConfiguration}
             * @param crlConfiguration Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crlConfiguration(software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.CrlConfigurationProperty crlConfiguration) {
                this.crlConfiguration = crlConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RevocationConfigurationProperty#getCrlConfiguration}
             * @param crlConfiguration Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crlConfiguration(software.amazon.awscdk.IResolvable crlConfiguration) {
                this.crlConfiguration = crlConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RevocationConfigurationProperty#getOcspConfiguration}
             * @param ocspConfiguration Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by your private CA.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ocspConfiguration(software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.OcspConfigurationProperty ocspConfiguration) {
                this.ocspConfiguration = ocspConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RevocationConfigurationProperty#getOcspConfiguration}
             * @param ocspConfiguration Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by your private CA.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ocspConfiguration(software.amazon.awscdk.IResolvable ocspConfiguration) {
                this.ocspConfiguration = ocspConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RevocationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RevocationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RevocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RevocationConfigurationProperty {
            private final java.lang.Object crlConfiguration;
            private final java.lang.Object ocspConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.crlConfiguration = software.amazon.jsii.Kernel.get(this, "crlConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ocspConfiguration = software.amazon.jsii.Kernel.get(this, "ocspConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.crlConfiguration = builder.crlConfiguration;
                this.ocspConfiguration = builder.ocspConfiguration;
            }

            @Override
            public final java.lang.Object getCrlConfiguration() {
                return this.crlConfiguration;
            }

            @Override
            public final java.lang.Object getOcspConfiguration() {
                return this.ocspConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCrlConfiguration() != null) {
                    data.set("crlConfiguration", om.valueToTree(this.getCrlConfiguration()));
                }
                if (this.getOcspConfiguration() != null) {
                    data.set("ocspConfiguration", om.valueToTree(this.getOcspConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.RevocationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RevocationConfigurationProperty.Jsii$Proxy that = (RevocationConfigurationProperty.Jsii$Proxy) o;

                if (this.crlConfiguration != null ? !this.crlConfiguration.equals(that.crlConfiguration) : that.crlConfiguration != null) return false;
                return this.ocspConfiguration != null ? this.ocspConfiguration.equals(that.ocspConfiguration) : that.ocspConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.crlConfiguration != null ? this.crlConfiguration.hashCode() : 0;
                result = 31 * result + (this.ocspConfiguration != null ? this.ocspConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * ASN1 subject for the certificate authority.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * SubjectProperty subjectProperty = SubjectProperty.builder()
     *         .commonName("commonName")
     *         .country("country")
     *         .customAttributes(List.of(CustomAttributeProperty.builder()
     *                 .objectIdentifier("objectIdentifier")
     *                 .value("value")
     *                 .build()))
     *         .distinguishedNameQualifier("distinguishedNameQualifier")
     *         .generationQualifier("generationQualifier")
     *         .givenName("givenName")
     *         .initials("initials")
     *         .locality("locality")
     *         .organization("organization")
     *         .organizationalUnit("organizationalUnit")
     *         .pseudonym("pseudonym")
     *         .serialNumber("serialNumber")
     *         .state("state")
     *         .surname("surname")
     *         .title("title")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.SubjectProperty")
    @software.amazon.jsii.Jsii.Proxy(SubjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Fully qualified domain name (FQDN) associated with the certificate subject.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCommonName() {
            return null;
        }

        /**
         * Two-digit code that specifies the country in which the certificate subject located.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCountry() {
            return null;
        }

        /**
         * Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an object identifier (OID) and a value. For more information, see NIST’s definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier) .
         * <p>
         * <blockquote>
         * <p>
         * Custom attributes cannot be used in combination with standard attributes.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomAttributes() {
            return null;
        }

        /**
         * Disambiguating information for the certificate subject.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDistinguishedNameQualifier() {
            return null;
        }

        /**
         * Typically a qualifier appended to the name of an individual.
         * <p>
         * Examples include Jr. for junior, Sr. for senior, and III for third.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGenerationQualifier() {
            return null;
        }

        /**
         * First name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGivenName() {
            return null;
        }

        /**
         * Concatenation that typically contains the first letter of the GivenName, the first letter of the middle name if one exists, and the first letter of the SurName.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInitials() {
            return null;
        }

        /**
         * The locality (such as a city or town) in which the certificate subject is located.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocality() {
            return null;
        }

        /**
         * Legal name of the organization with which the certificate subject is affiliated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrganization() {
            return null;
        }

        /**
         * A subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrganizationalUnit() {
            return null;
        }

        /**
         * Typically a shortened version of a longer GivenName.
         * <p>
         * For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPseudonym() {
            return null;
        }

        /**
         * The certificate serial number.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSerialNumber() {
            return null;
        }

        /**
         * State in which the subject of the certificate is located.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * Family name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSurname() {
            return null;
        }

        /**
         * A personal title such as Mr.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTitle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SubjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubjectProperty> {
            java.lang.String commonName;
            java.lang.String country;
            java.lang.Object customAttributes;
            java.lang.String distinguishedNameQualifier;
            java.lang.String generationQualifier;
            java.lang.String givenName;
            java.lang.String initials;
            java.lang.String locality;
            java.lang.String organization;
            java.lang.String organizationalUnit;
            java.lang.String pseudonym;
            java.lang.String serialNumber;
            java.lang.String state;
            java.lang.String surname;
            java.lang.String title;

            /**
             * Sets the value of {@link SubjectProperty#getCommonName}
             * @param commonName Fully qualified domain name (FQDN) associated with the certificate subject.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder commonName(java.lang.String commonName) {
                this.commonName = commonName;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getCountry}
             * @param country Two-digit code that specifies the country in which the certificate subject located.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder country(java.lang.String country) {
                this.country = country;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getCustomAttributes}
             * @param customAttributes Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an object identifier (OID) and a value. For more information, see NIST’s definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier) .
             *                         <blockquote>
             *                         <p>
             *                         Custom attributes cannot be used in combination with standard attributes.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAttributes(software.amazon.awscdk.IResolvable customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getCustomAttributes}
             * @param customAttributes Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an object identifier (OID) and a value. For more information, see NIST’s definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier) .
             *                         <blockquote>
             *                         <p>
             *                         Custom attributes cannot be used in combination with standard attributes.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAttributes(java.util.List<? extends java.lang.Object> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getDistinguishedNameQualifier}
             * @param distinguishedNameQualifier Disambiguating information for the certificate subject.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder distinguishedNameQualifier(java.lang.String distinguishedNameQualifier) {
                this.distinguishedNameQualifier = distinguishedNameQualifier;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getGenerationQualifier}
             * @param generationQualifier Typically a qualifier appended to the name of an individual.
             *                            Examples include Jr. for junior, Sr. for senior, and III for third.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generationQualifier(java.lang.String generationQualifier) {
                this.generationQualifier = generationQualifier;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getGivenName}
             * @param givenName First name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder givenName(java.lang.String givenName) {
                this.givenName = givenName;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getInitials}
             * @param initials Concatenation that typically contains the first letter of the GivenName, the first letter of the middle name if one exists, and the first letter of the SurName.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initials(java.lang.String initials) {
                this.initials = initials;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getLocality}
             * @param locality The locality (such as a city or town) in which the certificate subject is located.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locality(java.lang.String locality) {
                this.locality = locality;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getOrganization}
             * @param organization Legal name of the organization with which the certificate subject is affiliated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organization(java.lang.String organization) {
                this.organization = organization;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getOrganizationalUnit}
             * @param organizationalUnit A subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationalUnit(java.lang.String organizationalUnit) {
                this.organizationalUnit = organizationalUnit;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getPseudonym}
             * @param pseudonym Typically a shortened version of a longer GivenName.
             *                  For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pseudonym(java.lang.String pseudonym) {
                this.pseudonym = pseudonym;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getSerialNumber}
             * @param serialNumber The certificate serial number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serialNumber(java.lang.String serialNumber) {
                this.serialNumber = serialNumber;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getState}
             * @param state State in which the subject of the certificate is located.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getSurname}
             * @param surname Family name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder surname(java.lang.String surname) {
                this.surname = surname;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getTitle}
             * @param title A personal title such as Mr.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubjectProperty {
            private final java.lang.String commonName;
            private final java.lang.String country;
            private final java.lang.Object customAttributes;
            private final java.lang.String distinguishedNameQualifier;
            private final java.lang.String generationQualifier;
            private final java.lang.String givenName;
            private final java.lang.String initials;
            private final java.lang.String locality;
            private final java.lang.String organization;
            private final java.lang.String organizationalUnit;
            private final java.lang.String pseudonym;
            private final java.lang.String serialNumber;
            private final java.lang.String state;
            private final java.lang.String surname;
            private final java.lang.String title;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.commonName = software.amazon.jsii.Kernel.get(this, "commonName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.country = software.amazon.jsii.Kernel.get(this, "country", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customAttributes = software.amazon.jsii.Kernel.get(this, "customAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.distinguishedNameQualifier = software.amazon.jsii.Kernel.get(this, "distinguishedNameQualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.generationQualifier = software.amazon.jsii.Kernel.get(this, "generationQualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.givenName = software.amazon.jsii.Kernel.get(this, "givenName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.initials = software.amazon.jsii.Kernel.get(this, "initials", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.locality = software.amazon.jsii.Kernel.get(this, "locality", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.organization = software.amazon.jsii.Kernel.get(this, "organization", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.organizationalUnit = software.amazon.jsii.Kernel.get(this, "organizationalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pseudonym = software.amazon.jsii.Kernel.get(this, "pseudonym", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serialNumber = software.amazon.jsii.Kernel.get(this, "serialNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.surname = software.amazon.jsii.Kernel.get(this, "surname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.commonName = builder.commonName;
                this.country = builder.country;
                this.customAttributes = builder.customAttributes;
                this.distinguishedNameQualifier = builder.distinguishedNameQualifier;
                this.generationQualifier = builder.generationQualifier;
                this.givenName = builder.givenName;
                this.initials = builder.initials;
                this.locality = builder.locality;
                this.organization = builder.organization;
                this.organizationalUnit = builder.organizationalUnit;
                this.pseudonym = builder.pseudonym;
                this.serialNumber = builder.serialNumber;
                this.state = builder.state;
                this.surname = builder.surname;
                this.title = builder.title;
            }

            @Override
            public final java.lang.String getCommonName() {
                return this.commonName;
            }

            @Override
            public final java.lang.String getCountry() {
                return this.country;
            }

            @Override
            public final java.lang.Object getCustomAttributes() {
                return this.customAttributes;
            }

            @Override
            public final java.lang.String getDistinguishedNameQualifier() {
                return this.distinguishedNameQualifier;
            }

            @Override
            public final java.lang.String getGenerationQualifier() {
                return this.generationQualifier;
            }

            @Override
            public final java.lang.String getGivenName() {
                return this.givenName;
            }

            @Override
            public final java.lang.String getInitials() {
                return this.initials;
            }

            @Override
            public final java.lang.String getLocality() {
                return this.locality;
            }

            @Override
            public final java.lang.String getOrganization() {
                return this.organization;
            }

            @Override
            public final java.lang.String getOrganizationalUnit() {
                return this.organizationalUnit;
            }

            @Override
            public final java.lang.String getPseudonym() {
                return this.pseudonym;
            }

            @Override
            public final java.lang.String getSerialNumber() {
                return this.serialNumber;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            public final java.lang.String getSurname() {
                return this.surname;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommonName() != null) {
                    data.set("commonName", om.valueToTree(this.getCommonName()));
                }
                if (this.getCountry() != null) {
                    data.set("country", om.valueToTree(this.getCountry()));
                }
                if (this.getCustomAttributes() != null) {
                    data.set("customAttributes", om.valueToTree(this.getCustomAttributes()));
                }
                if (this.getDistinguishedNameQualifier() != null) {
                    data.set("distinguishedNameQualifier", om.valueToTree(this.getDistinguishedNameQualifier()));
                }
                if (this.getGenerationQualifier() != null) {
                    data.set("generationQualifier", om.valueToTree(this.getGenerationQualifier()));
                }
                if (this.getGivenName() != null) {
                    data.set("givenName", om.valueToTree(this.getGivenName()));
                }
                if (this.getInitials() != null) {
                    data.set("initials", om.valueToTree(this.getInitials()));
                }
                if (this.getLocality() != null) {
                    data.set("locality", om.valueToTree(this.getLocality()));
                }
                if (this.getOrganization() != null) {
                    data.set("organization", om.valueToTree(this.getOrganization()));
                }
                if (this.getOrganizationalUnit() != null) {
                    data.set("organizationalUnit", om.valueToTree(this.getOrganizationalUnit()));
                }
                if (this.getPseudonym() != null) {
                    data.set("pseudonym", om.valueToTree(this.getPseudonym()));
                }
                if (this.getSerialNumber() != null) {
                    data.set("serialNumber", om.valueToTree(this.getSerialNumber()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }
                if (this.getSurname() != null) {
                    data.set("surname", om.valueToTree(this.getSurname()));
                }
                if (this.getTitle() != null) {
                    data.set("title", om.valueToTree(this.getTitle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnCertificateAuthority.SubjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubjectProperty.Jsii$Proxy that = (SubjectProperty.Jsii$Proxy) o;

                if (this.commonName != null ? !this.commonName.equals(that.commonName) : that.commonName != null) return false;
                if (this.country != null ? !this.country.equals(that.country) : that.country != null) return false;
                if (this.customAttributes != null ? !this.customAttributes.equals(that.customAttributes) : that.customAttributes != null) return false;
                if (this.distinguishedNameQualifier != null ? !this.distinguishedNameQualifier.equals(that.distinguishedNameQualifier) : that.distinguishedNameQualifier != null) return false;
                if (this.generationQualifier != null ? !this.generationQualifier.equals(that.generationQualifier) : that.generationQualifier != null) return false;
                if (this.givenName != null ? !this.givenName.equals(that.givenName) : that.givenName != null) return false;
                if (this.initials != null ? !this.initials.equals(that.initials) : that.initials != null) return false;
                if (this.locality != null ? !this.locality.equals(that.locality) : that.locality != null) return false;
                if (this.organization != null ? !this.organization.equals(that.organization) : that.organization != null) return false;
                if (this.organizationalUnit != null ? !this.organizationalUnit.equals(that.organizationalUnit) : that.organizationalUnit != null) return false;
                if (this.pseudonym != null ? !this.pseudonym.equals(that.pseudonym) : that.pseudonym != null) return false;
                if (this.serialNumber != null ? !this.serialNumber.equals(that.serialNumber) : that.serialNumber != null) return false;
                if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
                if (this.surname != null ? !this.surname.equals(that.surname) : that.surname != null) return false;
                return this.title != null ? this.title.equals(that.title) : that.title == null;
            }

            @Override
            public final int hashCode() {
                int result = this.commonName != null ? this.commonName.hashCode() : 0;
                result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
                result = 31 * result + (this.customAttributes != null ? this.customAttributes.hashCode() : 0);
                result = 31 * result + (this.distinguishedNameQualifier != null ? this.distinguishedNameQualifier.hashCode() : 0);
                result = 31 * result + (this.generationQualifier != null ? this.generationQualifier.hashCode() : 0);
                result = 31 * result + (this.givenName != null ? this.givenName.hashCode() : 0);
                result = 31 * result + (this.initials != null ? this.initials.hashCode() : 0);
                result = 31 * result + (this.locality != null ? this.locality.hashCode() : 0);
                result = 31 * result + (this.organization != null ? this.organization.hashCode() : 0);
                result = 31 * result + (this.organizationalUnit != null ? this.organizationalUnit.hashCode() : 0);
                result = 31 * result + (this.pseudonym != null ? this.pseudonym.hashCode() : 0);
                result = 31 * result + (this.serialNumber != null ? this.serialNumber.hashCode() : 0);
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                result = 31 * result + (this.surname != null ? this.surname.hashCode() : 0);
                result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.acmpca.CfnCertificateAuthority}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.acmpca.CfnCertificateAuthority> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.acmpca.CfnCertificateAuthorityProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.acmpca.CfnCertificateAuthorityProps.Builder();
        }

        /**
         * Type of the public key algorithm and size, in bits, of the key pair that your CA creates when it issues a certificate.
         * <p>
         * When you create a subordinate CA, you must use a key algorithm supported by the parent CA.
         * <p>
         * @return {@code this}
         * @param keyAlgorithm Type of the public key algorithm and size, in bits, of the key pair that your CA creates when it issues a certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyAlgorithm(final java.lang.String keyAlgorithm) {
            this.props.keyAlgorithm(keyAlgorithm);
            return this;
        }

        /**
         * Name of the algorithm your private CA uses to sign certificate requests.
         * <p>
         * This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign certificates when they are issued.
         * <p>
         * @return {@code this}
         * @param signingAlgorithm Name of the algorithm your private CA uses to sign certificate requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signingAlgorithm(final java.lang.String signingAlgorithm) {
            this.props.signingAlgorithm(signingAlgorithm);
            return this;
        }

        /**
         * Structure that contains X.500 distinguished name information for your private CA.
         * <p>
         * @return {@code this}
         * @param subject Structure that contains X.500 distinguished name information for your private CA. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subject(final software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.SubjectProperty subject) {
            this.props.subject(subject);
            return this;
        }
        /**
         * Structure that contains X.500 distinguished name information for your private CA.
         * <p>
         * @return {@code this}
         * @param subject Structure that contains X.500 distinguished name information for your private CA. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subject(final software.amazon.awscdk.IResolvable subject) {
            this.props.subject(subject);
            return this;
        }

        /**
         * Type of your private CA.
         * <p>
         * @return {@code this}
         * @param type Type of your private CA. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * Specifies information to be added to the extension section of the certificate signing request (CSR).
         * <p>
         * @return {@code this}
         * @param csrExtensions Specifies information to be added to the extension section of the certificate signing request (CSR). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder csrExtensions(final software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.CsrExtensionsProperty csrExtensions) {
            this.props.csrExtensions(csrExtensions);
            return this;
        }
        /**
         * Specifies information to be added to the extension section of the certificate signing request (CSR).
         * <p>
         * @return {@code this}
         * @param csrExtensions Specifies information to be added to the extension section of the certificate signing request (CSR). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder csrExtensions(final software.amazon.awscdk.IResolvable csrExtensions) {
            this.props.csrExtensions(csrExtensions);
            return this;
        }

        /**
         * Specifies a cryptographic key management compliance standard used for handling CA keys.
         * <p>
         * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
         * <p>
         * <em>Note:</em> <code>FIPS_140_2_LEVEL_3_OR_HIGHER</code> is not supported in the following Regions:
         * <p>
         * <ul>
         * <li>ap-northeast-3</li>
         * <li>ap-southeast-3</li>
         * </ul>
         * <p>
         * When creating a CA in these Regions, you must provide <code>FIPS_140_2_LEVEL_2_OR_HIGHER</code> as the argument for <code>KeyStorageSecurityStandard</code> . Failure to do this results in an <code>InvalidArgsException</code> with the message, "A certificate authority cannot be created in this region with the specified security standard."
         * <p>
         * @return {@code this}
         * @param keyStorageSecurityStandard Specifies a cryptographic key management compliance standard used for handling CA keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyStorageSecurityStandard(final java.lang.String keyStorageSecurityStandard) {
            this.props.keyStorageSecurityStandard(keyStorageSecurityStandard);
            return this;
        }

        /**
         * Information about the certificate revocation list (CRL) created and maintained by your private CA.
         * <p>
         * Certificate revocation information used by the CreateCertificateAuthority and UpdateCertificateAuthority actions. Your certificate authority can create and maintain a certificate revocation list (CRL). A CRL contains information about certificates that have been revoked.
         * <p>
         * @return {@code this}
         * @param revocationConfiguration Information about the certificate revocation list (CRL) created and maintained by your private CA. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder revocationConfiguration(final software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.RevocationConfigurationProperty revocationConfiguration) {
            this.props.revocationConfiguration(revocationConfiguration);
            return this;
        }
        /**
         * Information about the certificate revocation list (CRL) created and maintained by your private CA.
         * <p>
         * Certificate revocation information used by the CreateCertificateAuthority and UpdateCertificateAuthority actions. Your certificate authority can create and maintain a certificate revocation list (CRL). A CRL contains information about certificates that have been revoked.
         * <p>
         * @return {@code this}
         * @param revocationConfiguration Information about the certificate revocation list (CRL) created and maintained by your private CA. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder revocationConfiguration(final software.amazon.awscdk.IResolvable revocationConfiguration) {
            this.props.revocationConfiguration(revocationConfiguration);
            return this;
        }

        /**
         * Key-value pairs that will be attached to the new private CA.
         * <p>
         * You can associate up to 50 tags with a private CA. For information using tags with IAM to manage permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a> .
         * <p>
         * @return {@code this}
         * @param tags Key-value pairs that will be attached to the new private CA. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.acmpca.CfnCertificateAuthority}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.acmpca.CfnCertificateAuthority build() {
            return new software.amazon.awscdk.services.acmpca.CfnCertificateAuthority(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
