/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sam;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.sam.CfnApi;
import software.amazon.awscdk.services.sam.CfnApiProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sam.CfnApi")
public class CfnApi
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApi.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));
    public static final String REQUIRED_TRANSFORM = (String)JsiiObject.jsiiStaticGet(CfnApi.class, (String)"REQUIRED_TRANSFORM", (NativeType)NativeType.forClass(String.class));

    protected CfnApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApi(@NotNull Construct scope, @NotNull String id, @NotNull CfnApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getDefinitionBody() {
        return Kernel.get((Object)this, (String)"definitionBody", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefinitionBody(@NotNull Object value) {
        Kernel.set((Object)this, (String)"definitionBody", (Object)Objects.requireNonNull(value, "definitionBody is required"));
    }

    @NotNull
    public String getStageName() {
        return (String)Kernel.get((Object)this, (String)"stageName", (NativeType)NativeType.forClass(String.class));
    }

    public void setStageName(@NotNull String value) {
        Kernel.set((Object)this, (String)"stageName", (Object)Objects.requireNonNull(value, "stageName is required"));
    }

    @Nullable
    public Object getAccessLogSetting() {
        return Kernel.get((Object)this, (String)"accessLogSetting", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAccessLogSetting(@Nullable AccessLogSettingProperty value) {
        Kernel.set((Object)this, (String)"accessLogSetting", (Object)value);
    }

    public void setAccessLogSetting(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"accessLogSetting", (Object)value);
    }

    @Nullable
    public Object getAuth() {
        return Kernel.get((Object)this, (String)"auth", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAuth(@Nullable AuthProperty value) {
        Kernel.set((Object)this, (String)"auth", (Object)value);
    }

    public void setAuth(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"auth", (Object)value);
    }

    @Nullable
    public List<String> getBinaryMediaTypes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"binaryMediaTypes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setBinaryMediaTypes(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"binaryMediaTypes", value);
    }

    @Nullable
    public Object getCacheClusterEnabled() {
        return Kernel.get((Object)this, (String)"cacheClusterEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCacheClusterEnabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"cacheClusterEnabled", (Object)value);
    }

    public void setCacheClusterEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"cacheClusterEnabled", (Object)value);
    }

    @Nullable
    public String getCacheClusterSize() {
        return (String)Kernel.get((Object)this, (String)"cacheClusterSize", (NativeType)NativeType.forClass(String.class));
    }

    public void setCacheClusterSize(@Nullable String value) {
        Kernel.set((Object)this, (String)"cacheClusterSize", (Object)value);
    }

    @Nullable
    public Object getCanarySetting() {
        return Kernel.get((Object)this, (String)"canarySetting", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCanarySetting(@Nullable CanarySettingProperty value) {
        Kernel.set((Object)this, (String)"canarySetting", (Object)value);
    }

    public void setCanarySetting(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"canarySetting", (Object)value);
    }

    @Nullable
    public Object getCors() {
        return Kernel.get((Object)this, (String)"cors", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCors(@Nullable String value) {
        Kernel.set((Object)this, (String)"cors", (Object)value);
    }

    public void setCors(@Nullable CorsConfigurationProperty value) {
        Kernel.set((Object)this, (String)"cors", (Object)value);
    }

    public void setCors(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"cors", (Object)value);
    }

    @Nullable
    public Object getDefinitionUri() {
        return Kernel.get((Object)this, (String)"definitionUri", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefinitionUri(@Nullable String value) {
        Kernel.set((Object)this, (String)"definitionUri", (Object)value);
    }

    public void setDefinitionUri(@Nullable S3LocationProperty value) {
        Kernel.set((Object)this, (String)"definitionUri", (Object)value);
    }

    public void setDefinitionUri(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"definitionUri", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getEndpointConfiguration() {
        return Kernel.get((Object)this, (String)"endpointConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEndpointConfiguration(@Nullable String value) {
        Kernel.set((Object)this, (String)"endpointConfiguration", (Object)value);
    }

    public void setEndpointConfiguration(@Nullable EndpointConfigurationProperty value) {
        Kernel.set((Object)this, (String)"endpointConfiguration", (Object)value);
    }

    public void setEndpointConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"endpointConfiguration", (Object)value);
    }

    @Nullable
    public Object getGatewayResponses() {
        return Kernel.get((Object)this, (String)"gatewayResponses", (NativeType)NativeType.forClass(Object.class));
    }

    public void setGatewayResponses(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"gatewayResponses", (Object)value);
    }

    public void setGatewayResponses(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"gatewayResponses", value);
    }

    @Nullable
    public Object getMethodSettings() {
        return Kernel.get((Object)this, (String)"methodSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMethodSettings(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"methodSettings", value);
    }

    public void setMethodSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"methodSettings", (Object)value);
    }

    @Nullable
    public Number getMinimumCompressionSize() {
        return (Number)Kernel.get((Object)this, (String)"minimumCompressionSize", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMinimumCompressionSize(@Nullable Number value) {
        Kernel.set((Object)this, (String)"minimumCompressionSize", (Object)value);
    }

    @Nullable
    public Object getModels() {
        return Kernel.get((Object)this, (String)"models", (NativeType)NativeType.forClass(Object.class));
    }

    public void setModels(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"models", (Object)value);
    }

    public void setModels(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"models", value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public String getOpenApiVersion() {
        return (String)Kernel.get((Object)this, (String)"openApiVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setOpenApiVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"openApiVersion", (Object)value);
    }

    @Nullable
    public Object getTracingEnabled() {
        return Kernel.get((Object)this, (String)"tracingEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTracingEnabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"tracingEnabled", (Object)value);
    }

    public void setTracingEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"tracingEnabled", (Object)value);
    }

    @Nullable
    public Object getVariables() {
        return Kernel.get((Object)this, (String)"variables", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVariables(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"variables", (Object)value);
    }

    public void setVariables(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"variables", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApi> {
        private final Construct scope;
        private final String id;
        private final CfnApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnApiProps.Builder();
        }

        public Builder stageName(String stageName) {
            this.props.stageName(stageName);
            return this;
        }

        public Builder accessLogSetting(AccessLogSettingProperty accessLogSetting) {
            this.props.accessLogSetting(accessLogSetting);
            return this;
        }

        public Builder accessLogSetting(IResolvable accessLogSetting) {
            this.props.accessLogSetting(accessLogSetting);
            return this;
        }

        public Builder auth(AuthProperty auth) {
            this.props.auth(auth);
            return this;
        }

        public Builder auth(IResolvable auth) {
            this.props.auth(auth);
            return this;
        }

        public Builder binaryMediaTypes(List<String> binaryMediaTypes) {
            this.props.binaryMediaTypes(binaryMediaTypes);
            return this;
        }

        public Builder cacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.props.cacheClusterEnabled(cacheClusterEnabled);
            return this;
        }

        public Builder cacheClusterEnabled(IResolvable cacheClusterEnabled) {
            this.props.cacheClusterEnabled(cacheClusterEnabled);
            return this;
        }

        public Builder cacheClusterSize(String cacheClusterSize) {
            this.props.cacheClusterSize(cacheClusterSize);
            return this;
        }

        public Builder canarySetting(CanarySettingProperty canarySetting) {
            this.props.canarySetting(canarySetting);
            return this;
        }

        public Builder canarySetting(IResolvable canarySetting) {
            this.props.canarySetting(canarySetting);
            return this;
        }

        public Builder cors(String cors) {
            this.props.cors(cors);
            return this;
        }

        public Builder cors(CorsConfigurationProperty cors) {
            this.props.cors(cors);
            return this;
        }

        public Builder cors(IResolvable cors) {
            this.props.cors(cors);
            return this;
        }

        public Builder definitionBody(Object definitionBody) {
            this.props.definitionBody(definitionBody);
            return this;
        }

        public Builder definitionUri(String definitionUri) {
            this.props.definitionUri(definitionUri);
            return this;
        }

        public Builder definitionUri(S3LocationProperty definitionUri) {
            this.props.definitionUri(definitionUri);
            return this;
        }

        public Builder definitionUri(IResolvable definitionUri) {
            this.props.definitionUri(definitionUri);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder endpointConfiguration(String endpointConfiguration) {
            this.props.endpointConfiguration(endpointConfiguration);
            return this;
        }

        public Builder endpointConfiguration(EndpointConfigurationProperty endpointConfiguration) {
            this.props.endpointConfiguration(endpointConfiguration);
            return this;
        }

        public Builder endpointConfiguration(IResolvable endpointConfiguration) {
            this.props.endpointConfiguration(endpointConfiguration);
            return this;
        }

        public Builder gatewayResponses(IResolvable gatewayResponses) {
            this.props.gatewayResponses(gatewayResponses);
            return this;
        }

        public Builder gatewayResponses(Map<String, String> gatewayResponses) {
            this.props.gatewayResponses(gatewayResponses);
            return this;
        }

        public Builder methodSettings(List<? extends Object> methodSettings) {
            this.props.methodSettings(methodSettings);
            return this;
        }

        public Builder methodSettings(IResolvable methodSettings) {
            this.props.methodSettings(methodSettings);
            return this;
        }

        public Builder minimumCompressionSize(Number minimumCompressionSize) {
            this.props.minimumCompressionSize(minimumCompressionSize);
            return this;
        }

        public Builder models(IResolvable models) {
            this.props.models(models);
            return this;
        }

        public Builder models(Map<String, String> models) {
            this.props.models(models);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder openApiVersion(String openApiVersion) {
            this.props.openApiVersion(openApiVersion);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder tracingEnabled(Boolean tracingEnabled) {
            this.props.tracingEnabled(tracingEnabled);
            return this;
        }

        public Builder tracingEnabled(IResolvable tracingEnabled) {
            this.props.tracingEnabled(tracingEnabled);
            return this;
        }

        public Builder variables(IResolvable variables) {
            this.props.variables(variables);
            return this;
        }

        public Builder variables(Map<String, String> variables) {
            this.props.variables(variables);
            return this;
        }

        public CfnApi build() {
            return new CfnApi(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sam.CfnApi.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        @NotNull
        public Number getVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            String bucket;
            String key;
            Number version;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder version(Number version) {
                this.version = version;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sam.CfnApi.EndpointConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EndpointConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public List<String> getVpcEndpointIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EndpointConfigurationProperty> {
            String type;
            List<String> vpcEndpointIds;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder vpcEndpointIds(List<String> vpcEndpointIds) {
                this.vpcEndpointIds = vpcEndpointIds;
                return this;
            }

            public EndpointConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sam.CfnApi.CorsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CorsConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getAllowOrigin();

        @Nullable
        default public Object getAllowCredentials() {
            return null;
        }

        @Nullable
        default public String getAllowHeaders() {
            return null;
        }

        @Nullable
        default public String getAllowMethods() {
            return null;
        }

        @Nullable
        default public String getMaxAge() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CorsConfigurationProperty> {
            String allowOrigin;
            Object allowCredentials;
            String allowHeaders;
            String allowMethods;
            String maxAge;

            public Builder allowOrigin(String allowOrigin) {
                this.allowOrigin = allowOrigin;
                return this;
            }

            public Builder allowCredentials(Boolean allowCredentials) {
                this.allowCredentials = allowCredentials;
                return this;
            }

            public Builder allowCredentials(IResolvable allowCredentials) {
                this.allowCredentials = allowCredentials;
                return this;
            }

            public Builder allowHeaders(String allowHeaders) {
                this.allowHeaders = allowHeaders;
                return this;
            }

            public Builder allowMethods(String allowMethods) {
                this.allowMethods = allowMethods;
                return this;
            }

            public Builder maxAge(String maxAge) {
                this.maxAge = maxAge;
                return this;
            }

            public CorsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sam.CfnApi.CanarySettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CanarySettingProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDeploymentId() {
            return null;
        }

        @Nullable
        default public Number getPercentTraffic() {
            return null;
        }

        @Nullable
        default public Object getStageVariableOverrides() {
            return null;
        }

        @Nullable
        default public Object getUseStageCache() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CanarySettingProperty> {
            String deploymentId;
            Number percentTraffic;
            Object stageVariableOverrides;
            Object useStageCache;

            public Builder deploymentId(String deploymentId) {
                this.deploymentId = deploymentId;
                return this;
            }

            public Builder percentTraffic(Number percentTraffic) {
                this.percentTraffic = percentTraffic;
                return this;
            }

            public Builder stageVariableOverrides(IResolvable stageVariableOverrides) {
                this.stageVariableOverrides = stageVariableOverrides;
                return this;
            }

            public Builder stageVariableOverrides(Map<String, String> stageVariableOverrides) {
                this.stageVariableOverrides = stageVariableOverrides;
                return this;
            }

            public Builder useStageCache(Boolean useStageCache) {
                this.useStageCache = useStageCache;
                return this;
            }

            public Builder useStageCache(IResolvable useStageCache) {
                this.useStageCache = useStageCache;
                return this;
            }

            public CanarySettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sam.CfnApi.AuthProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAuthorizers() {
            return null;
        }

        @Nullable
        default public String getDefaultAuthorizer() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthProperty> {
            Object authorizers;
            String defaultAuthorizer;

            public Builder authorizers(Object authorizers) {
                this.authorizers = authorizers;
                return this;
            }

            public Builder defaultAuthorizer(String defaultAuthorizer) {
                this.defaultAuthorizer = defaultAuthorizer;
                return this;
            }

            public AuthProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sam.CfnApi.AccessLogSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccessLogSettingProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDestinationArn() {
            return null;
        }

        @Nullable
        default public String getFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AccessLogSettingProperty> {
            String destinationArn;
            String format;

            public Builder destinationArn(String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public AccessLogSettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

