package software.amazon.awscdk.services.stepfunctions;

/**
 * Define a Wait state in the state machine.
 * <p>
 * A Wait state can be used to delay execution of the state machine for a while.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EvaluateExpression convertToSeconds = EvaluateExpression.Builder.create(this, "Convert to seconds")
 *         .expression("$.waitMilliseconds / 1000")
 *         .resultPath("$.waitSeconds")
 *         .build();
 * EvaluateExpression createMessage = EvaluateExpression.Builder.create(this, "Create message")
 *         // Note: this is a string inside a string.
 *         .expression("`Now waiting ${$.waitSeconds} seconds...`")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .resultPath("$.message")
 *         .build();
 * SnsPublish publishMessage = SnsPublish.Builder.create(this, "Publish message")
 *         .topic(new Topic(this, "cool-topic"))
 *         .message(TaskInput.fromJsonPathAt("$.message"))
 *         .resultPath("$.sns")
 *         .build();
 * Wait wait = Wait.Builder.create(this, "Wait")
 *         .time(WaitTime.secondsPath("$.waitSeconds"))
 *         .build();
 * StateMachine.Builder.create(this, "StateMachine")
 *         .definition(convertToSeconds.next(createMessage).next(publishMessage).next(wait))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:13.137Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.Wait")
public class Wait extends software.amazon.awscdk.services.stepfunctions.State implements software.amazon.awscdk.services.stepfunctions.INextable {

    protected Wait(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Wait(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Wait(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.WaitProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Continue normal execution with the given state.
     * <p>
     * @param next This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Chain next(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return software.amazon.jsii.Kernel.call(this, "next", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Chain.class), new Object[] { java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Return the Amazon States Language object for this state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
        return software.amazon.jsii.Kernel.call(this, "toStateJson", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
    }

    /**
     * Continuable states of this Chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "endStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.Wait}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.Wait> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.stepfunctions.WaitProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.stepfunctions.WaitProps.Builder();
        }

        /**
         * Wait duration.
         * <p>
         * @return {@code this}
         * @param time Wait duration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder time(final software.amazon.awscdk.services.stepfunctions.WaitTime time) {
            this.props.time(time);
            return this;
        }

        /**
         * An optional description for this state.
         * <p>
         * Default: No comment
         * <p>
         * @return {@code this}
         * @param comment An optional description for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.Wait}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.Wait build() {
            return new software.amazon.awscdk.services.stepfunctions.Wait(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
