package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for defining a Fail state.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function submitLambda;
 * Function getStatusLambda;
 * LambdaInvoke submitJob = LambdaInvoke.Builder.create(this, "Submit Job")
 *         .lambdaFunction(submitLambda)
 *         // Lambda's result is in the attribute `Payload`
 *         .outputPath("$.Payload")
 *         .build();
 * Wait waitX = Wait.Builder.create(this, "Wait X Seconds")
 *         .time(WaitTime.secondsPath("$.waitSeconds"))
 *         .build();
 * LambdaInvoke getStatus = LambdaInvoke.Builder.create(this, "Get Job Status")
 *         .lambdaFunction(getStatusLambda)
 *         // Pass just the field named "guid" into the Lambda, put the
 *         // Lambda's result in a field called "status" in the response
 *         .inputPath("$.guid")
 *         .outputPath("$.Payload")
 *         .build();
 * Fail jobFailed = Fail.Builder.create(this, "Job Failed")
 *         .cause("AWS Batch Job Failed")
 *         .error("DescribeJob returned FAILED")
 *         .build();
 * LambdaInvoke finalStatus = LambdaInvoke.Builder.create(this, "Get Final Job Status")
 *         .lambdaFunction(getStatusLambda)
 *         // Use "guid" field as input
 *         .inputPath("$.guid")
 *         .outputPath("$.Payload")
 *         .build();
 * Chain definition = submitJob.next(waitX).next(getStatus).next(new Choice(this, "Job Complete?").when(Condition.stringEquals("$.status", "FAILED"), jobFailed).when(Condition.stringEquals("$.status", "SUCCEEDED"), finalStatus).otherwise(waitX));
 * StateMachine.Builder.create(this, "StateMachine")
 *         .definition(definition)
 *         .timeout(Duration.minutes(5))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:13.106Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.FailProps")
@software.amazon.jsii.Jsii.Proxy(FailProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FailProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A description for the cause of the failure.
     * <p>
     * Default: No description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCause() {
        return null;
    }

    /**
     * An optional description for this state.
     * <p>
     * Default: No comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * Error code used to represent this failure.
     * <p>
     * Default: No error code
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getError() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FailProps> {
        java.lang.String cause;
        java.lang.String comment;
        java.lang.String error;

        /**
         * Sets the value of {@link FailProps#getCause}
         * @param cause A description for the cause of the failure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cause(java.lang.String cause) {
            this.cause = cause;
            return this;
        }

        /**
         * Sets the value of {@link FailProps#getComment}
         * @param comment An optional description for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link FailProps#getError}
         * @param error Error code used to represent this failure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder error(java.lang.String error) {
            this.error = error;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FailProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FailProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FailProps {
        private final java.lang.String cause;
        private final java.lang.String comment;
        private final java.lang.String error;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cause = software.amazon.jsii.Kernel.get(this, "cause", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.error = software.amazon.jsii.Kernel.get(this, "error", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cause = builder.cause;
            this.comment = builder.comment;
            this.error = builder.error;
        }

        @Override
        public final java.lang.String getCause() {
            return this.cause;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getError() {
            return this.error;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCause() != null) {
                data.set("cause", om.valueToTree(this.getCause()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getError() != null) {
                data.set("error", om.valueToTree(this.getError()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.FailProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FailProps.Jsii$Proxy that = (FailProps.Jsii$Proxy) o;

            if (this.cause != null ? !this.cause.equals(that.cause) : that.cause != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            return this.error != null ? this.error.equals(that.error) : that.error == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cause != null ? this.cause.hashCode() : 0;
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
            return result;
        }
    }
}
