/**
 * <h1>Amazon ECS Service Discovery Construct Library</h1>
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * This package contains constructs for working with <strong>AWS Cloud Map</strong>
 * <p>
 * AWS Cloud Map is a fully managed service that you can use to create and
 * maintain a map of the backend services and resources that your applications
 * depend on.
 * <p>
 * For further information on AWS Cloud Map,
 * see the <a href="https://docs.aws.amazon.com/cloud-map">AWS Cloud Map documentation</a>
 * <p>
 * <h2>HTTP Namespace Example</h2>
 * <p>
 * The following example creates an AWS Cloud Map namespace that
 * supports API calls, creates a service in that namespace, and
 * registers an instance to it:
 * <p>
 * <a href="test/integ.service-with-http-namespace.lit.ts">Creating a Cloud Map service within an HTTP namespace</a>
 * <p>
 * <h2>Private DNS Namespace Example</h2>
 * <p>
 * The following example creates an AWS Cloud Map namespace that
 * supports both API calls and DNS queries within a vpc, creates a
 * service in that namespace, and registers a loadbalancer as an
 * instance:
 * <p>
 * <a href="test/integ.service-with-private-dns-namespace.lit.ts">Creating a Cloud Map service within a Private DNS namespace</a>
 * <p>
 * <h2>Public DNS Namespace Example</h2>
 * <p>
 * The following example creates an AWS Cloud Map namespace that
 * supports both API calls and public DNS queries, creates a service in
 * that namespace, and registers an IP instance:
 * <p>
 * <a href="test/integ.service-with-public-dns-namespace.lit.ts">Creating a Cloud Map service within a Public namespace</a>
 * <p>
 * For DNS namespaces, you can also register instances to services with CNAME records:
 * <p>
 * <a href="test/integ.service-with-cname-record.lit.ts">Creating a Cloud Map service within a Public namespace</a>
 */
package software.amazon.awscdk.services.servicediscovery;
