package software.amazon.awscdk.services.servicediscovery;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * TaskDefinition taskDefinition;
 * Cluster cluster;
 * Ec2Service service = Ec2Service.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .cloudMapOptions(CloudMapOptions.builder()
 *                 // Create A records - useful for AWSVPC network mode.
 *                 .dnsRecordType(DnsRecordType.A)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:12.877Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.DnsRecordType")
public enum DnsRecordType {
    /**
     * An A record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    A,
    /**
     * An AAAA record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AAAA,
    /**
     * Both an A and AAAA record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    A_AAAA,
    /**
     * A Srv record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SRV,
    /**
     * A CNAME record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CNAME,
}
