package software.amazon.awscdk.services.route53resolver;

/**
 * Properties for defining a `CfnResolverConfig`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53resolver.*;
 * CfnResolverConfigProps cfnResolverConfigProps = CfnResolverConfigProps.builder()
 *         .autodefinedReverseFlag("autodefinedReverseFlag")
 *         .resourceId("resourceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:12.457Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53resolver.CfnResolverConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnResolverConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResolverConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Represents the desired status of `AutodefinedReverse` .
     * <p>
     * The only supported value on creation is <code>DISABLE</code> . Deletion of this resource will return <code>AutodefinedReverse</code> to its default value of <code>ENABLED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAutodefinedReverseFlag();

    /**
     * The ID of the Amazon Virtual Private Cloud VPC that you're configuring Resolver for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

    /**
     * @return a {@link Builder} of {@link CfnResolverConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResolverConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResolverConfigProps> {
        java.lang.String autodefinedReverseFlag;
        java.lang.String resourceId;

        /**
         * Sets the value of {@link CfnResolverConfigProps#getAutodefinedReverseFlag}
         * @param autodefinedReverseFlag Represents the desired status of `AutodefinedReverse` . This parameter is required.
         *                               The only supported value on creation is <code>DISABLE</code> . Deletion of this resource will return <code>AutodefinedReverse</code> to its default value of <code>ENABLED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autodefinedReverseFlag(java.lang.String autodefinedReverseFlag) {
            this.autodefinedReverseFlag = autodefinedReverseFlag;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverConfigProps#getResourceId}
         * @param resourceId The ID of the Amazon Virtual Private Cloud VPC that you're configuring Resolver for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(java.lang.String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResolverConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResolverConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResolverConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResolverConfigProps {
        private final java.lang.String autodefinedReverseFlag;
        private final java.lang.String resourceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autodefinedReverseFlag = software.amazon.jsii.Kernel.get(this, "autodefinedReverseFlag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autodefinedReverseFlag = java.util.Objects.requireNonNull(builder.autodefinedReverseFlag, "autodefinedReverseFlag is required");
            this.resourceId = java.util.Objects.requireNonNull(builder.resourceId, "resourceId is required");
        }

        @Override
        public final java.lang.String getAutodefinedReverseFlag() {
            return this.autodefinedReverseFlag;
        }

        @Override
        public final java.lang.String getResourceId() {
            return this.resourceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autodefinedReverseFlag", om.valueToTree(this.getAutodefinedReverseFlag()));
            data.set("resourceId", om.valueToTree(this.getResourceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53resolver.CfnResolverConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResolverConfigProps.Jsii$Proxy that = (CfnResolverConfigProps.Jsii$Proxy) o;

            if (!autodefinedReverseFlag.equals(that.autodefinedReverseFlag)) return false;
            return this.resourceId.equals(that.resourceId);
        }

        @Override
        public final int hashCode() {
            int result = this.autodefinedReverseFlag.hashCode();
            result = 31 * result + (this.resourceId.hashCode());
            return result;
        }
    }
}
