package software.amazon.awscdk.services.rds;

/**
 * Username and password combination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.auroraMysql(AuroraMysqlClusterEngineProps.builder().version(AuroraMysqlEngineVersion.VER_2_08_1).build()))
 *         .credentials(Credentials.fromGeneratedSecret("clusteradmin")) // Optional - will default to 'admin' username and generated password
 *         .instanceProps(InstanceProps.builder()
 *                 // optional , defaults to t3.medium
 *                 .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.SMALL))
 *                 .vpcSubnets(SubnetSelection.builder()
 *                         .subnetType(SubnetType.PRIVATE)
 *                         .build())
 *                 .vpc(vpc)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:12.189Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.Credentials")
public abstract class Credentials extends software.amazon.jsii.JsiiObject {

    protected Credentials(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Credentials(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Credentials() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates Credentials with a password generated and stored in Secrets Manager.
     * <p>
     * @param username This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Credentials fromGeneratedSecret(final @org.jetbrains.annotations.NotNull java.lang.String username, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CredentialsBaseOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.Credentials.class, "fromGeneratedSecret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Credentials.class), new Object[] { java.util.Objects.requireNonNull(username, "username is required"), options });
    }

    /**
     * Creates Credentials with a password generated and stored in Secrets Manager.
     * <p>
     * @param username This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Credentials fromGeneratedSecret(final @org.jetbrains.annotations.NotNull java.lang.String username) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.Credentials.class, "fromGeneratedSecret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Credentials.class), new Object[] { java.util.Objects.requireNonNull(username, "username is required") });
    }

    /**
     * Creates Credentials from a password.
     * <p>
     * Do not put passwords in your CDK code directly.
     * <p>
     * @param username This parameter is required.
     * @param password This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Credentials fromPassword(final @org.jetbrains.annotations.NotNull java.lang.String username, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue password) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.Credentials.class, "fromPassword", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Credentials.class), new Object[] { java.util.Objects.requireNonNull(username, "username is required"), java.util.Objects.requireNonNull(password, "password is required") });
    }

    /**
     * Creates Credentials from an existing Secrets Manager ``Secret`` (or ``DatabaseSecret``).
     * <p>
     * The Secret must be a JSON string with a <code>username</code> and <code>password</code> field:
     * <p>
     * <blockquote><pre>
     * {
     *    ...
     *    "username": &lt;required: username&gt;,
     *    "password": &lt;required: password&gt;,
     * }
     * </pre></blockquote>
     * <p>
     * @param secret The secret where the credentials are stored. This parameter is required.
     * @param username The username defined in the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Credentials fromSecret(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secret, final @org.jetbrains.annotations.Nullable java.lang.String username) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.Credentials.class, "fromSecret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Credentials.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required"), username });
    }

    /**
     * Creates Credentials from an existing Secrets Manager ``Secret`` (or ``DatabaseSecret``).
     * <p>
     * The Secret must be a JSON string with a <code>username</code> and <code>password</code> field:
     * <p>
     * <blockquote><pre>
     * {
     *    ...
     *    "username": &lt;required: username&gt;,
     *    "password": &lt;required: password&gt;,
     * }
     * </pre></blockquote>
     * <p>
     * @param secret The secret where the credentials are stored. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Credentials fromSecret(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secret) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.Credentials.class, "fromSecret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Credentials.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required") });
    }

    /**
     * Creates Credentials for the given username, and optional password and key.
     * <p>
     * If no password is provided, one will be generated and stored in Secrets Manager.
     * <p>
     * @param username This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Credentials fromUsername(final @org.jetbrains.annotations.NotNull java.lang.String username, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CredentialsFromUsernameOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.Credentials.class, "fromUsername", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Credentials.class), new Object[] { java.util.Objects.requireNonNull(username, "username is required"), options });
    }

    /**
     * Creates Credentials for the given username, and optional password and key.
     * <p>
     * If no password is provided, one will be generated and stored in Secrets Manager.
     * <p>
     * @param username This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Credentials fromUsername(final @org.jetbrains.annotations.NotNull java.lang.String username) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.Credentials.class, "fromUsername", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Credentials.class), new Object[] { java.util.Objects.requireNonNull(username, "username is required") });
    }

    /**
     * Username.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getUsername();

    /**
     * KMS encryption key to encrypt the generated secret.
     * <p>
     * Default: - default master key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey();

    /**
     * The characters to exclude from the generated password.
     * <p>
     * Only used if {&#64;link password} has not been set.
     * <p>
     * Default: - the DatabaseSecret default exclude character set (" %+~`#$&*()|[]{}:;<>?!'/
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.lang.String getExcludeCharacters();

    /**
     * Password.
     * <p>
     * Do not put passwords in your CDK code directly.
     * <p>
     * Default: - a Secrets Manager generated password
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.SecretValue getPassword();

    /**
     * A list of regions where to replicate the generated secret.
     * <p>
     * Default: - Secret is not replicated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> getReplicaRegions();

    /**
     * Secret used to instantiate this Login.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecret();

    /**
     * The name to use for the Secret if a new Secret is to be generated in SecretsManager for these Credentials.
     * <p>
     * Default: - A name is generated by CloudFormation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.lang.String getSecretName();

    /**
     * Whether the username should be referenced as a string and not as a dynamic reference to the username in the secret.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.lang.Boolean getUsernameAsString();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.rds.Credentials {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Username.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getUsername() {
            return software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * KMS encryption key to encrypt the generated secret.
         * <p>
         * Default: - default master key
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * The characters to exclude from the generated password.
         * <p>
         * Only used if {&#64;link password} has not been set.
         * <p>
         * Default: - the DatabaseSecret default exclude character set (" %+~`#$&*()|[]{}:;<>?!'/
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getExcludeCharacters() {
            return software.amazon.jsii.Kernel.get(this, "excludeCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Password.
         * <p>
         * Do not put passwords in your CDK code directly.
         * <p>
         * Default: - a Secrets Manager generated password
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SecretValue getPassword() {
            return software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
        }

        /**
         * A list of regions where to replicate the generated secret.
         * <p>
         * Default: - Secret is not replicated
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> getReplicaRegions() {
            return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion>)(software.amazon.jsii.Kernel.get(this, "replicaRegions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ReplicaRegion.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * Secret used to instantiate this Login.
         * <p>
         * Default: - none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
            return software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
        }

        /**
         * The name to use for the Secret if a new Secret is to be generated in SecretsManager for these Credentials.
         * <p>
         * Default: - A name is generated by CloudFormation.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getSecretName() {
            return software.amazon.jsii.Kernel.get(this, "secretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Whether the username should be referenced as a string and not as a dynamic reference to the username in the secret.
         * <p>
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getUsernameAsString() {
            return software.amazon.jsii.Kernel.get(this, "usernameAsString", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }
    }
}
