package software.amazon.awscdk.services.logs;

/**
 * Properties for a LogGroup.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Key kmsKey = new Key(this, "KmsKey");
 * // Pass the KMS key in the `encryptionKey` field to associate the key to the log group
 * LogGroup logGroup = LogGroup.Builder.create(this, "LogGroup")
 *         .encryptionKey(kmsKey)
 *         .build();
 * // Pass the KMS key in the `encryptionKey` field to associate the key to the S3 bucket
 * Bucket execBucket = Bucket.Builder.create(this, "EcsExecBucket")
 *         .encryptionKey(kmsKey)
 *         .build();
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         .vpc(vpc)
 *         .executeCommandConfiguration(ExecuteCommandConfiguration.builder()
 *                 .kmsKey(kmsKey)
 *                 .logConfiguration(ExecuteCommandLogConfiguration.builder()
 *                         .cloudWatchLogGroup(logGroup)
 *                         .cloudWatchEncryptionEnabled(true)
 *                         .s3Bucket(execBucket)
 *                         .s3EncryptionEnabled(true)
 *                         .s3KeyPrefix("exec-command-output")
 *                         .build())
 *                 .logging(ExecuteCommandLogging.OVERRIDE)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:11.468Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.LogGroupProps")
@software.amazon.jsii.Jsii.Proxy(LogGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The KMS Key to encrypt the log group with.
     * <p>
     * Default: - log group is encrypted with the default master key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * Name of the log group.
     * <p>
     * Default: Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupName() {
        return null;
    }

    /**
     * Determine the removal policy of this log group.
     * <p>
     * Normally you want to retain the log group so you can diagnose issues
     * from logs even after a deployment that no longer includes the log group.
     * In that case, use the normal date-based retention policy to age out your
     * logs.
     * <p>
     * Default: RemovalPolicy.Retain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * How long, in days, the log contents will be retained.
     * <p>
     * To retain all logs, set this value to RetentionDays.INFINITE.
     * <p>
     * Default: RetentionDays.TWO_YEARS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getRetention() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogGroupProps> {
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.lang.String logGroupName;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        software.amazon.awscdk.services.logs.RetentionDays retention;

        /**
         * Sets the value of {@link LogGroupProps#getEncryptionKey}
         * @param encryptionKey The KMS Key to encrypt the log group with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getLogGroupName}
         * @param logGroupName Name of the log group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(java.lang.String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getRemovalPolicy}
         * @param removalPolicy Determine the removal policy of this log group.
         *                      Normally you want to retain the log group so you can diagnose issues
         *                      from logs even after a deployment that no longer includes the log group.
         *                      In that case, use the normal date-based retention policy to age out your
         *                      logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getRetention}
         * @param retention How long, in days, the log contents will be retained.
         *                  To retain all logs, set this value to RetentionDays.INFINITE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retention(software.amazon.awscdk.services.logs.RetentionDays retention) {
            this.retention = retention;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogGroupProps {
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.String logGroupName;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.logs.RetentionDays retention;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.retention = software.amazon.jsii.Kernel.get(this, "retention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.encryptionKey = builder.encryptionKey;
            this.logGroupName = builder.logGroupName;
            this.removalPolicy = builder.removalPolicy;
            this.retention = builder.retention;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getRetention() {
            return this.retention;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getLogGroupName() != null) {
                data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getRetention() != null) {
                data.set("retention", om.valueToTree(this.getRetention()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.LogGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogGroupProps.Jsii$Proxy that = (LogGroupProps.Jsii$Proxy) o;

            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.logGroupName != null ? !this.logGroupName.equals(that.logGroupName) : that.logGroupName != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.retention != null ? this.retention.equals(that.retention) : that.retention == null;
        }

        @Override
        public final int hashCode() {
            int result = this.encryptionKey != null ? this.encryptionKey.hashCode() : 0;
            result = 31 * result + (this.logGroupName != null ? this.logGroupName.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.retention != null ? this.retention.hashCode() : 0);
            return result;
        }
    }
}
