package software.amazon.awscdk.services.location;

/**
 * Properties for defining a `CfnRouteCalculator`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.location.*;
 * CfnRouteCalculatorProps cfnRouteCalculatorProps = CfnRouteCalculatorProps.builder()
 *         .calculatorName("calculatorName")
 *         .dataSource("dataSource")
 *         .pricingPlan("pricingPlan")
 *         // the properties below are optional
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:11.447Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_location.CfnRouteCalculatorProps")
@software.amazon.jsii.Jsii.Proxy(CfnRouteCalculatorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRouteCalculatorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the route calculator resource.
     * <p>
     * Requirements:
     * <p>
     * <ul>
     * <li>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).</li>
     * <li>Must be a unique route calculator resource name.</li>
     * <li>No spaces allowed. For example, <code>ExampleRouteCalculator</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCalculatorName();

    /**
     * Specifies the data provider of traffic and road network data.
     * <p>
     * <blockquote>
     * <p>
     * This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error.
     * <p>
     * </blockquote>
     * <p>
     * Valid values include:
     * <p>
     * <ul>
     * <li><code>Esri</code></li>
     * <li><code>Here</code></li>
     * </ul>
     * <p>
     * For more information about data providers, see the <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers page</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataSource();

    /**
     * Specifies the pricing plan for your route calculator resource.
     * <p>
     * For additional details and restrictions on each pricing plan option, see the <a href="https://docs.aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPricingPlan();

    /**
     * The optional description for the route calculator resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRouteCalculatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRouteCalculatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRouteCalculatorProps> {
        java.lang.String calculatorName;
        java.lang.String dataSource;
        java.lang.String pricingPlan;
        java.lang.String description;

        /**
         * Sets the value of {@link CfnRouteCalculatorProps#getCalculatorName}
         * @param calculatorName The name of the route calculator resource. This parameter is required.
         *                       Requirements:
         *                       <p>
         *                       <ul>
         *                       <li>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).</li>
         *                       <li>Must be a unique route calculator resource name.</li>
         *                       <li>No spaces allowed. For example, <code>ExampleRouteCalculator</code> .</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder calculatorName(java.lang.String calculatorName) {
            this.calculatorName = calculatorName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteCalculatorProps#getDataSource}
         * @param dataSource Specifies the data provider of traffic and road network data. This parameter is required.
         *                   <blockquote>
         *                   <p>
         *                   This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error.
         *                   <p>
         *                   </blockquote>
         *                   <p>
         *                   Valid values include:
         *                   <p>
         *                   <ul>
         *                   <li><code>Esri</code></li>
         *                   <li><code>Here</code></li>
         *                   </ul>
         *                   <p>
         *                   For more information about data providers, see the <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers page</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSource(java.lang.String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteCalculatorProps#getPricingPlan}
         * @param pricingPlan Specifies the pricing plan for your route calculator resource. This parameter is required.
         *                    For additional details and restrictions on each pricing plan option, see the <a href="https://docs.aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pricingPlan(java.lang.String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteCalculatorProps#getDescription}
         * @param description The optional description for the route calculator resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRouteCalculatorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRouteCalculatorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRouteCalculatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRouteCalculatorProps {
        private final java.lang.String calculatorName;
        private final java.lang.String dataSource;
        private final java.lang.String pricingPlan;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.calculatorName = software.amazon.jsii.Kernel.get(this, "calculatorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataSource = software.amazon.jsii.Kernel.get(this, "dataSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pricingPlan = software.amazon.jsii.Kernel.get(this, "pricingPlan", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.calculatorName = java.util.Objects.requireNonNull(builder.calculatorName, "calculatorName is required");
            this.dataSource = java.util.Objects.requireNonNull(builder.dataSource, "dataSource is required");
            this.pricingPlan = java.util.Objects.requireNonNull(builder.pricingPlan, "pricingPlan is required");
            this.description = builder.description;
        }

        @Override
        public final java.lang.String getCalculatorName() {
            return this.calculatorName;
        }

        @Override
        public final java.lang.String getDataSource() {
            return this.dataSource;
        }

        @Override
        public final java.lang.String getPricingPlan() {
            return this.pricingPlan;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("calculatorName", om.valueToTree(this.getCalculatorName()));
            data.set("dataSource", om.valueToTree(this.getDataSource()));
            data.set("pricingPlan", om.valueToTree(this.getPricingPlan()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_location.CfnRouteCalculatorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRouteCalculatorProps.Jsii$Proxy that = (CfnRouteCalculatorProps.Jsii$Proxy) o;

            if (!calculatorName.equals(that.calculatorName)) return false;
            if (!dataSource.equals(that.dataSource)) return false;
            if (!pricingPlan.equals(that.pricingPlan)) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.calculatorName.hashCode();
            result = 31 * result + (this.dataSource.hashCode());
            result = 31 * result + (this.pricingPlan.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
