package software.amazon.awscdk.services.kinesisanalytics;

/**
 * Properties for defining a `CfnApplication`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisanalytics.*;
 * CfnApplicationProps cfnApplicationProps = CfnApplicationProps.builder()
 *         .inputs(List.of(InputProperty.builder()
 *                 .inputSchema(InputSchemaProperty.builder()
 *                         .recordColumns(List.of(RecordColumnProperty.builder()
 *                                 .name("name")
 *                                 .sqlType("sqlType")
 *                                 // the properties below are optional
 *                                 .mapping("mapping")
 *                                 .build()))
 *                         .recordFormat(RecordFormatProperty.builder()
 *                                 .recordFormatType("recordFormatType")
 *                                 // the properties below are optional
 *                                 .mappingParameters(MappingParametersProperty.builder()
 *                                         .csvMappingParameters(CSVMappingParametersProperty.builder()
 *                                                 .recordColumnDelimiter("recordColumnDelimiter")
 *                                                 .recordRowDelimiter("recordRowDelimiter")
 *                                                 .build())
 *                                         .jsonMappingParameters(JSONMappingParametersProperty.builder()
 *                                                 .recordRowPath("recordRowPath")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .recordEncoding("recordEncoding")
 *                         .build())
 *                 .namePrefix("namePrefix")
 *                 // the properties below are optional
 *                 .inputParallelism(InputParallelismProperty.builder()
 *                         .count(123)
 *                         .build())
 *                 .inputProcessingConfiguration(InputProcessingConfigurationProperty.builder()
 *                         .inputLambdaProcessor(InputLambdaProcessorProperty.builder()
 *                                 .resourceArn("resourceArn")
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .build())
 *                 .kinesisFirehoseInput(KinesisFirehoseInputProperty.builder()
 *                         .resourceArn("resourceArn")
 *                         .roleArn("roleArn")
 *                         .build())
 *                 .kinesisStreamsInput(KinesisStreamsInputProperty.builder()
 *                         .resourceArn("resourceArn")
 *                         .roleArn("roleArn")
 *                         .build())
 *                 .build()))
 *         // the properties below are optional
 *         .applicationCode("applicationCode")
 *         .applicationDescription("applicationDescription")
 *         .applicationName("applicationName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:10.974Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Use this parameter to configure the application input.
     * <p>
     * You can configure your application to receive input from a single streaming source. In this configuration, you map this streaming source to an in-application stream that is created. Your application code can then query the in-application stream like a table (you can think of it as a constantly updating table).
     * <p>
     * For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read this stream on your behalf.
     * <p>
     * To create the in-application stream, you need to specify a schema to transform your data into a schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming source to record columns in the in-app stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getInputs();

    /**
     * One or more SQL statements that read input data, transform it, and generate output.
     * <p>
     * For example, you can write a SQL statement that reads data from one in-application stream, generates a running average of the number of advertisement clicks by vendor, and insert resulting rows in another in-application stream using pumps. For more information about the typical pattern, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application Code</a> .
     * <p>
     * You can provide such series of SQL statements, where output of one statement can be used as the input for the next statement. You store intermediate results by creating in-application streams and pumps.
     * <p>
     * Note that the application code must create the streams with names specified in the <code>Outputs</code> . For example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code> and <code>ExampleOutputStream2</code> , then your application code must create these streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationCode() {
        return null;
    }

    /**
     * Summary description of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationDescription() {
        return null;
    }

    /**
     * Name of your Amazon Kinesis Analytics application (for example, `sample-app` ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationProps> {
        java.lang.Object inputs;
        java.lang.String applicationCode;
        java.lang.String applicationDescription;
        java.lang.String applicationName;

        /**
         * Sets the value of {@link CfnApplicationProps#getInputs}
         * @param inputs Use this parameter to configure the application input. This parameter is required.
         *               You can configure your application to receive input from a single streaming source. In this configuration, you map this streaming source to an in-application stream that is created. Your application code can then query the in-application stream like a table (you can think of it as a constantly updating table).
         *               <p>
         *               For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read this stream on your behalf.
         *               <p>
         *               To create the in-application stream, you need to specify a schema to transform your data into a schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming source to record columns in the in-app stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputs(software.amazon.awscdk.IResolvable inputs) {
            this.inputs = inputs;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getInputs}
         * @param inputs Use this parameter to configure the application input. This parameter is required.
         *               You can configure your application to receive input from a single streaming source. In this configuration, you map this streaming source to an in-application stream that is created. Your application code can then query the in-application stream like a table (you can think of it as a constantly updating table).
         *               <p>
         *               For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read this stream on your behalf.
         *               <p>
         *               To create the in-application stream, you need to specify a schema to transform your data into a schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming source to record columns in the in-app stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputs(java.util.List<? extends java.lang.Object> inputs) {
            this.inputs = inputs;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationCode}
         * @param applicationCode One or more SQL statements that read input data, transform it, and generate output.
         *                        For example, you can write a SQL statement that reads data from one in-application stream, generates a running average of the number of advertisement clicks by vendor, and insert resulting rows in another in-application stream using pumps. For more information about the typical pattern, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application Code</a> .
         *                        <p>
         *                        You can provide such series of SQL statements, where output of one statement can be used as the input for the next statement. You store intermediate results by creating in-application streams and pumps.
         *                        <p>
         *                        Note that the application code must create the streams with names specified in the <code>Outputs</code> . For example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code> and <code>ExampleOutputStream2</code> , then your application code must create these streams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationCode(java.lang.String applicationCode) {
            this.applicationCode = applicationCode;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationDescription}
         * @param applicationDescription Summary description of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationDescription(java.lang.String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationName}
         * @param applicationName Name of your Amazon Kinesis Analytics application (for example, `sample-app` ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationProps {
        private final java.lang.Object inputs;
        private final java.lang.String applicationCode;
        private final java.lang.String applicationDescription;
        private final java.lang.String applicationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inputs = software.amazon.jsii.Kernel.get(this, "inputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.applicationCode = software.amazon.jsii.Kernel.get(this, "applicationCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applicationDescription = software.amazon.jsii.Kernel.get(this, "applicationDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applicationName = software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inputs = java.util.Objects.requireNonNull(builder.inputs, "inputs is required");
            this.applicationCode = builder.applicationCode;
            this.applicationDescription = builder.applicationDescription;
            this.applicationName = builder.applicationName;
        }

        @Override
        public final java.lang.Object getInputs() {
            return this.inputs;
        }

        @Override
        public final java.lang.String getApplicationCode() {
            return this.applicationCode;
        }

        @Override
        public final java.lang.String getApplicationDescription() {
            return this.applicationDescription;
        }

        @Override
        public final java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("inputs", om.valueToTree(this.getInputs()));
            if (this.getApplicationCode() != null) {
                data.set("applicationCode", om.valueToTree(this.getApplicationCode()));
            }
            if (this.getApplicationDescription() != null) {
                data.set("applicationDescription", om.valueToTree(this.getApplicationDescription()));
            }
            if (this.getApplicationName() != null) {
                data.set("applicationName", om.valueToTree(this.getApplicationName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationProps.Jsii$Proxy that = (CfnApplicationProps.Jsii$Proxy) o;

            if (!inputs.equals(that.inputs)) return false;
            if (this.applicationCode != null ? !this.applicationCode.equals(that.applicationCode) : that.applicationCode != null) return false;
            if (this.applicationDescription != null ? !this.applicationDescription.equals(that.applicationDescription) : that.applicationDescription != null) return false;
            return this.applicationName != null ? this.applicationName.equals(that.applicationName) : that.applicationName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.inputs.hashCode();
            result = 31 * result + (this.applicationCode != null ? this.applicationCode.hashCode() : 0);
            result = 31 * result + (this.applicationDescription != null ? this.applicationDescription.hashCode() : 0);
            result = 31 * result + (this.applicationName != null ? this.applicationName.hashCode() : 0);
            return result;
        }
    }
}
