package software.amazon.awscdk.services.iotwireless;

/**
 * Properties for defining a `CfnFuotaTask`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotwireless.*;
 * CfnFuotaTaskProps cfnFuotaTaskProps = CfnFuotaTaskProps.builder()
 *         .firmwareUpdateImage("firmwareUpdateImage")
 *         .firmwareUpdateRole("firmwareUpdateRole")
 *         .loRaWan(LoRaWANProperty.builder()
 *                 .rfRegion("rfRegion")
 *                 // the properties below are optional
 *                 .startTime("startTime")
 *                 .build())
 *         // the properties below are optional
 *         .associateMulticastGroup("associateMulticastGroup")
 *         .associateWirelessDevice("associateWirelessDevice")
 *         .description("description")
 *         .disassociateMulticastGroup("disassociateMulticastGroup")
 *         .disassociateWirelessDevice("disassociateWirelessDevice")
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:10.854Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnFuotaTaskProps")
@software.amazon.jsii.Jsii.Proxy(CfnFuotaTaskProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFuotaTaskProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The S3 URI points to a firmware update image that is to be used with a FUOTA task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFirmwareUpdateImage();

    /**
     * The firmware update role that is to be used with a FUOTA task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFirmwareUpdateRole();

    /**
     * The LoRaWAN information used with a FUOTA task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLoRaWan();

    /**
     * The ID of the multicast group to associate with a FUOTA task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssociateMulticastGroup() {
        return null;
    }

    /**
     * The ID of the wireless device to associate with a multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssociateWirelessDevice() {
        return null;
    }

    /**
     * The description of the new resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The ID of the multicast group to disassociate from a FUOTA task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisassociateMulticastGroup() {
        return null;
    }

    /**
     * The ID of the wireless device to disassociate from a FUOTA task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisassociateWirelessDevice() {
        return null;
    }

    /**
     * The name of a FUOTA task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     * <p>
     * Tags can have a minimum of 0 and a maximum of 50 items.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFuotaTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFuotaTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFuotaTaskProps> {
        java.lang.String firmwareUpdateImage;
        java.lang.String firmwareUpdateRole;
        java.lang.Object loRaWan;
        java.lang.String associateMulticastGroup;
        java.lang.String associateWirelessDevice;
        java.lang.String description;
        java.lang.String disassociateMulticastGroup;
        java.lang.String disassociateWirelessDevice;
        java.lang.String name;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnFuotaTaskProps#getFirmwareUpdateImage}
         * @param firmwareUpdateImage The S3 URI points to a firmware update image that is to be used with a FUOTA task. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firmwareUpdateImage(java.lang.String firmwareUpdateImage) {
            this.firmwareUpdateImage = firmwareUpdateImage;
            return this;
        }

        /**
         * Sets the value of {@link CfnFuotaTaskProps#getFirmwareUpdateRole}
         * @param firmwareUpdateRole The firmware update role that is to be used with a FUOTA task. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firmwareUpdateRole(java.lang.String firmwareUpdateRole) {
            this.firmwareUpdateRole = firmwareUpdateRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnFuotaTaskProps#getLoRaWan}
         * @param loRaWan The LoRaWAN information used with a FUOTA task. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWan(software.amazon.awscdk.services.iotwireless.CfnFuotaTask.LoRaWANProperty loRaWan) {
            this.loRaWan = loRaWan;
            return this;
        }

        /**
         * Sets the value of {@link CfnFuotaTaskProps#getLoRaWan}
         * @param loRaWan The LoRaWAN information used with a FUOTA task. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWan(software.amazon.awscdk.IResolvable loRaWan) {
            this.loRaWan = loRaWan;
            return this;
        }

        /**
         * Sets the value of {@link CfnFuotaTaskProps#getAssociateMulticastGroup}
         * @param associateMulticastGroup The ID of the multicast group to associate with a FUOTA task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associateMulticastGroup(java.lang.String associateMulticastGroup) {
            this.associateMulticastGroup = associateMulticastGroup;
            return this;
        }

        /**
         * Sets the value of {@link CfnFuotaTaskProps#getAssociateWirelessDevice}
         * @param associateWirelessDevice The ID of the wireless device to associate with a multicast group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associateWirelessDevice(java.lang.String associateWirelessDevice) {
            this.associateWirelessDevice = associateWirelessDevice;
            return this;
        }

        /**
         * Sets the value of {@link CfnFuotaTaskProps#getDescription}
         * @param description The description of the new resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFuotaTaskProps#getDisassociateMulticastGroup}
         * @param disassociateMulticastGroup The ID of the multicast group to disassociate from a FUOTA task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disassociateMulticastGroup(java.lang.String disassociateMulticastGroup) {
            this.disassociateMulticastGroup = disassociateMulticastGroup;
            return this;
        }

        /**
         * Sets the value of {@link CfnFuotaTaskProps#getDisassociateWirelessDevice}
         * @param disassociateWirelessDevice The ID of the wireless device to disassociate from a FUOTA task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disassociateWirelessDevice(java.lang.String disassociateWirelessDevice) {
            this.disassociateWirelessDevice = disassociateWirelessDevice;
            return this;
        }

        /**
         * Sets the value of {@link CfnFuotaTaskProps#getName}
         * @param name The name of a FUOTA task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFuotaTaskProps#getTags}
         * @param tags The tags are an array of key-value pairs to attach to the specified resource.
         *             Tags can have a minimum of 0 and a maximum of 50 items.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFuotaTaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFuotaTaskProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFuotaTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFuotaTaskProps {
        private final java.lang.String firmwareUpdateImage;
        private final java.lang.String firmwareUpdateRole;
        private final java.lang.Object loRaWan;
        private final java.lang.String associateMulticastGroup;
        private final java.lang.String associateWirelessDevice;
        private final java.lang.String description;
        private final java.lang.String disassociateMulticastGroup;
        private final java.lang.String disassociateWirelessDevice;
        private final java.lang.String name;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.firmwareUpdateImage = software.amazon.jsii.Kernel.get(this, "firmwareUpdateImage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.firmwareUpdateRole = software.amazon.jsii.Kernel.get(this, "firmwareUpdateRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loRaWan = software.amazon.jsii.Kernel.get(this, "loRaWan", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.associateMulticastGroup = software.amazon.jsii.Kernel.get(this, "associateMulticastGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.associateWirelessDevice = software.amazon.jsii.Kernel.get(this, "associateWirelessDevice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disassociateMulticastGroup = software.amazon.jsii.Kernel.get(this, "disassociateMulticastGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disassociateWirelessDevice = software.amazon.jsii.Kernel.get(this, "disassociateWirelessDevice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.firmwareUpdateImage = java.util.Objects.requireNonNull(builder.firmwareUpdateImage, "firmwareUpdateImage is required");
            this.firmwareUpdateRole = java.util.Objects.requireNonNull(builder.firmwareUpdateRole, "firmwareUpdateRole is required");
            this.loRaWan = java.util.Objects.requireNonNull(builder.loRaWan, "loRaWan is required");
            this.associateMulticastGroup = builder.associateMulticastGroup;
            this.associateWirelessDevice = builder.associateWirelessDevice;
            this.description = builder.description;
            this.disassociateMulticastGroup = builder.disassociateMulticastGroup;
            this.disassociateWirelessDevice = builder.disassociateWirelessDevice;
            this.name = builder.name;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getFirmwareUpdateImage() {
            return this.firmwareUpdateImage;
        }

        @Override
        public final java.lang.String getFirmwareUpdateRole() {
            return this.firmwareUpdateRole;
        }

        @Override
        public final java.lang.Object getLoRaWan() {
            return this.loRaWan;
        }

        @Override
        public final java.lang.String getAssociateMulticastGroup() {
            return this.associateMulticastGroup;
        }

        @Override
        public final java.lang.String getAssociateWirelessDevice() {
            return this.associateWirelessDevice;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDisassociateMulticastGroup() {
            return this.disassociateMulticastGroup;
        }

        @Override
        public final java.lang.String getDisassociateWirelessDevice() {
            return this.disassociateWirelessDevice;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("firmwareUpdateImage", om.valueToTree(this.getFirmwareUpdateImage()));
            data.set("firmwareUpdateRole", om.valueToTree(this.getFirmwareUpdateRole()));
            data.set("loRaWan", om.valueToTree(this.getLoRaWan()));
            if (this.getAssociateMulticastGroup() != null) {
                data.set("associateMulticastGroup", om.valueToTree(this.getAssociateMulticastGroup()));
            }
            if (this.getAssociateWirelessDevice() != null) {
                data.set("associateWirelessDevice", om.valueToTree(this.getAssociateWirelessDevice()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisassociateMulticastGroup() != null) {
                data.set("disassociateMulticastGroup", om.valueToTree(this.getDisassociateMulticastGroup()));
            }
            if (this.getDisassociateWirelessDevice() != null) {
                data.set("disassociateWirelessDevice", om.valueToTree(this.getDisassociateWirelessDevice()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnFuotaTaskProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFuotaTaskProps.Jsii$Proxy that = (CfnFuotaTaskProps.Jsii$Proxy) o;

            if (!firmwareUpdateImage.equals(that.firmwareUpdateImage)) return false;
            if (!firmwareUpdateRole.equals(that.firmwareUpdateRole)) return false;
            if (!loRaWan.equals(that.loRaWan)) return false;
            if (this.associateMulticastGroup != null ? !this.associateMulticastGroup.equals(that.associateMulticastGroup) : that.associateMulticastGroup != null) return false;
            if (this.associateWirelessDevice != null ? !this.associateWirelessDevice.equals(that.associateWirelessDevice) : that.associateWirelessDevice != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.disassociateMulticastGroup != null ? !this.disassociateMulticastGroup.equals(that.disassociateMulticastGroup) : that.disassociateMulticastGroup != null) return false;
            if (this.disassociateWirelessDevice != null ? !this.disassociateWirelessDevice.equals(that.disassociateWirelessDevice) : that.disassociateWirelessDevice != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.firmwareUpdateImage.hashCode();
            result = 31 * result + (this.firmwareUpdateRole.hashCode());
            result = 31 * result + (this.loRaWan.hashCode());
            result = 31 * result + (this.associateMulticastGroup != null ? this.associateMulticastGroup.hashCode() : 0);
            result = 31 * result + (this.associateWirelessDevice != null ? this.associateWirelessDevice.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.disassociateMulticastGroup != null ? this.disassociateMulticastGroup.hashCode() : 0);
            result = 31 * result + (this.disassociateWirelessDevice != null ? this.disassociateWirelessDevice.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
