package software.amazon.awscdk.services.iotsitewise;

/**
 * A CloudFormation `AWS::IoTSiteWise::Asset`.
 * <p>
 * Creates an asset from an existing asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets</a> in the <em>AWS IoT SiteWise User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * CfnAsset cfnAsset = CfnAsset.Builder.create(this, "MyCfnAsset")
 *         .assetModelId("assetModelId")
 *         .assetName("assetName")
 *         // the properties below are optional
 *         .assetHierarchies(List.of(AssetHierarchyProperty.builder()
 *                 .childAssetId("childAssetId")
 *                 .logicalId("logicalId")
 *                 .build()))
 *         .assetProperties(List.of(AssetPropertyProperty.builder()
 *                 .logicalId("logicalId")
 *                 // the properties below are optional
 *                 .alias("alias")
 *                 .notificationState("notificationState")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:10.816Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAsset")
public class CfnAsset extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnAsset(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAsset(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotsitewise.CfnAsset.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IoTSiteWise::Asset`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAsset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotsitewise.CfnAssetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAssetArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAssetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAssetId() {
        return software.amazon.jsii.Kernel.get(this, "attrAssetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of key-value pairs that contain metadata for the asset.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The ID of the asset model from which to create the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssetModelId() {
        return software.amazon.jsii.Kernel.get(this, "assetModelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the asset model from which to create the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetModelId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "assetModelId", java.util.Objects.requireNonNull(value, "assetModelId is required"));
    }

    /**
     * A unique, friendly name for the asset.
     * <p>
     * The maximum length is 256 characters with the pattern <code>[^\ u0000-\ u001F\ u007F]+</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssetName() {
        return software.amazon.jsii.Kernel.get(this, "assetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique, friendly name for the asset.
     * <p>
     * The maximum length is 256 characters with the pattern <code>[^\ u0000-\ u001F\ u007F]+</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "assetName", java.util.Objects.requireNonNull(value, "assetName is required"));
    }

    /**
     * A list of asset hierarchies that each contain a `hierarchyLogicalId` .
     * <p>
     * A hierarchy specifies allowed parent/child asset relationships.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssetHierarchies() {
        return software.amazon.jsii.Kernel.get(this, "assetHierarchies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of asset hierarchies that each contain a `hierarchyLogicalId` .
     * <p>
     * A hierarchy specifies allowed parent/child asset relationships.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetHierarchies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "assetHierarchies", value);
    }

    /**
     * A list of asset hierarchies that each contain a `hierarchyLogicalId` .
     * <p>
     * A hierarchy specifies allowed parent/child asset relationships.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetHierarchies(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "assetHierarchies", value);
    }

    /**
     * The list of asset properties for the asset.
     * <p>
     * This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssetProperties() {
        return software.amazon.jsii.Kernel.get(this, "assetProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The list of asset properties for the asset.
     * <p>
     * This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "assetProperties", value);
    }

    /**
     * The list of asset properties for the asset.
     * <p>
     * This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetProperties(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "assetProperties", value);
    }
    /**
     * Describes an asset hierarchy that contains a `childAssetId` and `hierarchyLogicalId` .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * AssetHierarchyProperty assetHierarchyProperty = AssetHierarchyProperty.builder()
     *         .childAssetId("childAssetId")
     *         .logicalId("logicalId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAsset.AssetHierarchyProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetHierarchyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetHierarchyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Id of the child asset.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getChildAssetId();

        /**
         * The `LogicalID` of the hierarchy. This ID is a `hierarchyLogicalId` .
         * <p>
         * The maximum length is 256 characters, with the pattern <code>[^\ u0000-\ u001F\ u007F]+</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogicalId();

        /**
         * @return a {@link Builder} of {@link AssetHierarchyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetHierarchyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetHierarchyProperty> {
            java.lang.String childAssetId;
            java.lang.String logicalId;

            /**
             * Sets the value of {@link AssetHierarchyProperty#getChildAssetId}
             * @param childAssetId The Id of the child asset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder childAssetId(java.lang.String childAssetId) {
                this.childAssetId = childAssetId;
                return this;
            }

            /**
             * Sets the value of {@link AssetHierarchyProperty#getLogicalId}
             * @param logicalId The `LogicalID` of the hierarchy. This ID is a `hierarchyLogicalId` . This parameter is required.
             *                  The maximum length is 256 characters, with the pattern <code>[^\ u0000-\ u001F\ u007F]+</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logicalId(java.lang.String logicalId) {
                this.logicalId = logicalId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetHierarchyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetHierarchyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetHierarchyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetHierarchyProperty {
            private final java.lang.String childAssetId;
            private final java.lang.String logicalId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.childAssetId = software.amazon.jsii.Kernel.get(this, "childAssetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logicalId = software.amazon.jsii.Kernel.get(this, "logicalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.childAssetId = java.util.Objects.requireNonNull(builder.childAssetId, "childAssetId is required");
                this.logicalId = java.util.Objects.requireNonNull(builder.logicalId, "logicalId is required");
            }

            @Override
            public final java.lang.String getChildAssetId() {
                return this.childAssetId;
            }

            @Override
            public final java.lang.String getLogicalId() {
                return this.logicalId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("childAssetId", om.valueToTree(this.getChildAssetId()));
                data.set("logicalId", om.valueToTree(this.getLogicalId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAsset.AssetHierarchyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetHierarchyProperty.Jsii$Proxy that = (AssetHierarchyProperty.Jsii$Proxy) o;

                if (!childAssetId.equals(that.childAssetId)) return false;
                return this.logicalId.equals(that.logicalId);
            }

            @Override
            public final int hashCode() {
                int result = this.childAssetId.hashCode();
                result = 31 * result + (this.logicalId.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains asset property information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * AssetPropertyProperty assetPropertyProperty = AssetPropertyProperty.builder()
     *         .logicalId("logicalId")
     *         // the properties below are optional
     *         .alias("alias")
     *         .notificationState("notificationState")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAsset.AssetPropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetPropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetPropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The `LogicalID` of the asset property.
         * <p>
         * The maximum length is 256 characters, with the pattern <code>[^\ u0000-\ u001F\ u007F]+</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogicalId();

        /**
         * The property alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature` ).
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * The property alias must have 1-1000 characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlias() {
            return null;
        }

        /**
         * The MQTT notification state (enabled or disabled) for this asset property.
         * <p>
         * When the notification state is enabled, AWS IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * If you omit this parameter, the notification state is set to <code>DISABLED</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNotificationState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetPropertyProperty> {
            java.lang.String logicalId;
            java.lang.String alias;
            java.lang.String notificationState;

            /**
             * Sets the value of {@link AssetPropertyProperty#getLogicalId}
             * @param logicalId The `LogicalID` of the asset property. This parameter is required.
             *                  The maximum length is 256 characters, with the pattern <code>[^\ u0000-\ u001F\ u007F]+</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logicalId(java.lang.String logicalId) {
                this.logicalId = logicalId;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyProperty#getAlias}
             * @param alias The property alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature` ).
             *              For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <em>AWS IoT SiteWise User Guide</em> .
             *              <p>
             *              The property alias must have 1-1000 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyProperty#getNotificationState}
             * @param notificationState The MQTT notification state (enabled or disabled) for this asset property.
             *                          When the notification state is enabled, AWS IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <em>AWS IoT SiteWise User Guide</em> .
             *                          <p>
             *                          If you omit this parameter, the notification state is set to <code>DISABLED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationState(java.lang.String notificationState) {
                this.notificationState = notificationState;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetPropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetPropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetPropertyProperty {
            private final java.lang.String logicalId;
            private final java.lang.String alias;
            private final java.lang.String notificationState;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logicalId = software.amazon.jsii.Kernel.get(this, "logicalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.notificationState = software.amazon.jsii.Kernel.get(this, "notificationState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logicalId = java.util.Objects.requireNonNull(builder.logicalId, "logicalId is required");
                this.alias = builder.alias;
                this.notificationState = builder.notificationState;
            }

            @Override
            public final java.lang.String getLogicalId() {
                return this.logicalId;
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.String getNotificationState() {
                return this.notificationState;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logicalId", om.valueToTree(this.getLogicalId()));
                if (this.getAlias() != null) {
                    data.set("alias", om.valueToTree(this.getAlias()));
                }
                if (this.getNotificationState() != null) {
                    data.set("notificationState", om.valueToTree(this.getNotificationState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAsset.AssetPropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetPropertyProperty.Jsii$Proxy that = (AssetPropertyProperty.Jsii$Proxy) o;

                if (!logicalId.equals(that.logicalId)) return false;
                if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) return false;
                return this.notificationState != null ? this.notificationState.equals(that.notificationState) : that.notificationState == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logicalId.hashCode();
                result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
                result = 31 * result + (this.notificationState != null ? this.notificationState.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotsitewise.CfnAsset}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotsitewise.CfnAsset> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotsitewise.CfnAssetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotsitewise.CfnAssetProps.Builder();
        }

        /**
         * The ID of the asset model from which to create the asset.
         * <p>
         * @return {@code this}
         * @param assetModelId The ID of the asset model from which to create the asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelId(final java.lang.String assetModelId) {
            this.props.assetModelId(assetModelId);
            return this;
        }

        /**
         * A unique, friendly name for the asset.
         * <p>
         * The maximum length is 256 characters with the pattern <code>[^\ u0000-\ u001F\ u007F]+</code> .
         * <p>
         * @return {@code this}
         * @param assetName A unique, friendly name for the asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetName(final java.lang.String assetName) {
            this.props.assetName(assetName);
            return this;
        }

        /**
         * A list of asset hierarchies that each contain a `hierarchyLogicalId` .
         * <p>
         * A hierarchy specifies allowed parent/child asset relationships.
         * <p>
         * @return {@code this}
         * @param assetHierarchies A list of asset hierarchies that each contain a `hierarchyLogicalId` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHierarchies(final software.amazon.awscdk.IResolvable assetHierarchies) {
            this.props.assetHierarchies(assetHierarchies);
            return this;
        }
        /**
         * A list of asset hierarchies that each contain a `hierarchyLogicalId` .
         * <p>
         * A hierarchy specifies allowed parent/child asset relationships.
         * <p>
         * @return {@code this}
         * @param assetHierarchies A list of asset hierarchies that each contain a `hierarchyLogicalId` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHierarchies(final java.util.List<? extends java.lang.Object> assetHierarchies) {
            this.props.assetHierarchies(assetHierarchies);
            return this;
        }

        /**
         * The list of asset properties for the asset.
         * <p>
         * This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.
         * <p>
         * @return {@code this}
         * @param assetProperties The list of asset properties for the asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetProperties(final software.amazon.awscdk.IResolvable assetProperties) {
            this.props.assetProperties(assetProperties);
            return this;
        }
        /**
         * The list of asset properties for the asset.
         * <p>
         * This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.
         * <p>
         * @return {@code this}
         * @param assetProperties The list of asset properties for the asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetProperties(final java.util.List<? extends java.lang.Object> assetProperties) {
            this.props.assetProperties(assetProperties);
            return this;
        }

        /**
         * A list of key-value pairs that contain metadata for the asset.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @return {@code this}
         * @param tags A list of key-value pairs that contain metadata for the asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iotsitewise.CfnAsset}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotsitewise.CfnAsset build() {
            return new software.amazon.awscdk.services.iotsitewise.CfnAsset(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
