package software.amazon.awscdk.services.events.targets;

/**
 * Customize the Lambda Event Target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function fn = Function.Builder.create(this, "MyFunc")
 *         .runtime(Runtime.NODEJS_12_X)
 *         .handler("index.handler")
 *         .code(Code.fromInline("exports.handler = handler.toString()"))
 *         .build();
 * Rule rule = Rule.Builder.create(this, "rule")
 *         .eventPattern(EventPattern.builder()
 *                 .source(List.of("aws.ec2"))
 *                 .build())
 *         .build();
 * Queue queue = new Queue(this, "Queue");
 * rule.addTarget(LambdaFunction.Builder.create(fn)
 *         .deadLetterQueue(queue) // Optional: add a dead letter queue
 *         .maxEventAge(Duration.hours(2)) // Optional: set the maxEventAge retry policy
 *         .retryAttempts(2)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:10.157Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.LambdaFunctionProps")
@software.amazon.jsii.Jsii.Proxy(LambdaFunctionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaFunctionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.events.targets.TargetBaseProps {

    /**
     * The event to send to the Lambda.
     * <p>
     * This will be the payload sent to the Lambda Function.
     * <p>
     * Default: the entire EventBridge event
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.RuleTargetInput getEvent() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LambdaFunctionProps> {
        software.amazon.awscdk.services.events.RuleTargetInput event;
        software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        software.amazon.awscdk.Duration maxEventAge;
        java.lang.Number retryAttempts;

        /**
         * Sets the value of {@link LambdaFunctionProps#getEvent}
         * @param event The event to send to the Lambda.
         *              This will be the payload sent to the Lambda Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder event(software.amazon.awscdk.services.events.RuleTargetInput event) {
            this.event = event;
            return this;
        }

        /**
         * Sets the value of {@link LambdaFunctionProps#getDeadLetterQueue}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the [considerations for using a dead-letter queue](https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations).
         *                        The events not successfully delivered are automatically retried for a specified period of time,
         *                        depending on the retry policy of the target.
         *                        If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link LambdaFunctionProps#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing.
         *                    Minimum value of 60.
         *                    Maximum value of 86400.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link LambdaFunctionProps#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Minimum value of 0.
         *                      Maximum value of 185.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaFunctionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LambdaFunctionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LambdaFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaFunctionProps {
        private final software.amazon.awscdk.services.events.RuleTargetInput event;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final software.amazon.awscdk.Duration maxEventAge;
        private final java.lang.Number retryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.event = software.amazon.jsii.Kernel.get(this, "event", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInput.class));
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.maxEventAge = software.amazon.jsii.Kernel.get(this, "maxEventAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.event = builder.event;
            this.deadLetterQueue = builder.deadLetterQueue;
            this.maxEventAge = builder.maxEventAge;
            this.retryAttempts = builder.retryAttempts;
        }

        @Override
        public final software.amazon.awscdk.services.events.RuleTargetInput getEvent() {
            return this.event;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEvent() != null) {
                data.set("event", om.valueToTree(this.getEvent()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events_targets.LambdaFunctionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaFunctionProps.Jsii$Proxy that = (LambdaFunctionProps.Jsii$Proxy) o;

            if (this.event != null ? !this.event.equals(that.event) : that.event != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            return this.retryAttempts != null ? this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts == null;
        }

        @Override
        public final int hashCode() {
            int result = this.event != null ? this.event.hashCode() : 0;
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.maxEventAge != null ? this.maxEventAge.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            return result;
        }
    }
}
