package software.amazon.awscdk.services.events.targets;

/**
 * Use an API Gateway REST APIs as a target for Amazon EventBridge rules.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigateway.*;
 * import software.amazon.awscdk.services.lambda.*;
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.minutes(1)))
 *         .build();
 * Function fn = Function.Builder.create(this, "MyFunc")
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_12_X)
 *         .code(Code.fromInline("exports.handler = e =&gt; {}"))
 *         .build();
 * LambdaRestApi restApi = LambdaRestApi.Builder.create(this, "MyRestAPI").handler(fn).build();
 * Queue dlq = new Queue(this, "DeadLetterQueue");
 * rule.addTarget(
 * ApiGateway.Builder.create(restApi)
 *         .path("/*&#47;test")
 *         .method("GET")
 *         .stage("prod")
 *         .pathParameterValues(List.of("path-value"))
 *         .headerParameters(Map.of(
 *                 "Header1", "header1"))
 *         .queryStringParameters(Map.of(
 *                 "QueryParam1", "query-param-1"))
 *         .deadLetterQueue(dlq)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:10.137Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.ApiGateway")
public class ApiGateway extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected ApiGateway(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApiGateway(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param restApi This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApiGateway(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RestApi restApi, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.targets.ApiGatewayProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(restApi, "restApi is required"), props });
    }

    /**
     * @param restApi This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApiGateway(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RestApi restApi) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(restApi, "restApi is required") });
    }

    /**
     * Returns a RuleTarget that can be used to trigger this API Gateway REST APIs as a result from an EventBridge event.
     * <p>
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sqs-permissions
     * @param rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule, final @org.jetbrains.annotations.Nullable java.lang.String _id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required"), _id });
    }

    /**
     * Returns a RuleTarget that can be used to trigger this API Gateway REST APIs as a result from an EventBridge event.
     * <p>
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sqs-permissions
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RestApi getRestApi() {
        return software.amazon.jsii.Kernel.get(this, "restApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.RestApi.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.ApiGateway}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.ApiGateway> {
        /**
         * @return a new instance of {@link Builder}.
         * @param restApi This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.apigateway.RestApi restApi) {
            return new Builder(restApi);
        }

        private final software.amazon.awscdk.services.apigateway.RestApi restApi;
        private software.amazon.awscdk.services.events.targets.ApiGatewayProps.Builder props;

        private Builder(final software.amazon.awscdk.services.apigateway.RestApi restApi) {
            this.restApi = restApi;
        }

        /**
         * The SQS queue to be used as deadLetterQueue. Check out the [considerations for using a dead-letter queue](https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations).
         * <p>
         * The events not successfully delivered are automatically retried for a specified period of time,
         * depending on the retry policy of the target.
         * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * <p>
         * Default: - no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the [considerations for using a dead-letter queue](https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum value of 60.
         * Maximum value of 86400.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum value of 0.
         * Maximum value of 185.
         * <p>
         * Default: 185
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        /**
         * The role to assume before invoking the target (i.e., the pipeline) when the given rule is triggered.
         * <p>
         * Default: - a new role will be created
         * <p>
         * @return {@code this}
         * @param eventRole The role to assume before invoking the target (i.e., the pipeline) when the given rule is triggered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRole(final software.amazon.awscdk.services.iam.IRole eventRole) {
            this.props().eventRole(eventRole);
            return this;
        }

        /**
         * The headers to be set when requesting API.
         * <p>
         * Default: no header parameters
         * <p>
         * @return {@code this}
         * @param headerParameters The headers to be set when requesting API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headerParameters(final java.util.Map<java.lang.String, java.lang.String> headerParameters) {
            this.props().headerParameters(headerParameters);
            return this;
        }

        /**
         * The method for api resource invoked by the rule.
         * <p>
         * Default: '*' that treated as ANY
         * <p>
         * @return {@code this}
         * @param method The method for api resource invoked by the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(final java.lang.String method) {
            this.props().method(method);
            return this;
        }

        /**
         * The api resource invoked by the rule.
         * <p>
         * We can use wildcards('*') to specify the path. In that case,
         * an equal number of real values must be specified for pathParameterValues.
         * <p>
         * Default: '/'
         * <p>
         * @return {@code this}
         * @param path The api resource invoked by the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(final java.lang.String path) {
            this.props().path(path);
            return this;
        }

        /**
         * The path parameter values to be used to populate to wildcards("*") of requesting api path.
         * <p>
         * Default: no path parameters
         * <p>
         * @return {@code this}
         * @param pathParameterValues The path parameter values to be used to populate to wildcards("*") of requesting api path. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathParameterValues(final java.util.List<java.lang.String> pathParameterValues) {
            this.props().pathParameterValues(pathParameterValues);
            return this;
        }

        /**
         * This will be the post request body send to the API.
         * <p>
         * Default: the entire EventBridge event
         * <p>
         * @return {@code this}
         * @param postBody This will be the post request body send to the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postBody(final software.amazon.awscdk.services.events.RuleTargetInput postBody) {
            this.props().postBody(postBody);
            return this;
        }

        /**
         * The query parameters to be set when requesting API.
         * <p>
         * Default: no querystring parameters
         * <p>
         * @return {@code this}
         * @param queryStringParameters The query parameters to be set when requesting API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryStringParameters(final java.util.Map<java.lang.String, java.lang.String> queryStringParameters) {
            this.props().queryStringParameters(queryStringParameters);
            return this;
        }

        /**
         * The deploy stage of api gateway invoked by the rule.
         * <p>
         * Default: the value of deploymentStage.stageName of target api gateway.
         * <p>
         * @return {@code this}
         * @param stage The deploy stage of api gateway invoked by the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stage(final java.lang.String stage) {
            this.props().stage(stage);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.events.targets.ApiGateway}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.targets.ApiGateway build() {
            return new software.amazon.awscdk.services.events.targets.ApiGateway(
                this.restApi,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.ApiGatewayProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.targets.ApiGatewayProps.Builder();
            }
            return this.props;
        }
    }
}
