package software.amazon.awscdk.services.elasticsearch;

/**
 * Properties for defining a `CfnDomain`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticsearch.*;
 * Object accessPolicies;
 * CfnDomainProps cfnDomainProps = CfnDomainProps.builder()
 *         .accessPolicies(accessPolicies)
 *         .advancedOptions(Map.of(
 *                 "advancedOptionsKey", "advancedOptions"))
 *         .advancedSecurityOptions(AdvancedSecurityOptionsInputProperty.builder()
 *                 .enabled(false)
 *                 .internalUserDatabaseEnabled(false)
 *                 .masterUserOptions(MasterUserOptionsProperty.builder()
 *                         .masterUserArn("masterUserArn")
 *                         .masterUserName("masterUserName")
 *                         .masterUserPassword("masterUserPassword")
 *                         .build())
 *                 .build())
 *         .cognitoOptions(CognitoOptionsProperty.builder()
 *                 .enabled(false)
 *                 .identityPoolId("identityPoolId")
 *                 .roleArn("roleArn")
 *                 .userPoolId("userPoolId")
 *                 .build())
 *         .domainEndpointOptions(DomainEndpointOptionsProperty.builder()
 *                 .customEndpoint("customEndpoint")
 *                 .customEndpointCertificateArn("customEndpointCertificateArn")
 *                 .customEndpointEnabled(false)
 *                 .enforceHttps(false)
 *                 .tlsSecurityPolicy("tlsSecurityPolicy")
 *                 .build())
 *         .domainName("domainName")
 *         .ebsOptions(EBSOptionsProperty.builder()
 *                 .ebsEnabled(false)
 *                 .iops(123)
 *                 .volumeSize(123)
 *                 .volumeType("volumeType")
 *                 .build())
 *         .elasticsearchClusterConfig(ElasticsearchClusterConfigProperty.builder()
 *                 .coldStorageOptions(ColdStorageOptionsProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .dedicatedMasterCount(123)
 *                 .dedicatedMasterEnabled(false)
 *                 .dedicatedMasterType("dedicatedMasterType")
 *                 .instanceCount(123)
 *                 .instanceType("instanceType")
 *                 .warmCount(123)
 *                 .warmEnabled(false)
 *                 .warmType("warmType")
 *                 .zoneAwarenessConfig(ZoneAwarenessConfigProperty.builder()
 *                         .availabilityZoneCount(123)
 *                         .build())
 *                 .zoneAwarenessEnabled(false)
 *                 .build())
 *         .elasticsearchVersion("elasticsearchVersion")
 *         .encryptionAtRestOptions(EncryptionAtRestOptionsProperty.builder()
 *                 .enabled(false)
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .logPublishingOptions(Map.of(
 *                 "logPublishingOptionsKey", LogPublishingOptionProperty.builder()
 *                         .cloudWatchLogsLogGroupArn("cloudWatchLogsLogGroupArn")
 *                         .enabled(false)
 *                         .build()))
 *         .nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .snapshotOptions(SnapshotOptionsProperty.builder()
 *                 .automatedSnapshotStartHour(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcOptions(VPCOptionsProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:10.019Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomainProps")
@software.amazon.jsii.Jsii.Proxy(CfnDomainProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDomainProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An AWS Identity and Access Management ( IAM ) policy document that specifies who can access the OpenSearch Service domain and their permissions.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-creating">Configuring access policies</a> in the <em>Amazon OpenSearch Service Developer Guid</em> e.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessPolicies() {
        return null;
    }

    /**
     * Additional options to specify for the OpenSearch Service domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">Advanced cluster parameters</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedOptions() {
        return null;
    }

    /**
     * Specifies options for fine-grained access control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedSecurityOptions() {
        return null;
    }

    /**
     * Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCognitoOptions() {
        return null;
    }

    /**
     * Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDomainEndpointOptions() {
        return null;
    }

    /**
     * A name for the OpenSearch Service domain.
     * <p>
     * For valid values, see the <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-datatypes-domainname">DomainName</a> data type in the <em>Amazon OpenSearch Service Developer Guide</em> . If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the domain name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return null;
    }

    /**
     * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptions() {
        return null;
    }

    /**
     * ElasticsearchClusterConfig is a property of the AWS::Elasticsearch::Domain resource that configures the cluster of an Amazon OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchClusterConfig() {
        return null;
    }

    /**
     * The version of Elasticsearch to use, such as 2.3. If not specified, 1.5 is used as the default. For information about the versions that OpenSearch Service supports, see [Supported versions of OpenSearch and Elasticsearch](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/what-is.html#choosing-version) in the *Amazon OpenSearch Service Developer Guide* .
     * <p>
     * If you set the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-upgradeopensearchdomain">EnableVersionUpgrade</a> update policy to <code>true</code> , you can update <code>ElasticsearchVersion</code> without interruption. When <code>EnableVersionUpgrade</code> is set to <code>false</code> , or is not specified, updating <code>ElasticsearchVersion</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getElasticsearchVersion() {
        return null;
    }

    /**
     * Whether the domain should encrypt data at rest, and if so, the AWS Key Management Service key to use.
     * <p>
     * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html">Encryption of data at rest for Amazon OpenSearch Service</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionAtRestOptions() {
        return null;
    }

    /**
     * An object with one or more of the following keys: `SEARCH_SLOW_LOGS` , `ES_APPLICATION_LOGS` , `INDEX_SLOW_LOGS` , `AUDIT_LOGS` , depending on the types of logs you want to publish.
     * <p>
     * Each key needs a valid <code>LogPublishingOption</code> value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogPublishingOptions() {
        return null;
    }

    /**
     * Specifies whether node-to-node encryption is enabled.
     * <p>
     * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ntn.html">Node-to-node encryption for Amazon OpenSearch Service</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNodeToNodeEncryptionOptions() {
        return null;
    }

    /**
     * *DEPRECATED* .
     * <p>
     * The automated snapshot configuration for the OpenSearch Service domain indices.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSnapshotOptions() {
        return null;
    }

    /**
     * An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains within a VPC</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDomainProps> {
        java.lang.Object accessPolicies;
        java.lang.Object advancedOptions;
        java.lang.Object advancedSecurityOptions;
        java.lang.Object cognitoOptions;
        java.lang.Object domainEndpointOptions;
        java.lang.String domainName;
        java.lang.Object ebsOptions;
        java.lang.Object elasticsearchClusterConfig;
        java.lang.String elasticsearchVersion;
        java.lang.Object encryptionAtRestOptions;
        java.lang.Object logPublishingOptions;
        java.lang.Object nodeToNodeEncryptionOptions;
        java.lang.Object snapshotOptions;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object vpcOptions;

        /**
         * Sets the value of {@link CfnDomainProps#getAccessPolicies}
         * @param accessPolicies An AWS Identity and Access Management ( IAM ) policy document that specifies who can access the OpenSearch Service domain and their permissions.
         *                       For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-creating">Configuring access policies</a> in the <em>Amazon OpenSearch Service Developer Guid</em> e.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicies(java.lang.Object accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getAdvancedOptions}
         * @param advancedOptions Additional options to specify for the OpenSearch Service domain.
         *                        For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">Advanced cluster parameters</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedOptions(software.amazon.awscdk.IResolvable advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getAdvancedOptions}
         * @param advancedOptions Additional options to specify for the OpenSearch Service domain.
         *                        For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">Advanced cluster parameters</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedOptions(java.util.Map<java.lang.String, java.lang.String> advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getAdvancedSecurityOptions}
         * @param advancedSecurityOptions Specifies options for fine-grained access control.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedSecurityOptions(software.amazon.awscdk.services.elasticsearch.CfnDomain.AdvancedSecurityOptionsInputProperty advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getAdvancedSecurityOptions}
         * @param advancedSecurityOptions Specifies options for fine-grained access control.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedSecurityOptions(software.amazon.awscdk.IResolvable advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getCognitoOptions}
         * @param cognitoOptions Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoOptions(software.amazon.awscdk.services.elasticsearch.CfnDomain.CognitoOptionsProperty cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getCognitoOptions}
         * @param cognitoOptions Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoOptions(software.amazon.awscdk.IResolvable cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainEndpointOptions}
         * @param domainEndpointOptions Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainEndpointOptions(software.amazon.awscdk.services.elasticsearch.CfnDomain.DomainEndpointOptionsProperty domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainEndpointOptions}
         * @param domainEndpointOptions Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainEndpointOptions(software.amazon.awscdk.IResolvable domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainName}
         * @param domainName A name for the OpenSearch Service domain.
         *                   For valid values, see the <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-datatypes-domainname">DomainName</a> data type in the <em>Amazon OpenSearch Service Developer Guide</em> . If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the domain name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getEbsOptions}
         * @param ebsOptions The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
         *                   For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptions(software.amazon.awscdk.services.elasticsearch.CfnDomain.EBSOptionsProperty ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getEbsOptions}
         * @param ebsOptions The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
         *                   For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptions(software.amazon.awscdk.IResolvable ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getElasticsearchClusterConfig}
         * @param elasticsearchClusterConfig ElasticsearchClusterConfig is a property of the AWS::Elasticsearch::Domain resource that configures the cluster of an Amazon OpenSearch Service domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchClusterConfig(software.amazon.awscdk.services.elasticsearch.CfnDomain.ElasticsearchClusterConfigProperty elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getElasticsearchClusterConfig}
         * @param elasticsearchClusterConfig ElasticsearchClusterConfig is a property of the AWS::Elasticsearch::Domain resource that configures the cluster of an Amazon OpenSearch Service domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchClusterConfig(software.amazon.awscdk.IResolvable elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getElasticsearchVersion}
         * @param elasticsearchVersion The version of Elasticsearch to use, such as 2.3. If not specified, 1.5 is used as the default. For information about the versions that OpenSearch Service supports, see [Supported versions of OpenSearch and Elasticsearch](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/what-is.html#choosing-version) in the *Amazon OpenSearch Service Developer Guide* .
         *                             If you set the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-upgradeopensearchdomain">EnableVersionUpgrade</a> update policy to <code>true</code> , you can update <code>ElasticsearchVersion</code> without interruption. When <code>EnableVersionUpgrade</code> is set to <code>false</code> , or is not specified, updating <code>ElasticsearchVersion</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchVersion(java.lang.String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getEncryptionAtRestOptions}
         * @param encryptionAtRestOptions Whether the domain should encrypt data at rest, and if so, the AWS Key Management Service key to use.
         *                                See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html">Encryption of data at rest for Amazon OpenSearch Service</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRestOptions(software.amazon.awscdk.services.elasticsearch.CfnDomain.EncryptionAtRestOptionsProperty encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getEncryptionAtRestOptions}
         * @param encryptionAtRestOptions Whether the domain should encrypt data at rest, and if so, the AWS Key Management Service key to use.
         *                                See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html">Encryption of data at rest for Amazon OpenSearch Service</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRestOptions(software.amazon.awscdk.IResolvable encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getLogPublishingOptions}
         * @param logPublishingOptions An object with one or more of the following keys: `SEARCH_SLOW_LOGS` , `ES_APPLICATION_LOGS` , `INDEX_SLOW_LOGS` , `AUDIT_LOGS` , depending on the types of logs you want to publish.
         *                             Each key needs a valid <code>LogPublishingOption</code> value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPublishingOptions(software.amazon.awscdk.IResolvable logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getLogPublishingOptions}
         * @param logPublishingOptions An object with one or more of the following keys: `SEARCH_SLOW_LOGS` , `ES_APPLICATION_LOGS` , `INDEX_SLOW_LOGS` , `AUDIT_LOGS` , depending on the types of logs you want to publish.
         *                             Each key needs a valid <code>LogPublishingOption</code> value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPublishingOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getNodeToNodeEncryptionOptions}
         * @param nodeToNodeEncryptionOptions Specifies whether node-to-node encryption is enabled.
         *                                    See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ntn.html">Node-to-node encryption for Amazon OpenSearch Service</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeToNodeEncryptionOptions(software.amazon.awscdk.services.elasticsearch.CfnDomain.NodeToNodeEncryptionOptionsProperty nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getNodeToNodeEncryptionOptions}
         * @param nodeToNodeEncryptionOptions Specifies whether node-to-node encryption is enabled.
         *                                    See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ntn.html">Node-to-node encryption for Amazon OpenSearch Service</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeToNodeEncryptionOptions(software.amazon.awscdk.IResolvable nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getSnapshotOptions}
         * @param snapshotOptions *DEPRECATED* .
         *                        The automated snapshot configuration for the OpenSearch Service domain indices.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotOptions(software.amazon.awscdk.services.elasticsearch.CfnDomain.SnapshotOptionsProperty snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getSnapshotOptions}
         * @param snapshotOptions *DEPRECATED* .
         *                        The automated snapshot configuration for the OpenSearch Service domain indices.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotOptions(software.amazon.awscdk.IResolvable snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getTags}
         * @param tags An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Service domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getVpcOptions}
         * @param vpcOptions The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
         *                   For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains within a VPC</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOptions(software.amazon.awscdk.services.elasticsearch.CfnDomain.VPCOptionsProperty vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getVpcOptions}
         * @param vpcOptions The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
         *                   For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains within a VPC</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOptions(software.amazon.awscdk.IResolvable vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDomainProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDomainProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDomainProps {
        private final java.lang.Object accessPolicies;
        private final java.lang.Object advancedOptions;
        private final java.lang.Object advancedSecurityOptions;
        private final java.lang.Object cognitoOptions;
        private final java.lang.Object domainEndpointOptions;
        private final java.lang.String domainName;
        private final java.lang.Object ebsOptions;
        private final java.lang.Object elasticsearchClusterConfig;
        private final java.lang.String elasticsearchVersion;
        private final java.lang.Object encryptionAtRestOptions;
        private final java.lang.Object logPublishingOptions;
        private final java.lang.Object nodeToNodeEncryptionOptions;
        private final java.lang.Object snapshotOptions;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object vpcOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessPolicies = software.amazon.jsii.Kernel.get(this, "accessPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.advancedOptions = software.amazon.jsii.Kernel.get(this, "advancedOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.advancedSecurityOptions = software.amazon.jsii.Kernel.get(this, "advancedSecurityOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cognitoOptions = software.amazon.jsii.Kernel.get(this, "cognitoOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domainEndpointOptions = software.amazon.jsii.Kernel.get(this, "domainEndpointOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ebsOptions = software.amazon.jsii.Kernel.get(this, "ebsOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.elasticsearchClusterConfig = software.amazon.jsii.Kernel.get(this, "elasticsearchClusterConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.elasticsearchVersion = software.amazon.jsii.Kernel.get(this, "elasticsearchVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionAtRestOptions = software.amazon.jsii.Kernel.get(this, "encryptionAtRestOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logPublishingOptions = software.amazon.jsii.Kernel.get(this, "logPublishingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.nodeToNodeEncryptionOptions = software.amazon.jsii.Kernel.get(this, "nodeToNodeEncryptionOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.snapshotOptions = software.amazon.jsii.Kernel.get(this, "snapshotOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vpcOptions = software.amazon.jsii.Kernel.get(this, "vpcOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessPolicies = builder.accessPolicies;
            this.advancedOptions = builder.advancedOptions;
            this.advancedSecurityOptions = builder.advancedSecurityOptions;
            this.cognitoOptions = builder.cognitoOptions;
            this.domainEndpointOptions = builder.domainEndpointOptions;
            this.domainName = builder.domainName;
            this.ebsOptions = builder.ebsOptions;
            this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
            this.elasticsearchVersion = builder.elasticsearchVersion;
            this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
            this.logPublishingOptions = builder.logPublishingOptions;
            this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
            this.snapshotOptions = builder.snapshotOptions;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vpcOptions = builder.vpcOptions;
        }

        @Override
        public final java.lang.Object getAccessPolicies() {
            return this.accessPolicies;
        }

        @Override
        public final java.lang.Object getAdvancedOptions() {
            return this.advancedOptions;
        }

        @Override
        public final java.lang.Object getAdvancedSecurityOptions() {
            return this.advancedSecurityOptions;
        }

        @Override
        public final java.lang.Object getCognitoOptions() {
            return this.cognitoOptions;
        }

        @Override
        public final java.lang.Object getDomainEndpointOptions() {
            return this.domainEndpointOptions;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.Object getEbsOptions() {
            return this.ebsOptions;
        }

        @Override
        public final java.lang.Object getElasticsearchClusterConfig() {
            return this.elasticsearchClusterConfig;
        }

        @Override
        public final java.lang.String getElasticsearchVersion() {
            return this.elasticsearchVersion;
        }

        @Override
        public final java.lang.Object getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions;
        }

        @Override
        public final java.lang.Object getLogPublishingOptions() {
            return this.logPublishingOptions;
        }

        @Override
        public final java.lang.Object getNodeToNodeEncryptionOptions() {
            return this.nodeToNodeEncryptionOptions;
        }

        @Override
        public final java.lang.Object getSnapshotOptions() {
            return this.snapshotOptions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVpcOptions() {
            return this.vpcOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccessPolicies() != null) {
                data.set("accessPolicies", om.valueToTree(this.getAccessPolicies()));
            }
            if (this.getAdvancedOptions() != null) {
                data.set("advancedOptions", om.valueToTree(this.getAdvancedOptions()));
            }
            if (this.getAdvancedSecurityOptions() != null) {
                data.set("advancedSecurityOptions", om.valueToTree(this.getAdvancedSecurityOptions()));
            }
            if (this.getCognitoOptions() != null) {
                data.set("cognitoOptions", om.valueToTree(this.getCognitoOptions()));
            }
            if (this.getDomainEndpointOptions() != null) {
                data.set("domainEndpointOptions", om.valueToTree(this.getDomainEndpointOptions()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getEbsOptions() != null) {
                data.set("ebsOptions", om.valueToTree(this.getEbsOptions()));
            }
            if (this.getElasticsearchClusterConfig() != null) {
                data.set("elasticsearchClusterConfig", om.valueToTree(this.getElasticsearchClusterConfig()));
            }
            if (this.getElasticsearchVersion() != null) {
                data.set("elasticsearchVersion", om.valueToTree(this.getElasticsearchVersion()));
            }
            if (this.getEncryptionAtRestOptions() != null) {
                data.set("encryptionAtRestOptions", om.valueToTree(this.getEncryptionAtRestOptions()));
            }
            if (this.getLogPublishingOptions() != null) {
                data.set("logPublishingOptions", om.valueToTree(this.getLogPublishingOptions()));
            }
            if (this.getNodeToNodeEncryptionOptions() != null) {
                data.set("nodeToNodeEncryptionOptions", om.valueToTree(this.getNodeToNodeEncryptionOptions()));
            }
            if (this.getSnapshotOptions() != null) {
                data.set("snapshotOptions", om.valueToTree(this.getSnapshotOptions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcOptions() != null) {
                data.set("vpcOptions", om.valueToTree(this.getVpcOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CfnDomainProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDomainProps.Jsii$Proxy that = (CfnDomainProps.Jsii$Proxy) o;

            if (this.accessPolicies != null ? !this.accessPolicies.equals(that.accessPolicies) : that.accessPolicies != null) return false;
            if (this.advancedOptions != null ? !this.advancedOptions.equals(that.advancedOptions) : that.advancedOptions != null) return false;
            if (this.advancedSecurityOptions != null ? !this.advancedSecurityOptions.equals(that.advancedSecurityOptions) : that.advancedSecurityOptions != null) return false;
            if (this.cognitoOptions != null ? !this.cognitoOptions.equals(that.cognitoOptions) : that.cognitoOptions != null) return false;
            if (this.domainEndpointOptions != null ? !this.domainEndpointOptions.equals(that.domainEndpointOptions) : that.domainEndpointOptions != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.ebsOptions != null ? !this.ebsOptions.equals(that.ebsOptions) : that.ebsOptions != null) return false;
            if (this.elasticsearchClusterConfig != null ? !this.elasticsearchClusterConfig.equals(that.elasticsearchClusterConfig) : that.elasticsearchClusterConfig != null) return false;
            if (this.elasticsearchVersion != null ? !this.elasticsearchVersion.equals(that.elasticsearchVersion) : that.elasticsearchVersion != null) return false;
            if (this.encryptionAtRestOptions != null ? !this.encryptionAtRestOptions.equals(that.encryptionAtRestOptions) : that.encryptionAtRestOptions != null) return false;
            if (this.logPublishingOptions != null ? !this.logPublishingOptions.equals(that.logPublishingOptions) : that.logPublishingOptions != null) return false;
            if (this.nodeToNodeEncryptionOptions != null ? !this.nodeToNodeEncryptionOptions.equals(that.nodeToNodeEncryptionOptions) : that.nodeToNodeEncryptionOptions != null) return false;
            if (this.snapshotOptions != null ? !this.snapshotOptions.equals(that.snapshotOptions) : that.snapshotOptions != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcOptions != null ? this.vpcOptions.equals(that.vpcOptions) : that.vpcOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessPolicies != null ? this.accessPolicies.hashCode() : 0;
            result = 31 * result + (this.advancedOptions != null ? this.advancedOptions.hashCode() : 0);
            result = 31 * result + (this.advancedSecurityOptions != null ? this.advancedSecurityOptions.hashCode() : 0);
            result = 31 * result + (this.cognitoOptions != null ? this.cognitoOptions.hashCode() : 0);
            result = 31 * result + (this.domainEndpointOptions != null ? this.domainEndpointOptions.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.ebsOptions != null ? this.ebsOptions.hashCode() : 0);
            result = 31 * result + (this.elasticsearchClusterConfig != null ? this.elasticsearchClusterConfig.hashCode() : 0);
            result = 31 * result + (this.elasticsearchVersion != null ? this.elasticsearchVersion.hashCode() : 0);
            result = 31 * result + (this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.hashCode() : 0);
            result = 31 * result + (this.logPublishingOptions != null ? this.logPublishingOptions.hashCode() : 0);
            result = 31 * result + (this.nodeToNodeEncryptionOptions != null ? this.nodeToNodeEncryptionOptions.hashCode() : 0);
            result = 31 * result + (this.snapshotOptions != null ? this.snapshotOptions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcOptions != null ? this.vpcOptions.hashCode() : 0);
            return result;
        }
    }
}
