package software.amazon.awscdk.services.config;

/**
 * A CloudFormation `AWS::Config::ConfigRule`.
 * <p>
 * Specifies an AWS Config rule for evaluating whether your AWS resources comply with your desired configurations.
 * <p>
 * You can use this action for custom AWS Config rules and AWS managed Config rules. A custom AWS Config rule is a rule that you develop and maintain. An AWS managed Config rule is a customizable, predefined rule that AWS Config provides.
 * <p>
 * If you are adding a new custom AWS Config rule, you must first create the AWS Lambda function that the rule invokes to evaluate your resources. When you use the <code>PutConfigRule</code> action to add the rule to AWS Config , you must specify the Amazon Resource Name (ARN) that AWS Lambda assigns to the function. Specify the ARN for the <code>SourceIdentifier</code> key. This key is part of the <code>Source</code> object, which is part of the <code>ConfigRule</code> object.
 * <p>
 * If you are adding an AWS managed Config rule, specify the rule's identifier for the <code>SourceIdentifier</code> key. To reference AWS managed Config rule identifiers, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">About AWS Managed Config Rules</a> .
 * <p>
 * For any new rule that you add, specify the <code>ConfigRuleName</code> in the <code>ConfigRule</code> object. Do not specify the <code>ConfigRuleArn</code> or the <code>ConfigRuleId</code> . These values are generated by AWS Config for new rules.
 * <p>
 * If you are updating a rule that you added previously, you can specify the rule by <code>ConfigRuleName</code> , <code>ConfigRuleId</code> , or <code>ConfigRuleArn</code> in the <code>ConfigRule</code> data type that you use in this request.
 * <p>
 * The maximum number of rules that AWS Config supports is 150.
 * <p>
 * For information about requesting a rule limit increase, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">AWS Config Limits</a> in the <em>AWS General Reference Guide</em> .
 * <p>
 * For more information about developing and using AWS Config rules, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating AWS Resource Configurations with AWS Config</a> in the <em>AWS Config Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * Object inputParameters;
 * CfnConfigRule cfnConfigRule = CfnConfigRule.Builder.create(this, "MyCfnConfigRule")
 *         .source(SourceProperty.builder()
 *                 .owner("owner")
 *                 .sourceIdentifier("sourceIdentifier")
 *                 // the properties below are optional
 *                 .sourceDetails(List.of(SourceDetailProperty.builder()
 *                         .eventSource("eventSource")
 *                         .messageType("messageType")
 *                         // the properties below are optional
 *                         .maximumExecutionFrequency("maximumExecutionFrequency")
 *                         .build()))
 *                 .build())
 *         // the properties below are optional
 *         .configRuleName("configRuleName")
 *         .description("description")
 *         .inputParameters(inputParameters)
 *         .maximumExecutionFrequency("maximumExecutionFrequency")
 *         .scope(ScopeProperty.builder()
 *                 .complianceResourceId("complianceResourceId")
 *                 .complianceResourceTypes(List.of("complianceResourceTypes"))
 *                 .tagKey("tagKey")
 *                 .tagValue("tagValue")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.602Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigRule")
public class CfnConfigRule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConfigRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.CfnConfigRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Config::ConfigRule`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.CfnConfigRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the AWS Config rule, such as `arn:aws:config:us-east-1:123456789012:config-rule/config-rule-a1bzhi` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The compliance status of an AWS Config rule, such as `COMPLIANT` or `NON_COMPLIANT` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrComplianceType() {
        return software.amazon.jsii.Kernel.get(this, "attrComplianceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS Config rule, such as `config-rule-a1bzhi` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfigRuleId() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigRuleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A string, in JSON format, that is passed to the AWS Config rule Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInputParameters() {
        return software.amazon.jsii.Kernel.get(this, "inputParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A string, in JSON format, that is passed to the AWS Config rule Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputParameters(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "inputParameters", java.util.Objects.requireNonNull(value, "inputParameters is required"));
    }

    /**
     * Provides the rule owner ( AWS or customer), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSource() {
        return software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Provides the rule owner ( AWS or customer), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.CfnConfigRule.SourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "source", java.util.Objects.requireNonNull(value, "source is required"));
    }

    /**
     * Provides the rule owner ( AWS or customer), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "source", java.util.Objects.requireNonNull(value, "source is required"));
    }

    /**
     * A name for the AWS Config rule.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the rule name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConfigRuleName() {
        return software.amazon.jsii.Kernel.get(this, "configRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the AWS Config rule.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the rule name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigRuleName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "configRuleName", value);
    }

    /**
     * The description that you provide for the AWS Config rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description that you provide for the AWS Config rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The maximum frequency with which AWS Config runs evaluations for a rule.
     * <p>
     * You can specify a value for <code>MaximumExecutionFrequency</code> when:
     * <p>
     * <ul>
     * <li>You are using an AWS managed rule that is triggered at a periodic frequency.</li>
     * <li>Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html">ConfigSnapshotDeliveryProperties</a> .</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMaximumExecutionFrequency() {
        return software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The maximum frequency with which AWS Config runs evaluations for a rule.
     * <p>
     * You can specify a value for <code>MaximumExecutionFrequency</code> when:
     * <p>
     * <ul>
     * <li>You are using an AWS managed rule that is triggered at a periodic frequency.</li>
     * <li>Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html">ConfigSnapshotDeliveryProperties</a> .</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaximumExecutionFrequency(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "maximumExecutionFrequency", value);
    }

    /**
     * Defines which resources can trigger an evaluation for the rule.
     * <p>
     * The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
     * <p>
     * <blockquote>
     * <p>
     * The scope can be empty.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScope() {
        return software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Defines which resources can trigger an evaluation for the rule.
     * <p>
     * The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
     * <p>
     * <blockquote>
     * <p>
     * The scope can be empty.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScope(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CfnConfigRule.ScopeProperty value) {
        software.amazon.jsii.Kernel.set(this, "scope", value);
    }

    /**
     * Defines which resources can trigger an evaluation for the rule.
     * <p>
     * The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
     * <p>
     * <blockquote>
     * <p>
     * The scope can be empty.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScope(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scope", value);
    }
    /**
     * Defines which resources trigger an evaluation for an AWS Config rule.
     * <p>
     * The scope can include one or more resource types, a combination of a tag key and value, or a combination of one resource type and one resource ID. Specify a scope to constrain which resources trigger an evaluation for a rule. Otherwise, evaluations for the rule are triggered when any resource in your recording group changes in configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * ScopeProperty scopeProperty = ScopeProperty.builder()
     *         .complianceResourceId("complianceResourceId")
     *         .complianceResourceTypes(List.of("complianceResourceTypes"))
     *         .tagKey("tagKey")
     *         .tagValue("tagValue")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigRule.ScopeProperty")
    @software.amazon.jsii.Jsii.Proxy(ScopeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScopeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the only AWS resource that you want to trigger an evaluation for the rule.
         * <p>
         * If you specify a resource ID, you must specify one resource type for <code>ComplianceResourceTypes</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComplianceResourceId() {
            return null;
        }

        /**
         * The resource types of only those AWS resources that you want to trigger an evaluation for the rule.
         * <p>
         * You can only specify one type if you also specify a resource ID for <code>ComplianceResourceId</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getComplianceResourceTypes() {
            return null;
        }

        /**
         * The tag key that is applied to only those AWS resources that you want to trigger an evaluation for the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagKey() {
            return null;
        }

        /**
         * The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule.
         * <p>
         * If you specify a value for <code>TagValue</code> , you must also specify a value for <code>TagKey</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScopeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScopeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScopeProperty> {
            java.lang.String complianceResourceId;
            java.util.List<java.lang.String> complianceResourceTypes;
            java.lang.String tagKey;
            java.lang.String tagValue;

            /**
             * Sets the value of {@link ScopeProperty#getComplianceResourceId}
             * @param complianceResourceId The ID of the only AWS resource that you want to trigger an evaluation for the rule.
             *                             If you specify a resource ID, you must specify one resource type for <code>ComplianceResourceTypes</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceResourceId(java.lang.String complianceResourceId) {
                this.complianceResourceId = complianceResourceId;
                return this;
            }

            /**
             * Sets the value of {@link ScopeProperty#getComplianceResourceTypes}
             * @param complianceResourceTypes The resource types of only those AWS resources that you want to trigger an evaluation for the rule.
             *                                You can only specify one type if you also specify a resource ID for <code>ComplianceResourceId</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceResourceTypes(java.util.List<java.lang.String> complianceResourceTypes) {
                this.complianceResourceTypes = complianceResourceTypes;
                return this;
            }

            /**
             * Sets the value of {@link ScopeProperty#getTagKey}
             * @param tagKey The tag key that is applied to only those AWS resources that you want to trigger an evaluation for the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagKey(java.lang.String tagKey) {
                this.tagKey = tagKey;
                return this;
            }

            /**
             * Sets the value of {@link ScopeProperty#getTagValue}
             * @param tagValue The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule.
             *                 If you specify a value for <code>TagValue</code> , you must also specify a value for <code>TagKey</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagValue(java.lang.String tagValue) {
                this.tagValue = tagValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScopeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScopeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScopeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScopeProperty {
            private final java.lang.String complianceResourceId;
            private final java.util.List<java.lang.String> complianceResourceTypes;
            private final java.lang.String tagKey;
            private final java.lang.String tagValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.complianceResourceId = software.amazon.jsii.Kernel.get(this, "complianceResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.complianceResourceTypes = software.amazon.jsii.Kernel.get(this, "complianceResourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tagKey = software.amazon.jsii.Kernel.get(this, "tagKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagValue = software.amazon.jsii.Kernel.get(this, "tagValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.complianceResourceId = builder.complianceResourceId;
                this.complianceResourceTypes = builder.complianceResourceTypes;
                this.tagKey = builder.tagKey;
                this.tagValue = builder.tagValue;
            }

            @Override
            public final java.lang.String getComplianceResourceId() {
                return this.complianceResourceId;
            }

            @Override
            public final java.util.List<java.lang.String> getComplianceResourceTypes() {
                return this.complianceResourceTypes;
            }

            @Override
            public final java.lang.String getTagKey() {
                return this.tagKey;
            }

            @Override
            public final java.lang.String getTagValue() {
                return this.tagValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComplianceResourceId() != null) {
                    data.set("complianceResourceId", om.valueToTree(this.getComplianceResourceId()));
                }
                if (this.getComplianceResourceTypes() != null) {
                    data.set("complianceResourceTypes", om.valueToTree(this.getComplianceResourceTypes()));
                }
                if (this.getTagKey() != null) {
                    data.set("tagKey", om.valueToTree(this.getTagKey()));
                }
                if (this.getTagValue() != null) {
                    data.set("tagValue", om.valueToTree(this.getTagValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigRule.ScopeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScopeProperty.Jsii$Proxy that = (ScopeProperty.Jsii$Proxy) o;

                if (this.complianceResourceId != null ? !this.complianceResourceId.equals(that.complianceResourceId) : that.complianceResourceId != null) return false;
                if (this.complianceResourceTypes != null ? !this.complianceResourceTypes.equals(that.complianceResourceTypes) : that.complianceResourceTypes != null) return false;
                if (this.tagKey != null ? !this.tagKey.equals(that.tagKey) : that.tagKey != null) return false;
                return this.tagValue != null ? this.tagValue.equals(that.tagValue) : that.tagValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.complianceResourceId != null ? this.complianceResourceId.hashCode() : 0;
                result = 31 * result + (this.complianceResourceTypes != null ? this.complianceResourceTypes.hashCode() : 0);
                result = 31 * result + (this.tagKey != null ? this.tagKey.hashCode() : 0);
                result = 31 * result + (this.tagValue != null ? this.tagValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the source and the message types that trigger AWS Config to evaluate your AWS resources against a rule.
     * <p>
     * It also provides the frequency with which you want AWS Config to run evaluations for the rule if the trigger type is periodic. You can specify the parameter values for <code>SourceDetail</code> only for custom rules.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * SourceDetailProperty sourceDetailProperty = SourceDetailProperty.builder()
     *         .eventSource("eventSource")
     *         .messageType("messageType")
     *         // the properties below are optional
     *         .maximumExecutionFrequency("maximumExecutionFrequency")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigRule.SourceDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWS resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventSource();

        /**
         * The type of notification that triggers AWS Config to run an evaluation for a rule.
         * <p>
         * You can specify the following notification types:
         * <p>
         * <ul>
         * <li><code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a configuration item as a result of a resource change.</li>
         * <li><code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</li>
         * <li><code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code> .</li>
         * <li><code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when AWS Config delivers a configuration snapshot.</li>
         * </ul>
         * <p>
         * If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for <code>ConfigurationItemChangeNotification</code> and one for <code>OversizedConfigurationItemChangeNotification</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMessageType();

        /**
         * The frequency at which you want AWS Config to run evaluations for a custom rule with a periodic trigger.
         * <p>
         * If you specify a value for <code>MaximumExecutionFrequency</code> , then <code>MessageType</code> must use the <code>ScheduledNotification</code> value.
         * <p>
         * <blockquote>
         * <p>
         * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         * <p>
         * Based on the valid value you choose, AWS Config runs evaluations once for each valid value. For example, if you choose <code>Three_Hours</code> , AWS Config runs evaluations once every three hours. In this case, <code>Three_Hours</code> is the frequency of this rule.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaximumExecutionFrequency() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceDetailProperty> {
            java.lang.String eventSource;
            java.lang.String messageType;
            java.lang.String maximumExecutionFrequency;

            /**
             * Sets the value of {@link SourceDetailProperty#getEventSource}
             * @param eventSource The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWS resources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventSource(java.lang.String eventSource) {
                this.eventSource = eventSource;
                return this;
            }

            /**
             * Sets the value of {@link SourceDetailProperty#getMessageType}
             * @param messageType The type of notification that triggers AWS Config to run an evaluation for a rule. This parameter is required.
             *                    You can specify the following notification types:
             *                    <p>
             *                    <ul>
             *                    <li><code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a configuration item as a result of a resource change.</li>
             *                    <li><code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</li>
             *                    <li><code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code> .</li>
             *                    <li><code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when AWS Config delivers a configuration snapshot.</li>
             *                    </ul>
             *                    <p>
             *                    If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for <code>ConfigurationItemChangeNotification</code> and one for <code>OversizedConfigurationItemChangeNotification</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageType(java.lang.String messageType) {
                this.messageType = messageType;
                return this;
            }

            /**
             * Sets the value of {@link SourceDetailProperty#getMaximumExecutionFrequency}
             * @param maximumExecutionFrequency The frequency at which you want AWS Config to run evaluations for a custom rule with a periodic trigger.
             *                                  If you specify a value for <code>MaximumExecutionFrequency</code> , then <code>MessageType</code> must use the <code>ScheduledNotification</code> value.
             *                                  <p>
             *                                  <blockquote>
             *                                  <p>
             *                                  By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
             *                                  <p>
             *                                  Based on the valid value you choose, AWS Config runs evaluations once for each valid value. For example, if you choose <code>Three_Hours</code> , AWS Config runs evaluations once every three hours. In this case, <code>Three_Hours</code> is the frequency of this rule.
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumExecutionFrequency(java.lang.String maximumExecutionFrequency) {
                this.maximumExecutionFrequency = maximumExecutionFrequency;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceDetailProperty {
            private final java.lang.String eventSource;
            private final java.lang.String messageType;
            private final java.lang.String maximumExecutionFrequency;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventSource = software.amazon.jsii.Kernel.get(this, "eventSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.messageType = software.amazon.jsii.Kernel.get(this, "messageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maximumExecutionFrequency = software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventSource = java.util.Objects.requireNonNull(builder.eventSource, "eventSource is required");
                this.messageType = java.util.Objects.requireNonNull(builder.messageType, "messageType is required");
                this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
            }

            @Override
            public final java.lang.String getEventSource() {
                return this.eventSource;
            }

            @Override
            public final java.lang.String getMessageType() {
                return this.messageType;
            }

            @Override
            public final java.lang.String getMaximumExecutionFrequency() {
                return this.maximumExecutionFrequency;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventSource", om.valueToTree(this.getEventSource()));
                data.set("messageType", om.valueToTree(this.getMessageType()));
                if (this.getMaximumExecutionFrequency() != null) {
                    data.set("maximumExecutionFrequency", om.valueToTree(this.getMaximumExecutionFrequency()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigRule.SourceDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceDetailProperty.Jsii$Proxy that = (SourceDetailProperty.Jsii$Proxy) o;

                if (!eventSource.equals(that.eventSource)) return false;
                if (!messageType.equals(that.messageType)) return false;
                return this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.equals(that.maximumExecutionFrequency) : that.maximumExecutionFrequency == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventSource.hashCode();
                result = 31 * result + (this.messageType.hashCode());
                result = 31 * result + (this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the AWS Config rule owner ( AWS or customer), the rule identifier, and the events that trigger the evaluation of your AWS resources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * SourceProperty sourceProperty = SourceProperty.builder()
     *         .owner("owner")
     *         .sourceIdentifier("sourceIdentifier")
     *         // the properties below are optional
     *         .sourceDetails(List.of(SourceDetailProperty.builder()
     *                 .eventSource("eventSource")
     *                 .messageType("messageType")
     *                 // the properties below are optional
     *                 .maximumExecutionFrequency("maximumExecutionFrequency")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigRule.SourceProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether AWS or the customer owns and manages the AWS Config rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOwner();

        /**
         * For AWS Config managed rules, a predefined identifier from a list.
         * <p>
         * For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using AWS Config managed rules</a> .
         * <p>
         * For custom rules, the identifier is the Amazon Resource Name (ARN) of the rule's AWS Lambda function, such as <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceIdentifier();

        /**
         * Provides the source and type of the event that causes AWS Config to evaluate your AWS resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceDetails() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceProperty> {
            java.lang.String owner;
            java.lang.String sourceIdentifier;
            java.lang.Object sourceDetails;

            /**
             * Sets the value of {@link SourceProperty#getOwner}
             * @param owner Indicates whether AWS or the customer owns and manages the AWS Config rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder owner(java.lang.String owner) {
                this.owner = owner;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSourceIdentifier}
             * @param sourceIdentifier For AWS Config managed rules, a predefined identifier from a list. This parameter is required.
             *                         For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using AWS Config managed rules</a> .
             *                         <p>
             *                         For custom rules, the identifier is the Amazon Resource Name (ARN) of the rule's AWS Lambda function, such as <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceIdentifier(java.lang.String sourceIdentifier) {
                this.sourceIdentifier = sourceIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSourceDetails}
             * @param sourceDetails Provides the source and type of the event that causes AWS Config to evaluate your AWS resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceDetails(software.amazon.awscdk.IResolvable sourceDetails) {
                this.sourceDetails = sourceDetails;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSourceDetails}
             * @param sourceDetails Provides the source and type of the event that causes AWS Config to evaluate your AWS resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceDetails(java.util.List<? extends java.lang.Object> sourceDetails) {
                this.sourceDetails = sourceDetails;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceProperty {
            private final java.lang.String owner;
            private final java.lang.String sourceIdentifier;
            private final java.lang.Object sourceDetails;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceIdentifier = software.amazon.jsii.Kernel.get(this, "sourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceDetails = software.amazon.jsii.Kernel.get(this, "sourceDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.owner = java.util.Objects.requireNonNull(builder.owner, "owner is required");
                this.sourceIdentifier = java.util.Objects.requireNonNull(builder.sourceIdentifier, "sourceIdentifier is required");
                this.sourceDetails = builder.sourceDetails;
            }

            @Override
            public final java.lang.String getOwner() {
                return this.owner;
            }

            @Override
            public final java.lang.String getSourceIdentifier() {
                return this.sourceIdentifier;
            }

            @Override
            public final java.lang.Object getSourceDetails() {
                return this.sourceDetails;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("owner", om.valueToTree(this.getOwner()));
                data.set("sourceIdentifier", om.valueToTree(this.getSourceIdentifier()));
                if (this.getSourceDetails() != null) {
                    data.set("sourceDetails", om.valueToTree(this.getSourceDetails()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigRule.SourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceProperty.Jsii$Proxy that = (SourceProperty.Jsii$Proxy) o;

                if (!owner.equals(that.owner)) return false;
                if (!sourceIdentifier.equals(that.sourceIdentifier)) return false;
                return this.sourceDetails != null ? this.sourceDetails.equals(that.sourceDetails) : that.sourceDetails == null;
            }

            @Override
            public final int hashCode() {
                int result = this.owner.hashCode();
                result = 31 * result + (this.sourceIdentifier.hashCode());
                result = 31 * result + (this.sourceDetails != null ? this.sourceDetails.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.config.CfnConfigRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.config.CfnConfigRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.config.CfnConfigRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.config.CfnConfigRuleProps.Builder();
        }

        /**
         * Provides the rule owner ( AWS or customer), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
         * <p>
         * @return {@code this}
         * @param source Provides the rule owner ( AWS or customer), the rule identifier, and the notifications that cause the function to evaluate your AWS resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.services.config.CfnConfigRule.SourceProperty source) {
            this.props.source(source);
            return this;
        }
        /**
         * Provides the rule owner ( AWS or customer), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
         * <p>
         * @return {@code this}
         * @param source Provides the rule owner ( AWS or customer), the rule identifier, and the notifications that cause the function to evaluate your AWS resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.IResolvable source) {
            this.props.source(source);
            return this;
        }

        /**
         * A name for the AWS Config rule.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the rule name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * @return {@code this}
         * @param configRuleName A name for the AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configRuleName(final java.lang.String configRuleName) {
            this.props.configRuleName(configRuleName);
            return this;
        }

        /**
         * The description that you provide for the AWS Config rule.
         * <p>
         * @return {@code this}
         * @param description The description that you provide for the AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * A string, in JSON format, that is passed to the AWS Config rule Lambda function.
         * <p>
         * @return {@code this}
         * @param inputParameters A string, in JSON format, that is passed to the AWS Config rule Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputParameters(final java.lang.Object inputParameters) {
            this.props.inputParameters(inputParameters);
            return this;
        }

        /**
         * The maximum frequency with which AWS Config runs evaluations for a rule.
         * <p>
         * You can specify a value for <code>MaximumExecutionFrequency</code> when:
         * <p>
         * <ul>
         * <li>You are using an AWS managed rule that is triggered at a periodic frequency.</li>
         * <li>Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html">ConfigSnapshotDeliveryProperties</a> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param maximumExecutionFrequency The maximum frequency with which AWS Config runs evaluations for a rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumExecutionFrequency(final java.lang.String maximumExecutionFrequency) {
            this.props.maximumExecutionFrequency(maximumExecutionFrequency);
            return this;
        }

        /**
         * Defines which resources can trigger an evaluation for the rule.
         * <p>
         * The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
         * <p>
         * <blockquote>
         * <p>
         * The scope can be empty.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param scope Defines which resources can trigger an evaluation for the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(final software.amazon.awscdk.services.config.CfnConfigRule.ScopeProperty scope) {
            this.props.scope(scope);
            return this;
        }
        /**
         * Defines which resources can trigger an evaluation for the rule.
         * <p>
         * The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
         * <p>
         * <blockquote>
         * <p>
         * The scope can be empty.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param scope Defines which resources can trigger an evaluation for the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(final software.amazon.awscdk.IResolvable scope) {
            this.props.scope(scope);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.config.CfnConfigRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.config.CfnConfigRule build() {
            return new software.amazon.awscdk.services.config.CfnConfigRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
