package software.amazon.awscdk.services.cognito;

/**
 * Options to customize the behaviour of `signInUrl()`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool userpool = UserPool.Builder.create(this, "UserPool").build();
 * UserPoolClient client = userpool.addClient("Client", UserPoolClientOptions.builder()
 *         // ...
 *         .oAuth(OAuthSettings.builder()
 *                 .flows(OAuthFlows.builder()
 *                         .implicitCodeGrant(true)
 *                         .build())
 *                 .callbackUrls(List.of("https://myapp.com/home", "https://myapp.com/users"))
 *                 .build())
 *         .build());
 * UserPoolDomain domain = userpool.addDomain("Domain", UserPoolDomainOptions.builder().build());
 * String signInUrl = domain.signInUrl(client, SignInUrlOptions.builder()
 *         .redirectUri("https://myapp.com/home")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.565Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.SignInUrlOptions")
@software.amazon.jsii.Jsii.Proxy(SignInUrlOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SignInUrlOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Where to redirect to after sign in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRedirectUri();

    /**
     * The path in the URI where the sign-in page is located.
     * <p>
     * Default: '/login'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSignInPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SignInUrlOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SignInUrlOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SignInUrlOptions> {
        java.lang.String redirectUri;
        java.lang.String signInPath;

        /**
         * Sets the value of {@link SignInUrlOptions#getRedirectUri}
         * @param redirectUri Where to redirect to after sign in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redirectUri(java.lang.String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        /**
         * Sets the value of {@link SignInUrlOptions#getSignInPath}
         * @param signInPath The path in the URI where the sign-in page is located.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signInPath(java.lang.String signInPath) {
            this.signInPath = signInPath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SignInUrlOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SignInUrlOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SignInUrlOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SignInUrlOptions {
        private final java.lang.String redirectUri;
        private final java.lang.String signInPath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.redirectUri = software.amazon.jsii.Kernel.get(this, "redirectUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.signInPath = software.amazon.jsii.Kernel.get(this, "signInPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.redirectUri = java.util.Objects.requireNonNull(builder.redirectUri, "redirectUri is required");
            this.signInPath = builder.signInPath;
        }

        @Override
        public final java.lang.String getRedirectUri() {
            return this.redirectUri;
        }

        @Override
        public final java.lang.String getSignInPath() {
            return this.signInPath;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("redirectUri", om.valueToTree(this.getRedirectUri()));
            if (this.getSignInPath() != null) {
                data.set("signInPath", om.valueToTree(this.getSignInPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.SignInUrlOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SignInUrlOptions.Jsii$Proxy that = (SignInUrlOptions.Jsii$Proxy) o;

            if (!redirectUri.equals(that.redirectUri)) return false;
            return this.signInPath != null ? this.signInPath.equals(that.signInPath) : that.signInPath == null;
        }

        @Override
        public final int hashCode() {
            int result = this.redirectUri.hashCode();
            result = 31 * result + (this.signInPath != null ? this.signInPath.hashCode() : 0);
            return result;
        }
    }
}
