package software.amazon.awscdk.services.codestar;

/**
 * Properties for defining a `CfnGitHubRepository`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codestar.*;
 * CfnGitHubRepositoryProps cfnGitHubRepositoryProps = CfnGitHubRepositoryProps.builder()
 *         .repositoryName("repositoryName")
 *         .repositoryOwner("repositoryOwner")
 *         // the properties below are optional
 *         .code(CodeProperty.builder()
 *                 .s3(S3Property.builder()
 *                         .bucket("bucket")
 *                         .key("key")
 *                         // the properties below are optional
 *                         .objectVersion("objectVersion")
 *                         .build())
 *                 .build())
 *         .connectionArn("connectionArn")
 *         .enableIssues(false)
 *         .isPrivate(false)
 *         .repositoryAccessToken("repositoryAccessToken")
 *         .repositoryDescription("repositoryDescription")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.474Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codestar.CfnGitHubRepositoryProps")
@software.amazon.jsii.Jsii.Proxy(CfnGitHubRepositoryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGitHubRepositoryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the repository you want to create in GitHub with AWS CloudFormation stack creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName();

    /**
     * The GitHub user name for the owner of the GitHub repository to be created.
     * <p>
     * If this repository should be owned by a GitHub organization, provide its name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryOwner();

    /**
     * Information about code to be committed to a repository after it is created in an AWS CloudFormation stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCode() {
        return null;
    }

    /**
     * `AWS::CodeStar::GitHubRepository.ConnectionArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectionArn() {
        return null;
    }

    /**
     * Indicates whether to enable issues for the GitHub repository.
     * <p>
     * You can use GitHub issues to track information and bugs for your repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableIssues() {
        return null;
    }

    /**
     * Indicates whether the GitHub repository is a private repository.
     * <p>
     * If so, you choose who can see and commit to this repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIsPrivate() {
        return null;
    }

    /**
     * The GitHub user's personal access token for the GitHub repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRepositoryAccessToken() {
        return null;
    }

    /**
     * A comment or description about the new repository.
     * <p>
     * This description is displayed in GitHub after the repository is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRepositoryDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGitHubRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGitHubRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGitHubRepositoryProps> {
        java.lang.String repositoryName;
        java.lang.String repositoryOwner;
        java.lang.Object code;
        java.lang.String connectionArn;
        java.lang.Object enableIssues;
        java.lang.Object isPrivate;
        java.lang.String repositoryAccessToken;
        java.lang.String repositoryDescription;

        /**
         * Sets the value of {@link CfnGitHubRepositoryProps#getRepositoryName}
         * @param repositoryName The name of the repository you want to create in GitHub with AWS CloudFormation stack creation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Sets the value of {@link CfnGitHubRepositoryProps#getRepositoryOwner}
         * @param repositoryOwner The GitHub user name for the owner of the GitHub repository to be created. This parameter is required.
         *                        If this repository should be owned by a GitHub organization, provide its name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryOwner(java.lang.String repositoryOwner) {
            this.repositoryOwner = repositoryOwner;
            return this;
        }

        /**
         * Sets the value of {@link CfnGitHubRepositoryProps#getCode}
         * @param code Information about code to be committed to a repository after it is created in an AWS CloudFormation stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(software.amazon.awscdk.services.codestar.CfnGitHubRepository.CodeProperty code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of {@link CfnGitHubRepositoryProps#getCode}
         * @param code Information about code to be committed to a repository after it is created in an AWS CloudFormation stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(software.amazon.awscdk.IResolvable code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of {@link CfnGitHubRepositoryProps#getConnectionArn}
         * @param connectionArn `AWS::CodeStar::GitHubRepository.ConnectionArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionArn(java.lang.String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnGitHubRepositoryProps#getEnableIssues}
         * @param enableIssues Indicates whether to enable issues for the GitHub repository.
         *                     You can use GitHub issues to track information and bugs for your repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIssues(java.lang.Boolean enableIssues) {
            this.enableIssues = enableIssues;
            return this;
        }

        /**
         * Sets the value of {@link CfnGitHubRepositoryProps#getEnableIssues}
         * @param enableIssues Indicates whether to enable issues for the GitHub repository.
         *                     You can use GitHub issues to track information and bugs for your repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIssues(software.amazon.awscdk.IResolvable enableIssues) {
            this.enableIssues = enableIssues;
            return this;
        }

        /**
         * Sets the value of {@link CfnGitHubRepositoryProps#getIsPrivate}
         * @param isPrivate Indicates whether the GitHub repository is a private repository.
         *                  If so, you choose who can see and commit to this repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isPrivate(java.lang.Boolean isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }

        /**
         * Sets the value of {@link CfnGitHubRepositoryProps#getIsPrivate}
         * @param isPrivate Indicates whether the GitHub repository is a private repository.
         *                  If so, you choose who can see and commit to this repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isPrivate(software.amazon.awscdk.IResolvable isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }

        /**
         * Sets the value of {@link CfnGitHubRepositoryProps#getRepositoryAccessToken}
         * @param repositoryAccessToken The GitHub user's personal access token for the GitHub repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryAccessToken(java.lang.String repositoryAccessToken) {
            this.repositoryAccessToken = repositoryAccessToken;
            return this;
        }

        /**
         * Sets the value of {@link CfnGitHubRepositoryProps#getRepositoryDescription}
         * @param repositoryDescription A comment or description about the new repository.
         *                              This description is displayed in GitHub after the repository is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryDescription(java.lang.String repositoryDescription) {
            this.repositoryDescription = repositoryDescription;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGitHubRepositoryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGitHubRepositoryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGitHubRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGitHubRepositoryProps {
        private final java.lang.String repositoryName;
        private final java.lang.String repositoryOwner;
        private final java.lang.Object code;
        private final java.lang.String connectionArn;
        private final java.lang.Object enableIssues;
        private final java.lang.Object isPrivate;
        private final java.lang.String repositoryAccessToken;
        private final java.lang.String repositoryDescription;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositoryOwner = software.amazon.jsii.Kernel.get(this, "repositoryOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.connectionArn = software.amazon.jsii.Kernel.get(this, "connectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableIssues = software.amazon.jsii.Kernel.get(this, "enableIssues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.isPrivate = software.amazon.jsii.Kernel.get(this, "isPrivate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.repositoryAccessToken = software.amazon.jsii.Kernel.get(this, "repositoryAccessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositoryDescription = software.amazon.jsii.Kernel.get(this, "repositoryDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.repositoryName = java.util.Objects.requireNonNull(builder.repositoryName, "repositoryName is required");
            this.repositoryOwner = java.util.Objects.requireNonNull(builder.repositoryOwner, "repositoryOwner is required");
            this.code = builder.code;
            this.connectionArn = builder.connectionArn;
            this.enableIssues = builder.enableIssues;
            this.isPrivate = builder.isPrivate;
            this.repositoryAccessToken = builder.repositoryAccessToken;
            this.repositoryDescription = builder.repositoryDescription;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final java.lang.String getRepositoryOwner() {
            return this.repositoryOwner;
        }

        @Override
        public final java.lang.Object getCode() {
            return this.code;
        }

        @Override
        public final java.lang.String getConnectionArn() {
            return this.connectionArn;
        }

        @Override
        public final java.lang.Object getEnableIssues() {
            return this.enableIssues;
        }

        @Override
        public final java.lang.Object getIsPrivate() {
            return this.isPrivate;
        }

        @Override
        public final java.lang.String getRepositoryAccessToken() {
            return this.repositoryAccessToken;
        }

        @Override
        public final java.lang.String getRepositoryDescription() {
            return this.repositoryDescription;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            data.set("repositoryOwner", om.valueToTree(this.getRepositoryOwner()));
            if (this.getCode() != null) {
                data.set("code", om.valueToTree(this.getCode()));
            }
            if (this.getConnectionArn() != null) {
                data.set("connectionArn", om.valueToTree(this.getConnectionArn()));
            }
            if (this.getEnableIssues() != null) {
                data.set("enableIssues", om.valueToTree(this.getEnableIssues()));
            }
            if (this.getIsPrivate() != null) {
                data.set("isPrivate", om.valueToTree(this.getIsPrivate()));
            }
            if (this.getRepositoryAccessToken() != null) {
                data.set("repositoryAccessToken", om.valueToTree(this.getRepositoryAccessToken()));
            }
            if (this.getRepositoryDescription() != null) {
                data.set("repositoryDescription", om.valueToTree(this.getRepositoryDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codestar.CfnGitHubRepositoryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGitHubRepositoryProps.Jsii$Proxy that = (CfnGitHubRepositoryProps.Jsii$Proxy) o;

            if (!repositoryName.equals(that.repositoryName)) return false;
            if (!repositoryOwner.equals(that.repositoryOwner)) return false;
            if (this.code != null ? !this.code.equals(that.code) : that.code != null) return false;
            if (this.connectionArn != null ? !this.connectionArn.equals(that.connectionArn) : that.connectionArn != null) return false;
            if (this.enableIssues != null ? !this.enableIssues.equals(that.enableIssues) : that.enableIssues != null) return false;
            if (this.isPrivate != null ? !this.isPrivate.equals(that.isPrivate) : that.isPrivate != null) return false;
            if (this.repositoryAccessToken != null ? !this.repositoryAccessToken.equals(that.repositoryAccessToken) : that.repositoryAccessToken != null) return false;
            return this.repositoryDescription != null ? this.repositoryDescription.equals(that.repositoryDescription) : that.repositoryDescription == null;
        }

        @Override
        public final int hashCode() {
            int result = this.repositoryName.hashCode();
            result = 31 * result + (this.repositoryOwner.hashCode());
            result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
            result = 31 * result + (this.connectionArn != null ? this.connectionArn.hashCode() : 0);
            result = 31 * result + (this.enableIssues != null ? this.enableIssues.hashCode() : 0);
            result = 31 * result + (this.isPrivate != null ? this.isPrivate.hashCode() : 0);
            result = 31 * result + (this.repositoryAccessToken != null ? this.repositoryAccessToken.hashCode() : 0);
            result = 31 * result + (this.repositoryDescription != null ? this.repositoryDescription.hashCode() : 0);
            return result;
        }
    }
}
