package software.amazon.awscdk.services.codepipeline.actions;

/**
 * The CodePipeline variables emitted by the S3 source Action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * S3SourceVariables s3SourceVariables = S3SourceVariables.builder()
 *         .eTag("eTag")
 *         .versionId("versionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.468Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.S3SourceVariables")
@software.amazon.jsii.Jsii.Proxy(S3SourceVariables.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3SourceVariables extends software.amazon.jsii.JsiiSerializable {

    /**
     * The e-tag of the S3 version of the object that triggered the build.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getETag();

    /**
     * The identifier of the S3 version of the object that triggered the build.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVersionId();

    /**
     * @return a {@link Builder} of {@link S3SourceVariables}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3SourceVariables}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<S3SourceVariables> {
        java.lang.String eTag;
        java.lang.String versionId;

        /**
         * Sets the value of {@link S3SourceVariables#getETag}
         * @param eTag The e-tag of the S3 version of the object that triggered the build. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eTag(java.lang.String eTag) {
            this.eTag = eTag;
            return this;
        }

        /**
         * Sets the value of {@link S3SourceVariables#getVersionId}
         * @param versionId The identifier of the S3 version of the object that triggered the build. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionId(java.lang.String versionId) {
            this.versionId = versionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3SourceVariables}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public S3SourceVariables build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3SourceVariables}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3SourceVariables {
        private final java.lang.String eTag;
        private final java.lang.String versionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eTag = software.amazon.jsii.Kernel.get(this, "eTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.versionId = software.amazon.jsii.Kernel.get(this, "versionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eTag = java.util.Objects.requireNonNull(builder.eTag, "eTag is required");
            this.versionId = java.util.Objects.requireNonNull(builder.versionId, "versionId is required");
        }

        @Override
        public final java.lang.String getETag() {
            return this.eTag;
        }

        @Override
        public final java.lang.String getVersionId() {
            return this.versionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eTag", om.valueToTree(this.getETag()));
            data.set("versionId", om.valueToTree(this.getVersionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.S3SourceVariables"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3SourceVariables.Jsii$Proxy that = (S3SourceVariables.Jsii$Proxy) o;

            if (!eTag.equals(that.eTag)) return false;
            return this.versionId.equals(that.versionId);
        }

        @Override
        public final int hashCode() {
            int result = this.eTag.hashCode();
            result = 31 * result + (this.versionId.hashCode());
            return result;
        }
    }
}
