package software.amazon.awscdk.services.codedeploy;

/**
 * Lambda Deployment config type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LambdaApplication application;
 * Alias alias;
 * CustomLambdaDeploymentConfig config = CustomLambdaDeploymentConfig.Builder.create(this, "CustomConfig")
 *         .type(CustomLambdaDeploymentConfigType.CANARY)
 *         .interval(Duration.minutes(1))
 *         .percentage(5)
 *         .build();
 * LambdaDeploymentGroup deploymentGroup = LambdaDeploymentGroup.Builder.create(this, "BlueGreenDeployment")
 *         .application(application)
 *         .alias(alias)
 *         .deploymentConfig(config)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.319Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.CustomLambdaDeploymentConfigType")
public enum CustomLambdaDeploymentConfigType {
    /**
     * Canary deployment type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CANARY,
    /**
     * Linear deployment type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LINEAR,
}
