package software.amazon.awscdk.services.cloudfront;

/**
 * Configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
 * <p>
 * CloudFront adds these headers to HTTP responses that it sends for CORS requests that match a cache behavior
 * associated with this response headers policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Using an existing managed response headers policy
 * S3Origin bucketOrigin;
 * Distribution.Builder.create(this, "myDistManagedPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .responseHeadersPolicy(ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS)
 *                 .build())
 *         .build();
 * // Creating a custom response headers policy -- all parameters optional
 * ResponseHeadersPolicy myResponseHeadersPolicy = ResponseHeadersPolicy.Builder.create(this, "ResponseHeadersPolicy")
 *         .responseHeadersPolicyName("MyPolicy")
 *         .comment("A default policy")
 *         .corsBehavior(ResponseHeadersCorsBehavior.builder()
 *                 .accessControlAllowCredentials(false)
 *                 .accessControlAllowHeaders(List.of("X-Custom-Header-1", "X-Custom-Header-2"))
 *                 .accessControlAllowMethods(List.of("GET", "POST"))
 *                 .accessControlAllowOrigins(List.of("*"))
 *                 .accessControlExposeHeaders(List.of("X-Custom-Header-1", "X-Custom-Header-2"))
 *                 .accessControlMaxAge(Duration.seconds(600))
 *                 .originOverride(true)
 *                 .build())
 *         .customHeadersBehavior(ResponseCustomHeadersBehavior.builder()
 *                 .customHeaders(List.of(ResponseCustomHeader.builder().header("X-Amz-Date").value("some-value").override(true).build(), ResponseCustomHeader.builder().header("X-Amz-Security-Token").value("some-value").override(false).build()))
 *                 .build())
 *         .securityHeadersBehavior(ResponseSecurityHeadersBehavior.builder()
 *                 .contentSecurityPolicy(ResponseHeadersContentSecurityPolicy.builder().contentSecurityPolicy("default-src https:;").override(true).build())
 *                 .contentTypeOptions(ResponseHeadersContentTypeOptions.builder().override(true).build())
 *                 .frameOptions(ResponseHeadersFrameOptions.builder().frameOption(HeadersFrameOption.DENY).override(true).build())
 *                 .referrerPolicy(ResponseHeadersReferrerPolicy.builder().referrerPolicy(HeadersReferrerPolicy.NO_REFERRER).override(true).build())
 *                 .strictTransportSecurity(ResponseHeadersStrictTransportSecurity.builder().accessControlMaxAge(Duration.seconds(600)).includeSubdomains(true).override(true).build())
 *                 .xssProtection(ResponseHeadersXSSProtection.builder().protection(true).modeBlock(true).reportUri("https://example.com/csp-report").override(true).build())
 *                 .build())
 *         .build();
 * Distribution.Builder.create(this, "myDistCustomPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .responseHeadersPolicy(myResponseHeadersPolicy)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.062Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.ResponseHeadersCorsBehavior")
@software.amazon.jsii.Jsii.Proxy(ResponseHeadersCorsBehavior.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResponseHeadersCorsBehavior extends software.amazon.jsii.JsiiSerializable {

    /**
     * A Boolean that CloudFront uses as the value for the Access-Control-Allow-Credentials HTTP response header.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getAccessControlAllowCredentials();

    /**
     * A list of HTTP header names that CloudFront includes as values for the Access-Control-Allow-Headers HTTP response header.
     * <p>
     * You can specify <code>['*']</code> to allow all headers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAccessControlAllowHeaders();

    /**
     * A list of HTTP methods that CloudFront includes as values for the Access-Control-Allow-Methods HTTP response header.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAccessControlAllowMethods();

    /**
     * A list of origins (domain names) that CloudFront can use as the value for the Access-Control-Allow-Origin HTTP response header.
     * <p>
     * You can specify <code>['*']</code> to allow all origins.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAccessControlAllowOrigins();

    /**
     * A Boolean that determines whether CloudFront overrides HTTP response headers received from the origin with the ones specified in this response headers policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getOriginOverride();

    /**
     * A list of HTTP headers that CloudFront includes as values for the Access-Control-Expose-Headers HTTP response header.
     * <p>
     * You can specify <code>['*']</code> to expose all headers.
     * <p>
     * Default: - no headers exposed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAccessControlExposeHeaders() {
        return null;
    }

    /**
     * A number that CloudFront uses as the value for the Access-Control-Max-Age HTTP response header.
     * <p>
     * Default: - no max age
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getAccessControlMaxAge() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResponseHeadersCorsBehavior}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResponseHeadersCorsBehavior}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResponseHeadersCorsBehavior> {
        java.lang.Boolean accessControlAllowCredentials;
        java.util.List<java.lang.String> accessControlAllowHeaders;
        java.util.List<java.lang.String> accessControlAllowMethods;
        java.util.List<java.lang.String> accessControlAllowOrigins;
        java.lang.Boolean originOverride;
        java.util.List<java.lang.String> accessControlExposeHeaders;
        software.amazon.awscdk.Duration accessControlMaxAge;

        /**
         * Sets the value of {@link ResponseHeadersCorsBehavior#getAccessControlAllowCredentials}
         * @param accessControlAllowCredentials A Boolean that CloudFront uses as the value for the Access-Control-Allow-Credentials HTTP response header. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControlAllowCredentials(java.lang.Boolean accessControlAllowCredentials) {
            this.accessControlAllowCredentials = accessControlAllowCredentials;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersCorsBehavior#getAccessControlAllowHeaders}
         * @param accessControlAllowHeaders A list of HTTP header names that CloudFront includes as values for the Access-Control-Allow-Headers HTTP response header. This parameter is required.
         *                                  You can specify <code>['*']</code> to allow all headers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControlAllowHeaders(java.util.List<java.lang.String> accessControlAllowHeaders) {
            this.accessControlAllowHeaders = accessControlAllowHeaders;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersCorsBehavior#getAccessControlAllowMethods}
         * @param accessControlAllowMethods A list of HTTP methods that CloudFront includes as values for the Access-Control-Allow-Methods HTTP response header. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControlAllowMethods(java.util.List<java.lang.String> accessControlAllowMethods) {
            this.accessControlAllowMethods = accessControlAllowMethods;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersCorsBehavior#getAccessControlAllowOrigins}
         * @param accessControlAllowOrigins A list of origins (domain names) that CloudFront can use as the value for the Access-Control-Allow-Origin HTTP response header. This parameter is required.
         *                                  You can specify <code>['*']</code> to allow all origins.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControlAllowOrigins(java.util.List<java.lang.String> accessControlAllowOrigins) {
            this.accessControlAllowOrigins = accessControlAllowOrigins;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersCorsBehavior#getOriginOverride}
         * @param originOverride A Boolean that determines whether CloudFront overrides HTTP response headers received from the origin with the ones specified in this response headers policy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originOverride(java.lang.Boolean originOverride) {
            this.originOverride = originOverride;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersCorsBehavior#getAccessControlExposeHeaders}
         * @param accessControlExposeHeaders A list of HTTP headers that CloudFront includes as values for the Access-Control-Expose-Headers HTTP response header.
         *                                   You can specify <code>['*']</code> to expose all headers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControlExposeHeaders(java.util.List<java.lang.String> accessControlExposeHeaders) {
            this.accessControlExposeHeaders = accessControlExposeHeaders;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersCorsBehavior#getAccessControlMaxAge}
         * @param accessControlMaxAge A number that CloudFront uses as the value for the Access-Control-Max-Age HTTP response header.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControlMaxAge(software.amazon.awscdk.Duration accessControlMaxAge) {
            this.accessControlMaxAge = accessControlMaxAge;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResponseHeadersCorsBehavior}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResponseHeadersCorsBehavior build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResponseHeadersCorsBehavior}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResponseHeadersCorsBehavior {
        private final java.lang.Boolean accessControlAllowCredentials;
        private final java.util.List<java.lang.String> accessControlAllowHeaders;
        private final java.util.List<java.lang.String> accessControlAllowMethods;
        private final java.util.List<java.lang.String> accessControlAllowOrigins;
        private final java.lang.Boolean originOverride;
        private final java.util.List<java.lang.String> accessControlExposeHeaders;
        private final software.amazon.awscdk.Duration accessControlMaxAge;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessControlAllowCredentials = software.amazon.jsii.Kernel.get(this, "accessControlAllowCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.accessControlAllowHeaders = software.amazon.jsii.Kernel.get(this, "accessControlAllowHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.accessControlAllowMethods = software.amazon.jsii.Kernel.get(this, "accessControlAllowMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.accessControlAllowOrigins = software.amazon.jsii.Kernel.get(this, "accessControlAllowOrigins", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.originOverride = software.amazon.jsii.Kernel.get(this, "originOverride", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.accessControlExposeHeaders = software.amazon.jsii.Kernel.get(this, "accessControlExposeHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.accessControlMaxAge = software.amazon.jsii.Kernel.get(this, "accessControlMaxAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessControlAllowCredentials = java.util.Objects.requireNonNull(builder.accessControlAllowCredentials, "accessControlAllowCredentials is required");
            this.accessControlAllowHeaders = java.util.Objects.requireNonNull(builder.accessControlAllowHeaders, "accessControlAllowHeaders is required");
            this.accessControlAllowMethods = java.util.Objects.requireNonNull(builder.accessControlAllowMethods, "accessControlAllowMethods is required");
            this.accessControlAllowOrigins = java.util.Objects.requireNonNull(builder.accessControlAllowOrigins, "accessControlAllowOrigins is required");
            this.originOverride = java.util.Objects.requireNonNull(builder.originOverride, "originOverride is required");
            this.accessControlExposeHeaders = builder.accessControlExposeHeaders;
            this.accessControlMaxAge = builder.accessControlMaxAge;
        }

        @Override
        public final java.lang.Boolean getAccessControlAllowCredentials() {
            return this.accessControlAllowCredentials;
        }

        @Override
        public final java.util.List<java.lang.String> getAccessControlAllowHeaders() {
            return this.accessControlAllowHeaders;
        }

        @Override
        public final java.util.List<java.lang.String> getAccessControlAllowMethods() {
            return this.accessControlAllowMethods;
        }

        @Override
        public final java.util.List<java.lang.String> getAccessControlAllowOrigins() {
            return this.accessControlAllowOrigins;
        }

        @Override
        public final java.lang.Boolean getOriginOverride() {
            return this.originOverride;
        }

        @Override
        public final java.util.List<java.lang.String> getAccessControlExposeHeaders() {
            return this.accessControlExposeHeaders;
        }

        @Override
        public final software.amazon.awscdk.Duration getAccessControlMaxAge() {
            return this.accessControlMaxAge;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessControlAllowCredentials", om.valueToTree(this.getAccessControlAllowCredentials()));
            data.set("accessControlAllowHeaders", om.valueToTree(this.getAccessControlAllowHeaders()));
            data.set("accessControlAllowMethods", om.valueToTree(this.getAccessControlAllowMethods()));
            data.set("accessControlAllowOrigins", om.valueToTree(this.getAccessControlAllowOrigins()));
            data.set("originOverride", om.valueToTree(this.getOriginOverride()));
            if (this.getAccessControlExposeHeaders() != null) {
                data.set("accessControlExposeHeaders", om.valueToTree(this.getAccessControlExposeHeaders()));
            }
            if (this.getAccessControlMaxAge() != null) {
                data.set("accessControlMaxAge", om.valueToTree(this.getAccessControlMaxAge()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.ResponseHeadersCorsBehavior"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResponseHeadersCorsBehavior.Jsii$Proxy that = (ResponseHeadersCorsBehavior.Jsii$Proxy) o;

            if (!accessControlAllowCredentials.equals(that.accessControlAllowCredentials)) return false;
            if (!accessControlAllowHeaders.equals(that.accessControlAllowHeaders)) return false;
            if (!accessControlAllowMethods.equals(that.accessControlAllowMethods)) return false;
            if (!accessControlAllowOrigins.equals(that.accessControlAllowOrigins)) return false;
            if (!originOverride.equals(that.originOverride)) return false;
            if (this.accessControlExposeHeaders != null ? !this.accessControlExposeHeaders.equals(that.accessControlExposeHeaders) : that.accessControlExposeHeaders != null) return false;
            return this.accessControlMaxAge != null ? this.accessControlMaxAge.equals(that.accessControlMaxAge) : that.accessControlMaxAge == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessControlAllowCredentials.hashCode();
            result = 31 * result + (this.accessControlAllowHeaders.hashCode());
            result = 31 * result + (this.accessControlAllowMethods.hashCode());
            result = 31 * result + (this.accessControlAllowOrigins.hashCode());
            result = 31 * result + (this.originOverride.hashCode());
            result = 31 * result + (this.accessControlExposeHeaders != null ? this.accessControlExposeHeaders.hashCode() : 0);
            result = 31 * result + (this.accessControlMaxAge != null ? this.accessControlMaxAge.hashCode() : 0);
            return result;
        }
    }
}
