package software.amazon.awscdk.services.batch;

/**
 * Properties for defining a `CfnJobQueue`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * Object tags;
 * CfnJobQueueProps cfnJobQueueProps = CfnJobQueueProps.builder()
 *         .computeEnvironmentOrder(List.of(ComputeEnvironmentOrderProperty.builder()
 *                 .computeEnvironment("computeEnvironment")
 *                 .order(123)
 *                 .build()))
 *         .priority(123)
 *         // the properties below are optional
 *         .jobQueueName("jobQueueName")
 *         .schedulingPolicyArn("schedulingPolicyArn")
 *         .state("state")
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.837Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobQueueProps")
@software.amazon.jsii.Jsii.Proxy(CfnJobQueueProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnJobQueueProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Batch::JobQueue.ComputeEnvironmentOrder`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getComputeEnvironmentOrder();

    /**
     * `AWS::Batch::JobQueue.Priority`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

    /**
     * `AWS::Batch::JobQueue.JobQueueName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobQueueName() {
        return null;
    }

    /**
     * `AWS::Batch::JobQueue.SchedulingPolicyArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSchedulingPolicyArn() {
        return null;
    }

    /**
     * `AWS::Batch::JobQueue.State`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return null;
    }

    /**
     * `AWS::Batch::JobQueue.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnJobQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnJobQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnJobQueueProps> {
        java.lang.Object computeEnvironmentOrder;
        java.lang.Number priority;
        java.lang.String jobQueueName;
        java.lang.String schedulingPolicyArn;
        java.lang.String state;
        java.lang.Object tags;

        /**
         * Sets the value of {@link CfnJobQueueProps#getComputeEnvironmentOrder}
         * @param computeEnvironmentOrder `AWS::Batch::JobQueue.ComputeEnvironmentOrder`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentOrder(software.amazon.awscdk.IResolvable computeEnvironmentOrder) {
            this.computeEnvironmentOrder = computeEnvironmentOrder;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobQueueProps#getComputeEnvironmentOrder}
         * @param computeEnvironmentOrder `AWS::Batch::JobQueue.ComputeEnvironmentOrder`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentOrder(java.util.List<? extends java.lang.Object> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = computeEnvironmentOrder;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobQueueProps#getPriority}
         * @param priority `AWS::Batch::JobQueue.Priority`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobQueueProps#getJobQueueName}
         * @param jobQueueName `AWS::Batch::JobQueue.JobQueueName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobQueueName(java.lang.String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobQueueProps#getSchedulingPolicyArn}
         * @param schedulingPolicyArn `AWS::Batch::JobQueue.SchedulingPolicyArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPolicyArn(java.lang.String schedulingPolicyArn) {
            this.schedulingPolicyArn = schedulingPolicyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobQueueProps#getState}
         * @param state `AWS::Batch::JobQueue.State`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(java.lang.String state) {
            this.state = state;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobQueueProps#getTags}
         * @param tags `AWS::Batch::JobQueue.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnJobQueueProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnJobQueueProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnJobQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnJobQueueProps {
        private final java.lang.Object computeEnvironmentOrder;
        private final java.lang.Number priority;
        private final java.lang.String jobQueueName;
        private final java.lang.String schedulingPolicyArn;
        private final java.lang.String state;
        private final java.lang.Object tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computeEnvironmentOrder = software.amazon.jsii.Kernel.get(this, "computeEnvironmentOrder", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.jobQueueName = software.amazon.jsii.Kernel.get(this, "jobQueueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schedulingPolicyArn = software.amazon.jsii.Kernel.get(this, "schedulingPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computeEnvironmentOrder = java.util.Objects.requireNonNull(builder.computeEnvironmentOrder, "computeEnvironmentOrder is required");
            this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
            this.jobQueueName = builder.jobQueueName;
            this.schedulingPolicyArn = builder.schedulingPolicyArn;
            this.state = builder.state;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getComputeEnvironmentOrder() {
            return this.computeEnvironmentOrder;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final java.lang.String getJobQueueName() {
            return this.jobQueueName;
        }

        @Override
        public final java.lang.String getSchedulingPolicyArn() {
            return this.schedulingPolicyArn;
        }

        @Override
        public final java.lang.String getState() {
            return this.state;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("computeEnvironmentOrder", om.valueToTree(this.getComputeEnvironmentOrder()));
            data.set("priority", om.valueToTree(this.getPriority()));
            if (this.getJobQueueName() != null) {
                data.set("jobQueueName", om.valueToTree(this.getJobQueueName()));
            }
            if (this.getSchedulingPolicyArn() != null) {
                data.set("schedulingPolicyArn", om.valueToTree(this.getSchedulingPolicyArn()));
            }
            if (this.getState() != null) {
                data.set("state", om.valueToTree(this.getState()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobQueueProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnJobQueueProps.Jsii$Proxy that = (CfnJobQueueProps.Jsii$Proxy) o;

            if (!computeEnvironmentOrder.equals(that.computeEnvironmentOrder)) return false;
            if (!priority.equals(that.priority)) return false;
            if (this.jobQueueName != null ? !this.jobQueueName.equals(that.jobQueueName) : that.jobQueueName != null) return false;
            if (this.schedulingPolicyArn != null ? !this.schedulingPolicyArn.equals(that.schedulingPolicyArn) : that.schedulingPolicyArn != null) return false;
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.computeEnvironmentOrder.hashCode();
            result = 31 * result + (this.priority.hashCode());
            result = 31 * result + (this.jobQueueName != null ? this.jobQueueName.hashCode() : 0);
            result = 31 * result + (this.schedulingPolicyArn != null ? this.schedulingPolicyArn.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
