package software.amazon.awscdk.services.batch;

/**
 * Properties for defining a `CfnComputeEnvironment`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * Object tags;
 * CfnComputeEnvironmentProps cfnComputeEnvironmentProps = CfnComputeEnvironmentProps.builder()
 *         .type("type")
 *         // the properties below are optional
 *         .computeEnvironmentName("computeEnvironmentName")
 *         .computeResources(ComputeResourcesProperty.builder()
 *                 .maxvCpus(123)
 *                 .subnets(List.of("subnets"))
 *                 .type("type")
 *                 // the properties below are optional
 *                 .allocationStrategy("allocationStrategy")
 *                 .bidPercentage(123)
 *                 .desiredvCpus(123)
 *                 .ec2Configuration(List.of(Ec2ConfigurationObjectProperty.builder()
 *                         .imageType("imageType")
 *                         // the properties below are optional
 *                         .imageIdOverride("imageIdOverride")
 *                         .build()))
 *                 .ec2KeyPair("ec2KeyPair")
 *                 .imageId("imageId")
 *                 .instanceRole("instanceRole")
 *                 .instanceTypes(List.of("instanceTypes"))
 *                 .launchTemplate(LaunchTemplateSpecificationProperty.builder()
 *                         .launchTemplateId("launchTemplateId")
 *                         .launchTemplateName("launchTemplateName")
 *                         .version("version")
 *                         .build())
 *                 .minvCpus(123)
 *                 .placementGroup("placementGroup")
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .spotIamFleetRole("spotIamFleetRole")
 *                 .tags(tags)
 *                 .build())
 *         .serviceRole("serviceRole")
 *         .state("state")
 *         .tags(tags)
 *         .unmanagedvCpus(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.824Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnComputeEnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnComputeEnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnComputeEnvironmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Batch::ComputeEnvironment.Type`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * `AWS::Batch::ComputeEnvironment.ComputeEnvironmentName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComputeEnvironmentName() {
        return null;
    }

    /**
     * `AWS::Batch::ComputeEnvironment.ComputeResources`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getComputeResources() {
        return null;
    }

    /**
     * `AWS::Batch::ComputeEnvironment.ServiceRole`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceRole() {
        return null;
    }

    /**
     * `AWS::Batch::ComputeEnvironment.State`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return null;
    }

    /**
     * `AWS::Batch::ComputeEnvironment.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * `AWS::Batch::ComputeEnvironment.UnmanagedvCpus`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUnmanagedvCpus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnComputeEnvironmentProps> {
        java.lang.String type;
        java.lang.String computeEnvironmentName;
        java.lang.Object computeResources;
        java.lang.String serviceRole;
        java.lang.String state;
        java.lang.Object tags;
        java.lang.Number unmanagedvCpus;

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getType}
         * @param type `AWS::Batch::ComputeEnvironment.Type`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getComputeEnvironmentName}
         * @param computeEnvironmentName `AWS::Batch::ComputeEnvironment.ComputeEnvironmentName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentName(java.lang.String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getComputeResources}
         * @param computeResources `AWS::Batch::ComputeEnvironment.ComputeResources`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeResources(software.amazon.awscdk.services.batch.CfnComputeEnvironment.ComputeResourcesProperty computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getComputeResources}
         * @param computeResources `AWS::Batch::ComputeEnvironment.ComputeResources`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeResources(software.amazon.awscdk.IResolvable computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getServiceRole}
         * @param serviceRole `AWS::Batch::ComputeEnvironment.ServiceRole`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(java.lang.String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getState}
         * @param state `AWS::Batch::ComputeEnvironment.State`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(java.lang.String state) {
            this.state = state;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getTags}
         * @param tags `AWS::Batch::ComputeEnvironment.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getUnmanagedvCpus}
         * @param unmanagedvCpus `AWS::Batch::ComputeEnvironment.UnmanagedvCpus`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unmanagedvCpus(java.lang.Number unmanagedvCpus) {
            this.unmanagedvCpus = unmanagedvCpus;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnComputeEnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnComputeEnvironmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnComputeEnvironmentProps {
        private final java.lang.String type;
        private final java.lang.String computeEnvironmentName;
        private final java.lang.Object computeResources;
        private final java.lang.String serviceRole;
        private final java.lang.String state;
        private final java.lang.Object tags;
        private final java.lang.Number unmanagedvCpus;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.computeEnvironmentName = software.amazon.jsii.Kernel.get(this, "computeEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.computeResources = software.amazon.jsii.Kernel.get(this, "computeResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.unmanagedvCpus = software.amazon.jsii.Kernel.get(this, "unmanagedvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.computeEnvironmentName = builder.computeEnvironmentName;
            this.computeResources = builder.computeResources;
            this.serviceRole = builder.serviceRole;
            this.state = builder.state;
            this.tags = builder.tags;
            this.unmanagedvCpus = builder.unmanagedvCpus;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getComputeEnvironmentName() {
            return this.computeEnvironmentName;
        }

        @Override
        public final java.lang.Object getComputeResources() {
            return this.computeResources;
        }

        @Override
        public final java.lang.String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final java.lang.String getState() {
            return this.state;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getUnmanagedvCpus() {
            return this.unmanagedvCpus;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getComputeEnvironmentName() != null) {
                data.set("computeEnvironmentName", om.valueToTree(this.getComputeEnvironmentName()));
            }
            if (this.getComputeResources() != null) {
                data.set("computeResources", om.valueToTree(this.getComputeResources()));
            }
            if (this.getServiceRole() != null) {
                data.set("serviceRole", om.valueToTree(this.getServiceRole()));
            }
            if (this.getState() != null) {
                data.set("state", om.valueToTree(this.getState()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUnmanagedvCpus() != null) {
                data.set("unmanagedvCpus", om.valueToTree(this.getUnmanagedvCpus()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnComputeEnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnComputeEnvironmentProps.Jsii$Proxy that = (CfnComputeEnvironmentProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.computeEnvironmentName != null ? !this.computeEnvironmentName.equals(that.computeEnvironmentName) : that.computeEnvironmentName != null) return false;
            if (this.computeResources != null ? !this.computeResources.equals(that.computeResources) : that.computeResources != null) return false;
            if (this.serviceRole != null ? !this.serviceRole.equals(that.serviceRole) : that.serviceRole != null) return false;
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.unmanagedvCpus != null ? this.unmanagedvCpus.equals(that.unmanagedvCpus) : that.unmanagedvCpus == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.computeEnvironmentName != null ? this.computeEnvironmentName.hashCode() : 0);
            result = 31 * result + (this.computeResources != null ? this.computeResources.hashCode() : 0);
            result = 31 * result + (this.serviceRole != null ? this.serviceRole.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.unmanagedvCpus != null ? this.unmanagedvCpus.hashCode() : 0);
            return result;
        }
    }
}
