package software.amazon.awscdk.services.autoscaling;

/**
 * A CloudFormation `AWS::AutoScaling::WarmPool`.
 * <p>
 * The <code>AWS::AutoScaling::WarmPool</code> resource creates a pool of pre-initialized EC2 instances that sits alongside the Auto Scaling group. Whenever your application needs to scale out, the Auto Scaling group can draw on the warm pool to meet its new desired capacity.
 * <p>
 * When you create a warm pool, you can define a minimum size. When your Auto Scaling group scales out and the size of the warm pool shrinks, Amazon EC2 Auto Scaling launches new instances into the warm pool to maintain its minimum size.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for Amazon EC2 Auto Scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * CloudFormation supports the <code>UpdatePolicy</code> attribute for Auto Scaling groups. During an update, if <code>UpdatePolicy</code> is set to <code>AutoScalingRollingUpdate</code> , CloudFormation replaces <code>InService</code> instances only. Instances in the warm pool are not replaced. The difference in which instances are replaced can potentially result in different instance configurations after the stack update completes. If <code>UpdatePolicy</code> is set to <code>AutoScalingReplacingUpdate</code> , you do not encounter this issue because CloudFormation replaces both the Auto Scaling group and the warm pool.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * CfnWarmPool cfnWarmPool = CfnWarmPool.Builder.create(this, "MyCfnWarmPool")
 *         .autoScalingGroupName("autoScalingGroupName")
 *         // the properties below are optional
 *         .instanceReusePolicy(InstanceReusePolicyProperty.builder()
 *                 .reuseOnScaleIn(false)
 *                 .build())
 *         .maxGroupPreparedCapacity(123)
 *         .minSize(123)
 *         .poolState("poolState")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.745Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnWarmPool")
public class CfnWarmPool extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnWarmPool(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWarmPool(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.autoscaling.CfnWarmPool.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::AutoScaling::WarmPool`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWarmPool(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.CfnWarmPoolProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupName() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingGroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingGroupName", java.util.Objects.requireNonNull(value, "autoScalingGroupName is required"));
    }

    /**
     * `AWS::AutoScaling::WarmPool.InstanceReusePolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInstanceReusePolicy() {
        return software.amazon.jsii.Kernel.get(this, "instanceReusePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::AutoScaling::WarmPool.InstanceReusePolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceReusePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.CfnWarmPool.InstanceReusePolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "instanceReusePolicy", value);
    }

    /**
     * `AWS::AutoScaling::WarmPool.InstanceReusePolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceReusePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "instanceReusePolicy", value);
    }

    /**
     * Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except `Terminated` for the Auto Scaling group.
     * <p>
     * This is an optional property. Specify it only if you do not want the warm pool size to be determined by the difference between the group's maximum capacity and its desired capacity.
     * <p>
     * <blockquote>
     * <p>
     * If a value for <code>MaxGroupPreparedCapacity</code> is not specified, Amazon EC2 Auto Scaling launches and maintains the difference between the group's maximum capacity and its desired capacity. If you specify a value for <code>MaxGroupPreparedCapacity</code> , Amazon EC2 Auto Scaling uses the difference between the <code>MaxGroupPreparedCapacity</code> and the desired capacity instead.
     * <p>
     * The size of the warm pool is dynamic. Only when <code>MaxGroupPreparedCapacity</code> and <code>MinSize</code> are set to the same value does the warm pool have an absolute size.
     * <p>
     * </blockquote>
     * <p>
     * If the desired capacity of the Auto Scaling group is higher than the <code>MaxGroupPreparedCapacity</code> , the capacity of the warm pool is 0, unless you specify a value for <code>MinSize</code> . To remove a value that you previously set, include the property but specify -1 for the value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxGroupPreparedCapacity() {
        return software.amazon.jsii.Kernel.get(this, "maxGroupPreparedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except `Terminated` for the Auto Scaling group.
     * <p>
     * This is an optional property. Specify it only if you do not want the warm pool size to be determined by the difference between the group's maximum capacity and its desired capacity.
     * <p>
     * <blockquote>
     * <p>
     * If a value for <code>MaxGroupPreparedCapacity</code> is not specified, Amazon EC2 Auto Scaling launches and maintains the difference between the group's maximum capacity and its desired capacity. If you specify a value for <code>MaxGroupPreparedCapacity</code> , Amazon EC2 Auto Scaling uses the difference between the <code>MaxGroupPreparedCapacity</code> and the desired capacity instead.
     * <p>
     * The size of the warm pool is dynamic. Only when <code>MaxGroupPreparedCapacity</code> and <code>MinSize</code> are set to the same value does the warm pool have an absolute size.
     * <p>
     * </blockquote>
     * <p>
     * If the desired capacity of the Auto Scaling group is higher than the <code>MaxGroupPreparedCapacity</code> , the capacity of the warm pool is 0, unless you specify a value for <code>MinSize</code> . To remove a value that you previously set, include the property but specify -1 for the value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxGroupPreparedCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxGroupPreparedCapacity", value);
    }

    /**
     * Specifies the minimum number of instances to maintain in the warm pool.
     * <p>
     * This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinSize() {
        return software.amazon.jsii.Kernel.get(this, "minSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Specifies the minimum number of instances to maintain in the warm pool.
     * <p>
     * This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinSize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minSize", value);
    }

    /**
     * Sets the instance state to transition to after the lifecycle actions are complete.
     * <p>
     * Default is <code>Stopped</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPoolState() {
        return software.amazon.jsii.Kernel.get(this, "poolState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Sets the instance state to transition to after the lifecycle actions are complete.
     * <p>
     * Default is <code>Stopped</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPoolState(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "poolState", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscaling.*;
     * InstanceReusePolicyProperty instanceReusePolicyProperty = InstanceReusePolicyProperty.builder()
     *         .reuseOnScaleIn(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnWarmPool.InstanceReusePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceReusePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceReusePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnWarmPool.InstanceReusePolicyProperty.ReuseOnScaleIn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReuseOnScaleIn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceReusePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceReusePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceReusePolicyProperty> {
            java.lang.Object reuseOnScaleIn;

            /**
             * Sets the value of {@link InstanceReusePolicyProperty#getReuseOnScaleIn}
             * @param reuseOnScaleIn `CfnWarmPool.InstanceReusePolicyProperty.ReuseOnScaleIn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reuseOnScaleIn(java.lang.Boolean reuseOnScaleIn) {
                this.reuseOnScaleIn = reuseOnScaleIn;
                return this;
            }

            /**
             * Sets the value of {@link InstanceReusePolicyProperty#getReuseOnScaleIn}
             * @param reuseOnScaleIn `CfnWarmPool.InstanceReusePolicyProperty.ReuseOnScaleIn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reuseOnScaleIn(software.amazon.awscdk.IResolvable reuseOnScaleIn) {
                this.reuseOnScaleIn = reuseOnScaleIn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceReusePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceReusePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceReusePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceReusePolicyProperty {
            private final java.lang.Object reuseOnScaleIn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.reuseOnScaleIn = software.amazon.jsii.Kernel.get(this, "reuseOnScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.reuseOnScaleIn = builder.reuseOnScaleIn;
            }

            @Override
            public final java.lang.Object getReuseOnScaleIn() {
                return this.reuseOnScaleIn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReuseOnScaleIn() != null) {
                    data.set("reuseOnScaleIn", om.valueToTree(this.getReuseOnScaleIn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnWarmPool.InstanceReusePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceReusePolicyProperty.Jsii$Proxy that = (InstanceReusePolicyProperty.Jsii$Proxy) o;

                return this.reuseOnScaleIn != null ? this.reuseOnScaleIn.equals(that.reuseOnScaleIn) : that.reuseOnScaleIn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.reuseOnScaleIn != null ? this.reuseOnScaleIn.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.autoscaling.CfnWarmPool}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.autoscaling.CfnWarmPool> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.autoscaling.CfnWarmPoolProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.autoscaling.CfnWarmPoolProps.Builder();
        }

        /**
         * The name of the Auto Scaling group.
         * <p>
         * @return {@code this}
         * @param autoScalingGroupName The name of the Auto Scaling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupName(final java.lang.String autoScalingGroupName) {
            this.props.autoScalingGroupName(autoScalingGroupName);
            return this;
        }

        /**
         * `AWS::AutoScaling::WarmPool.InstanceReusePolicy`.
         * <p>
         * @return {@code this}
         * @param instanceReusePolicy `AWS::AutoScaling::WarmPool.InstanceReusePolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceReusePolicy(final software.amazon.awscdk.services.autoscaling.CfnWarmPool.InstanceReusePolicyProperty instanceReusePolicy) {
            this.props.instanceReusePolicy(instanceReusePolicy);
            return this;
        }
        /**
         * `AWS::AutoScaling::WarmPool.InstanceReusePolicy`.
         * <p>
         * @return {@code this}
         * @param instanceReusePolicy `AWS::AutoScaling::WarmPool.InstanceReusePolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceReusePolicy(final software.amazon.awscdk.IResolvable instanceReusePolicy) {
            this.props.instanceReusePolicy(instanceReusePolicy);
            return this;
        }

        /**
         * Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except `Terminated` for the Auto Scaling group.
         * <p>
         * This is an optional property. Specify it only if you do not want the warm pool size to be determined by the difference between the group's maximum capacity and its desired capacity.
         * <p>
         * <blockquote>
         * <p>
         * If a value for <code>MaxGroupPreparedCapacity</code> is not specified, Amazon EC2 Auto Scaling launches and maintains the difference between the group's maximum capacity and its desired capacity. If you specify a value for <code>MaxGroupPreparedCapacity</code> , Amazon EC2 Auto Scaling uses the difference between the <code>MaxGroupPreparedCapacity</code> and the desired capacity instead.
         * <p>
         * The size of the warm pool is dynamic. Only when <code>MaxGroupPreparedCapacity</code> and <code>MinSize</code> are set to the same value does the warm pool have an absolute size.
         * <p>
         * </blockquote>
         * <p>
         * If the desired capacity of the Auto Scaling group is higher than the <code>MaxGroupPreparedCapacity</code> , the capacity of the warm pool is 0, unless you specify a value for <code>MinSize</code> . To remove a value that you previously set, include the property but specify -1 for the value.
         * <p>
         * @return {@code this}
         * @param maxGroupPreparedCapacity Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except `Terminated` for the Auto Scaling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxGroupPreparedCapacity(final java.lang.Number maxGroupPreparedCapacity) {
            this.props.maxGroupPreparedCapacity(maxGroupPreparedCapacity);
            return this;
        }

        /**
         * Specifies the minimum number of instances to maintain in the warm pool.
         * <p>
         * This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
         * <p>
         * @return {@code this}
         * @param minSize Specifies the minimum number of instances to maintain in the warm pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSize(final java.lang.Number minSize) {
            this.props.minSize(minSize);
            return this;
        }

        /**
         * Sets the instance state to transition to after the lifecycle actions are complete.
         * <p>
         * Default is <code>Stopped</code> .
         * <p>
         * @return {@code this}
         * @param poolState Sets the instance state to transition to after the lifecycle actions are complete. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder poolState(final java.lang.String poolState) {
            this.props.poolState(poolState);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.autoscaling.CfnWarmPool}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.autoscaling.CfnWarmPool build() {
            return new software.amazon.awscdk.services.autoscaling.CfnWarmPool(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
