package software.amazon.awscdk.services.appsync;

/**
 * A CloudFormation `AWS::AppSync::GraphQLApi`.
 * <p>
 * The <code>AWS::AppSync::GraphQLApi</code> resource creates a new AWS AppSync GraphQL API. This is the top-level construct for your application. For more information, see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/quickstart.html">Quick Start</a> in the <em>AWS AppSync Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnGraphQLApi cfnGraphQLApi = CfnGraphQLApi.Builder.create(this, "MyCfnGraphQLApi")
 *         .authenticationType("authenticationType")
 *         .name("name")
 *         // the properties below are optional
 *         .additionalAuthenticationProviders(List.of(AdditionalAuthenticationProviderProperty.builder()
 *                 .authenticationType("authenticationType")
 *                 // the properties below are optional
 *                 .lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty.builder()
 *                         .authorizerResultTtlInSeconds(123)
 *                         .authorizerUri("authorizerUri")
 *                         .identityValidationExpression("identityValidationExpression")
 *                         .build())
 *                 .openIdConnectConfig(OpenIDConnectConfigProperty.builder()
 *                         .authTtl(123)
 *                         .clientId("clientId")
 *                         .iatTtl(123)
 *                         .issuer("issuer")
 *                         .build())
 *                 .userPoolConfig(CognitoUserPoolConfigProperty.builder()
 *                         .appIdClientRegex("appIdClientRegex")
 *                         .awsRegion("awsRegion")
 *                         .userPoolId("userPoolId")
 *                         .build())
 *                 .build()))
 *         .lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty.builder()
 *                 .authorizerResultTtlInSeconds(123)
 *                 .authorizerUri("authorizerUri")
 *                 .identityValidationExpression("identityValidationExpression")
 *                 .build())
 *         .logConfig(LogConfigProperty.builder()
 *                 .cloudWatchLogsRoleArn("cloudWatchLogsRoleArn")
 *                 .excludeVerboseContent(false)
 *                 .fieldLogLevel("fieldLogLevel")
 *                 .build())
 *         .openIdConnectConfig(OpenIDConnectConfigProperty.builder()
 *                 .authTtl(123)
 *                 .clientId("clientId")
 *                 .iatTtl(123)
 *                 .issuer("issuer")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userPoolConfig(UserPoolConfigProperty.builder()
 *                 .appIdClientRegex("appIdClientRegex")
 *                 .awsRegion("awsRegion")
 *                 .defaultAction("defaultAction")
 *                 .userPoolId("userPoolId")
 *                 .build())
 *         .xrayEnabled(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.628Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi")
public class CfnGraphQLApi extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnGraphQLApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGraphQLApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appsync.CfnGraphQLApi.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::AppSync::GraphQLApi`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGraphQLApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CfnGraphQLApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Unique AWS AppSync GraphQL API identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrApiId() {
        return software.amazon.jsii.Kernel.get(this, "attrApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the API key, such as `arn:aws:appsync:us-east-1:123456789012:apis/graphqlapiid` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Endpoint URL of your GraphQL API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGraphQlUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrGraphQlUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An arbitrary set of tags (key-value pairs) for this GraphQL API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Security configuration for your GraphQL API.
     * <p>
     * For allowed values (such as <code>API_KEY</code> , <code>AWS_IAM</code> , <code>AMAZON_COGNITO_USER_POOLS</code> , <code>OPENID_CONNECT</code> , or <code>AWS_LAMBDA</code> ), see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/security.html">Security</a> in the <em>AWS AppSync Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthenticationType() {
        return software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Security configuration for your GraphQL API.
     * <p>
     * For allowed values (such as <code>API_KEY</code> , <code>AWS_IAM</code> , <code>AMAZON_COGNITO_USER_POOLS</code> , <code>OPENID_CONNECT</code> , or <code>AWS_LAMBDA</code> ), see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/security.html">Security</a> in the <em>AWS AppSync Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authenticationType", java.util.Objects.requireNonNull(value, "authenticationType is required"));
    }

    /**
     * The API name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The API name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A list of additional authentication providers for the `GraphqlApi` API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalAuthenticationProviders() {
        return software.amazon.jsii.Kernel.get(this, "additionalAuthenticationProviders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of additional authentication providers for the `GraphqlApi` API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalAuthenticationProviders(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "additionalAuthenticationProviders", value);
    }

    /**
     * A list of additional authentication providers for the `GraphqlApi` API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalAuthenticationProviders(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "additionalAuthenticationProviders", value);
    }

    /**
     * A `LambdaAuthorizerConfig` holds configuration on how to authorize AWS AppSync API access when using the `AWS_LAMBDA` authorizer mode.
     * <p>
     * Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLambdaAuthorizerConfig() {
        return software.amazon.jsii.Kernel.get(this, "lambdaAuthorizerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A `LambdaAuthorizerConfig` holds configuration on how to authorize AWS AppSync API access when using the `AWS_LAMBDA` authorizer mode.
     * <p>
     * Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaAuthorizerConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "lambdaAuthorizerConfig", value);
    }

    /**
     * A `LambdaAuthorizerConfig` holds configuration on how to authorize AWS AppSync API access when using the `AWS_LAMBDA` authorizer mode.
     * <p>
     * Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaAuthorizerConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lambdaAuthorizerConfig", value);
    }

    /**
     * The Amazon CloudWatch Logs configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogConfig() {
        return software.amazon.jsii.Kernel.get(this, "logConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon CloudWatch Logs configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnGraphQLApi.LogConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "logConfig", value);
    }

    /**
     * The Amazon CloudWatch Logs configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logConfig", value);
    }

    /**
     * The OpenID Connect configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOpenIdConnectConfig() {
        return software.amazon.jsii.Kernel.get(this, "openIdConnectConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The OpenID Connect configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenIdConnectConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnGraphQLApi.OpenIDConnectConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "openIdConnectConfig", value);
    }

    /**
     * The OpenID Connect configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenIdConnectConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "openIdConnectConfig", value);
    }

    /**
     * Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUserPoolConfig() {
        return software.amazon.jsii.Kernel.get(this, "userPoolConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnGraphQLApi.UserPoolConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "userPoolConfig", value);
    }

    /**
     * Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "userPoolConfig", value);
    }

    /**
     * A flag indicating whether to use AWS X-Ray tracing for this `GraphqlApi` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getXrayEnabled() {
        return software.amazon.jsii.Kernel.get(this, "xrayEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A flag indicating whether to use AWS X-Ray tracing for this `GraphqlApi` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setXrayEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "xrayEnabled", value);
    }

    /**
     * A flag indicating whether to use AWS X-Ray tracing for this `GraphqlApi` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setXrayEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "xrayEnabled", value);
    }
    /**
     * Describes an additional authentication provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * AdditionalAuthenticationProviderProperty additionalAuthenticationProviderProperty = AdditionalAuthenticationProviderProperty.builder()
     *         .authenticationType("authenticationType")
     *         // the properties below are optional
     *         .lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty.builder()
     *                 .authorizerResultTtlInSeconds(123)
     *                 .authorizerUri("authorizerUri")
     *                 .identityValidationExpression("identityValidationExpression")
     *                 .build())
     *         .openIdConnectConfig(OpenIDConnectConfigProperty.builder()
     *                 .authTtl(123)
     *                 .clientId("clientId")
     *                 .iatTtl(123)
     *                 .issuer("issuer")
     *                 .build())
     *         .userPoolConfig(CognitoUserPoolConfigProperty.builder()
     *                 .appIdClientRegex("appIdClientRegex")
     *                 .awsRegion("awsRegion")
     *                 .userPoolId("userPoolId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.AdditionalAuthenticationProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(AdditionalAuthenticationProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdditionalAuthenticationProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authentication type for API key, AWS Identity and Access Management , OIDC, Amazon Cognito user pools , or AWS Lambda .
         * <p>
         * Valid Values: <code>API_KEY</code> | <code>AWS_IAM</code> | <code>OPENID_CONNECT</code> | <code>AMAZON_COGNITO_USER_POOLS</code> | <code>AWS_LAMBDA</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthenticationType();

        /**
         * Configuration for AWS Lambda function authorization.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaAuthorizerConfig() {
            return null;
        }

        /**
         * The OIDC configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOpenIdConnectConfig() {
            return null;
        }

        /**
         * The Amazon Cognito user pool configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserPoolConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdditionalAuthenticationProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdditionalAuthenticationProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdditionalAuthenticationProviderProperty> {
            java.lang.String authenticationType;
            java.lang.Object lambdaAuthorizerConfig;
            java.lang.Object openIdConnectConfig;
            java.lang.Object userPoolConfig;

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getAuthenticationType}
             * @param authenticationType The authentication type for API key, AWS Identity and Access Management , OIDC, Amazon Cognito user pools , or AWS Lambda . This parameter is required.
             *                           Valid Values: <code>API_KEY</code> | <code>AWS_IAM</code> | <code>OPENID_CONNECT</code> | <code>AMAZON_COGNITO_USER_POOLS</code> | <code>AWS_LAMBDA</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationType(java.lang.String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getLambdaAuthorizerConfig}
             * @param lambdaAuthorizerConfig Configuration for AWS Lambda function authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaAuthorizerConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty lambdaAuthorizerConfig) {
                this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getLambdaAuthorizerConfig}
             * @param lambdaAuthorizerConfig Configuration for AWS Lambda function authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaAuthorizerConfig(software.amazon.awscdk.IResolvable lambdaAuthorizerConfig) {
                this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getOpenIdConnectConfig}
             * @param openIdConnectConfig The OIDC configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openIdConnectConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.OpenIDConnectConfigProperty openIdConnectConfig) {
                this.openIdConnectConfig = openIdConnectConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getOpenIdConnectConfig}
             * @param openIdConnectConfig The OIDC configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openIdConnectConfig(software.amazon.awscdk.IResolvable openIdConnectConfig) {
                this.openIdConnectConfig = openIdConnectConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getUserPoolConfig}
             * @param userPoolConfig The Amazon Cognito user pool configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.CognitoUserPoolConfigProperty userPoolConfig) {
                this.userPoolConfig = userPoolConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getUserPoolConfig}
             * @param userPoolConfig The Amazon Cognito user pool configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolConfig(software.amazon.awscdk.IResolvable userPoolConfig) {
                this.userPoolConfig = userPoolConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdditionalAuthenticationProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdditionalAuthenticationProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdditionalAuthenticationProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdditionalAuthenticationProviderProperty {
            private final java.lang.String authenticationType;
            private final java.lang.Object lambdaAuthorizerConfig;
            private final java.lang.Object openIdConnectConfig;
            private final java.lang.Object userPoolConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lambdaAuthorizerConfig = software.amazon.jsii.Kernel.get(this, "lambdaAuthorizerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.openIdConnectConfig = software.amazon.jsii.Kernel.get(this, "openIdConnectConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userPoolConfig = software.amazon.jsii.Kernel.get(this, "userPoolConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authenticationType = java.util.Objects.requireNonNull(builder.authenticationType, "authenticationType is required");
                this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
                this.openIdConnectConfig = builder.openIdConnectConfig;
                this.userPoolConfig = builder.userPoolConfig;
            }

            @Override
            public final java.lang.String getAuthenticationType() {
                return this.authenticationType;
            }

            @Override
            public final java.lang.Object getLambdaAuthorizerConfig() {
                return this.lambdaAuthorizerConfig;
            }

            @Override
            public final java.lang.Object getOpenIdConnectConfig() {
                return this.openIdConnectConfig;
            }

            @Override
            public final java.lang.Object getUserPoolConfig() {
                return this.userPoolConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
                if (this.getLambdaAuthorizerConfig() != null) {
                    data.set("lambdaAuthorizerConfig", om.valueToTree(this.getLambdaAuthorizerConfig()));
                }
                if (this.getOpenIdConnectConfig() != null) {
                    data.set("openIdConnectConfig", om.valueToTree(this.getOpenIdConnectConfig()));
                }
                if (this.getUserPoolConfig() != null) {
                    data.set("userPoolConfig", om.valueToTree(this.getUserPoolConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.AdditionalAuthenticationProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdditionalAuthenticationProviderProperty.Jsii$Proxy that = (AdditionalAuthenticationProviderProperty.Jsii$Proxy) o;

                if (!authenticationType.equals(that.authenticationType)) return false;
                if (this.lambdaAuthorizerConfig != null ? !this.lambdaAuthorizerConfig.equals(that.lambdaAuthorizerConfig) : that.lambdaAuthorizerConfig != null) return false;
                if (this.openIdConnectConfig != null ? !this.openIdConnectConfig.equals(that.openIdConnectConfig) : that.openIdConnectConfig != null) return false;
                return this.userPoolConfig != null ? this.userPoolConfig.equals(that.userPoolConfig) : that.userPoolConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authenticationType.hashCode();
                result = 31 * result + (this.lambdaAuthorizerConfig != null ? this.lambdaAuthorizerConfig.hashCode() : 0);
                result = 31 * result + (this.openIdConnectConfig != null ? this.openIdConnectConfig.hashCode() : 0);
                result = 31 * result + (this.userPoolConfig != null ? this.userPoolConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an Amazon Cognito user pool configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * CognitoUserPoolConfigProperty cognitoUserPoolConfigProperty = CognitoUserPoolConfigProperty.builder()
     *         .appIdClientRegex("appIdClientRegex")
     *         .awsRegion("awsRegion")
     *         .userPoolId("userPoolId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.CognitoUserPoolConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoUserPoolConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoUserPoolConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A regular expression for validating the incoming Amazon Cognito user pool app client ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAppIdClientRegex() {
            return null;
        }

        /**
         * The AWS Region in which the user pool was created.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsRegion() {
            return null;
        }

        /**
         * The user pool ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CognitoUserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoUserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoUserPoolConfigProperty> {
            java.lang.String appIdClientRegex;
            java.lang.String awsRegion;
            java.lang.String userPoolId;

            /**
             * Sets the value of {@link CognitoUserPoolConfigProperty#getAppIdClientRegex}
             * @param appIdClientRegex A regular expression for validating the incoming Amazon Cognito user pool app client ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appIdClientRegex(java.lang.String appIdClientRegex) {
                this.appIdClientRegex = appIdClientRegex;
                return this;
            }

            /**
             * Sets the value of {@link CognitoUserPoolConfigProperty#getAwsRegion}
             * @param awsRegion The AWS Region in which the user pool was created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegion(java.lang.String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            /**
             * Sets the value of {@link CognitoUserPoolConfigProperty#getUserPoolId}
             * @param userPoolId The user pool ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolId(java.lang.String userPoolId) {
                this.userPoolId = userPoolId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoUserPoolConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoUserPoolConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CognitoUserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoUserPoolConfigProperty {
            private final java.lang.String appIdClientRegex;
            private final java.lang.String awsRegion;
            private final java.lang.String userPoolId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appIdClientRegex = software.amazon.jsii.Kernel.get(this, "appIdClientRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsRegion = software.amazon.jsii.Kernel.get(this, "awsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appIdClientRegex = builder.appIdClientRegex;
                this.awsRegion = builder.awsRegion;
                this.userPoolId = builder.userPoolId;
            }

            @Override
            public final java.lang.String getAppIdClientRegex() {
                return this.appIdClientRegex;
            }

            @Override
            public final java.lang.String getAwsRegion() {
                return this.awsRegion;
            }

            @Override
            public final java.lang.String getUserPoolId() {
                return this.userPoolId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppIdClientRegex() != null) {
                    data.set("appIdClientRegex", om.valueToTree(this.getAppIdClientRegex()));
                }
                if (this.getAwsRegion() != null) {
                    data.set("awsRegion", om.valueToTree(this.getAwsRegion()));
                }
                if (this.getUserPoolId() != null) {
                    data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.CognitoUserPoolConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoUserPoolConfigProperty.Jsii$Proxy that = (CognitoUserPoolConfigProperty.Jsii$Proxy) o;

                if (this.appIdClientRegex != null ? !this.appIdClientRegex.equals(that.appIdClientRegex) : that.appIdClientRegex != null) return false;
                if (this.awsRegion != null ? !this.awsRegion.equals(that.awsRegion) : that.awsRegion != null) return false;
                return this.userPoolId != null ? this.userPoolId.equals(that.userPoolId) : that.userPoolId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appIdClientRegex != null ? this.appIdClientRegex.hashCode() : 0;
                result = 31 * result + (this.awsRegion != null ? this.awsRegion.hashCode() : 0);
                result = 31 * result + (this.userPoolId != null ? this.userPoolId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for AWS Lambda function authorization.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * LambdaAuthorizerConfigProperty lambdaAuthorizerConfigProperty = LambdaAuthorizerConfigProperty.builder()
     *         .authorizerResultTtlInSeconds(123)
     *         .authorizerUri("authorizerUri")
     *         .identityValidationExpression("identityValidationExpression")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaAuthorizerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaAuthorizerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of seconds a response should be cached for.
         * <p>
         * The default is 5 minutes (300 seconds). The Lambda function can override this by returning a <code>ttlOverride</code> key in its response. A value of 0 disables caching of responses.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAuthorizerResultTtlInSeconds() {
            return null;
        }

        /**
         * The ARN of the Lambda function to be called for authorization.
         * <p>
         * This may be a standard Lambda ARN, a version ARN ( <code>.../v3</code> ) or alias ARN.
         * <p>
         * <em>Note</em> : This Lambda function must have the following resource-based policy assigned to it. When configuring Lambda authorizers in the console, this is done for you. To do so with the AWS CLI , run the following:
         * <p>
         * <code>aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerUri() {
            return null;
        }

        /**
         * A regular expression for validation of tokens before the Lambda function is called.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityValidationExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaAuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaAuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaAuthorizerConfigProperty> {
            java.lang.Number authorizerResultTtlInSeconds;
            java.lang.String authorizerUri;
            java.lang.String identityValidationExpression;

            /**
             * Sets the value of {@link LambdaAuthorizerConfigProperty#getAuthorizerResultTtlInSeconds}
             * @param authorizerResultTtlInSeconds The number of seconds a response should be cached for.
             *                                     The default is 5 minutes (300 seconds). The Lambda function can override this by returning a <code>ttlOverride</code> key in its response. A value of 0 disables caching of responses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizerResultTtlInSeconds(java.lang.Number authorizerResultTtlInSeconds) {
                this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link LambdaAuthorizerConfigProperty#getAuthorizerUri}
             * @param authorizerUri The ARN of the Lambda function to be called for authorization.
             *                      This may be a standard Lambda ARN, a version ARN ( <code>.../v3</code> ) or alias ARN.
             *                      <p>
             *                      <em>Note</em> : This Lambda function must have the following resource-based policy assigned to it. When configuring Lambda authorizers in the console, this is done for you. To do so with the AWS CLI , run the following:
             *                      <p>
             *                      <code>aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizerUri(java.lang.String authorizerUri) {
                this.authorizerUri = authorizerUri;
                return this;
            }

            /**
             * Sets the value of {@link LambdaAuthorizerConfigProperty#getIdentityValidationExpression}
             * @param identityValidationExpression A regular expression for validation of tokens before the Lambda function is called.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityValidationExpression(java.lang.String identityValidationExpression) {
                this.identityValidationExpression = identityValidationExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaAuthorizerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaAuthorizerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaAuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaAuthorizerConfigProperty {
            private final java.lang.Number authorizerResultTtlInSeconds;
            private final java.lang.String authorizerUri;
            private final java.lang.String identityValidationExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizerResultTtlInSeconds = software.amazon.jsii.Kernel.get(this, "authorizerResultTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.authorizerUri = software.amazon.jsii.Kernel.get(this, "authorizerUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.identityValidationExpression = software.amazon.jsii.Kernel.get(this, "identityValidationExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizerResultTtlInSeconds = builder.authorizerResultTtlInSeconds;
                this.authorizerUri = builder.authorizerUri;
                this.identityValidationExpression = builder.identityValidationExpression;
            }

            @Override
            public final java.lang.Number getAuthorizerResultTtlInSeconds() {
                return this.authorizerResultTtlInSeconds;
            }

            @Override
            public final java.lang.String getAuthorizerUri() {
                return this.authorizerUri;
            }

            @Override
            public final java.lang.String getIdentityValidationExpression() {
                return this.identityValidationExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthorizerResultTtlInSeconds() != null) {
                    data.set("authorizerResultTtlInSeconds", om.valueToTree(this.getAuthorizerResultTtlInSeconds()));
                }
                if (this.getAuthorizerUri() != null) {
                    data.set("authorizerUri", om.valueToTree(this.getAuthorizerUri()));
                }
                if (this.getIdentityValidationExpression() != null) {
                    data.set("identityValidationExpression", om.valueToTree(this.getIdentityValidationExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaAuthorizerConfigProperty.Jsii$Proxy that = (LambdaAuthorizerConfigProperty.Jsii$Proxy) o;

                if (this.authorizerResultTtlInSeconds != null ? !this.authorizerResultTtlInSeconds.equals(that.authorizerResultTtlInSeconds) : that.authorizerResultTtlInSeconds != null) return false;
                if (this.authorizerUri != null ? !this.authorizerUri.equals(that.authorizerUri) : that.authorizerUri != null) return false;
                return this.identityValidationExpression != null ? this.identityValidationExpression.equals(that.identityValidationExpression) : that.identityValidationExpression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizerResultTtlInSeconds != null ? this.authorizerResultTtlInSeconds.hashCode() : 0;
                result = 31 * result + (this.authorizerUri != null ? this.authorizerUri.hashCode() : 0);
                result = 31 * result + (this.identityValidationExpression != null ? this.identityValidationExpression.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `LogConfig` property type specifies the logging configuration when writing GraphQL operations and tracing to Amazon CloudWatch for an AWS AppSync GraphQL API.
     * <p>
     * <code>LogConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html">AWS::AppSync::GraphQLApi</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * LogConfigProperty logConfigProperty = LogConfigProperty.builder()
     *         .cloudWatchLogsRoleArn("cloudWatchLogsRoleArn")
     *         .excludeVerboseContent(false)
     *         .fieldLogLevel("fieldLogLevel")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.LogConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LogConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The service role that AWS AppSync will assume to publish to Amazon CloudWatch Logs in your account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogsRoleArn() {
            return null;
        }

        /**
         * Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeVerboseContent() {
            return null;
        }

        /**
         * The field logging level. Values can be NONE, ERROR, or ALL.
         * <p>
         * <ul>
         * <li><em>NONE</em> : No field-level logs are captured.</li>
         * <li><em>ERROR</em> : Logs the following information only for the fields that are in error:</li>
         * <li>The error section in the server response.</li>
         * <li>Field-level errors.</li>
         * <li>The generated request/response functions that got resolved for error fields.</li>
         * <li><em>ALL</em> : The following information is logged for all fields in the query:</li>
         * <li>Field-level tracing information.</li>
         * <li>The generated request/response functions that got resolved for each field.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFieldLogLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogConfigProperty> {
            java.lang.String cloudWatchLogsRoleArn;
            java.lang.Object excludeVerboseContent;
            java.lang.String fieldLogLevel;

            /**
             * Sets the value of {@link LogConfigProperty#getCloudWatchLogsRoleArn}
             * @param cloudWatchLogsRoleArn The service role that AWS AppSync will assume to publish to Amazon CloudWatch Logs in your account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsRoleArn(java.lang.String cloudWatchLogsRoleArn) {
                this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigProperty#getExcludeVerboseContent}
             * @param excludeVerboseContent Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeVerboseContent(java.lang.Boolean excludeVerboseContent) {
                this.excludeVerboseContent = excludeVerboseContent;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigProperty#getExcludeVerboseContent}
             * @param excludeVerboseContent Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeVerboseContent(software.amazon.awscdk.IResolvable excludeVerboseContent) {
                this.excludeVerboseContent = excludeVerboseContent;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigProperty#getFieldLogLevel}
             * @param fieldLogLevel The field logging level. Values can be NONE, ERROR, or ALL.
             *                      <ul>
             *                      <li><em>NONE</em> : No field-level logs are captured.</li>
             *                      <li><em>ERROR</em> : Logs the following information only for the fields that are in error:</li>
             *                      <li>The error section in the server response.</li>
             *                      <li>Field-level errors.</li>
             *                      <li>The generated request/response functions that got resolved for error fields.</li>
             *                      <li><em>ALL</em> : The following information is logged for all fields in the query:</li>
             *                      <li>Field-level tracing information.</li>
             *                      <li>The generated request/response functions that got resolved for each field.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldLogLevel(java.lang.String fieldLogLevel) {
                this.fieldLogLevel = fieldLogLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogConfigProperty {
            private final java.lang.String cloudWatchLogsRoleArn;
            private final java.lang.Object excludeVerboseContent;
            private final java.lang.String fieldLogLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogsRoleArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excludeVerboseContent = software.amazon.jsii.Kernel.get(this, "excludeVerboseContent", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fieldLogLevel = software.amazon.jsii.Kernel.get(this, "fieldLogLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
                this.excludeVerboseContent = builder.excludeVerboseContent;
                this.fieldLogLevel = builder.fieldLogLevel;
            }

            @Override
            public final java.lang.String getCloudWatchLogsRoleArn() {
                return this.cloudWatchLogsRoleArn;
            }

            @Override
            public final java.lang.Object getExcludeVerboseContent() {
                return this.excludeVerboseContent;
            }

            @Override
            public final java.lang.String getFieldLogLevel() {
                return this.fieldLogLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogsRoleArn() != null) {
                    data.set("cloudWatchLogsRoleArn", om.valueToTree(this.getCloudWatchLogsRoleArn()));
                }
                if (this.getExcludeVerboseContent() != null) {
                    data.set("excludeVerboseContent", om.valueToTree(this.getExcludeVerboseContent()));
                }
                if (this.getFieldLogLevel() != null) {
                    data.set("fieldLogLevel", om.valueToTree(this.getFieldLogLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.LogConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogConfigProperty.Jsii$Proxy that = (LogConfigProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogsRoleArn != null ? !this.cloudWatchLogsRoleArn.equals(that.cloudWatchLogsRoleArn) : that.cloudWatchLogsRoleArn != null) return false;
                if (this.excludeVerboseContent != null ? !this.excludeVerboseContent.equals(that.excludeVerboseContent) : that.excludeVerboseContent != null) return false;
                return this.fieldLogLevel != null ? this.fieldLogLevel.equals(that.fieldLogLevel) : that.fieldLogLevel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogsRoleArn != null ? this.cloudWatchLogsRoleArn.hashCode() : 0;
                result = 31 * result + (this.excludeVerboseContent != null ? this.excludeVerboseContent.hashCode() : 0);
                result = 31 * result + (this.fieldLogLevel != null ? this.fieldLogLevel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `OpenIDConnectConfig` property type specifies the optional authorization configuration for using an OpenID Connect compliant service with your GraphQL endpoint for an AWS AppSync GraphQL API.
     * <p>
     * <code>OpenIDConnectConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html">AWS::AppSync::GraphQLApi</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * OpenIDConnectConfigProperty openIDConnectConfigProperty = OpenIDConnectConfigProperty.builder()
     *         .authTtl(123)
     *         .clientId("clientId")
     *         .iatTtl(123)
     *         .issuer("issuer")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.OpenIDConnectConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenIDConnectConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenIDConnectConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of milliseconds that a token is valid after being authenticated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAuthTtl() {
            return null;
        }

        /**
         * The client identifier of the Relying party at the OpenID identity provider.
         * <p>
         * This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so that AWS AppSync can validate against multiple client identifiers at a time.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientId() {
            return null;
        }

        /**
         * The number of milliseconds that a token is valid after it's issued to a user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIatTtl() {
            return null;
        }

        /**
         * The issuer for the OIDC configuration.
         * <p>
         * The issuer returned by discovery must exactly match the value of <code>iss</code> in the ID token.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIssuer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenIDConnectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenIDConnectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenIDConnectConfigProperty> {
            java.lang.Number authTtl;
            java.lang.String clientId;
            java.lang.Number iatTtl;
            java.lang.String issuer;

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getAuthTtl}
             * @param authTtl The number of milliseconds that a token is valid after being authenticated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authTtl(java.lang.Number authTtl) {
                this.authTtl = authTtl;
                return this;
            }

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getClientId}
             * @param clientId The client identifier of the Relying party at the OpenID identity provider.
             *                 This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so that AWS AppSync can validate against multiple client identifiers at a time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getIatTtl}
             * @param iatTtl The number of milliseconds that a token is valid after it's issued to a user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iatTtl(java.lang.Number iatTtl) {
                this.iatTtl = iatTtl;
                return this;
            }

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getIssuer}
             * @param issuer The issuer for the OIDC configuration.
             *               The issuer returned by discovery must exactly match the value of <code>iss</code> in the ID token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder issuer(java.lang.String issuer) {
                this.issuer = issuer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenIDConnectConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenIDConnectConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenIDConnectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenIDConnectConfigProperty {
            private final java.lang.Number authTtl;
            private final java.lang.String clientId;
            private final java.lang.Number iatTtl;
            private final java.lang.String issuer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authTtl = software.amazon.jsii.Kernel.get(this, "authTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iatTtl = software.amazon.jsii.Kernel.get(this, "iatTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.issuer = software.amazon.jsii.Kernel.get(this, "issuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authTtl = builder.authTtl;
                this.clientId = builder.clientId;
                this.iatTtl = builder.iatTtl;
                this.issuer = builder.issuer;
            }

            @Override
            public final java.lang.Number getAuthTtl() {
                return this.authTtl;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.Number getIatTtl() {
                return this.iatTtl;
            }

            @Override
            public final java.lang.String getIssuer() {
                return this.issuer;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthTtl() != null) {
                    data.set("authTtl", om.valueToTree(this.getAuthTtl()));
                }
                if (this.getClientId() != null) {
                    data.set("clientId", om.valueToTree(this.getClientId()));
                }
                if (this.getIatTtl() != null) {
                    data.set("iatTtl", om.valueToTree(this.getIatTtl()));
                }
                if (this.getIssuer() != null) {
                    data.set("issuer", om.valueToTree(this.getIssuer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.OpenIDConnectConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenIDConnectConfigProperty.Jsii$Proxy that = (OpenIDConnectConfigProperty.Jsii$Proxy) o;

                if (this.authTtl != null ? !this.authTtl.equals(that.authTtl) : that.authTtl != null) return false;
                if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) return false;
                if (this.iatTtl != null ? !this.iatTtl.equals(that.iatTtl) : that.iatTtl != null) return false;
                return this.issuer != null ? this.issuer.equals(that.issuer) : that.issuer == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authTtl != null ? this.authTtl.hashCode() : 0;
                result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
                result = 31 * result + (this.iatTtl != null ? this.iatTtl.hashCode() : 0);
                result = 31 * result + (this.issuer != null ? this.issuer.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `UserPoolConfig` property type specifies the optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint for an AWS AppSync GraphQL API.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * UserPoolConfigProperty userPoolConfigProperty = UserPoolConfigProperty.builder()
     *         .appIdClientRegex("appIdClientRegex")
     *         .awsRegion("awsRegion")
     *         .defaultAction("defaultAction")
     *         .userPoolId("userPoolId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.UserPoolConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(UserPoolConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserPoolConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A regular expression for validating the incoming Amazon Cognito user pool app client ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAppIdClientRegex() {
            return null;
        }

        /**
         * The AWS Region in which the user pool was created.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsRegion() {
            return null;
        }

        /**
         * The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool authentication doesn't match the Amazon Cognito user pool configuration.
         * <p>
         * When specifying Amazon Cognito user pools as the default authentication, you must set the value for <code>DefaultAction</code> to <code>ALLOW</code> if specifying <code>AdditionalAuthenticationProviders</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultAction() {
            return null;
        }

        /**
         * The user pool ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserPoolConfigProperty> {
            java.lang.String appIdClientRegex;
            java.lang.String awsRegion;
            java.lang.String defaultAction;
            java.lang.String userPoolId;

            /**
             * Sets the value of {@link UserPoolConfigProperty#getAppIdClientRegex}
             * @param appIdClientRegex A regular expression for validating the incoming Amazon Cognito user pool app client ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appIdClientRegex(java.lang.String appIdClientRegex) {
                this.appIdClientRegex = appIdClientRegex;
                return this;
            }

            /**
             * Sets the value of {@link UserPoolConfigProperty#getAwsRegion}
             * @param awsRegion The AWS Region in which the user pool was created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegion(java.lang.String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            /**
             * Sets the value of {@link UserPoolConfigProperty#getDefaultAction}
             * @param defaultAction The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool authentication doesn't match the Amazon Cognito user pool configuration.
             *                      When specifying Amazon Cognito user pools as the default authentication, you must set the value for <code>DefaultAction</code> to <code>ALLOW</code> if specifying <code>AdditionalAuthenticationProviders</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultAction(java.lang.String defaultAction) {
                this.defaultAction = defaultAction;
                return this;
            }

            /**
             * Sets the value of {@link UserPoolConfigProperty#getUserPoolId}
             * @param userPoolId The user pool ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolId(java.lang.String userPoolId) {
                this.userPoolId = userPoolId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserPoolConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserPoolConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolConfigProperty {
            private final java.lang.String appIdClientRegex;
            private final java.lang.String awsRegion;
            private final java.lang.String defaultAction;
            private final java.lang.String userPoolId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appIdClientRegex = software.amazon.jsii.Kernel.get(this, "appIdClientRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsRegion = software.amazon.jsii.Kernel.get(this, "awsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultAction = software.amazon.jsii.Kernel.get(this, "defaultAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appIdClientRegex = builder.appIdClientRegex;
                this.awsRegion = builder.awsRegion;
                this.defaultAction = builder.defaultAction;
                this.userPoolId = builder.userPoolId;
            }

            @Override
            public final java.lang.String getAppIdClientRegex() {
                return this.appIdClientRegex;
            }

            @Override
            public final java.lang.String getAwsRegion() {
                return this.awsRegion;
            }

            @Override
            public final java.lang.String getDefaultAction() {
                return this.defaultAction;
            }

            @Override
            public final java.lang.String getUserPoolId() {
                return this.userPoolId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppIdClientRegex() != null) {
                    data.set("appIdClientRegex", om.valueToTree(this.getAppIdClientRegex()));
                }
                if (this.getAwsRegion() != null) {
                    data.set("awsRegion", om.valueToTree(this.getAwsRegion()));
                }
                if (this.getDefaultAction() != null) {
                    data.set("defaultAction", om.valueToTree(this.getDefaultAction()));
                }
                if (this.getUserPoolId() != null) {
                    data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.UserPoolConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserPoolConfigProperty.Jsii$Proxy that = (UserPoolConfigProperty.Jsii$Proxy) o;

                if (this.appIdClientRegex != null ? !this.appIdClientRegex.equals(that.appIdClientRegex) : that.appIdClientRegex != null) return false;
                if (this.awsRegion != null ? !this.awsRegion.equals(that.awsRegion) : that.awsRegion != null) return false;
                if (this.defaultAction != null ? !this.defaultAction.equals(that.defaultAction) : that.defaultAction != null) return false;
                return this.userPoolId != null ? this.userPoolId.equals(that.userPoolId) : that.userPoolId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appIdClientRegex != null ? this.appIdClientRegex.hashCode() : 0;
                result = 31 * result + (this.awsRegion != null ? this.awsRegion.hashCode() : 0);
                result = 31 * result + (this.defaultAction != null ? this.defaultAction.hashCode() : 0);
                result = 31 * result + (this.userPoolId != null ? this.userPoolId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.CfnGraphQLApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.CfnGraphQLApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.CfnGraphQLApiProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.CfnGraphQLApiProps.Builder();
        }

        /**
         * Security configuration for your GraphQL API.
         * <p>
         * For allowed values (such as <code>API_KEY</code> , <code>AWS_IAM</code> , <code>AMAZON_COGNITO_USER_POOLS</code> , <code>OPENID_CONNECT</code> , or <code>AWS_LAMBDA</code> ), see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/security.html">Security</a> in the <em>AWS AppSync Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param authenticationType Security configuration for your GraphQL API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationType(final java.lang.String authenticationType) {
            this.props.authenticationType(authenticationType);
            return this;
        }

        /**
         * The API name.
         * <p>
         * @return {@code this}
         * @param name The API name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A list of additional authentication providers for the `GraphqlApi` API.
         * <p>
         * @return {@code this}
         * @param additionalAuthenticationProviders A list of additional authentication providers for the `GraphqlApi` API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalAuthenticationProviders(final software.amazon.awscdk.IResolvable additionalAuthenticationProviders) {
            this.props.additionalAuthenticationProviders(additionalAuthenticationProviders);
            return this;
        }
        /**
         * A list of additional authentication providers for the `GraphqlApi` API.
         * <p>
         * @return {@code this}
         * @param additionalAuthenticationProviders A list of additional authentication providers for the `GraphqlApi` API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalAuthenticationProviders(final java.util.List<? extends java.lang.Object> additionalAuthenticationProviders) {
            this.props.additionalAuthenticationProviders(additionalAuthenticationProviders);
            return this;
        }

        /**
         * A `LambdaAuthorizerConfig` holds configuration on how to authorize AWS AppSync API access when using the `AWS_LAMBDA` authorizer mode.
         * <p>
         * Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
         * <p>
         * @return {@code this}
         * @param lambdaAuthorizerConfig A `LambdaAuthorizerConfig` holds configuration on how to authorize AWS AppSync API access when using the `AWS_LAMBDA` authorizer mode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaAuthorizerConfig(final software.amazon.awscdk.services.appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty lambdaAuthorizerConfig) {
            this.props.lambdaAuthorizerConfig(lambdaAuthorizerConfig);
            return this;
        }
        /**
         * A `LambdaAuthorizerConfig` holds configuration on how to authorize AWS AppSync API access when using the `AWS_LAMBDA` authorizer mode.
         * <p>
         * Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
         * <p>
         * @return {@code this}
         * @param lambdaAuthorizerConfig A `LambdaAuthorizerConfig` holds configuration on how to authorize AWS AppSync API access when using the `AWS_LAMBDA` authorizer mode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaAuthorizerConfig(final software.amazon.awscdk.IResolvable lambdaAuthorizerConfig) {
            this.props.lambdaAuthorizerConfig(lambdaAuthorizerConfig);
            return this;
        }

        /**
         * The Amazon CloudWatch Logs configuration.
         * <p>
         * @return {@code this}
         * @param logConfig The Amazon CloudWatch Logs configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(final software.amazon.awscdk.services.appsync.CfnGraphQLApi.LogConfigProperty logConfig) {
            this.props.logConfig(logConfig);
            return this;
        }
        /**
         * The Amazon CloudWatch Logs configuration.
         * <p>
         * @return {@code this}
         * @param logConfig The Amazon CloudWatch Logs configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(final software.amazon.awscdk.IResolvable logConfig) {
            this.props.logConfig(logConfig);
            return this;
        }

        /**
         * The OpenID Connect configuration.
         * <p>
         * @return {@code this}
         * @param openIdConnectConfig The OpenID Connect configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectConfig(final software.amazon.awscdk.services.appsync.CfnGraphQLApi.OpenIDConnectConfigProperty openIdConnectConfig) {
            this.props.openIdConnectConfig(openIdConnectConfig);
            return this;
        }
        /**
         * The OpenID Connect configuration.
         * <p>
         * @return {@code this}
         * @param openIdConnectConfig The OpenID Connect configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectConfig(final software.amazon.awscdk.IResolvable openIdConnectConfig) {
            this.props.openIdConnectConfig(openIdConnectConfig);
            return this;
        }

        /**
         * An arbitrary set of tags (key-value pairs) for this GraphQL API.
         * <p>
         * @return {@code this}
         * @param tags An arbitrary set of tags (key-value pairs) for this GraphQL API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final software.amazon.awscdk.IResolvable tags) {
            this.props.tags(tags);
            return this;
        }
        /**
         * An arbitrary set of tags (key-value pairs) for this GraphQL API.
         * <p>
         * @return {@code this}
         * @param tags An arbitrary set of tags (key-value pairs) for this GraphQL API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends java.lang.Object> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
         * <p>
         * @return {@code this}
         * @param userPoolConfig Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolConfig(final software.amazon.awscdk.services.appsync.CfnGraphQLApi.UserPoolConfigProperty userPoolConfig) {
            this.props.userPoolConfig(userPoolConfig);
            return this;
        }
        /**
         * Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
         * <p>
         * @return {@code this}
         * @param userPoolConfig Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolConfig(final software.amazon.awscdk.IResolvable userPoolConfig) {
            this.props.userPoolConfig(userPoolConfig);
            return this;
        }

        /**
         * A flag indicating whether to use AWS X-Ray tracing for this `GraphqlApi` .
         * <p>
         * @return {@code this}
         * @param xrayEnabled A flag indicating whether to use AWS X-Ray tracing for this `GraphqlApi` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xrayEnabled(final java.lang.Boolean xrayEnabled) {
            this.props.xrayEnabled(xrayEnabled);
            return this;
        }
        /**
         * A flag indicating whether to use AWS X-Ray tracing for this `GraphqlApi` .
         * <p>
         * @return {@code this}
         * @param xrayEnabled A flag indicating whether to use AWS X-Ray tracing for this `GraphqlApi` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xrayEnabled(final software.amazon.awscdk.IResolvable xrayEnabled) {
            this.props.xrayEnabled(xrayEnabled);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appsync.CfnGraphQLApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.CfnGraphQLApi build() {
            return new software.amazon.awscdk.services.appsync.CfnGraphQLApi(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
