package software.amazon.awscdk.services.appmesh;

/**
 * Properties for a VirtualGateway listener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * VirtualGatewayListenerConfig virtualGatewayListenerConfig = VirtualGatewayListenerConfig.builder()
 *         .listener(VirtualGatewayListenerProperty.builder()
 *                 .portMapping(VirtualGatewayPortMappingProperty.builder()
 *                         .port(123)
 *                         .protocol("protocol")
 *                         .build())
 *                 // the properties below are optional
 *                 .connectionPool(VirtualGatewayConnectionPoolProperty.builder()
 *                         .grpc(VirtualGatewayGrpcConnectionPoolProperty.builder()
 *                                 .maxRequests(123)
 *                                 .build())
 *                         .http(VirtualGatewayHttpConnectionPoolProperty.builder()
 *                                 .maxConnections(123)
 *                                 // the properties below are optional
 *                                 .maxPendingRequests(123)
 *                                 .build())
 *                         .http2(VirtualGatewayHttp2ConnectionPoolProperty.builder()
 *                                 .maxRequests(123)
 *                                 .build())
 *                         .build())
 *                 .healthCheck(VirtualGatewayHealthCheckPolicyProperty.builder()
 *                         .healthyThreshold(123)
 *                         .intervalMillis(123)
 *                         .protocol("protocol")
 *                         .timeoutMillis(123)
 *                         .unhealthyThreshold(123)
 *                         // the properties below are optional
 *                         .path("path")
 *                         .port(123)
 *                         .build())
 *                 .tls(VirtualGatewayListenerTlsProperty.builder()
 *                         .certificate(VirtualGatewayListenerTlsCertificateProperty.builder()
 *                                 .acm(VirtualGatewayListenerTlsAcmCertificateProperty.builder()
 *                                         .certificateArn("certificateArn")
 *                                         .build())
 *                                 .file(VirtualGatewayListenerTlsFileCertificateProperty.builder()
 *                                         .certificateChain("certificateChain")
 *                                         .privateKey("privateKey")
 *                                         .build())
 *                                 .sds(VirtualGatewayListenerTlsSdsCertificateProperty.builder()
 *                                         .secretName("secretName")
 *                                         .build())
 *                                 .build())
 *                         .mode("mode")
 *                         // the properties below are optional
 *                         .validation(VirtualGatewayListenerTlsValidationContextProperty.builder()
 *                                 .trust(VirtualGatewayListenerTlsValidationContextTrustProperty.builder()
 *                                         .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
 *                                                 .certificateChain("certificateChain")
 *                                                 .build())
 *                                         .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
 *                                                 .secretName("secretName")
 *                                                 .build())
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
 *                                         .match(SubjectAlternativeNameMatchersProperty.builder()
 *                                                 .exact(List.of("exact"))
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.542Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualGatewayListenerConfig")
@software.amazon.jsii.Jsii.Proxy(VirtualGatewayListenerConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualGatewayListenerConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Single listener config for a VirtualGateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerProperty getListener();

    /**
     * @return a {@link Builder} of {@link VirtualGatewayListenerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualGatewayListenerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayListenerConfig> {
        software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerProperty listener;

        /**
         * Sets the value of {@link VirtualGatewayListenerConfig#getListener}
         * @param listener Single listener config for a VirtualGateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listener(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerProperty listener) {
            this.listener = listener;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualGatewayListenerConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualGatewayListenerConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualGatewayListenerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayListenerConfig {
        private final software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerProperty listener;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.listener = software.amazon.jsii.Kernel.get(this, "listener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listener = java.util.Objects.requireNonNull(builder.listener, "listener is required");
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerProperty getListener() {
            return this.listener;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("listener", om.valueToTree(this.getListener()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.VirtualGatewayListenerConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualGatewayListenerConfig.Jsii$Proxy that = (VirtualGatewayListenerConfig.Jsii$Proxy) o;

            return this.listener.equals(that.listener);
        }

        @Override
        public final int hashCode() {
            int result = this.listener.hashCode();
            return result;
        }
    }
}
