package software.amazon.awscdk.services.appmesh;

/**
 * A wrapper for the tls config returned by {@link TlsCertificate.bind}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * TlsCertificateConfig tlsCertificateConfig = TlsCertificateConfig.builder()
 *         .tlsCertificate(ListenerTlsCertificateProperty.builder()
 *                 .acm(ListenerTlsAcmCertificateProperty.builder()
 *                         .certificateArn("certificateArn")
 *                         .build())
 *                 .file(ListenerTlsFileCertificateProperty.builder()
 *                         .certificateChain("certificateChain")
 *                         .privateKey("privateKey")
 *                         .build())
 *                 .sds(ListenerTlsSdsCertificateProperty.builder()
 *                         .secretName("secretName")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.529Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.TlsCertificateConfig")
@software.amazon.jsii.Jsii.Proxy(TlsCertificateConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TlsCertificateConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CFN shape for a TLS certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsCertificateProperty getTlsCertificate();

    /**
     * @return a {@link Builder} of {@link TlsCertificateConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TlsCertificateConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TlsCertificateConfig> {
        software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsCertificateProperty tlsCertificate;

        /**
         * Sets the value of {@link TlsCertificateConfig#getTlsCertificate}
         * @param tlsCertificate The CFN shape for a TLS certificate. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsCertificate(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsCertificateProperty tlsCertificate) {
            this.tlsCertificate = tlsCertificate;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TlsCertificateConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TlsCertificateConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TlsCertificateConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TlsCertificateConfig {
        private final software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsCertificateProperty tlsCertificate;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.tlsCertificate = software.amazon.jsii.Kernel.get(this, "tlsCertificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsCertificateProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.tlsCertificate = java.util.Objects.requireNonNull(builder.tlsCertificate, "tlsCertificate is required");
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsCertificateProperty getTlsCertificate() {
            return this.tlsCertificate;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("tlsCertificate", om.valueToTree(this.getTlsCertificate()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.TlsCertificateConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TlsCertificateConfig.Jsii$Proxy that = (TlsCertificateConfig.Jsii$Proxy) o;

            return this.tlsCertificate.equals(that.tlsCertificate);
        }

        @Override
        public final int hashCode() {
            int result = this.tlsCertificate.hashCode();
            return result;
        }
    }
}
