package software.amazon.awscdk.services.appmesh;

/**
 * Represent the HTTP2 Node Listener prorperty.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.appmesh.*;
 * HealthCheck healthCheck;
 * MutualTlsValidationTrust mutualTlsValidationTrust;
 * SubjectAlternativeNames subjectAlternativeNames;
 * TlsCertificate tlsCertificate;
 * Http2VirtualNodeListenerOptions http2VirtualNodeListenerOptions = Http2VirtualNodeListenerOptions.builder()
 *         .connectionPool(Http2ConnectionPool.builder()
 *                 .maxRequests(123)
 *                 .build())
 *         .healthCheck(healthCheck)
 *         .outlierDetection(OutlierDetection.builder()
 *                 .baseEjectionDuration(Duration.minutes(30))
 *                 .interval(Duration.minutes(30))
 *                 .maxEjectionPercent(123)
 *                 .maxServerErrors(123)
 *                 .build())
 *         .port(123)
 *         .timeout(HttpTimeout.builder()
 *                 .idle(Duration.minutes(30))
 *                 .perRequest(Duration.minutes(30))
 *                 .build())
 *         .tls(ListenerTlsOptions.builder()
 *                 .certificate(tlsCertificate)
 *                 .mode(TlsMode.STRICT)
 *                 // the properties below are optional
 *                 .mutualTlsValidation(MutualTlsValidation.builder()
 *                         .trust(mutualTlsValidationTrust)
 *                         // the properties below are optional
 *                         .subjectAlternativeNames(subjectAlternativeNames)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.503Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.Http2VirtualNodeListenerOptions")
@software.amazon.jsii.Jsii.Proxy(Http2VirtualNodeListenerOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Http2VirtualNodeListenerOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Connection pool for http2 listeners.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.Http2ConnectionPool getConnectionPool() {
        return null;
    }

    /**
     * The health check information for the listener.
     * <p>
     * Default: - no healthcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.HealthCheck getHealthCheck() {
        return null;
    }

    /**
     * Represents the configuration for enabling outlier detection.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.OutlierDetection getOutlierDetection() {
        return null;
    }

    /**
     * Port to listen for connections on.
     * <p>
     * Default: - 8080
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * Timeout for HTTP protocol.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.HttpTimeout getTimeout() {
        return null;
    }

    /**
     * Represents the configuration for enabling TLS on a listener.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.ListenerTlsOptions getTls() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Http2VirtualNodeListenerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Http2VirtualNodeListenerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Http2VirtualNodeListenerOptions> {
        software.amazon.awscdk.services.appmesh.Http2ConnectionPool connectionPool;
        software.amazon.awscdk.services.appmesh.HealthCheck healthCheck;
        software.amazon.awscdk.services.appmesh.OutlierDetection outlierDetection;
        java.lang.Number port;
        software.amazon.awscdk.services.appmesh.HttpTimeout timeout;
        software.amazon.awscdk.services.appmesh.ListenerTlsOptions tls;

        /**
         * Sets the value of {@link Http2VirtualNodeListenerOptions#getConnectionPool}
         * @param connectionPool Connection pool for http2 listeners.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionPool(software.amazon.awscdk.services.appmesh.Http2ConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
            return this;
        }

        /**
         * Sets the value of {@link Http2VirtualNodeListenerOptions#getHealthCheck}
         * @param healthCheck The health check information for the listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.appmesh.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link Http2VirtualNodeListenerOptions#getOutlierDetection}
         * @param outlierDetection Represents the configuration for enabling outlier detection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outlierDetection(software.amazon.awscdk.services.appmesh.OutlierDetection outlierDetection) {
            this.outlierDetection = outlierDetection;
            return this;
        }

        /**
         * Sets the value of {@link Http2VirtualNodeListenerOptions#getPort}
         * @param port Port to listen for connections on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link Http2VirtualNodeListenerOptions#getTimeout}
         * @param timeout Timeout for HTTP protocol.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.services.appmesh.HttpTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link Http2VirtualNodeListenerOptions#getTls}
         * @param tls Represents the configuration for enabling TLS on a listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tls(software.amazon.awscdk.services.appmesh.ListenerTlsOptions tls) {
            this.tls = tls;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Http2VirtualNodeListenerOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Http2VirtualNodeListenerOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Http2VirtualNodeListenerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Http2VirtualNodeListenerOptions {
        private final software.amazon.awscdk.services.appmesh.Http2ConnectionPool connectionPool;
        private final software.amazon.awscdk.services.appmesh.HealthCheck healthCheck;
        private final software.amazon.awscdk.services.appmesh.OutlierDetection outlierDetection;
        private final java.lang.Number port;
        private final software.amazon.awscdk.services.appmesh.HttpTimeout timeout;
        private final software.amazon.awscdk.services.appmesh.ListenerTlsOptions tls;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectionPool = software.amazon.jsii.Kernel.get(this, "connectionPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.Http2ConnectionPool.class));
            this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HealthCheck.class));
            this.outlierDetection = software.amazon.jsii.Kernel.get(this, "outlierDetection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.OutlierDetection.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpTimeout.class));
            this.tls = software.amazon.jsii.Kernel.get(this, "tls", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ListenerTlsOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectionPool = builder.connectionPool;
            this.healthCheck = builder.healthCheck;
            this.outlierDetection = builder.outlierDetection;
            this.port = builder.port;
            this.timeout = builder.timeout;
            this.tls = builder.tls;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.Http2ConnectionPool getConnectionPool() {
            return this.connectionPool;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.OutlierDetection getOutlierDetection() {
            return this.outlierDetection;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.HttpTimeout getTimeout() {
            return this.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.ListenerTlsOptions getTls() {
            return this.tls;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConnectionPool() != null) {
                data.set("connectionPool", om.valueToTree(this.getConnectionPool()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getOutlierDetection() != null) {
                data.set("outlierDetection", om.valueToTree(this.getOutlierDetection()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getTls() != null) {
                data.set("tls", om.valueToTree(this.getTls()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.Http2VirtualNodeListenerOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Http2VirtualNodeListenerOptions.Jsii$Proxy that = (Http2VirtualNodeListenerOptions.Jsii$Proxy) o;

            if (this.connectionPool != null ? !this.connectionPool.equals(that.connectionPool) : that.connectionPool != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.outlierDetection != null ? !this.outlierDetection.equals(that.outlierDetection) : that.outlierDetection != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.tls != null ? this.tls.equals(that.tls) : that.tls == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectionPool != null ? this.connectionPool.hashCode() : 0;
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.outlierDetection != null ? this.outlierDetection.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.tls != null ? this.tls.hashCode() : 0);
            return result;
        }
    }
}
