package software.amazon.awscdk.services.apigatewayv2;

/**
 * A CloudFormation `AWS::ApiGatewayV2::Api`.
 * <p>
 * The <code>AWS::ApiGatewayV2::Api</code> resource creates an API. WebSocket APIs and HTTP APIs are supported. For more information about WebSocket APIs, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-overview.html">About WebSocket APIs in API Gateway</a> in the <em>API Gateway Developer Guide</em> . For more information about HTTP APIs, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api.html">HTTP APIs</a> in the <em>API Gateway Developer Guide.</em>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * Object body;
 * Object tags;
 * CfnApi cfnApi = CfnApi.Builder.create(this, "MyCfnApi")
 *         .apiKeySelectionExpression("apiKeySelectionExpression")
 *         .basePath("basePath")
 *         .body(body)
 *         .bodyS3Location(BodyS3LocationProperty.builder()
 *                 .bucket("bucket")
 *                 .etag("etag")
 *                 .key("key")
 *                 .version("version")
 *                 .build())
 *         .corsConfiguration(CorsProperty.builder()
 *                 .allowCredentials(false)
 *                 .allowHeaders(List.of("allowHeaders"))
 *                 .allowMethods(List.of("allowMethods"))
 *                 .allowOrigins(List.of("allowOrigins"))
 *                 .exposeHeaders(List.of("exposeHeaders"))
 *                 .maxAge(123)
 *                 .build())
 *         .credentialsArn("credentialsArn")
 *         .description("description")
 *         .disableExecuteApiEndpoint(false)
 *         .disableSchemaValidation(false)
 *         .failOnWarnings(false)
 *         .name("name")
 *         .protocolType("protocolType")
 *         .routeKey("routeKey")
 *         .routeSelectionExpression("routeSelectionExpression")
 *         .tags(tags)
 *         .target("target")
 *         .version("version")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.183Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnApi")
public class CfnApi extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.CfnApi.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ApiGatewayV2::Api`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.CfnApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::ApiGatewayV2::Api`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The default endpoint for an API.
     * <p>
     * For example: <code>https://abcdef.execute-api.us-west-2.amazonaws.com</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrApiEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrApiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The collection of tags.
     * <p>
     * Each tag element is associated with a given resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The OpenAPI definition.
     * <p>
     * Supported only for HTTP APIs. To import an HTTP API, you must specify a <code>Body</code> or <code>BodyS3Location</code> . If you specify a <code>Body</code> or <code>BodyS3Location</code> , don't specify CloudFormation resources such as <code>AWS::ApiGatewayV2::Authorizer</code> or <code>AWS::ApiGatewayV2::Route</code> . API Gateway doesn't support the combination of OpenAPI and CloudFormation resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getBody() {
        return software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The OpenAPI definition.
     * <p>
     * Supported only for HTTP APIs. To import an HTTP API, you must specify a <code>Body</code> or <code>BodyS3Location</code> . If you specify a <code>Body</code> or <code>BodyS3Location</code> , don't specify CloudFormation resources such as <code>AWS::ApiGatewayV2::Authorizer</code> or <code>AWS::ApiGatewayV2::Route</code> . API Gateway doesn't support the combination of OpenAPI and CloudFormation resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBody(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "body", java.util.Objects.requireNonNull(value, "body is required"));
    }

    /**
     * An API key selection expression.
     * <p>
     * Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApiKeySelectionExpression() {
        return software.amazon.jsii.Kernel.get(this, "apiKeySelectionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An API key selection expression.
     * <p>
     * Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiKeySelectionExpression(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "apiKeySelectionExpression", value);
    }

    /**
     * Specifies how to interpret the base path of the API during import.
     * <p>
     * Valid values are <code>ignore</code> , <code>prepend</code> , and <code>split</code> . The default value is <code>ignore</code> . To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a> . Supported only for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBasePath() {
        return software.amazon.jsii.Kernel.get(this, "basePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies how to interpret the base path of the API during import.
     * <p>
     * Valid values are <code>ignore</code> , <code>prepend</code> , and <code>split</code> . The default value is <code>ignore</code> . To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a> . Supported only for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBasePath(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "basePath", value);
    }

    /**
     * The S3 location of an OpenAPI definition.
     * <p>
     * Supported only for HTTP APIs. To import an HTTP API, you must specify a <code>Body</code> or <code>BodyS3Location</code> . If you specify a <code>Body</code> or <code>BodyS3Location</code> , don't specify CloudFormation resources such as <code>AWS::ApiGatewayV2::Authorizer</code> or <code>AWS::ApiGatewayV2::Route</code> . API Gateway doesn't support the combination of OpenAPI and CloudFormation resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBodyS3Location() {
        return software.amazon.jsii.Kernel.get(this, "bodyS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The S3 location of an OpenAPI definition.
     * <p>
     * Supported only for HTTP APIs. To import an HTTP API, you must specify a <code>Body</code> or <code>BodyS3Location</code> . If you specify a <code>Body</code> or <code>BodyS3Location</code> , don't specify CloudFormation resources such as <code>AWS::ApiGatewayV2::Authorizer</code> or <code>AWS::ApiGatewayV2::Route</code> . API Gateway doesn't support the combination of OpenAPI and CloudFormation resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBodyS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.CfnApi.BodyS3LocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "bodyS3Location", value);
    }

    /**
     * The S3 location of an OpenAPI definition.
     * <p>
     * Supported only for HTTP APIs. To import an HTTP API, you must specify a <code>Body</code> or <code>BodyS3Location</code> . If you specify a <code>Body</code> or <code>BodyS3Location</code> , don't specify CloudFormation resources such as <code>AWS::ApiGatewayV2::Authorizer</code> or <code>AWS::ApiGatewayV2::Route</code> . API Gateway doesn't support the combination of OpenAPI and CloudFormation resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBodyS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "bodyS3Location", value);
    }

    /**
     * A CORS configuration.
     * <p>
     * Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCorsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "corsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A CORS configuration.
     * <p>
     * Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCorsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.CfnApi.CorsProperty value) {
        software.amazon.jsii.Kernel.set(this, "corsConfiguration", value);
    }

    /**
     * A CORS configuration.
     * <p>
     * Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCorsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "corsConfiguration", value);
    }

    /**
     * This property is part of quick create.
     * <p>
     * It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify <code>arn:aws:iam::*:user/*</code> . To use resource-based permissions on supported AWS services, specify <code>null</code> . Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCredentialsArn() {
        return software.amazon.jsii.Kernel.get(this, "credentialsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This property is part of quick create.
     * <p>
     * It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify <code>arn:aws:iam::*:user/*</code> . To use resource-based permissions on supported AWS services, specify <code>null</code> . Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCredentialsArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "credentialsArn", value);
    }

    /**
     * The description of the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies whether clients can invoke your API by using the default `execute-api` endpoint.
     * <p>
     * By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDisableExecuteApiEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "disableExecuteApiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether clients can invoke your API by using the default `execute-api` endpoint.
     * <p>
     * By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableExecuteApiEndpoint(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "disableExecuteApiEndpoint", value);
    }

    /**
     * Specifies whether clients can invoke your API by using the default `execute-api` endpoint.
     * <p>
     * By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableExecuteApiEndpoint(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "disableExecuteApiEndpoint", value);
    }

    /**
     * Avoid validating models when creating a deployment.
     * <p>
     * Supported only for WebSocket APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDisableSchemaValidation() {
        return software.amazon.jsii.Kernel.get(this, "disableSchemaValidation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Avoid validating models when creating a deployment.
     * <p>
     * Supported only for WebSocket APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableSchemaValidation(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "disableSchemaValidation", value);
    }

    /**
     * Avoid validating models when creating a deployment.
     * <p>
     * Supported only for WebSocket APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableSchemaValidation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "disableSchemaValidation", value);
    }

    /**
     * Specifies whether to rollback the API creation when a warning is encountered.
     * <p>
     * By default, API creation continues if a warning is encountered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFailOnWarnings() {
        return software.amazon.jsii.Kernel.get(this, "failOnWarnings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to rollback the API creation when a warning is encountered.
     * <p>
     * By default, API creation continues if a warning is encountered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailOnWarnings(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "failOnWarnings", value);
    }

    /**
     * Specifies whether to rollback the API creation when a warning is encountered.
     * <p>
     * By default, API creation continues if a warning is encountered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailOnWarnings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "failOnWarnings", value);
    }

    /**
     * The name of the API.
     * <p>
     * Required unless you specify an OpenAPI definition for <code>Body</code> or <code>S3BodyLocation</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the API.
     * <p>
     * Required unless you specify an OpenAPI definition for <code>Body</code> or <code>S3BodyLocation</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The API protocol.
     * <p>
     * Valid values are <code>WEBSOCKET</code> or <code>HTTP</code> . Required unless you specify an OpenAPI definition for <code>Body</code> or <code>S3BodyLocation</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProtocolType() {
        return software.amazon.jsii.Kernel.get(this, "protocolType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The API protocol.
     * <p>
     * Valid values are <code>WEBSOCKET</code> or <code>HTTP</code> . Required unless you specify an OpenAPI definition for <code>Body</code> or <code>S3BodyLocation</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocolType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "protocolType", value);
    }

    /**
     * This property is part of quick create.
     * <p>
     * If you don't specify a <code>routeKey</code> , a default route of <code>$default</code> is created. The <code>$default</code> route acts as a catch-all for any request made to your API, for a particular stage. The <code>$default</code> route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRouteKey() {
        return software.amazon.jsii.Kernel.get(this, "routeKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This property is part of quick create.
     * <p>
     * If you don't specify a <code>routeKey</code> , a default route of <code>$default</code> is created. The <code>$default</code> route acts as a catch-all for any request made to your API, for a particular stage. The <code>$default</code> route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRouteKey(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "routeKey", value);
    }

    /**
     * The route selection expression for the API.
     * <p>
     * For HTTP APIs, the <code>routeSelectionExpression</code> must be <code>${request.method} ${request.path}</code> . If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRouteSelectionExpression() {
        return software.amazon.jsii.Kernel.get(this, "routeSelectionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The route selection expression for the API.
     * <p>
     * For HTTP APIs, the <code>routeSelectionExpression</code> must be <code>${request.method} ${request.path}</code> . If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRouteSelectionExpression(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "routeSelectionExpression", value);
    }

    /**
     * This property is part of quick create.
     * <p>
     * Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTarget() {
        return software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This property is part of quick create.
     * <p>
     * Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTarget(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "target", value);
    }

    /**
     * A version identifier for the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A version identifier for the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "version", value);
    }
    /**
     * The `BodyS3Location` property specifies an S3 location from which to import an OpenAPI definition.
     * <p>
     * Supported only for HTTP APIs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigatewayv2.*;
     * BodyS3LocationProperty bodyS3LocationProperty = BodyS3LocationProperty.builder()
     *         .bucket("bucket")
     *         .etag("etag")
     *         .key("key")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnApi.BodyS3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(BodyS3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BodyS3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 bucket that contains the OpenAPI definition to import.
         * <p>
         * Required if you specify a <code>BodyS3Location</code> for an API.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucket() {
            return null;
        }

        /**
         * The Etag of the S3 object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEtag() {
            return null;
        }

        /**
         * The key of the S3 object.
         * <p>
         * Required if you specify a <code>BodyS3Location</code> for an API.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The version of the S3 object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BodyS3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BodyS3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BodyS3LocationProperty> {
            java.lang.String bucket;
            java.lang.String etag;
            java.lang.String key;
            java.lang.String version;

            /**
             * Sets the value of {@link BodyS3LocationProperty#getBucket}
             * @param bucket The S3 bucket that contains the OpenAPI definition to import.
             *               Required if you specify a <code>BodyS3Location</code> for an API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link BodyS3LocationProperty#getEtag}
             * @param etag The Etag of the S3 object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder etag(java.lang.String etag) {
                this.etag = etag;
                return this;
            }

            /**
             * Sets the value of {@link BodyS3LocationProperty#getKey}
             * @param key The key of the S3 object.
             *            Required if you specify a <code>BodyS3Location</code> for an API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link BodyS3LocationProperty#getVersion}
             * @param version The version of the S3 object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BodyS3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BodyS3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BodyS3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BodyS3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String etag;
            private final java.lang.String key;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.etag = software.amazon.jsii.Kernel.get(this, "etag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = builder.bucket;
                this.etag = builder.etag;
                this.key = builder.key;
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getEtag() {
                return this.etag;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucket() != null) {
                    data.set("bucket", om.valueToTree(this.getBucket()));
                }
                if (this.getEtag() != null) {
                    data.set("etag", om.valueToTree(this.getEtag()));
                }
                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnApi.BodyS3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BodyS3LocationProperty.Jsii$Proxy that = (BodyS3LocationProperty.Jsii$Proxy) o;

                if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
                if (this.etag != null ? !this.etag.equals(that.etag) : that.etag != null) return false;
                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket != null ? this.bucket.hashCode() : 0;
                result = 31 * result + (this.etag != null ? this.etag.hashCode() : 0);
                result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `Cors` property specifies a CORS configuration for an API.
     * <p>
     * Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigatewayv2.*;
     * CorsProperty corsProperty = CorsProperty.builder()
     *         .allowCredentials(false)
     *         .allowHeaders(List.of("allowHeaders"))
     *         .allowMethods(List.of("allowMethods"))
     *         .allowOrigins(List.of("allowOrigins"))
     *         .exposeHeaders(List.of("exposeHeaders"))
     *         .maxAge(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnApi.CorsProperty")
    @software.amazon.jsii.Jsii.Proxy(CorsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CorsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether credentials are included in the CORS request.
         * <p>
         * Supported only for HTTP APIs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowCredentials() {
            return null;
        }

        /**
         * Represents a collection of allowed headers.
         * <p>
         * Supported only for HTTP APIs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowHeaders() {
            return null;
        }

        /**
         * Represents a collection of allowed HTTP methods.
         * <p>
         * Supported only for HTTP APIs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowMethods() {
            return null;
        }

        /**
         * Represents a collection of allowed origins.
         * <p>
         * Supported only for HTTP APIs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowOrigins() {
            return null;
        }

        /**
         * Represents a collection of exposed headers.
         * <p>
         * Supported only for HTTP APIs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExposeHeaders() {
            return null;
        }

        /**
         * The number of seconds that the browser should cache preflight request results.
         * <p>
         * Supported only for HTTP APIs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAge() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CorsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CorsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CorsProperty> {
            java.lang.Object allowCredentials;
            java.util.List<java.lang.String> allowHeaders;
            java.util.List<java.lang.String> allowMethods;
            java.util.List<java.lang.String> allowOrigins;
            java.util.List<java.lang.String> exposeHeaders;
            java.lang.Number maxAge;

            /**
             * Sets the value of {@link CorsProperty#getAllowCredentials}
             * @param allowCredentials Specifies whether credentials are included in the CORS request.
             *                         Supported only for HTTP APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowCredentials(java.lang.Boolean allowCredentials) {
                this.allowCredentials = allowCredentials;
                return this;
            }

            /**
             * Sets the value of {@link CorsProperty#getAllowCredentials}
             * @param allowCredentials Specifies whether credentials are included in the CORS request.
             *                         Supported only for HTTP APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowCredentials(software.amazon.awscdk.IResolvable allowCredentials) {
                this.allowCredentials = allowCredentials;
                return this;
            }

            /**
             * Sets the value of {@link CorsProperty#getAllowHeaders}
             * @param allowHeaders Represents a collection of allowed headers.
             *                     Supported only for HTTP APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowHeaders(java.util.List<java.lang.String> allowHeaders) {
                this.allowHeaders = allowHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsProperty#getAllowMethods}
             * @param allowMethods Represents a collection of allowed HTTP methods.
             *                     Supported only for HTTP APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowMethods(java.util.List<java.lang.String> allowMethods) {
                this.allowMethods = allowMethods;
                return this;
            }

            /**
             * Sets the value of {@link CorsProperty#getAllowOrigins}
             * @param allowOrigins Represents a collection of allowed origins.
             *                     Supported only for HTTP APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowOrigins(java.util.List<java.lang.String> allowOrigins) {
                this.allowOrigins = allowOrigins;
                return this;
            }

            /**
             * Sets the value of {@link CorsProperty#getExposeHeaders}
             * @param exposeHeaders Represents a collection of exposed headers.
             *                      Supported only for HTTP APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exposeHeaders(java.util.List<java.lang.String> exposeHeaders) {
                this.exposeHeaders = exposeHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsProperty#getMaxAge}
             * @param maxAge The number of seconds that the browser should cache preflight request results.
             *               Supported only for HTTP APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxAge(java.lang.Number maxAge) {
                this.maxAge = maxAge;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CorsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CorsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsProperty {
            private final java.lang.Object allowCredentials;
            private final java.util.List<java.lang.String> allowHeaders;
            private final java.util.List<java.lang.String> allowMethods;
            private final java.util.List<java.lang.String> allowOrigins;
            private final java.util.List<java.lang.String> exposeHeaders;
            private final java.lang.Number maxAge;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowCredentials = software.amazon.jsii.Kernel.get(this, "allowCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowHeaders = software.amazon.jsii.Kernel.get(this, "allowHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowMethods = software.amazon.jsii.Kernel.get(this, "allowMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowOrigins = software.amazon.jsii.Kernel.get(this, "allowOrigins", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.exposeHeaders = software.amazon.jsii.Kernel.get(this, "exposeHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.maxAge = software.amazon.jsii.Kernel.get(this, "maxAge", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowCredentials = builder.allowCredentials;
                this.allowHeaders = builder.allowHeaders;
                this.allowMethods = builder.allowMethods;
                this.allowOrigins = builder.allowOrigins;
                this.exposeHeaders = builder.exposeHeaders;
                this.maxAge = builder.maxAge;
            }

            @Override
            public final java.lang.Object getAllowCredentials() {
                return this.allowCredentials;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowHeaders() {
                return this.allowHeaders;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowMethods() {
                return this.allowMethods;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowOrigins() {
                return this.allowOrigins;
            }

            @Override
            public final java.util.List<java.lang.String> getExposeHeaders() {
                return this.exposeHeaders;
            }

            @Override
            public final java.lang.Number getMaxAge() {
                return this.maxAge;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowCredentials() != null) {
                    data.set("allowCredentials", om.valueToTree(this.getAllowCredentials()));
                }
                if (this.getAllowHeaders() != null) {
                    data.set("allowHeaders", om.valueToTree(this.getAllowHeaders()));
                }
                if (this.getAllowMethods() != null) {
                    data.set("allowMethods", om.valueToTree(this.getAllowMethods()));
                }
                if (this.getAllowOrigins() != null) {
                    data.set("allowOrigins", om.valueToTree(this.getAllowOrigins()));
                }
                if (this.getExposeHeaders() != null) {
                    data.set("exposeHeaders", om.valueToTree(this.getExposeHeaders()));
                }
                if (this.getMaxAge() != null) {
                    data.set("maxAge", om.valueToTree(this.getMaxAge()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnApi.CorsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CorsProperty.Jsii$Proxy that = (CorsProperty.Jsii$Proxy) o;

                if (this.allowCredentials != null ? !this.allowCredentials.equals(that.allowCredentials) : that.allowCredentials != null) return false;
                if (this.allowHeaders != null ? !this.allowHeaders.equals(that.allowHeaders) : that.allowHeaders != null) return false;
                if (this.allowMethods != null ? !this.allowMethods.equals(that.allowMethods) : that.allowMethods != null) return false;
                if (this.allowOrigins != null ? !this.allowOrigins.equals(that.allowOrigins) : that.allowOrigins != null) return false;
                if (this.exposeHeaders != null ? !this.exposeHeaders.equals(that.exposeHeaders) : that.exposeHeaders != null) return false;
                return this.maxAge != null ? this.maxAge.equals(that.maxAge) : that.maxAge == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowCredentials != null ? this.allowCredentials.hashCode() : 0;
                result = 31 * result + (this.allowHeaders != null ? this.allowHeaders.hashCode() : 0);
                result = 31 * result + (this.allowMethods != null ? this.allowMethods.hashCode() : 0);
                result = 31 * result + (this.allowOrigins != null ? this.allowOrigins.hashCode() : 0);
                result = 31 * result + (this.exposeHeaders != null ? this.exposeHeaders.hashCode() : 0);
                result = 31 * result + (this.maxAge != null ? this.maxAge.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.CfnApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.CfnApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.apigatewayv2.CfnApiProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * An API key selection expression.
         * <p>
         * Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a> .
         * <p>
         * @return {@code this}
         * @param apiKeySelectionExpression An API key selection expression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeySelectionExpression(final java.lang.String apiKeySelectionExpression) {
            this.props().apiKeySelectionExpression(apiKeySelectionExpression);
            return this;
        }

        /**
         * Specifies how to interpret the base path of the API during import.
         * <p>
         * Valid values are <code>ignore</code> , <code>prepend</code> , and <code>split</code> . The default value is <code>ignore</code> . To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a> . Supported only for HTTP APIs.
         * <p>
         * @return {@code this}
         * @param basePath Specifies how to interpret the base path of the API during import. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder basePath(final java.lang.String basePath) {
            this.props().basePath(basePath);
            return this;
        }

        /**
         * The OpenAPI definition.
         * <p>
         * Supported only for HTTP APIs. To import an HTTP API, you must specify a <code>Body</code> or <code>BodyS3Location</code> . If you specify a <code>Body</code> or <code>BodyS3Location</code> , don't specify CloudFormation resources such as <code>AWS::ApiGatewayV2::Authorizer</code> or <code>AWS::ApiGatewayV2::Route</code> . API Gateway doesn't support the combination of OpenAPI and CloudFormation resources.
         * <p>
         * @return {@code this}
         * @param body The OpenAPI definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder body(final java.lang.Object body) {
            this.props().body(body);
            return this;
        }

        /**
         * The S3 location of an OpenAPI definition.
         * <p>
         * Supported only for HTTP APIs. To import an HTTP API, you must specify a <code>Body</code> or <code>BodyS3Location</code> . If you specify a <code>Body</code> or <code>BodyS3Location</code> , don't specify CloudFormation resources such as <code>AWS::ApiGatewayV2::Authorizer</code> or <code>AWS::ApiGatewayV2::Route</code> . API Gateway doesn't support the combination of OpenAPI and CloudFormation resources.
         * <p>
         * @return {@code this}
         * @param bodyS3Location The S3 location of an OpenAPI definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bodyS3Location(final software.amazon.awscdk.services.apigatewayv2.CfnApi.BodyS3LocationProperty bodyS3Location) {
            this.props().bodyS3Location(bodyS3Location);
            return this;
        }
        /**
         * The S3 location of an OpenAPI definition.
         * <p>
         * Supported only for HTTP APIs. To import an HTTP API, you must specify a <code>Body</code> or <code>BodyS3Location</code> . If you specify a <code>Body</code> or <code>BodyS3Location</code> , don't specify CloudFormation resources such as <code>AWS::ApiGatewayV2::Authorizer</code> or <code>AWS::ApiGatewayV2::Route</code> . API Gateway doesn't support the combination of OpenAPI and CloudFormation resources.
         * <p>
         * @return {@code this}
         * @param bodyS3Location The S3 location of an OpenAPI definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bodyS3Location(final software.amazon.awscdk.IResolvable bodyS3Location) {
            this.props().bodyS3Location(bodyS3Location);
            return this;
        }

        /**
         * A CORS configuration.
         * <p>
         * Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.
         * <p>
         * @return {@code this}
         * @param corsConfiguration A CORS configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(final software.amazon.awscdk.services.apigatewayv2.CfnApi.CorsProperty corsConfiguration) {
            this.props().corsConfiguration(corsConfiguration);
            return this;
        }
        /**
         * A CORS configuration.
         * <p>
         * Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.
         * <p>
         * @return {@code this}
         * @param corsConfiguration A CORS configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(final software.amazon.awscdk.IResolvable corsConfiguration) {
            this.props().corsConfiguration(corsConfiguration);
            return this;
        }

        /**
         * This property is part of quick create.
         * <p>
         * It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify <code>arn:aws:iam::*:user/*</code> . To use resource-based permissions on supported AWS services, specify <code>null</code> . Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.
         * <p>
         * @return {@code this}
         * @param credentialsArn This property is part of quick create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsArn(final java.lang.String credentialsArn) {
            this.props().credentialsArn(credentialsArn);
            return this;
        }

        /**
         * The description of the API.
         * <p>
         * @return {@code this}
         * @param description The description of the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Specifies whether clients can invoke your API by using the default `execute-api` endpoint.
         * <p>
         * By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
         * <p>
         * @return {@code this}
         * @param disableExecuteApiEndpoint Specifies whether clients can invoke your API by using the default `execute-api` endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(final java.lang.Boolean disableExecuteApiEndpoint) {
            this.props().disableExecuteApiEndpoint(disableExecuteApiEndpoint);
            return this;
        }
        /**
         * Specifies whether clients can invoke your API by using the default `execute-api` endpoint.
         * <p>
         * By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
         * <p>
         * @return {@code this}
         * @param disableExecuteApiEndpoint Specifies whether clients can invoke your API by using the default `execute-api` endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(final software.amazon.awscdk.IResolvable disableExecuteApiEndpoint) {
            this.props().disableExecuteApiEndpoint(disableExecuteApiEndpoint);
            return this;
        }

        /**
         * Avoid validating models when creating a deployment.
         * <p>
         * Supported only for WebSocket APIs.
         * <p>
         * @return {@code this}
         * @param disableSchemaValidation Avoid validating models when creating a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableSchemaValidation(final java.lang.Boolean disableSchemaValidation) {
            this.props().disableSchemaValidation(disableSchemaValidation);
            return this;
        }
        /**
         * Avoid validating models when creating a deployment.
         * <p>
         * Supported only for WebSocket APIs.
         * <p>
         * @return {@code this}
         * @param disableSchemaValidation Avoid validating models when creating a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableSchemaValidation(final software.amazon.awscdk.IResolvable disableSchemaValidation) {
            this.props().disableSchemaValidation(disableSchemaValidation);
            return this;
        }

        /**
         * Specifies whether to rollback the API creation when a warning is encountered.
         * <p>
         * By default, API creation continues if a warning is encountered.
         * <p>
         * @return {@code this}
         * @param failOnWarnings Specifies whether to rollback the API creation when a warning is encountered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(final java.lang.Boolean failOnWarnings) {
            this.props().failOnWarnings(failOnWarnings);
            return this;
        }
        /**
         * Specifies whether to rollback the API creation when a warning is encountered.
         * <p>
         * By default, API creation continues if a warning is encountered.
         * <p>
         * @return {@code this}
         * @param failOnWarnings Specifies whether to rollback the API creation when a warning is encountered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(final software.amazon.awscdk.IResolvable failOnWarnings) {
            this.props().failOnWarnings(failOnWarnings);
            return this;
        }

        /**
         * The name of the API.
         * <p>
         * Required unless you specify an OpenAPI definition for <code>Body</code> or <code>S3BodyLocation</code> .
         * <p>
         * @return {@code this}
         * @param name The name of the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The API protocol.
         * <p>
         * Valid values are <code>WEBSOCKET</code> or <code>HTTP</code> . Required unless you specify an OpenAPI definition for <code>Body</code> or <code>S3BodyLocation</code> .
         * <p>
         * @return {@code this}
         * @param protocolType The API protocol. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolType(final java.lang.String protocolType) {
            this.props().protocolType(protocolType);
            return this;
        }

        /**
         * This property is part of quick create.
         * <p>
         * If you don't specify a <code>routeKey</code> , a default route of <code>$default</code> is created. The <code>$default</code> route acts as a catch-all for any request made to your API, for a particular stage. The <code>$default</code> route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.
         * <p>
         * @return {@code this}
         * @param routeKey This property is part of quick create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeKey(final java.lang.String routeKey) {
            this.props().routeKey(routeKey);
            return this;
        }

        /**
         * The route selection expression for the API.
         * <p>
         * For HTTP APIs, the <code>routeSelectionExpression</code> must be <code>${request.method} ${request.path}</code> . If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.
         * <p>
         * @return {@code this}
         * @param routeSelectionExpression The route selection expression for the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeSelectionExpression(final java.lang.String routeSelectionExpression) {
            this.props().routeSelectionExpression(routeSelectionExpression);
            return this;
        }

        /**
         * The collection of tags.
         * <p>
         * Each tag element is associated with a given resource.
         * <p>
         * @return {@code this}
         * @param tags The collection of tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * This property is part of quick create.
         * <p>
         * Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.
         * <p>
         * @return {@code this}
         * @param target This property is part of quick create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final java.lang.String target) {
            this.props().target(target);
            return this;
        }

        /**
         * A version identifier for the API.
         * <p>
         * @return {@code this}
         * @param version A version identifier for the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(final java.lang.String version) {
            this.props().version(version);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.CfnApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.CfnApi build() {
            return new software.amazon.awscdk.services.apigatewayv2.CfnApi(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigatewayv2.CfnApiProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigatewayv2.CfnApiProps.Builder();
            }
            return this.props;
        }
    }
}
