package software.amazon.awscdk.assertions;

/**
 * Suite of assertions that can be run on a CDK stack.
 * <p>
 * Typically used, as part of unit tests, to validate that the rendered
 * CloudFormation template has expected resources and properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.Stack;
 * import software.amazon.awscdk.assertions.Template;
 * Stack stack = new Stack();
 * // ...
 * Template template = Template.fromStack(stack);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:06.925Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.assertions.Template")
public class Template extends software.amazon.jsii.JsiiObject {

    protected Template(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Template(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Base your assertions from an existing CloudFormation template formatted as an in-memory JSON object.
     * <p>
     * @param template the CloudFormation template formatted as a nested set of records. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Template fromJSON(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends java.lang.Object> template) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Template.class, "fromJSON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Template.class), new Object[] { java.util.Objects.requireNonNull(template, "template is required") });
    }

    /**
     * Base your assertions on the CloudFormation template synthesized by a CDK `Stack`.
     * <p>
     * @param stack the CDK Stack to run assertions on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Template fromStack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Template.class, "fromStack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Template.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Base your assertions from an existing CloudFormation template formatted as a JSON string.
     * <p>
     * @param template the CloudFormation template in. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Template fromString(final @org.jetbrains.annotations.NotNull java.lang.String template) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Template.class, "fromString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Template.class), new Object[] { java.util.Objects.requireNonNull(template, "template is required") });
    }

    /**
     * Get the set of matching Conditions that match the given properties in the CloudFormation template.
     * <p>
     * @param logicalId the name of the condition. This parameter is required.
     * @param props by default, matches all Conditions in the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> findConditions(final @org.jetbrains.annotations.NotNull java.lang.String logicalId, final @org.jetbrains.annotations.Nullable java.lang.Object props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "findConditions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))), new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required"), props }));
    }

    /**
     * Get the set of matching Conditions that match the given properties in the CloudFormation template.
     * <p>
     * @param logicalId the name of the condition. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> findConditions(final @org.jetbrains.annotations.NotNull java.lang.String logicalId) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "findConditions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))), new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required") }));
    }

    /**
     * Get the set of matching Mappings that match the given properties in the CloudFormation template.
     * <p>
     * @param logicalId the name of the mapping. This parameter is required.
     * @param props by default, matches all Mappings in the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> findMappings(final @org.jetbrains.annotations.NotNull java.lang.String logicalId, final @org.jetbrains.annotations.Nullable java.lang.Object props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "findMappings", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))), new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required"), props }));
    }

    /**
     * Get the set of matching Mappings that match the given properties in the CloudFormation template.
     * <p>
     * @param logicalId the name of the mapping. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> findMappings(final @org.jetbrains.annotations.NotNull java.lang.String logicalId) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "findMappings", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))), new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required") }));
    }

    /**
     * Get the set of matching Outputs that match the given properties in the CloudFormation template.
     * <p>
     * @param logicalId the name of the output. This parameter is required.
     * @param props by default, matches all Outputs in the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> findOutputs(final @org.jetbrains.annotations.NotNull java.lang.String logicalId, final @org.jetbrains.annotations.Nullable java.lang.Object props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "findOutputs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))), new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required"), props }));
    }

    /**
     * Get the set of matching Outputs that match the given properties in the CloudFormation template.
     * <p>
     * @param logicalId the name of the output. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> findOutputs(final @org.jetbrains.annotations.NotNull java.lang.String logicalId) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "findOutputs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))), new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required") }));
    }

    /**
     * Get the set of matching Parameters that match the given properties in the CloudFormation template.
     * <p>
     * @param logicalId the name of the parameter. This parameter is required.
     * @param props by default, matches all Parameters in the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> findParameters(final @org.jetbrains.annotations.NotNull java.lang.String logicalId, final @org.jetbrains.annotations.Nullable java.lang.Object props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "findParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))), new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required"), props }));
    }

    /**
     * Get the set of matching Parameters that match the given properties in the CloudFormation template.
     * <p>
     * @param logicalId the name of the parameter. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> findParameters(final @org.jetbrains.annotations.NotNull java.lang.String logicalId) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "findParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))), new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required") }));
    }

    /**
     * Get the set of matching resources of a given type and properties in the CloudFormation template.
     * <p>
     * @param type the type to match in the CloudFormation template. This parameter is required.
     * @param props by default, matches all resources with the given type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> findResources(final @org.jetbrains.annotations.NotNull java.lang.String type, final @org.jetbrains.annotations.Nullable java.lang.Object props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "findResources", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))), new Object[] { java.util.Objects.requireNonNull(type, "type is required"), props }));
    }

    /**
     * Get the set of matching resources of a given type and properties in the CloudFormation template.
     * <p>
     * @param type the type to match in the CloudFormation template. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> findResources(final @org.jetbrains.annotations.NotNull java.lang.String type) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "findResources", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))), new Object[] { java.util.Objects.requireNonNull(type, "type is required") }));
    }

    /**
     * Assert that a Condition with the given properties exists in the CloudFormation template.
     * <p>
     * By default, performs partial matching on the resource, via the <code>Match.objectLike()</code>.
     * To configure different behavour, use other matchers in the <code>Match</code> class.
     * <p>
     * @param logicalId the name of the mapping. This parameter is required.
     * @param props the output as should be expected in the template. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void hasCondition(final @org.jetbrains.annotations.NotNull java.lang.String logicalId, final @org.jetbrains.annotations.NotNull java.lang.Object props) {
        software.amazon.jsii.Kernel.call(this, "hasCondition", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required"), props });
    }

    /**
     * Assert that a Mapping with the given properties exists in the CloudFormation template.
     * <p>
     * By default, performs partial matching on the resource, via the <code>Match.objectLike()</code>.
     * To configure different behavour, use other matchers in the <code>Match</code> class.
     * <p>
     * @param logicalId the name of the mapping. This parameter is required.
     * @param props the output as should be expected in the template. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void hasMapping(final @org.jetbrains.annotations.NotNull java.lang.String logicalId, final @org.jetbrains.annotations.NotNull java.lang.Object props) {
        software.amazon.jsii.Kernel.call(this, "hasMapping", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required"), props });
    }

    /**
     * Assert that an Output with the given properties exists in the CloudFormation template.
     * <p>
     * By default, performs partial matching on the resource, via the <code>Match.objectLike()</code>.
     * To configure different behavour, use other matchers in the <code>Match</code> class.
     * <p>
     * @param logicalId the name of the output. This parameter is required.
     * @param props the output as should be expected in the template. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void hasOutput(final @org.jetbrains.annotations.NotNull java.lang.String logicalId, final @org.jetbrains.annotations.NotNull java.lang.Object props) {
        software.amazon.jsii.Kernel.call(this, "hasOutput", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required"), props });
    }

    /**
     * Assert that a Parameter with the given properties exists in the CloudFormation template.
     * <p>
     * By default, performs partial matching on the parameter, via the <code>Match.objectLike()</code>.
     * To configure different behavior, use other matchers in the <code>Match</code> class.
     * <p>
     * @param logicalId the name of the parameter. This parameter is required.
     * @param props the parameter as should be expected in the template. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void hasParameter(final @org.jetbrains.annotations.NotNull java.lang.String logicalId, final @org.jetbrains.annotations.NotNull java.lang.Object props) {
        software.amazon.jsii.Kernel.call(this, "hasParameter", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required"), props });
    }

    /**
     * Assert that a resource of the given type and given definition exists in the CloudFormation template.
     * <p>
     * By default, performs partial matching on the resource, via the <code>Match.objectLike()</code>.
     * To configure different behavour, use other matchers in the <code>Match</code> class.
     * <p>
     * @param type the resource type;. This parameter is required.
     * @param props the entire defintion of the resource as should be expected in the template. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void hasResource(final @org.jetbrains.annotations.NotNull java.lang.String type, final @org.jetbrains.annotations.NotNull java.lang.Object props) {
        software.amazon.jsii.Kernel.call(this, "hasResource", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(type, "type is required"), props });
    }

    /**
     * Assert that a resource of the given type and properties exists in the CloudFormation template.
     * <p>
     * By default, performs partial matching on the <code>Properties</code> key of the resource, via the
     * <code>Match.objectLike()</code>. To configure different behavour, use other matchers in the <code>Match</code> class.
     * <p>
     * @param type the resource type;. This parameter is required.
     * @param props the 'Properties' section of the resource as should be expected in the template. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void hasResourceProperties(final @org.jetbrains.annotations.NotNull java.lang.String type, final @org.jetbrains.annotations.NotNull java.lang.Object props) {
        software.amazon.jsii.Kernel.call(this, "hasResourceProperties", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(type, "type is required"), props });
    }

    /**
     * Assert that the given number of resources of the given type exist in the template.
     * <p>
     * @param type the resource type;. This parameter is required.
     * @param count number of expected instances. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void resourceCountIs(final @org.jetbrains.annotations.NotNull java.lang.String type, final @org.jetbrains.annotations.NotNull java.lang.Number count) {
        software.amazon.jsii.Kernel.call(this, "resourceCountIs", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(type, "type is required"), java.util.Objects.requireNonNull(count, "count is required") });
    }

    /**
     * Assert that the CloudFormation template matches the given value.
     * <p>
     * @param expected the expected CloudFormation template as key-value pairs. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void templateMatches(final @org.jetbrains.annotations.NotNull java.lang.Object expected) {
        software.amazon.jsii.Kernel.call(this, "templateMatches", software.amazon.jsii.NativeType.VOID, new Object[] { expected });
    }

    /**
     * The CloudFormation template deserialized into an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> toJSON() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }
}
