/*
 * Decompiled with CFR 0.152.
 */
package org.apache.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.util.NSStack;
import org.apache.util.QName;

public class XMLPrinter2 {
    public static final int OPENING = 0;
    public static final int CLOSING = 1;
    public static final int NO_CONTENT = 2;
    protected StringBuffer buffer = new StringBuffer();
    protected Writer writer = null;
    protected NSStack stack = new NSStack();

    public XMLPrinter2() {
    }

    public XMLPrinter2(Writer writer) {
        this.writer = writer;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void writeProperty(QName name, String value, boolean cdata) {
        this.writeElement(name, 0);
        if (cdata) {
            this.writeData(value);
        } else {
            this.writeText(value);
        }
        this.writeElement(name, 1);
    }

    public void writeProperty(QName name, String value) {
        this.writeProperty(name, value, false);
    }

    public void writeProperty(QName name) {
        this.writeElement(name, 2);
    }

    public void writeElement(QName name, int type) {
        this.writeElement(name, type, null);
    }

    public void addNSDeclaration(String prefix, String URI) {
        this.stack.addNSDeclaration(prefix, URI);
    }

    public String addNSDeclaration(String URI) {
        return this.stack.addNSDeclaration(URI);
    }

    public void writeElement(QName name, int type, String[] additionalNamespaceURIs) {
        switch (type) {
            case 0: {
                String xmlns1 = this.stack.getXmlns();
                this.stack.pushScope();
                String prefix = this.addNSDeclaration(name.getNamespaceURI());
                if (additionalNamespaceURIs != null) {
                    int i = 0;
                    while (i < additionalNamespaceURIs.length) {
                        this.addNSDeclaration(additionalNamespaceURIs[i]);
                        ++i;
                    }
                }
                String xmlns2 = this.stack.getXmlns();
                this.stack.pushScope();
                String localName = name.getLocalName();
                String xmlns = xmlns1 + xmlns2;
                this.buffer.append("<" + prefix + ":" + localName + xmlns + ">");
                break;
            }
            case 1: {
                String prefix = this.addNSDeclaration(name.getNamespaceURI());
                String localName = name.getLocalName();
                this.buffer.append("</" + prefix + ":" + localName + ">");
                this.stack.popScope();
                this.stack.popScope();
                break;
            }
            default: {
                String xmlns1 = this.stack.getXmlns();
                this.stack.pushScope();
                String prefix = this.addNSDeclaration(name.getNamespaceURI());
                String xmlns2 = this.stack.getXmlns();
                String localName = name.getLocalName();
                String xmlns = xmlns1 + xmlns2;
                this.buffer.append("<" + prefix + ":" + localName + xmlns + "/>");
                this.stack.popScope();
            }
        }
    }

    public void writeText(String text) {
        this.buffer.append(text);
    }

    public void writeData(String data) {
        this.buffer.append("<![CDATA[");
        this.buffer.append(data);
        this.buffer.append("]]>");
    }

    public void writeXMLHeader() {
        this.buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
    }

    public void sendData() throws IOException {
        if (this.writer != null) {
            this.writer.write(this.buffer.toString());
            this.buffer = new StringBuffer();
        }
    }
}

