/*
 * Decompiled with CFR 0.152.
 */
package shadow.de.vandermeer.skb.interfaces.strategies.collections.set;

import java.util.Collection;
import java.util.HashSet;
import shadow.de.vandermeer.skb.interfaces.strategies.collections.IsSetStrategy;

public interface HashSetStrategy<T>
extends IsSetStrategy<HashSet<T>, T> {
    @Override
    default public HashSet<T> get(Collection<T> collection) {
        if (collection == null) {
            return new HashSet();
        }
        return new HashSet<T>(collection);
    }

    @Override
    default public HashSet<T> get() {
        return new HashSet();
    }

    public static <T> HashSetStrategy<T> create() {
        return new HashSetStrategy<T>(){};
    }
}

