/*
 * Decompiled with CFR 0.152.
 */
package shadow.de.vandermeer.skb.interfaces.messagesets;

import java.util.LinkedHashSet;
import java.util.Set;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.Validate;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.text.StrBuilder;
import se.bjurr.violations.violationsgitlib.org.slf4j.helpers.FormattingTuple;
import se.bjurr.violations.violationsgitlib.org.slf4j.helpers.MessageFormatter;
import shadow.de.vandermeer.skb.interfaces.messagesets.IsWarningSet;

public interface IsWarningSetFT
extends IsWarningSet<FormattingTuple> {
    default public void addAllWarnings(IsWarningSetFT warnings) {
        this.getWarningMessages().addAll(warnings.getWarningMessages());
    }

    default public void addError(String warning) {
        Validate.notBlank(warning);
        this.addWarning(MessageFormatter.arrayFormat(warning, new Object[0]));
    }

    default public void addError(String warning, Object ... obj) {
        Validate.notBlank(warning);
        Validate.notNull(obj);
        Validate.noNullElements(obj);
        this.addWarning(MessageFormatter.arrayFormat(warning, obj));
    }

    @Override
    default public String render() {
        StrBuilder ret = new StrBuilder(100);
        for (FormattingTuple ft : this.getWarningMessages()) {
            ret.append(ft.getMessage()).appendNewLine();
        }
        return ret.toString();
    }

    public static IsWarningSetFT create() {
        return new IsWarningSetFT(){
            final Set<FormattingTuple> warningSet = new LinkedHashSet<FormattingTuple>();

            @Override
            public Set<FormattingTuple> getWarningMessages() {
                return this.warningSet;
            }
        };
    }
}

