/*
 * Decompiled with CFR 0.152.
 */
package shadow.de.vandermeer.asciithemes;

import java.lang.constant.Constable;
import java.util.ArrayList;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.text.StrBuilder;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.tuple.Pair;
import shadow.de.vandermeer.asciithemes.TA_GridOptions;

public final class TA_GridHelpers {
    static int[][] topRule = new int[][]{{1, 10}, {2, 12}, {4, 14}, {8, 6}};
    static int[][] midRule = new int[][]{{256, 11}, {512, 12}, {1024, 15}, {2048, 7}};
    static int[][] bottomRule = new int[][]{{16, 9}, {32, 12}, {64, 13}, {128, 5}};

    public static void addRule(int[][] type, int mode, int rowtype, ArrayList<Integer> columns, ArrayList<ArrayList<Object>> frame) {
        ArrayList<Integer> al = new ArrayList<Integer>();
        if (TA_GridOptions.testOption(type[0][0], mode)) {
            al.add(type[0][1] | rowtype);
        } else if (TA_GridOptions.optionNeeded(type[0][0], mode)) {
            al.add(0 | rowtype);
        }
        for (int k = 0; k < columns.size(); ++k) {
            for (int l = 0; l < columns.get(k); ++l) {
                if (TA_GridOptions.testOption(type[1][0], mode)) {
                    al.add(type[1][1] | rowtype);
                    continue;
                }
                if (!TA_GridOptions.optionNeeded(type[1][0], mode)) continue;
                al.add(0 | rowtype);
            }
            if (k >= columns.size() - 1) continue;
            if (TA_GridOptions.testOption(type[2][0], mode)) {
                al.add(type[2][1] | rowtype);
                continue;
            }
            if (!TA_GridOptions.optionNeeded(type[2][0], mode)) continue;
            al.add(0 | rowtype);
        }
        if (TA_GridOptions.testOption(type[3][0], mode)) {
            al.add(type[3][1] | rowtype);
        } else if (TA_GridOptions.optionNeeded(type[3][0], mode)) {
            al.add(0 | rowtype);
        }
        if (al.size() > 0) {
            frame.add(al);
        }
    }

    public static void addContentRow(String[][] ar, int mode, int rowtype, ArrayList<ArrayList<Object>> frame) {
        for (int k = 0; k < ar.length; ++k) {
            ArrayList<Constable> al = new ArrayList<Constable>();
            if (TA_GridOptions.testOption(4096, mode)) {
                al.add(Integer.valueOf(3 | rowtype));
            } else if (TA_GridOptions.optionNeeded(4096, mode)) {
                al.add(Integer.valueOf(0 | rowtype));
            }
            for (int l = 0; l < ar[k].length; ++l) {
                if (ar[k][l] == null) continue;
                for (char c : ar[k][l].toCharArray()) {
                    al.add(Character.valueOf(c));
                }
                if (l >= ar[k].length - 1) continue;
                if (TA_GridOptions.testOption(8192, mode)) {
                    al.add(Integer.valueOf(3 | rowtype));
                    continue;
                }
                if (!TA_GridOptions.optionNeeded(8192, mode)) continue;
                al.add(Integer.valueOf(0 | rowtype));
            }
            if (TA_GridOptions.testOption(16384, mode)) {
                al.add(Integer.valueOf(3 | rowtype));
            } else if (TA_GridOptions.optionNeeded(16384, mode)) {
                al.add(Integer.valueOf(0 | rowtype));
            }
            if (al.size() <= 0) continue;
            frame.add(al);
        }
    }

    public static int adjustBorder(int postype, int v, int h, int mode, ArrayList<ArrayList<Object>> frame) {
        int vsize = frame.size() - 1;
        int hsize = frame.get(v).size() - 1;
        if (v > 0) {
            if (frame.get(v - 1).get(h) instanceof Character) {
                postype &= 0xFFFFFFFE;
            } else if (frame.get(v - 1).get(h) instanceof Integer && TA_GridHelpers.hasType(postype)) {
                postype |= 1;
            }
        }
        if (v < vsize) {
            if (frame.get(v + 1).get(h) instanceof Character) {
                postype &= 0xFFFFFFFD;
            } else if (frame.get(v + 1).get(h) instanceof Integer && TA_GridHelpers.hasType(postype)) {
                postype |= 2;
            }
        }
        if (h > 0) {
            if (frame.get(v).get(h - 1) instanceof Character) {
                postype &= 0xFFFFFFFB;
            } else if (frame.get(v).get(h - 1) instanceof Integer && TA_GridHelpers.hasType(postype)) {
                postype |= 4;
            }
        }
        if (h < hsize) {
            if (frame.get(v).get(h + 1) instanceof Character) {
                postype &= 0xFFFFFFF7;
            } else if (frame.get(v).get(h + 1) instanceof Integer && TA_GridHelpers.hasType(postype)) {
                postype |= 8;
            }
        }
        return postype;
    }

    public static boolean hasType(int postype) {
        return (postype & 1) == 1 || (postype & 2) == 2 || (postype & 4) == 4 || (postype & 8) == 8;
    }

    public static int convertBorders(int postype, int v, int h, int vsize, int hsize, int mode) {
        if (v > 0 && v < vsize && (h == 0 || h == hsize) && TA_GridOptions.testOption(32768, mode)) {
            postype &= 0xFFFFFFFB;
            return postype &= 0xFFFFFFF7;
        }
        return postype;
    }

    public static int convertConnectors(int postype, int v, int h, int vsize, int hsize, int mode) {
        if (v == 0 && h > 0 && h < hsize && TA_GridOptions.testOption(65536, mode)) {
            return postype &= 0xFFFFFFFD;
        }
        if (v == vsize) {
            if (h > 0 && h < hsize && TA_GridOptions.testOption(65536, mode)) {
                return postype &= 0xFFFFFFFE;
            }
        } else if (h > 0 && h < hsize) {
            if (TA_GridOptions.testOption(65536, mode)) {
                postype &= 0xFFFFFFFE;
                return postype &= 0xFFFFFFFD;
            }
            if (TA_GridOptions.testOption(131072, mode)) {
                postype &= 0xFFFFFFFB;
                return postype &= 0xFFFFFFF7;
            }
        }
        return postype;
    }

    static ArrayList<Object> todocEmptyContent(int ruleset) {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(ruleset);
        ret.add(Pair.of(ruleset, new String[][]{{" ", " ", " ", " "}}));
        ret.add(ruleset);
        ret.add(Pair.of(ruleset, new String[][]{{" ", " ", " ", " "}}));
        ret.add(ruleset);
        return ret;
    }

    static ArrayList<Object> todocExampleContent(int lightRule, int strongRule, int heavyRule) {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(heavyRule);
        ret.add(Pair.of(strongRule, new String[][]{{" h1  ", " h2  ", " h3  ", " h4  "}}));
        ret.add(strongRule);
        ret.add(Pair.of(strongRule, new String[][]{{" c11 to c14 w/col-span "}}));
        ret.add(256);
        ret.add(Pair.of(strongRule, new String[][]{{" c21 ", " c22 ", " c23 ", " c24 "}}));
        ret.add(lightRule);
        ret.add(Pair.of(strongRule, new String[][]{{" c31 - c32 ", " c33 - c34 "}}));
        ret.add(strongRule);
        ret.add(Pair.of(strongRule, new String[][]{{" f1  ", " f2  ", " f3  ", " f4  "}}));
        ret.add(heavyRule);
        return ret;
    }

    static ArrayList<StrBuilder> todocBuildAll(ArrayList<StrBuilder> normalGrid, ArrayList<StrBuilder> strongGrid, ArrayList<StrBuilder> heavyGrid, ArrayList<StrBuilder> lightGrid, ArrayList<StrBuilder> exampleGrid) {
        ArrayList<StrBuilder> ret = new ArrayList<StrBuilder>();
        StrBuilder top = new StrBuilder();
        if (normalGrid != null) {
            top.append("Normal         ");
        }
        if (strongGrid != null) {
            top.append("Strong         ");
        }
        if (lightGrid != null) {
            top.append("Light          ");
        }
        if (heavyGrid != null) {
            top.append("Heavy          ");
        }
        if (exampleGrid != null) {
            top.append("Example");
        }
        ret.add(top);
        int max = 0;
        max = normalGrid != null && normalGrid.size() > max ? normalGrid.size() : max;
        max = strongGrid != null && strongGrid.size() > max ? strongGrid.size() : max;
        max = lightGrid != null && lightGrid.size() > max ? lightGrid.size() : max;
        max = heavyGrid != null && heavyGrid.size() > max ? heavyGrid.size() : max;
        max = exampleGrid != null && exampleGrid.size() > max ? exampleGrid.size() : max;
        String space = "      ";
        String empty = "               ";
        for (int i = 0; i < max; ++i) {
            StrBuilder line = new StrBuilder();
            if (normalGrid != null && i < normalGrid.size()) {
                line.append(normalGrid.get(i)).append(space);
            }
            if (strongGrid != null && i < strongGrid.size()) {
                line.append(strongGrid.get(i)).append(space);
            }
            if (lightGrid != null && i < lightGrid.size()) {
                line.append(lightGrid.get(i)).append(space);
            }
            if (heavyGrid != null && i < heavyGrid.size()) {
                line.append(heavyGrid.get(i)).append(space);
            }
            if (exampleGrid != null && i < exampleGrid.size()) {
                if (normalGrid != null && i >= normalGrid.size()) {
                    line.append(empty);
                }
                if (strongGrid != null && strongGrid != null && i >= strongGrid.size()) {
                    line.append(empty);
                }
                if (lightGrid != null && lightGrid != null && i >= lightGrid.size()) {
                    line.append(empty);
                }
                if (heavyGrid != null && heavyGrid != null && i >= heavyGrid.size()) {
                    line.append(empty);
                }
                line.append(exampleGrid.get(i));
            }
            ret.add(line);
        }
        return ret;
    }
}

