/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.PreUploadHook;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.ServiceMayNotContinueException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.UploadPack;

public class PreUploadHookChain
implements PreUploadHook {
    private final List<PreUploadHook> hooks;

    public static PreUploadHook newChain(List<PreUploadHook> hooks) {
        List<PreUploadHook> newHooks = hooks.stream().filter(hook -> !hook.equals(PreUploadHook.NULL)).collect(Collectors.toList());
        if (newHooks.isEmpty()) {
            return PreUploadHook.NULL;
        }
        if (newHooks.size() == 1) {
            return (PreUploadHook)newHooks.get(0);
        }
        return new PreUploadHookChain(newHooks);
    }

    @Override
    public void onBeginNegotiateRound(UploadPack up, Collection<? extends ObjectId> wants, int cntOffered) throws ServiceMayNotContinueException {
        for (PreUploadHook hook : this.hooks) {
            hook.onBeginNegotiateRound(up, wants, cntOffered);
        }
    }

    @Override
    public void onEndNegotiateRound(UploadPack up, Collection<? extends ObjectId> wants, int cntCommon, int cntNotFound, boolean ready) throws ServiceMayNotContinueException {
        for (PreUploadHook hook : this.hooks) {
            hook.onEndNegotiateRound(up, wants, cntCommon, cntNotFound, ready);
        }
    }

    @Override
    public void onSendPack(UploadPack up, Collection<? extends ObjectId> wants, Collection<? extends ObjectId> haves) throws ServiceMayNotContinueException {
        for (PreUploadHook hook : this.hooks) {
            hook.onSendPack(up, wants, haves);
        }
    }

    private PreUploadHookChain(List<PreUploadHook> hooks) {
        this.hooks = Collections.unmodifiableList(hooks);
    }
}

