/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.MissingObjectException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.StopWalkException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevCommit;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevWalk;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.filter.RevFilter;

public class MaxCountRevFilter
extends RevFilter {
    private int maxCount;
    private int count = 0;

    public static RevFilter create(int maxCount) {
        if (maxCount < 0) {
            throw new IllegalArgumentException(JGitText.get().maxCountMustBeNonNegative);
        }
        return new MaxCountRevFilter(maxCount);
    }

    private MaxCountRevFilter(int maxCount) {
        this.maxCount = maxCount;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        ++this.count;
        if (this.count > this.maxCount) {
            throw StopWalkException.INSTANCE;
        }
        return true;
    }

    @Override
    public RevFilter clone() {
        return new MaxCountRevFilter(this.maxCount);
    }
}

