/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.merge;

import java.io.IOException;
import java.text.MessageFormat;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.annotations.Nullable;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.NoMergeBaseException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.AnyObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.NullProgressMonitor;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectInserter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectReader;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ProgressMonitor;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevCommit;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevObject;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevTree;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevWalk;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.filter.RevFilter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.treewalk.AbstractTreeIterator;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.treewalk.CanonicalTreeParser;

public abstract class Merger {
    @Nullable
    protected final Repository db;
    protected ObjectReader reader;
    protected RevWalk walk;
    private ObjectInserter inserter;
    protected RevObject[] sourceObjects;
    protected RevCommit[] sourceCommits;
    protected RevTree[] sourceTrees;
    protected ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected Merger(Repository local) {
        if (local == null) {
            throw new NullPointerException(JGitText.get().repositoryIsRequired);
        }
        this.db = local;
        this.inserter = local.newObjectInserter();
        this.reader = this.inserter.newReader();
        this.walk = new RevWalk(this.reader);
    }

    protected Merger(ObjectInserter oi) {
        this.db = null;
        this.inserter = oi;
        this.reader = oi.newReader();
        this.walk = new RevWalk(this.reader);
    }

    @Nullable
    public Repository getRepository() {
        return this.db;
    }

    protected Repository nonNullRepo() {
        if (this.db == null) {
            throw new NullPointerException(JGitText.get().repositoryIsRequired);
        }
        return this.db;
    }

    public ObjectInserter getObjectInserter() {
        return this.inserter;
    }

    public void setObjectInserter(ObjectInserter oi) {
        this.walk.close();
        this.reader.close();
        this.inserter.close();
        this.inserter = oi;
        this.reader = oi.newReader();
        this.walk = new RevWalk(this.reader);
    }

    public boolean merge(AnyObjectId ... tips) throws IOException {
        return this.merge(true, tips);
    }

    public boolean merge(boolean flush, AnyObjectId ... tips) throws IOException {
        this.sourceObjects = new RevObject[tips.length];
        int i = 0;
        while (i < tips.length) {
            this.sourceObjects[i] = this.walk.parseAny(tips[i]);
            ++i;
        }
        this.sourceCommits = new RevCommit[this.sourceObjects.length];
        i = 0;
        while (i < this.sourceObjects.length) {
            try {
                this.sourceCommits[i] = this.walk.parseCommit(this.sourceObjects[i]);
            }
            catch (IncorrectObjectTypeException err) {
                this.sourceCommits[i] = null;
            }
            ++i;
        }
        this.sourceTrees = new RevTree[this.sourceObjects.length];
        i = 0;
        while (i < this.sourceObjects.length) {
            this.sourceTrees[i] = this.walk.parseTree(this.sourceObjects[i]);
            ++i;
        }
        try {
            boolean ok = this.mergeImpl();
            if (ok && flush) {
                this.inserter.flush();
            }
            boolean bl = ok;
            return bl;
        }
        finally {
            if (flush) {
                this.inserter.close();
            }
            this.reader.close();
        }
    }

    public abstract ObjectId getBaseCommitId();

    protected RevCommit getBaseCommit(RevCommit a, RevCommit b) throws IncorrectObjectTypeException, IOException {
        this.walk.reset();
        this.walk.setRevFilter(RevFilter.MERGE_BASE);
        this.walk.markStart(a);
        this.walk.markStart(b);
        RevCommit base = this.walk.next();
        if (base == null) {
            return null;
        }
        RevCommit base2 = this.walk.next();
        if (base2 != null) {
            throw new NoMergeBaseException(NoMergeBaseException.MergeBaseFailureReason.MULTIPLE_MERGE_BASES_NOT_SUPPORTED, MessageFormat.format(JGitText.get().multipleMergeBasesFor, a.name(), b.name(), base.name(), base2.name()));
        }
        return base;
    }

    protected AbstractTreeIterator openTree(AnyObjectId treeId) throws IncorrectObjectTypeException, IOException {
        return new CanonicalTreeParser(null, this.reader, treeId);
    }

    protected abstract boolean mergeImpl() throws IOException;

    public abstract ObjectId getResultTreeId();

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor == null ? NullProgressMonitor.INSTANCE : monitor;
    }
}

