/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.merge;

import java.text.MessageFormat;
import java.util.HashMap;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Config;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectInserter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.merge.Merger;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.merge.StrategyOneSided;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.merge.StrategyRecursive;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.merge.StrategyResolve;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.merge.StrategySimpleTwoWayInCore;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.merge.ThreeWayMergeStrategy;

public abstract class MergeStrategy {
    public static final MergeStrategy OURS = new StrategyOneSided("ours", 0);
    public static final MergeStrategy THEIRS = new StrategyOneSided("theirs", 1);
    public static final ThreeWayMergeStrategy SIMPLE_TWO_WAY_IN_CORE = new StrategySimpleTwoWayInCore();
    public static final ThreeWayMergeStrategy RESOLVE = new StrategyResolve();
    public static final ThreeWayMergeStrategy RECURSIVE = new StrategyRecursive();
    private static final HashMap<String, MergeStrategy> STRATEGIES = new HashMap();

    static {
        MergeStrategy.register(OURS);
        MergeStrategy.register(THEIRS);
        MergeStrategy.register(SIMPLE_TWO_WAY_IN_CORE);
        MergeStrategy.register(RESOLVE);
        MergeStrategy.register(RECURSIVE);
    }

    public static void register(MergeStrategy imp) {
        MergeStrategy.register(imp.getName(), imp);
    }

    public static synchronized void register(String name, MergeStrategy imp) {
        if (STRATEGIES.containsKey(name)) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().mergeStrategyAlreadyExistsAsDefault, name));
        }
        STRATEGIES.put(name, imp);
    }

    public static synchronized MergeStrategy get(String name) {
        return STRATEGIES.get(name);
    }

    public static synchronized MergeStrategy[] get() {
        MergeStrategy[] r = new MergeStrategy[STRATEGIES.size()];
        STRATEGIES.values().toArray(r);
        return r;
    }

    public abstract String getName();

    public abstract Merger newMerger(Repository var1);

    public abstract Merger newMerger(Repository var1, boolean var2);

    public abstract Merger newMerger(ObjectInserter var1, Config var2);
}

