/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.fnmatch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.InvalidPatternException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.NoClosingBracketException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.fnmatch.AbstractHead;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.fnmatch.CharacterHead;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.fnmatch.GroupHead;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.fnmatch.Head;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.fnmatch.LastHead;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.fnmatch.RestrictedWildCardHead;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.fnmatch.WildCardHead;

public class FileNameMatcher {
    static final List<Head> EMPTY_HEAD_LIST = Collections.emptyList();
    private static final Pattern characterClassStartPattern = Pattern.compile("\\[[.:=]");
    private List<Head> headsStartValue;
    private List<Head> heads;
    private List<Head> listForLocalUseage;

    private FileNameMatcher(List<Head> headsStartValue) {
        this(headsStartValue, headsStartValue);
    }

    private FileNameMatcher(List<Head> headsStartValue, List<Head> heads) {
        this.headsStartValue = headsStartValue;
        this.heads = new ArrayList<Head>(heads.size());
        this.heads.addAll(heads);
        this.listForLocalUseage = new ArrayList<Head>(heads.size());
    }

    public FileNameMatcher(String patternString, Character invalidWildgetCharacter) throws InvalidPatternException {
        this(FileNameMatcher.createHeadsStartValues(patternString, invalidWildgetCharacter));
    }

    public FileNameMatcher(FileNameMatcher other) {
        this(other.headsStartValue, other.heads);
    }

    private static List<Head> createHeadsStartValues(String patternString, Character invalidWildgetCharacter) throws InvalidPatternException {
        List<AbstractHead> allHeads = FileNameMatcher.parseHeads(patternString, invalidWildgetCharacter);
        ArrayList<Head> nextHeadsSuggestion = new ArrayList<Head>(2);
        nextHeadsSuggestion.add(LastHead.INSTANCE);
        int i = allHeads.size() - 1;
        while (i >= 0) {
            AbstractHead head = allHeads.get(i);
            if (head.isStar()) {
                nextHeadsSuggestion.add(head);
                head.setNewHeads(nextHeadsSuggestion);
            } else {
                head.setNewHeads(nextHeadsSuggestion);
                nextHeadsSuggestion = new ArrayList(2);
                nextHeadsSuggestion.add(head);
            }
            --i;
        }
        return nextHeadsSuggestion;
    }

    private static int findGroupEnd(int indexOfStartBracket, String pattern) throws InvalidPatternException {
        int firstValidCharClassIndex = indexOfStartBracket + 1;
        int firstValidEndBracketIndex = indexOfStartBracket + 2;
        if (indexOfStartBracket + 1 >= pattern.length()) {
            throw new NoClosingBracketException(indexOfStartBracket, "[", "]", pattern);
        }
        if (pattern.charAt(firstValidCharClassIndex) == '!') {
            ++firstValidCharClassIndex;
            ++firstValidEndBracketIndex;
        }
        Matcher charClassStartMatcher = characterClassStartPattern.matcher(pattern);
        int groupEnd = -1;
        while (groupEnd == -1) {
            int possibleGroupEnd = FileNameMatcher.indexOfUnescaped(pattern, ']', firstValidEndBracketIndex);
            if (possibleGroupEnd == -1) {
                throw new NoClosingBracketException(indexOfStartBracket, "[", "]", pattern);
            }
            boolean foundCharClass = charClassStartMatcher.find(firstValidCharClassIndex);
            if (foundCharClass && charClassStartMatcher.start() < possibleGroupEnd) {
                int classStartIndex;
                String classStart = charClassStartMatcher.group(0);
                String classEnd = String.valueOf(classStart.charAt(1)) + "]";
                int classEndIndex = pattern.indexOf(classEnd, (classStartIndex = charClassStartMatcher.start()) + 2);
                if (classEndIndex == -1) {
                    throw new NoClosingBracketException(classStartIndex, classStart, classEnd, pattern);
                }
                firstValidEndBracketIndex = firstValidCharClassIndex = classEndIndex + 2;
                continue;
            }
            groupEnd = possibleGroupEnd;
        }
        return groupEnd;
    }

    private static List<AbstractHead> parseHeads(String pattern, Character invalidWildgetCharacter) throws InvalidPatternException {
        int currentIndex = 0;
        ArrayList<AbstractHead> heads = new ArrayList<AbstractHead>();
        while (currentIndex < pattern.length()) {
            String patternPart;
            int groupStart = FileNameMatcher.indexOfUnescaped(pattern, '[', currentIndex);
            if (groupStart == -1) {
                patternPart = pattern.substring(currentIndex);
                heads.addAll(FileNameMatcher.createSimpleHeads(patternPart, invalidWildgetCharacter));
                currentIndex = pattern.length();
                continue;
            }
            patternPart = pattern.substring(currentIndex, groupStart);
            heads.addAll(FileNameMatcher.createSimpleHeads(patternPart, invalidWildgetCharacter));
            int groupEnd = FileNameMatcher.findGroupEnd(groupStart, pattern);
            String groupPart = pattern.substring(groupStart + 1, groupEnd);
            heads.add(new GroupHead(groupPart, pattern));
            currentIndex = groupEnd + 1;
        }
        return heads;
    }

    private static List<AbstractHead> createSimpleHeads(String patternPart, Character invalidWildgetCharacter) {
        ArrayList<AbstractHead> heads = new ArrayList<AbstractHead>(patternPart.length());
        boolean escaped = false;
        int i = 0;
        while (i < patternPart.length()) {
            AbstractHead head;
            char c = patternPart.charAt(i);
            if (escaped) {
                head = new CharacterHead(c);
                heads.add(head);
                escaped = false;
            } else {
                switch (c) {
                    case '*': {
                        head = FileNameMatcher.createWildCardHead(invalidWildgetCharacter, true);
                        heads.add(head);
                        break;
                    }
                    case '?': {
                        head = FileNameMatcher.createWildCardHead(invalidWildgetCharacter, false);
                        heads.add(head);
                        break;
                    }
                    case '\\': {
                        escaped = true;
                        break;
                    }
                    default: {
                        head = new CharacterHead(c);
                        heads.add(head);
                    }
                }
            }
            ++i;
        }
        return heads;
    }

    private static AbstractHead createWildCardHead(Character invalidWildgetCharacter, boolean star) {
        if (invalidWildgetCharacter != null) {
            return new RestrictedWildCardHead(invalidWildgetCharacter.charValue(), star);
        }
        return new WildCardHead(star);
    }

    private boolean extendStringToMatchByOneCharacter(char c) {
        List<Head> newHeads = this.listForLocalUseage;
        newHeads.clear();
        List<Head> lastAddedHeads = null;
        int i = 0;
        while (i < this.heads.size()) {
            Head head = this.heads.get(i);
            List<Head> headsToAdd = head.getNextHeads(c);
            if (headsToAdd != lastAddedHeads) {
                if (!headsToAdd.isEmpty()) {
                    newHeads.addAll(headsToAdd);
                }
                lastAddedHeads = headsToAdd;
            }
            ++i;
        }
        this.listForLocalUseage = this.heads;
        this.heads = newHeads;
        return !newHeads.isEmpty();
    }

    private static int indexOfUnescaped(String searchString, char ch, int fromIndex) {
        int i = fromIndex;
        while (i < searchString.length()) {
            char current = searchString.charAt(i);
            if (current == ch) {
                return i;
            }
            if (current == '\\') {
                ++i;
            }
            ++i;
        }
        return -1;
    }

    public void append(String stringToMatch) {
        int i = 0;
        while (i < stringToMatch.length()) {
            char c = stringToMatch.charAt(i);
            if (!this.extendStringToMatchByOneCharacter(c)) break;
            ++i;
        }
    }

    public void reset() {
        this.heads.clear();
        this.heads.addAll(this.headsStartValue);
    }

    public FileNameMatcher createMatcherForSuffix() {
        ArrayList<Head> copyOfHeads = new ArrayList<Head>(this.heads.size());
        copyOfHeads.addAll(this.heads);
        return new FileNameMatcher(copyOfHeads);
    }

    public boolean isMatch() {
        if (this.heads.isEmpty()) {
            return false;
        }
        ListIterator<Head> headIterator = this.heads.listIterator(this.heads.size());
        while (headIterator.hasPrevious()) {
            Head head = headIterator.previous();
            if (head != LastHead.INSTANCE) continue;
            return true;
        }
        return false;
    }

    public boolean canAppendMatch() {
        for (Head head : this.heads) {
            if (head == LastHead.INSTANCE) continue;
            return true;
        }
        return false;
    }
}

