/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class JUnitParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(reportContent.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            String className = null;
            String name = null;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1) continue;
                if (xmlr.getLocalName().equalsIgnoreCase("testcase")) {
                    className = ViolationParserUtils.findAttribute(xmlr, "classname").orElse("");
                    name = ViolationParserUtils.getAttribute(xmlr, "name");
                    continue;
                }
                if (!xmlr.getLocalName().equalsIgnoreCase("failure") && !xmlr.getLocalName().equalsIgnoreCase("error")) continue;
                Violation v = this.parseFailure(xmlr, className, name, violationsLogger);
                violations.add(v);
            }
        }
        return violations;
    }

    private Violation parseFailure(XMLStreamReader xmlr, String className, String name, ViolationsLogger violationsLogger) throws Exception {
        String messageAttr = xmlr.getAttributeValue("", "message");
        String failureContent = xmlr.getElementText();
        FileAndLine fl = this.findFilePathInContent(failureContent, className);
        if (fl == null) {
            fl = this.deriveFileFromClass(failureContent);
        }
        if (fl == null) {
            violationsLogger.log(Level.FINE, "Cannot determine file and line in:\n" + failureContent);
            fl = new FileAndLine();
            fl.line = 0;
            fl.file = "-";
        }
        String message = name + " : " + (messageAttr != null ? messageAttr + " " + failureContent : failureContent);
        return Violation.violationBuilder().setParser(Parser.JUNIT).setMessage(message.trim()).setStartLine(fl.line).setFile(fl.file).setSource(className).setSeverity(SEVERITY.ERROR).build();
    }

    private FileAndLine deriveFileFromClass(String failureContent) {
        String failureContentFrontSlash = failureContent.replace("\\", "/");
        Matcher matcher = Pattern.compile("((([a-zA-Z]+?/)|([a-zA-Z]:/)|(/))([^:]+?)):(\\d+)").matcher(failureContentFrontSlash);
        boolean foundFilePath = matcher.find();
        if (foundFilePath) {
            FileAndLine fl = new FileAndLine();
            fl.file = matcher.group(1);
            fl.line = Integer.parseInt(matcher.group(7));
            return fl;
        }
        Matcher classNameMatcher = Pattern.compile("([a-zA-Z\\.]+?):(\\d+)").matcher(failureContentFrontSlash);
        boolean foundClassName = classNameMatcher.find();
        if (foundClassName) {
            FileAndLine fl = new FileAndLine();
            fl.file = classNameMatcher.group(1);
            fl.line = Integer.parseInt(classNameMatcher.group(2));
            return fl;
        }
        return null;
    }

    private FileAndLine findFilePathInContent(String failureContent, String className) {
        String failureContentFrontSlash = failureContent.replace("\\", "/");
        Matcher matcher = Pattern.compile("\\s+?at\\s([a-zA-Z0-9\\.]*)\\(([^:]+):(\\d+?)\\)", 8).matcher(failureContentFrontSlash);
        ArrayList<FileAndLine> found = new ArrayList<FileAndLine>();
        while (matcher.find()) {
            FileAndLine fl = new FileAndLine();
            String classNameFromMatcher = matcher.group(1);
            String filepath = classNameFromMatcher.replace(".", "/");
            filepath = (filepath = filepath.substring(0, filepath.lastIndexOf("/"))).lastIndexOf("/") == -1 ? "" : filepath.substring(0, filepath.lastIndexOf("/"));
            String filename = matcher.group(2);
            fl.file = filepath.isEmpty() ? filename : filepath + "/" + filename;
            fl.line = Integer.parseInt(matcher.group(3));
            found.add(fl);
        }
        if (found.size() == 0) {
            return null;
        }
        if (found.size() == 1) {
            return (FileAndLine)found.get(0);
        }
        if (!className.isEmpty()) {
            for (FileAndLine candidate : found) {
                if (!candidate.file.startsWith(className.replace(".", "/"))) continue;
                return candidate;
            }
        }
        return (FileAndLine)found.get(0);
    }

    private static class FileAndLine {
        public String file;
        public Integer line;

        private FileAndLine() {
        }
    }
}

