/*
 * Decompiled with CFR 0.152.
 */
package shadow.de.vandermeer.skb.interfaces;

import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.Validate;
import se.bjurr.violations.violationsgitlib.org.slf4j.helpers.FormattingTuple;
import se.bjurr.violations.violationsgitlib.org.slf4j.helpers.MessageFormatter;

public interface FormattingTupleWrapper {
    public FormattingTuple getTuple();

    default public String getMessage() {
        return this.getTuple().getMessage();
    }

    public static FormattingTupleWrapper create(final String msg) {
        Validate.notBlank(msg);
        return new FormattingTupleWrapper(){

            @Override
            public FormattingTuple getTuple() {
                return MessageFormatter.arrayFormat(msg, new Object[0]);
            }
        };
    }

    public static FormattingTupleWrapper create(final String msg, final Object ... obj) {
        Validate.notBlank(msg);
        Validate.notNull(obj);
        Validate.noNullElements(obj);
        return new FormattingTupleWrapper(){

            @Override
            public FormattingTuple getTuple() {
                return MessageFormatter.arrayFormat(msg, obj);
            }

            public String toString() {
                return this.getMessage();
            }
        };
    }
}

