/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.attributes.AttributesNode;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.attributes.AttributesNodeProvider;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsConfig;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsRefDatabase;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsRepositoryBuilder;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.RefUpdate;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ReflogReader;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.StoredConfig;

public abstract class DfsRepository
extends Repository {
    private final DfsConfig config = new DfsConfig();
    private final DfsRepositoryDescription description;

    protected DfsRepository(DfsRepositoryBuilder builder) {
        super(builder);
        this.description = builder.getRepositoryDescription();
    }

    @Override
    public abstract DfsObjDatabase getObjectDatabase();

    public DfsRepositoryDescription getDescription() {
        return this.description;
    }

    public boolean exists() throws IOException {
        if (this.getRefDatabase() instanceof DfsRefDatabase) {
            return ((DfsRefDatabase)this.getRefDatabase()).exists();
        }
        return true;
    }

    @Override
    public void create(boolean bare) throws IOException {
        if (this.exists()) {
            throw new IOException(MessageFormat.format(JGitText.get().repositoryAlreadyExists, ""));
        }
        String master = "refs/heads/master";
        RefUpdate.Result result = this.updateRef("HEAD", true).link(master);
        if (result != RefUpdate.Result.NEW) {
            throw new IOException(result.name());
        }
    }

    @Override
    public StoredConfig getConfig() {
        return this.config;
    }

    @Override
    public void scanForRepoChanges() throws IOException {
        this.getRefDatabase().refresh();
        this.getObjectDatabase().clearCache();
    }

    @Override
    public void notifyIndexChanged() {
    }

    @Override
    public ReflogReader getReflogReader(String refName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public AttributesNodeProvider createAttributesNodeProvider() {
        return new EmptyAttributesNodeProvider();
    }

    private static class EmptyAttributesNodeProvider
    implements AttributesNodeProvider {
        private EmptyAttributesNode emptyAttributesNode = new EmptyAttributesNode();

        private EmptyAttributesNodeProvider() {
        }

        @Override
        public AttributesNode getInfoAttributesNode() throws IOException {
            return this.emptyAttributesNode;
        }

        @Override
        public AttributesNode getGlobalAttributesNode() throws IOException {
            return this.emptyAttributesNode;
        }

        private static class EmptyAttributesNode
        extends AttributesNode {
            public EmptyAttributesNode() {
                super(Collections.emptyList());
            }

            @Override
            public void parse(InputStream in) throws IOException {
            }
        }
    }
}

