/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsInserter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsPacksChangedEvent;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsReader;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsReaderOptions;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsReftable;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.pack.PackExt;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.AnyObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectDatabase;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectInserter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectReader;

public abstract class DfsObjDatabase
extends ObjectDatabase {
    private static final PackList NO_PACKS = new PackList(new DfsPackFile[0], new DfsReftable[0]){

        @Override
        boolean dirty() {
            return true;
        }

        @Override
        void clearDirty() {
        }

        @Override
        public void markDirty() {
        }
    };
    private final AtomicReference<PackList> packList;
    private final DfsRepository repository;
    private DfsReaderOptions readerOptions;

    protected DfsObjDatabase(DfsRepository repository, DfsReaderOptions options) {
        this.repository = repository;
        this.packList = new AtomicReference<PackList>(NO_PACKS);
        this.readerOptions = options;
    }

    public DfsReaderOptions getReaderOptions() {
        return this.readerOptions;
    }

    @Override
    public DfsReader newReader() {
        return new DfsReader(this);
    }

    @Override
    public ObjectInserter newInserter() {
        return new DfsInserter(this);
    }

    public DfsPackFile[] getPacks() throws IOException {
        return this.getPackList().packs;
    }

    public DfsReftable[] getReftables() throws IOException {
        return this.getPackList().reftables;
    }

    public PackList getPackList() throws IOException {
        return this.scanPacks(NO_PACKS);
    }

    protected DfsRepository getRepository() {
        return this.repository;
    }

    public DfsPackFile[] getCurrentPacks() {
        return this.getCurrentPackList().packs;
    }

    public DfsReftable[] getCurrentReftables() {
        return this.getCurrentPackList().reftables;
    }

    public PackList getCurrentPackList() {
        return this.packList.get();
    }

    public boolean has(AnyObjectId objectId, boolean avoidUnreachableObjects) throws IOException {
        try (DfsReader or = this.newReader();){
            ((ObjectReader)or).setAvoidUnreachableObjects(avoidUnreachableObjects);
            boolean bl = ((ObjectReader)or).has(objectId);
            return bl;
        }
    }

    protected abstract DfsPackDescription newPack(PackSource var1) throws IOException;

    protected DfsPackDescription newPack(PackSource source, long estimatedPackSize) throws IOException {
        DfsPackDescription pack = this.newPack(source);
        pack.setEstimatedPackSize(estimatedPackSize);
        return pack;
    }

    protected void commitPack(Collection<DfsPackDescription> desc, Collection<DfsPackDescription> replaces) throws IOException {
        this.commitPackImpl(desc, replaces);
        this.getRepository().fireEvent(new DfsPacksChangedEvent());
    }

    protected abstract void commitPackImpl(Collection<DfsPackDescription> var1, Collection<DfsPackDescription> var2) throws IOException;

    protected abstract void rollbackPack(Collection<DfsPackDescription> var1);

    protected abstract List<DfsPackDescription> listPacks() throws IOException;

    protected abstract ReadableChannel openFile(DfsPackDescription var1, PackExt var2) throws FileNotFoundException, IOException;

    protected abstract DfsOutputStream writeFile(DfsPackDescription var1, PackExt var2) throws IOException;

    void addPack(DfsPackFile newPack) throws IOException {
        DfsPackFile[] packs;
        PackListImpl n;
        PackList o;
        do {
            if ((o = this.packList.get()) == NO_PACKS) {
                o = this.scanPacks(o);
                for (DfsPackFile p : o.packs) {
                    if (p != newPack) continue;
                    return;
                }
            }
            packs = new DfsPackFile[1 + o.packs.length];
            packs[0] = newPack;
            System.arraycopy(o.packs, 0, packs, 1, o.packs.length);
        } while (!this.packList.compareAndSet(o, n = new PackListImpl(packs, o.reftables)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackList scanPacks(PackList original) throws IOException {
        PackList n;
        AtomicReference<PackList> atomicReference = this.packList;
        synchronized (atomicReference) {
            PackList o;
            do {
                if ((o = this.packList.get()) != original) {
                    return o;
                }
                n = this.scanPacksImpl(o);
                if (n != o) continue;
                return n;
            } while (!this.packList.compareAndSet(o, n));
        }
        this.getRepository().fireEvent(new DfsPacksChangedEvent());
        return n;
    }

    private PackList scanPacksImpl(PackList old) throws IOException {
        DfsBlockCache cache = DfsBlockCache.getInstance();
        Map<DfsPackDescription, DfsPackFile> packs = DfsObjDatabase.packMap(old);
        Map<DfsPackDescription, DfsReftable> reftables = DfsObjDatabase.reftableMap(old);
        List<DfsPackDescription> scanned = this.listPacks();
        Collections.sort(scanned);
        ArrayList<DfsPackFile> newPacks = new ArrayList<DfsPackFile>(scanned.size());
        ArrayList<DfsReftable> newReftables = new ArrayList<DfsReftable>(scanned.size());
        boolean foundNew = false;
        for (DfsPackDescription dsc : scanned) {
            DfsPackFile oldPack = packs.remove(dsc);
            if (oldPack != null) {
                newPacks.add(oldPack);
            } else if (dsc.hasFileExt(PackExt.PACK)) {
                newPacks.add(new DfsPackFile(cache, dsc));
                foundNew = true;
            }
            DfsReftable oldReftable = reftables.remove(dsc);
            if (oldReftable != null) {
                newReftables.add(oldReftable);
                continue;
            }
            if (!dsc.hasFileExt(PackExt.REFTABLE)) continue;
            newReftables.add(new DfsReftable(cache, dsc));
            foundNew = true;
        }
        if (newPacks.isEmpty()) {
            return new PackListImpl(DfsObjDatabase.NO_PACKS.packs, DfsObjDatabase.NO_PACKS.reftables);
        }
        if (!foundNew) {
            old.clearDirty();
            return old;
        }
        Collections.sort(newReftables, this.reftableComparator());
        return new PackListImpl(newPacks.toArray(new DfsPackFile[0]), newReftables.toArray(new DfsReftable[0]));
    }

    private static Map<DfsPackDescription, DfsPackFile> packMap(PackList old) {
        HashMap<DfsPackDescription, DfsPackFile> forReuse = new HashMap<DfsPackDescription, DfsPackFile>();
        for (DfsPackFile p : old.packs) {
            if (p.invalid()) continue;
            forReuse.put(p.desc, p);
        }
        return forReuse;
    }

    private static Map<DfsPackDescription, DfsReftable> reftableMap(PackList old) {
        HashMap<DfsPackDescription, DfsReftable> forReuse = new HashMap<DfsPackDescription, DfsReftable>();
        for (DfsReftable p : old.reftables) {
            if (p.invalid()) continue;
            forReuse.put(p.desc, p);
        }
        return forReuse;
    }

    protected Comparator<DfsReftable> reftableComparator() {
        return (fa, fb) -> {
            DfsPackDescription a = fa.getPackDescription();
            DfsPackDescription b = fb.getPackDescription();
            int c = DfsObjDatabase.category(b) - DfsObjDatabase.category(a);
            if (c != 0) {
                return c;
            }
            c = Long.signum(a.getMaxUpdateIndex() - b.getMaxUpdateIndex());
            if (c != 0) {
                return c;
            }
            return Long.signum(a.getLastModified() - b.getLastModified());
        };
    }

    static int category(DfsPackDescription d) {
        PackSource s = d.getPackSource();
        return s != null ? s.category : 0;
    }

    protected void clearCache() {
        this.packList.set(NO_PACKS);
    }

    @Override
    public void close() {
        this.packList.set(NO_PACKS);
    }

    public static abstract class PackList {
        public final DfsPackFile[] packs;
        public final DfsReftable[] reftables;
        private long lastModified = -1L;

        PackList(DfsPackFile[] packs, DfsReftable[] reftables) {
            this.packs = packs;
            this.reftables = reftables;
        }

        public long getLastModified() {
            if (this.lastModified < 0L) {
                long max = 0L;
                for (DfsPackFile pack : this.packs) {
                    max = Math.max(max, pack.getPackDescription().getLastModified());
                }
                this.lastModified = max;
            }
            return this.lastModified;
        }

        abstract boolean dirty();

        abstract void clearDirty();

        public abstract void markDirty();
    }

    private static final class PackListImpl
    extends PackList {
        private volatile boolean dirty;

        PackListImpl(DfsPackFile[] packs, DfsReftable[] reftables) {
            super(packs, reftables);
        }

        @Override
        boolean dirty() {
            return this.dirty;
        }

        @Override
        void clearDirty() {
            this.dirty = false;
        }

        @Override
        public void markDirty() {
            this.dirty = true;
        }
    }

    public static enum PackSource {
        INSERT(0),
        RECEIVE(0),
        COMPACT(1),
        GC(2),
        GC_REST(3),
        GC_TXN(4),
        UNREACHABLE_GARBAGE(5);

        final int category;

        private PackSource(int category) {
            this.category = category;
        }
    }
}

