/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.GitCommand;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.GitAPIException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.JGitInternalException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.ConfigInvalidException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.submodule.SubmoduleStatus;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.submodule.SubmoduleStatusType;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.submodule.SubmoduleWalk;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleStatusCommand
extends GitCommand<Map<String, SubmoduleStatus>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleStatusCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleStatusCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, SubmoduleStatus> call() throws GitAPIException {
        this.checkCallable();
        try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            HashMap<String, SubmoduleStatus> statuses = new HashMap<String, SubmoduleStatus>();
            while (generator.next()) {
                SubmoduleStatus status = this.getStatus(generator);
                statuses.put(status.getPath(), status);
            }
            HashMap<String, SubmoduleStatus> hashMap = statuses;
            return hashMap;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubmoduleStatus getStatus(SubmoduleWalk generator) throws IOException, ConfigInvalidException {
        ObjectId headId;
        ObjectId id = generator.getObjectId();
        String path = generator.getPath();
        if (generator.getModulesPath() == null) {
            return new SubmoduleStatus(SubmoduleStatusType.MISSING, path, id);
        }
        if (generator.getConfigUrl() == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path, id);
        }
        Repository subRepo = generator.getRepository();
        if (subRepo == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path, id);
        }
        try {
            headId = subRepo.resolve("HEAD");
        }
        finally {
            subRepo.close();
        }
        if (headId == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path, id, headId);
        }
        if (!headId.equals(id)) {
            return new SubmoduleStatus(SubmoduleStatusType.REV_CHECKED_OUT, path, id, headId);
        }
        return new SubmoduleStatus(SubmoduleStatusType.INITIALIZED, path, id, headId);
    }
}

