/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.GitCommand;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.GitAPIException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.JGitInternalException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.StoredConfig;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.RefSpec;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.RemoteConfig;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.URIish;

public class RemoteAddCommand
extends GitCommand<RemoteConfig> {
    private String name;
    private URIish uri;

    protected RemoteAddCommand(Repository repo) {
        super(repo);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUri(URIish uri) {
        this.uri = uri;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config, this.name);
            RefSpec refSpec = new RefSpec();
            refSpec = refSpec.setForceUpdate(true);
            refSpec = refSpec.setSourceDestination("refs/heads/*", "refs/remotes/" + this.name + "/*");
            remote.addFetchRefSpec(refSpec);
            remote.addURI(this.uri);
            remote.update(config);
            config.save();
            return remote;
        }
        catch (IOException | URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

