/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.apache.http.protocol;

import java.io.IOException;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpException;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpRequest;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpRequestInterceptor;
import se.bjurr.violations.violationsgitlib.org.apache.http.annotation.Immutable;
import se.bjurr.violations.violationsgitlib.org.apache.http.params.HttpParams;
import se.bjurr.violations.violationsgitlib.org.apache.http.protocol.HttpContext;
import se.bjurr.violations.violationsgitlib.org.apache.http.util.Args;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

