/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.reports;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import se.bjurr.violations.lib.ViolationsLogger;

public class ReportsFinder {
    public static List<File> findAllReports(final ViolationsLogger violationsLogger, File startFile, final String pattern, final List<String> ignorePaths) {
        final ArrayList<File> found = new ArrayList<File>();
        final Path startPath = startFile.toPath();
        try {
            Files.walkFileTree(startPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String relativePath = startPath.relativize(file).toString();
                    if (ReportsFinder.isIgnored(relativePath, ignorePaths)) {
                        return super.visitFile(file, attrs);
                    }
                    String absolutePath = file.toFile().getAbsolutePath();
                    if (Pattern.matches(pattern, absolutePath) || Pattern.matches(pattern, ReportsFinder.withFrontSlashes(absolutePath))) {
                        violationsLogger.log(Level.FINE, pattern + " matches " + absolutePath);
                        found.add(file.toFile());
                    } else {
                        violationsLogger.log(Level.FINE, pattern + " does not match " + absolutePath);
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Collections.sort(found);
        return found;
    }

    static String withFrontSlashes(String file) {
        return file.replace('\\', '/');
    }

    public static boolean isIgnored(String path, List<String> ignorePaths) {
        for (String ignorePath : ignorePaths) {
            if (!ReportsFinder.withFrontSlashes(path).startsWith(ReportsFinder.withFrontSlashes(ignorePath))) continue;
            return true;
        }
        return false;
    }
}

